/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.tasks;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.IOUtils;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ExceptionsHelper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ResourceAlreadyExistsException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.index.IndexRequestBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.index.IndexResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.Client;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.Requests;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.component.AbstractComponent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.Streams;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.tasks.TaskResult;

public class TaskResultsService
extends AbstractComponent {
    public static final String TASK_INDEX = ".tasks";
    public static final String TASK_TYPE = "task";
    public static final String TASK_RESULT_INDEX_MAPPING_FILE = "task-index-mapping.json";
    private final Client client;
    private final ClusterService clusterService;
    private final TransportCreateIndexAction createIndexAction;

    @Inject
    public TaskResultsService(Settings settings, Client client, ClusterService clusterService, TransportCreateIndexAction createIndexAction) {
        super(settings);
        this.client = client;
        this.clusterService = clusterService;
        this.createIndexAction = createIndexAction;
    }

    public void storeResult(final TaskResult taskResult, final ActionListener<Void> listener) {
        ClusterState state = this.clusterService.state();
        if (!state.routingTable().hasIndex(TASK_INDEX)) {
            CreateIndexRequest createIndexRequest = new CreateIndexRequest();
            createIndexRequest.settings(this.taskResultIndexSettings());
            createIndexRequest.index(TASK_INDEX);
            createIndexRequest.mapping(TASK_TYPE, this.taskResultIndexMapping());
            createIndexRequest.cause("auto(task api)");
            this.createIndexAction.execute(null, createIndexRequest, new ActionListener<CreateIndexResponse>(){

                @Override
                public void onResponse(CreateIndexResponse result) {
                    TaskResultsService.this.doStoreResult(taskResult, listener);
                }

                @Override
                public void onFailure(Exception e) {
                    if (ExceptionsHelper.unwrapCause(e) instanceof ResourceAlreadyExistsException) {
                        try {
                            TaskResultsService.this.doStoreResult(taskResult, listener);
                        }
                        catch (Exception inner) {
                            inner.addSuppressed(e);
                            listener.onFailure(inner);
                        }
                    } else {
                        listener.onFailure(e);
                    }
                }
            });
        } else {
            IndexMetaData metaData = state.getMetaData().index(TASK_INDEX);
            if (!metaData.getMappings().containsKey(TASK_TYPE)) {
                this.client.admin().indices().preparePutMapping(TASK_INDEX).setType(TASK_TYPE).setSource(this.taskResultIndexMapping()).execute(new ActionListener<PutMappingResponse>(){

                    @Override
                    public void onResponse(PutMappingResponse putMappingResponse) {
                        TaskResultsService.this.doStoreResult(taskResult, listener);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                });
            } else {
                this.doStoreResult(taskResult, listener);
            }
        }
    }

    private void doStoreResult(TaskResult taskResult, final ActionListener<Void> listener) {
        IndexRequestBuilder index = this.client.prepareIndex(TASK_INDEX, TASK_TYPE, taskResult.getTask().getTaskId().toString());
        try (XContentBuilder builder = XContentFactory.contentBuilder(Requests.INDEX_CONTENT_TYPE);){
            taskResult.toXContent(builder, ToXContent.EMPTY_PARAMS);
            index.setSource(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Couldn't convert task result to XContent for [{}]", (Throwable)e, taskResult.getTask());
        }
        index.execute(new ActionListener<IndexResponse>(){

            @Override
            public void onResponse(IndexResponse indexResponse) {
                listener.onResponse(null);
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private Settings taskResultIndexSettings() {
        return Settings.builder().put(IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.getKey(), 1).put(IndexMetaData.INDEX_AUTO_EXPAND_REPLICAS_SETTING.getKey(), "0-1").put("index.priority", Integer.MAX_VALUE).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String taskResultIndexMapping() {
        try (InputStream is = this.getClass().getResourceAsStream(TASK_RESULT_INDEX_MAPPING_FILE);){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Streams.copy(is, (OutputStream)out);
            String string = out.toString(IOUtils.UTF_8);
            return string;
        }
        catch (Exception e) {
            this.logger.error(() -> new ParameterizedMessage("failed to create tasks results index template [{}]", (Object)TASK_RESULT_INDEX_MAPPING_FILE), (Throwable)e);
            throw new IllegalStateException("failed to create tasks results index template [task-index-mapping.json]", e);
        }
    }
}

