/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch6;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.core.Bulk;
import io.searchbox.core.BulkResult;
import io.searchbox.core.DocumentResult;
import io.searchbox.core.Get;
import io.searchbox.core.Index;
import io.searchbox.indices.Analyze;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.http.client.config.RequestConfig;
import org.graylog.storage.elasticsearch6.jest.JestUtils;
import org.graylog2.indexer.messages.ChunkedBulkIndexer;
import org.graylog2.indexer.messages.DocumentNotFoundException;
import org.graylog2.indexer.messages.Indexable;
import org.graylog2.indexer.messages.IndexingRequest;
import org.graylog2.indexer.messages.Messages;
import org.graylog2.indexer.messages.MessagesAdapter;
import org.graylog2.indexer.results.ResultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagesAdapterES6
implements MessagesAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(MessagesAdapterES6.class);
    static final String INDEX_BLOCK_ERROR = "cluster_block_exception";
    static final String INDEX_BLOCK_REASON = "blocked by: [FORBIDDEN/12/index read-only / allow delete (api)];";
    static final String MAPPER_PARSING_EXCEPTION = "mapper_parsing_exception";
    static final String UNAVAILABLE_SHARDS_EXCEPTION = "unavailable_shards_exception";
    static final String PRIMARY_SHARD_NOT_ACTIVE_REASON = "primary shard is not active";
    private final JestClient client;
    private final boolean useExpectContinue;
    private final Meter invalidTimestampMeter;
    private final ChunkedBulkIndexer chunkedBulkIndexer;
    private final ObjectMapper objectMapper;

    @Inject
    public MessagesAdapterES6(JestClient client, @Named(value="elasticsearch_use_expect_continue") boolean useExpectContinue, MetricRegistry metricRegistry, ChunkedBulkIndexer chunkedBulkIndexer, ObjectMapper objectMapper) {
        this.client = client;
        this.useExpectContinue = useExpectContinue;
        this.invalidTimestampMeter = metricRegistry.meter(MetricRegistry.name(Messages.class, (String[])new String[]{"invalid-timestamps"}));
        this.chunkedBulkIndexer = chunkedBulkIndexer;
        this.objectMapper = objectMapper;
    }

    public ResultMessage get(String messageId, String index) throws IOException, DocumentNotFoundException {
        Get get = ((Get.Builder)new Get.Builder(index, messageId).type("message")).build();
        DocumentResult result = this.client.execute(get);
        if (!result.isSucceeded()) {
            throw new DocumentNotFoundException(index, messageId);
        }
        Map message = result.getSourceAsObject(Map.class, false);
        return ResultMessage.parseFromSource((String)result.getId(), (String)result.getIndex(), (Map)message);
    }

    public List<String> analyze(String toAnalyze, String index, String analyzer) throws IOException {
        Analyze analyze = new Analyze.Builder().index(index).analyzer(analyzer).text(toAnalyze).build();
        JestResult result = this.client.execute(analyze);
        List tokens = (List)result.getValue("tokens");
        ArrayList<String> terms = new ArrayList<String>(tokens.size());
        tokens.forEach(token -> terms.add((String)token.get("token")));
        return terms;
    }

    private List<Messages.IndexingError> indexingErrorsFrom(List<BulkResult.BulkResultItem> failedItems, List<IndexingRequest> messageList) {
        if (failedItems.isEmpty()) {
            return Collections.emptyList();
        }
        Map messageMap = messageList.stream().map(IndexingRequest::message).distinct().collect(Collectors.toMap(Indexable::getId, Function.identity()));
        ArrayList<Messages.IndexingError> indexFailures = new ArrayList<Messages.IndexingError>(failedItems.size());
        for (BulkResult.BulkResultItem item : failedItems) {
            LOG.warn("Failed to index message: index=<{}> id=<{}> error=<{}>", new Object[]{item.index, item.id, item.error});
            Indexable messageEntry = (Indexable)messageMap.get(item.id);
            Messages.IndexingError indexFailure = this.indexingErrorFromResultItem(item, messageEntry);
            indexFailures.add(indexFailure);
        }
        return indexFailures;
    }

    private Messages.IndexingError indexingErrorFromResultItem(BulkResult.BulkResultItem item, Indexable message) {
        return Messages.IndexingError.create((Indexable)message, (String)item.index, (Messages.IndexingError.ErrorType)this.errorTypeFromResponse(item), (String)item.errorReason);
    }

    private Messages.IndexingError.ErrorType errorTypeFromResponse(BulkResult.BulkResultItem item) {
        switch (item.errorType) {
            case "cluster_block_exception": {
                return Messages.IndexingError.ErrorType.IndexBlocked;
            }
            case "mapper_parsing_exception": {
                return Messages.IndexingError.ErrorType.MappingError;
            }
            case "unavailable_shards_exception": {
                if (!item.errorReason.contains(PRIMARY_SHARD_NOT_ACTIVE_REASON)) break;
                return Messages.IndexingError.ErrorType.IndexBlocked;
            }
        }
        return Messages.IndexingError.ErrorType.Unknown;
    }

    private BulkResult runBulkRequest(Bulk request, int count) throws IOException {
        RequestConfig requestConfig = RequestConfig.custom().setExpectContinueEnabled(this.useExpectContinue).build();
        return JestUtils.execute(this.client, requestConfig, request);
    }

    public List<Messages.IndexingError> bulkIndex(List<IndexingRequest> messageList) throws IOException {
        return this.chunkedBulkIndexer.index(messageList, this::bulkIndexChunked);
    }

    private List<Messages.IndexingError> bulkIndexChunked(ChunkedBulkIndexer.Chunk command) throws ChunkedBulkIndexer.EntityTooLargeException, IOException {
        List messageList = command.requests;
        int offset = command.offset;
        int chunkSize = Math.min(messageList.size(), command.size);
        ArrayList<BulkResult.BulkResultItem> failedItems = new ArrayList<BulkResult.BulkResultItem>();
        Iterable chunks = Iterables.partition(messageList.subList(offset, messageList.size()), (int)chunkSize);
        int chunkCount = 1;
        int indexedSuccessfully = 0;
        for (List chunk : chunks) {
            BulkResult result = this.bulkIndexChunk(chunk);
            if (result.getResponseCode() == 413) {
                throw new ChunkedBulkIndexer.EntityTooLargeException(indexedSuccessfully, this.indexingErrorsFrom(failedItems, messageList));
            }
            if (result.getResponseCode() >= 400) {
                throw JestUtils.specificException(() -> "Error during bulk indexing: ", result.getJsonObject().get("error"));
            }
            indexedSuccessfully += chunk.size();
            List<BulkResult.BulkResultItem> remainingFailures = result.getFailedItems();
            failedItems.addAll(remainingFailures);
            if (LOG.isDebugEnabled()) {
                String chunkInfo = "";
                if (chunkSize != messageList.size()) {
                    chunkInfo = String.format(Locale.ROOT, " (chunk %d/%d offset %d)", chunkCount, (int)Math.ceil((double)messageList.size() / (double)chunkSize), offset);
                }
                LOG.debug("Index: Bulk indexed {} messages{}, failures: {}", new Object[]{result.getItems().size(), chunkInfo, failedItems.size()});
            }
            if (!remainingFailures.isEmpty()) {
                LOG.error("Failed to index [{}] messages. Please check the index error log in your web interface for the reason. Error: {}", (Object)remainingFailures.size(), (Object)result.getErrorMessage());
            }
            ++chunkCount;
        }
        return this.indexingErrorsFrom(failedItems, messageList);
    }

    private BulkResult bulkIndexChunk(List<IndexingRequest> chunk) throws IOException {
        Bulk.Builder bulk = new Bulk.Builder();
        for (IndexingRequest entry : chunk) {
            Indexable message = entry.message();
            bulk.addAction(((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder(message.toElasticSearchObject(this.objectMapper, this.invalidTimestampMeter)).index(entry.indexSet().getWriteIndexAlias())).type("message")).id(message.getId())).build());
        }
        return this.runBulkRequest(bulk.build(), chunk.size());
    }
}

