/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateFpgaImageRequest;
import com.amazonaws.services.ec2.model.StorageLocation;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateFpgaImageRequestMarshaller
implements Marshaller<Request<CreateFpgaImageRequest>, CreateFpgaImageRequest> {
    @Override
    public Request<CreateFpgaImageRequest> marshall(CreateFpgaImageRequest createFpgaImageRequest) {
        SdkInternalList createFpgaImageRequestTagSpecificationsList;
        StorageLocation logsStorageLocation;
        if (createFpgaImageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateFpgaImageRequest> request = new DefaultRequest<CreateFpgaImageRequest>(createFpgaImageRequest, "AmazonEC2");
        request.addParameter("Action", "CreateFpgaImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        StorageLocation inputStorageLocation = createFpgaImageRequest.getInputStorageLocation();
        if (inputStorageLocation != null) {
            if (inputStorageLocation.getBucket() != null) {
                request.addParameter("InputStorageLocation.Bucket", StringUtils.fromString(inputStorageLocation.getBucket()));
            }
            if (inputStorageLocation.getKey() != null) {
                request.addParameter("InputStorageLocation.Key", StringUtils.fromString(inputStorageLocation.getKey()));
            }
        }
        if ((logsStorageLocation = createFpgaImageRequest.getLogsStorageLocation()) != null) {
            if (logsStorageLocation.getBucket() != null) {
                request.addParameter("LogsStorageLocation.Bucket", StringUtils.fromString(logsStorageLocation.getBucket()));
            }
            if (logsStorageLocation.getKey() != null) {
                request.addParameter("LogsStorageLocation.Key", StringUtils.fromString(logsStorageLocation.getKey()));
            }
        }
        if (createFpgaImageRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createFpgaImageRequest.getDescription()));
        }
        if (createFpgaImageRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString(createFpgaImageRequest.getName()));
        }
        if (createFpgaImageRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(createFpgaImageRequest.getClientToken()));
        }
        if (!(createFpgaImageRequestTagSpecificationsList = (SdkInternalList)createFpgaImageRequest.getTagSpecifications()).isEmpty() || !createFpgaImageRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createFpgaImageRequestTagSpecificationsListValue : createFpgaImageRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createFpgaImageRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createFpgaImageRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createFpgaImageRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

