/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.CapacityReservationSpecification;
import com.amazonaws.services.ec2.model.CapacityReservationTarget;
import com.amazonaws.services.ec2.model.CpuOptionsRequest;
import com.amazonaws.services.ec2.model.CreditSpecificationRequest;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.services.ec2.model.ElasticGpuSpecification;
import com.amazonaws.services.ec2.model.ElasticInferenceAccelerator;
import com.amazonaws.services.ec2.model.EnclaveOptionsRequest;
import com.amazonaws.services.ec2.model.HibernationOptionsRequest;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.InstanceIpv6Address;
import com.amazonaws.services.ec2.model.InstanceMarketOptionsRequest;
import com.amazonaws.services.ec2.model.InstanceMetadataOptionsRequest;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.LaunchTemplateSpecification;
import com.amazonaws.services.ec2.model.LicenseConfigurationRequest;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.PrivateIpAddressSpecification;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.SpotMarketOptions;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class RunInstancesRequestMarshaller
implements Marshaller<Request<RunInstancesRequest>, RunInstancesRequest> {
    @Override
    public Request<RunInstancesRequest> marshall(RunInstancesRequest runInstancesRequest) {
        EnclaveOptionsRequest enclaveOptions;
        InstanceMetadataOptionsRequest metadataOptions;
        SdkInternalList runInstancesRequestLicenseSpecificationsList;
        HibernationOptionsRequest hibernationOptions;
        CapacityReservationSpecification capacityReservationSpecification;
        CpuOptionsRequest cpuOptions;
        CreditSpecificationRequest creditSpecification;
        InstanceMarketOptionsRequest instanceMarketOptions;
        LaunchTemplateSpecification launchTemplate;
        SdkInternalList runInstancesRequestTagSpecificationsList;
        SdkInternalList runInstancesRequestElasticInferenceAcceleratorsList;
        SdkInternalList runInstancesRequestElasticGpuSpecificationList;
        SdkInternalList runInstancesRequestNetworkInterfacesList;
        IamInstanceProfileSpecification iamInstanceProfile;
        SdkInternalList runInstancesRequestSecurityGroupsList;
        SdkInternalList runInstancesRequestSecurityGroupIdsList;
        Placement placement;
        SdkInternalList runInstancesRequestIpv6AddressesList;
        if (runInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RunInstancesRequest> request = new DefaultRequest<RunInstancesRequest>(runInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "RunInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList runInstancesRequestBlockDeviceMappingsList = (SdkInternalList)runInstancesRequest.getBlockDeviceMappings();
        if (!runInstancesRequestBlockDeviceMappingsList.isEmpty() || !runInstancesRequestBlockDeviceMappingsList.isAutoConstruct()) {
            int blockDeviceMappingsListIndex = 1;
            for (Object runInstancesRequestBlockDeviceMappingsListValue : runInstancesRequestBlockDeviceMappingsList) {
                EbsBlockDevice ebs;
                if (((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).getDeviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString(((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).getDeviceName()));
                }
                if (((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).getVirtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString(((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).getVirtualName()));
                }
                if ((ebs = ((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).getEbs()) != null) {
                    if (ebs.getDeleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean(ebs.getDeleteOnTermination()));
                    }
                    if (ebs.getIops() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger(ebs.getIops()));
                    }
                    if (ebs.getSnapshotId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString(ebs.getSnapshotId()));
                    }
                    if (ebs.getVolumeSize() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger(ebs.getVolumeSize()));
                    }
                    if (ebs.getVolumeType() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString(ebs.getVolumeType()));
                    }
                    if (ebs.getKmsKeyId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.KmsKeyId", StringUtils.fromString(ebs.getKmsKeyId()));
                    }
                    if (ebs.getThroughput() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Throughput", StringUtils.fromInteger(ebs.getThroughput()));
                    }
                    if (ebs.getEncrypted() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean(ebs.getEncrypted()));
                    }
                }
                if (((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).getNoDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString(((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).getNoDevice()));
                }
                ++blockDeviceMappingsListIndex;
            }
        }
        if (runInstancesRequest.getImageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString(runInstancesRequest.getImageId()));
        }
        if (runInstancesRequest.getInstanceType() != null) {
            request.addParameter("InstanceType", StringUtils.fromString(runInstancesRequest.getInstanceType()));
        }
        if (runInstancesRequest.getIpv6AddressCount() != null) {
            request.addParameter("Ipv6AddressCount", StringUtils.fromInteger(runInstancesRequest.getIpv6AddressCount()));
        }
        if (!(runInstancesRequestIpv6AddressesList = (SdkInternalList)runInstancesRequest.getIpv6Addresses()).isEmpty() || !runInstancesRequestIpv6AddressesList.isAutoConstruct()) {
            int ipv6AddressesListIndex = 1;
            for (InstanceIpv6Address runInstancesRequestIpv6AddressesListValue : runInstancesRequestIpv6AddressesList) {
                if (runInstancesRequestIpv6AddressesListValue.getIpv6Address() != null) {
                    request.addParameter("Ipv6Address." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils.fromString(runInstancesRequestIpv6AddressesListValue.getIpv6Address()));
                }
                ++ipv6AddressesListIndex;
            }
        }
        if (runInstancesRequest.getKernelId() != null) {
            request.addParameter("KernelId", StringUtils.fromString(runInstancesRequest.getKernelId()));
        }
        if (runInstancesRequest.getKeyName() != null) {
            request.addParameter("KeyName", StringUtils.fromString(runInstancesRequest.getKeyName()));
        }
        if (runInstancesRequest.getMaxCount() != null) {
            request.addParameter("MaxCount", StringUtils.fromInteger(runInstancesRequest.getMaxCount()));
        }
        if (runInstancesRequest.getMinCount() != null) {
            request.addParameter("MinCount", StringUtils.fromInteger(runInstancesRequest.getMinCount()));
        }
        if (runInstancesRequest.getMonitoring() != null) {
            request.addParameter("Monitoring.Enabled", StringUtils.fromBoolean(runInstancesRequest.getMonitoring()));
        }
        if ((placement = runInstancesRequest.getPlacement()) != null) {
            if (placement.getAvailabilityZone() != null) {
                request.addParameter("Placement.AvailabilityZone", StringUtils.fromString(placement.getAvailabilityZone()));
            }
            if (placement.getAffinity() != null) {
                request.addParameter("Placement.Affinity", StringUtils.fromString(placement.getAffinity()));
            }
            if (placement.getGroupName() != null) {
                request.addParameter("Placement.GroupName", StringUtils.fromString(placement.getGroupName()));
            }
            if (placement.getPartitionNumber() != null) {
                request.addParameter("Placement.PartitionNumber", StringUtils.fromInteger(placement.getPartitionNumber()));
            }
            if (placement.getHostId() != null) {
                request.addParameter("Placement.HostId", StringUtils.fromString(placement.getHostId()));
            }
            if (placement.getTenancy() != null) {
                request.addParameter("Placement.Tenancy", StringUtils.fromString(placement.getTenancy()));
            }
            if (placement.getSpreadDomain() != null) {
                request.addParameter("Placement.SpreadDomain", StringUtils.fromString(placement.getSpreadDomain()));
            }
            if (placement.getHostResourceGroupArn() != null) {
                request.addParameter("Placement.HostResourceGroupArn", StringUtils.fromString(placement.getHostResourceGroupArn()));
            }
        }
        if (runInstancesRequest.getRamdiskId() != null) {
            request.addParameter("RamdiskId", StringUtils.fromString(runInstancesRequest.getRamdiskId()));
        }
        if (!(runInstancesRequestSecurityGroupIdsList = (SdkInternalList)runInstancesRequest.getSecurityGroupIds()).isEmpty() || !runInstancesRequestSecurityGroupIdsList.isAutoConstruct()) {
            int securityGroupIdsListIndex = 1;
            for (Object runInstancesRequestSecurityGroupIdsListValue : runInstancesRequestSecurityGroupIdsList) {
                if (runInstancesRequestSecurityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)runInstancesRequestSecurityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (!(runInstancesRequestSecurityGroupsList = (SdkInternalList)runInstancesRequest.getSecurityGroups()).isEmpty() || !runInstancesRequestSecurityGroupsList.isAutoConstruct()) {
            int securityGroupsListIndex = 1;
            for (String runInstancesRequestSecurityGroupsListValue : runInstancesRequestSecurityGroupsList) {
                if (runInstancesRequestSecurityGroupsListValue != null) {
                    request.addParameter("SecurityGroup." + securityGroupsListIndex, StringUtils.fromString(runInstancesRequestSecurityGroupsListValue));
                }
                ++securityGroupsListIndex;
            }
        }
        if (runInstancesRequest.getSubnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString(runInstancesRequest.getSubnetId()));
        }
        if (runInstancesRequest.getUserData() != null) {
            request.addParameter("UserData", StringUtils.fromString(runInstancesRequest.getUserData()));
        }
        if (runInstancesRequest.getAdditionalInfo() != null) {
            request.addParameter("AdditionalInfo", StringUtils.fromString(runInstancesRequest.getAdditionalInfo()));
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString(runInstancesRequest.getClientToken()));
        if (runInstancesRequest.getDisableApiTermination() != null) {
            request.addParameter("DisableApiTermination", StringUtils.fromBoolean(runInstancesRequest.getDisableApiTermination()));
        }
        if (runInstancesRequest.getEbsOptimized() != null) {
            request.addParameter("EbsOptimized", StringUtils.fromBoolean(runInstancesRequest.getEbsOptimized()));
        }
        if ((iamInstanceProfile = runInstancesRequest.getIamInstanceProfile()) != null) {
            if (iamInstanceProfile.getArn() != null) {
                request.addParameter("IamInstanceProfile.Arn", StringUtils.fromString(iamInstanceProfile.getArn()));
            }
            if (iamInstanceProfile.getName() != null) {
                request.addParameter("IamInstanceProfile.Name", StringUtils.fromString(iamInstanceProfile.getName()));
            }
        }
        if (runInstancesRequest.getInstanceInitiatedShutdownBehavior() != null) {
            request.addParameter("InstanceInitiatedShutdownBehavior", StringUtils.fromString(runInstancesRequest.getInstanceInitiatedShutdownBehavior()));
        }
        if (!(runInstancesRequestNetworkInterfacesList = (SdkInternalList)runInstancesRequest.getNetworkInterfaces()).isEmpty() || !runInstancesRequestNetworkInterfacesList.isAutoConstruct()) {
            int networkInterfacesListIndex = 1;
            for (Object runInstancesRequestNetworkInterfacesListValue : runInstancesRequestNetworkInterfacesList) {
                SdkInternalList instanceNetworkInterfaceSpecificationPrivateIpAddressesList;
                SdkInternalList instanceNetworkInterfaceSpecificationIpv6AddressesList;
                SdkInternalList instanceNetworkInterfaceSpecificationGroupsList;
                if (((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getAssociatePublicIpAddress() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringUtils.fromBoolean(((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getAssociatePublicIpAddress()));
                }
                if (((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getDeleteOnTermination() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean(((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getDeleteOnTermination()));
                }
                if (((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getDescription() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".Description", StringUtils.fromString(((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getDescription()));
                }
                if (((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getDeviceIndex() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger(((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getDeviceIndex()));
                }
                if (!(instanceNetworkInterfaceSpecificationGroupsList = (SdkInternalList)((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getGroups()).isEmpty() || !instanceNetworkInterfaceSpecificationGroupsList.isAutoConstruct()) {
                    int groupsListIndex = 1;
                    for (Object instanceNetworkInterfaceSpecificationGroupsListValue : instanceNetworkInterfaceSpecificationGroupsList) {
                        if (instanceNetworkInterfaceSpecificationGroupsListValue != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)instanceNetworkInterfaceSpecificationGroupsListValue));
                        }
                        ++groupsListIndex;
                    }
                }
                if (((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getIpv6AddressCount() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".Ipv6AddressCount", StringUtils.fromInteger(((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getIpv6AddressCount()));
                }
                if (!(instanceNetworkInterfaceSpecificationIpv6AddressesList = (SdkInternalList)((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getIpv6Addresses()).isEmpty() || !instanceNetworkInterfaceSpecificationIpv6AddressesList.isAutoConstruct()) {
                    Object instanceNetworkInterfaceSpecificationGroupsListValue;
                    int ipv6AddressesListIndex = 1;
                    instanceNetworkInterfaceSpecificationGroupsListValue = instanceNetworkInterfaceSpecificationIpv6AddressesList.iterator();
                    while (instanceNetworkInterfaceSpecificationGroupsListValue.hasNext()) {
                        InstanceIpv6Address instanceNetworkInterfaceSpecificationIpv6AddressesListValue = (InstanceIpv6Address)instanceNetworkInterfaceSpecificationGroupsListValue.next();
                        if (instanceNetworkInterfaceSpecificationIpv6AddressesListValue.getIpv6Address() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".Ipv6Addresses." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils.fromString(instanceNetworkInterfaceSpecificationIpv6AddressesListValue.getIpv6Address()));
                        }
                        ++ipv6AddressesListIndex;
                    }
                }
                if (((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getNetworkInterfaceId() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString(((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getNetworkInterfaceId()));
                }
                if (((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getPrivateIpAddress() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString(((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getPrivateIpAddress()));
                }
                if (!(instanceNetworkInterfaceSpecificationPrivateIpAddressesList = (SdkInternalList)((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getPrivateIpAddresses()).isEmpty() || !instanceNetworkInterfaceSpecificationPrivateIpAddressesList.isAutoConstruct()) {
                    int privateIpAddressesListIndex = 1;
                    for (Object instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue : instanceNetworkInterfaceSpecificationPrivateIpAddressesList) {
                        if (((PrivateIpAddressSpecification)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue).getPrimary() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean(((PrivateIpAddressSpecification)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue).getPrimary()));
                        }
                        if (((PrivateIpAddressSpecification)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue).getPrivateIpAddress() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString(((PrivateIpAddressSpecification)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue).getPrivateIpAddress()));
                        }
                        ++privateIpAddressesListIndex;
                    }
                }
                if (((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getSecondaryPrivateIpAddressCount() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger(((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getSecondaryPrivateIpAddressCount()));
                }
                if (((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getSubnetId() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString(((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getSubnetId()));
                }
                if (((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getAssociateCarrierIpAddress() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".AssociateCarrierIpAddress", StringUtils.fromBoolean(((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getAssociateCarrierIpAddress()));
                }
                if (((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getInterfaceType() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".InterfaceType", StringUtils.fromString(((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getInterfaceType()));
                }
                if (((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getNetworkCardIndex() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".NetworkCardIndex", StringUtils.fromInteger(((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).getNetworkCardIndex()));
                }
                ++networkInterfacesListIndex;
            }
        }
        if (runInstancesRequest.getPrivateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringUtils.fromString(runInstancesRequest.getPrivateIpAddress()));
        }
        if (!(runInstancesRequestElasticGpuSpecificationList = (SdkInternalList)runInstancesRequest.getElasticGpuSpecification()).isEmpty() || !runInstancesRequestElasticGpuSpecificationList.isAutoConstruct()) {
            int elasticGpuSpecificationListIndex = 1;
            for (Object runInstancesRequestElasticGpuSpecificationListValue : runInstancesRequestElasticGpuSpecificationList) {
                if (((ElasticGpuSpecification)runInstancesRequestElasticGpuSpecificationListValue).getType() != null) {
                    request.addParameter("ElasticGpuSpecification." + elasticGpuSpecificationListIndex + ".Type", StringUtils.fromString(((ElasticGpuSpecification)runInstancesRequestElasticGpuSpecificationListValue).getType()));
                }
                ++elasticGpuSpecificationListIndex;
            }
        }
        if (!(runInstancesRequestElasticInferenceAcceleratorsList = (SdkInternalList)runInstancesRequest.getElasticInferenceAccelerators()).isEmpty() || !runInstancesRequestElasticInferenceAcceleratorsList.isAutoConstruct()) {
            int elasticInferenceAcceleratorsListIndex = 1;
            for (Object runInstancesRequestElasticInferenceAcceleratorsListValue : runInstancesRequestElasticInferenceAcceleratorsList) {
                if (((ElasticInferenceAccelerator)runInstancesRequestElasticInferenceAcceleratorsListValue).getType() != null) {
                    request.addParameter("ElasticInferenceAccelerator." + elasticInferenceAcceleratorsListIndex + ".Type", StringUtils.fromString(((ElasticInferenceAccelerator)runInstancesRequestElasticInferenceAcceleratorsListValue).getType()));
                }
                if (((ElasticInferenceAccelerator)runInstancesRequestElasticInferenceAcceleratorsListValue).getCount() != null) {
                    request.addParameter("ElasticInferenceAccelerator." + elasticInferenceAcceleratorsListIndex + ".Count", StringUtils.fromInteger(((ElasticInferenceAccelerator)runInstancesRequestElasticInferenceAcceleratorsListValue).getCount()));
                }
                ++elasticInferenceAcceleratorsListIndex;
            }
        }
        if (!(runInstancesRequestTagSpecificationsList = (SdkInternalList)runInstancesRequest.getTagSpecifications()).isEmpty() || !runInstancesRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification runInstancesRequestTagSpecificationsListValue : runInstancesRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (runInstancesRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(runInstancesRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)runInstancesRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if ((launchTemplate = runInstancesRequest.getLaunchTemplate()) != null) {
            if (launchTemplate.getLaunchTemplateId() != null) {
                request.addParameter("LaunchTemplate.LaunchTemplateId", StringUtils.fromString(launchTemplate.getLaunchTemplateId()));
            }
            if (launchTemplate.getLaunchTemplateName() != null) {
                request.addParameter("LaunchTemplate.LaunchTemplateName", StringUtils.fromString(launchTemplate.getLaunchTemplateName()));
            }
            if (launchTemplate.getVersion() != null) {
                request.addParameter("LaunchTemplate.Version", StringUtils.fromString(launchTemplate.getVersion()));
            }
        }
        if ((instanceMarketOptions = runInstancesRequest.getInstanceMarketOptions()) != null) {
            SpotMarketOptions spotOptions;
            if (instanceMarketOptions.getMarketType() != null) {
                request.addParameter("InstanceMarketOptions.MarketType", StringUtils.fromString(instanceMarketOptions.getMarketType()));
            }
            if ((spotOptions = instanceMarketOptions.getSpotOptions()) != null) {
                if (spotOptions.getMaxPrice() != null) {
                    request.addParameter("InstanceMarketOptions.SpotOptions.MaxPrice", StringUtils.fromString(spotOptions.getMaxPrice()));
                }
                if (spotOptions.getSpotInstanceType() != null) {
                    request.addParameter("InstanceMarketOptions.SpotOptions.SpotInstanceType", StringUtils.fromString(spotOptions.getSpotInstanceType()));
                }
                if (spotOptions.getBlockDurationMinutes() != null) {
                    request.addParameter("InstanceMarketOptions.SpotOptions.BlockDurationMinutes", StringUtils.fromInteger(spotOptions.getBlockDurationMinutes()));
                }
                if (spotOptions.getValidUntil() != null) {
                    request.addParameter("InstanceMarketOptions.SpotOptions.ValidUntil", StringUtils.fromDate(spotOptions.getValidUntil()));
                }
                if (spotOptions.getInstanceInterruptionBehavior() != null) {
                    request.addParameter("InstanceMarketOptions.SpotOptions.InstanceInterruptionBehavior", StringUtils.fromString(spotOptions.getInstanceInterruptionBehavior()));
                }
            }
        }
        if ((creditSpecification = runInstancesRequest.getCreditSpecification()) != null && creditSpecification.getCpuCredits() != null) {
            request.addParameter("CreditSpecification.CpuCredits", StringUtils.fromString(creditSpecification.getCpuCredits()));
        }
        if ((cpuOptions = runInstancesRequest.getCpuOptions()) != null) {
            if (cpuOptions.getCoreCount() != null) {
                request.addParameter("CpuOptions.CoreCount", StringUtils.fromInteger(cpuOptions.getCoreCount()));
            }
            if (cpuOptions.getThreadsPerCore() != null) {
                request.addParameter("CpuOptions.ThreadsPerCore", StringUtils.fromInteger(cpuOptions.getThreadsPerCore()));
            }
        }
        if ((capacityReservationSpecification = runInstancesRequest.getCapacityReservationSpecification()) != null) {
            CapacityReservationTarget capacityReservationTarget;
            if (capacityReservationSpecification.getCapacityReservationPreference() != null) {
                request.addParameter("CapacityReservationSpecification.CapacityReservationPreference", StringUtils.fromString(capacityReservationSpecification.getCapacityReservationPreference()));
            }
            if ((capacityReservationTarget = capacityReservationSpecification.getCapacityReservationTarget()) != null) {
                if (capacityReservationTarget.getCapacityReservationId() != null) {
                    request.addParameter("CapacityReservationSpecification.CapacityReservationTarget.CapacityReservationId", StringUtils.fromString(capacityReservationTarget.getCapacityReservationId()));
                }
                if (capacityReservationTarget.getCapacityReservationResourceGroupArn() != null) {
                    request.addParameter("CapacityReservationSpecification.CapacityReservationTarget.CapacityReservationResourceGroupArn", StringUtils.fromString(capacityReservationTarget.getCapacityReservationResourceGroupArn()));
                }
            }
        }
        if ((hibernationOptions = runInstancesRequest.getHibernationOptions()) != null && hibernationOptions.getConfigured() != null) {
            request.addParameter("HibernationOptions.Configured", StringUtils.fromBoolean(hibernationOptions.getConfigured()));
        }
        if (!(runInstancesRequestLicenseSpecificationsList = (SdkInternalList)runInstancesRequest.getLicenseSpecifications()).isEmpty() || !runInstancesRequestLicenseSpecificationsList.isAutoConstruct()) {
            int licenseSpecificationsListIndex = 1;
            for (LicenseConfigurationRequest runInstancesRequestLicenseSpecificationsListValue : runInstancesRequestLicenseSpecificationsList) {
                if (runInstancesRequestLicenseSpecificationsListValue.getLicenseConfigurationArn() != null) {
                    request.addParameter("LicenseSpecification." + licenseSpecificationsListIndex + ".LicenseConfigurationArn", StringUtils.fromString(runInstancesRequestLicenseSpecificationsListValue.getLicenseConfigurationArn()));
                }
                ++licenseSpecificationsListIndex;
            }
        }
        if ((metadataOptions = runInstancesRequest.getMetadataOptions()) != null) {
            if (metadataOptions.getHttpTokens() != null) {
                request.addParameter("MetadataOptions.HttpTokens", StringUtils.fromString(metadataOptions.getHttpTokens()));
            }
            if (metadataOptions.getHttpPutResponseHopLimit() != null) {
                request.addParameter("MetadataOptions.HttpPutResponseHopLimit", StringUtils.fromInteger(metadataOptions.getHttpPutResponseHopLimit()));
            }
            if (metadataOptions.getHttpEndpoint() != null) {
                request.addParameter("MetadataOptions.HttpEndpoint", StringUtils.fromString(metadataOptions.getHttpEndpoint()));
            }
        }
        if ((enclaveOptions = runInstancesRequest.getEnclaveOptions()) != null && enclaveOptions.getEnabled() != null) {
            request.addParameter("EnclaveOptions.Enabled", StringUtils.fromBoolean(enclaveOptions.getEnabled()));
        }
        return request;
    }
}

