/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.exceptions.InvalidStateException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.KinesisClientLibDependencyException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.KinesisClientLibException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.ShutdownException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.ThrottlingException;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.ICheckpoint;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IPreparedCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.DoesNothingPreparedCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.PreparedCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.SequenceNumberValidator;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardInfo;
import com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import com.amazonaws.services.kinesis.clientlibrary.types.UserRecord;
import com.amazonaws.services.kinesis.metrics.impl.MetricsHelper;
import com.amazonaws.services.kinesis.metrics.impl.ThreadSafeMetricsDelegatingScope;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import com.amazonaws.services.kinesis.model.Record;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class RecordProcessorCheckpointer
implements IRecordProcessorCheckpointer {
    private static final Log LOG = LogFactory.getLog(RecordProcessorCheckpointer.class);
    private ICheckpoint checkpoint;
    private ExtendedSequenceNumber largestPermittedCheckpointValue;
    private ExtendedSequenceNumber lastCheckpointValue;
    private ShardInfo shardInfo;
    private SequenceNumberValidator sequenceNumberValidator;
    private ExtendedSequenceNumber sequenceNumberAtShardEnd;
    private IMetricsFactory metricsFactory;

    RecordProcessorCheckpointer(ShardInfo shardInfo, ICheckpoint checkpoint, SequenceNumberValidator validator, IMetricsFactory metricsFactory) {
        this.shardInfo = shardInfo;
        this.checkpoint = checkpoint;
        this.sequenceNumberValidator = validator;
        this.metricsFactory = metricsFactory;
    }

    @Override
    public synchronized void checkpoint() throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checkpointing " + this.shardInfo.getShardId() + ",  token " + this.shardInfo.getConcurrencyToken() + " at largest permitted value " + this.largestPermittedCheckpointValue);
        }
        this.advancePosition(this.largestPermittedCheckpointValue);
    }

    @Override
    public synchronized void checkpoint(Record record) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException, IllegalArgumentException {
        if (record == null) {
            throw new IllegalArgumentException("Could not checkpoint a null record");
        }
        if (record instanceof UserRecord) {
            this.checkpoint(record.getSequenceNumber(), ((UserRecord)record).getSubSequenceNumber());
        } else {
            this.checkpoint(record.getSequenceNumber(), 0L);
        }
    }

    @Override
    public synchronized void checkpoint(String sequenceNumber) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException, IllegalArgumentException {
        this.checkpoint(sequenceNumber, 0L);
    }

    @Override
    public synchronized void checkpoint(String sequenceNumber, long subSequenceNumber) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException, IllegalArgumentException {
        if (subSequenceNumber < 0L) {
            throw new IllegalArgumentException("Could not checkpoint at invalid, negative subsequence number " + subSequenceNumber);
        }
        this.sequenceNumberValidator.validateSequenceNumber(sequenceNumber);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validated checkpoint sequence number " + sequenceNumber + " for " + this.shardInfo.getShardId() + ", token " + this.shardInfo.getConcurrencyToken());
        }
        ExtendedSequenceNumber newCheckpoint = new ExtendedSequenceNumber(sequenceNumber, subSequenceNumber);
        if ((this.lastCheckpointValue == null || this.lastCheckpointValue.compareTo(newCheckpoint) <= 0) && newCheckpoint.compareTo(this.largestPermittedCheckpointValue) <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checkpointing " + this.shardInfo.getShardId() + ", token " + this.shardInfo.getConcurrencyToken() + " at specific extended sequence number " + newCheckpoint);
            }
        } else {
            throw new IllegalArgumentException(String.format("Could not checkpoint at extended sequence number %s as it did not fall into acceptable range between the last checkpoint %s and the greatest extended sequence number passed to this record processor %s", newCheckpoint, this.lastCheckpointValue, this.largestPermittedCheckpointValue));
        }
        this.advancePosition(newCheckpoint);
    }

    @Override
    public synchronized IPreparedCheckpointer prepareCheckpoint() throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        return this.prepareCheckpoint(this.largestPermittedCheckpointValue.getSequenceNumber(), this.largestPermittedCheckpointValue.getSubSequenceNumber());
    }

    @Override
    public synchronized IPreparedCheckpointer prepareCheckpoint(Record record) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        if (record == null) {
            throw new IllegalArgumentException("Could not prepare checkpoint a null record");
        }
        if (record instanceof UserRecord) {
            return this.prepareCheckpoint(record.getSequenceNumber(), ((UserRecord)record).getSubSequenceNumber());
        }
        return this.prepareCheckpoint(record.getSequenceNumber(), 0L);
    }

    @Override
    public synchronized IPreparedCheckpointer prepareCheckpoint(String sequenceNumber) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        return this.prepareCheckpoint(sequenceNumber, 0L);
    }

    @Override
    public synchronized IPreparedCheckpointer prepareCheckpoint(String sequenceNumber, long subSequenceNumber) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        if (subSequenceNumber < 0L) {
            throw new IllegalArgumentException("Could not checkpoint at invalid, negative subsequence number " + subSequenceNumber);
        }
        this.sequenceNumberValidator.validateSequenceNumber(sequenceNumber);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validated prepareCheckpoint sequence number " + sequenceNumber + " for " + this.shardInfo.getShardId() + ", token " + this.shardInfo.getConcurrencyToken());
        }
        ExtendedSequenceNumber pendingCheckpoint = new ExtendedSequenceNumber(sequenceNumber, subSequenceNumber);
        if ((this.lastCheckpointValue == null || this.lastCheckpointValue.compareTo(pendingCheckpoint) <= 0) && pendingCheckpoint.compareTo(this.largestPermittedCheckpointValue) <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Preparing checkpoint " + this.shardInfo.getShardId() + ", token " + this.shardInfo.getConcurrencyToken() + " at specific extended sequence number " + pendingCheckpoint);
            }
            return this.doPrepareCheckpoint(pendingCheckpoint);
        }
        throw new IllegalArgumentException(String.format("Could not prepare checkpoint at extended sequence number %s as it did not fall into acceptable range between the last checkpoint %s and the greatest extended sequence number passed to this record processor %s", pendingCheckpoint, this.lastCheckpointValue, this.largestPermittedCheckpointValue));
    }

    ExtendedSequenceNumber getLastCheckpointValue() {
        return this.lastCheckpointValue;
    }

    synchronized void setInitialCheckpointValue(ExtendedSequenceNumber initialCheckpoint) {
        this.lastCheckpointValue = initialCheckpoint;
    }

    synchronized ExtendedSequenceNumber getLargestPermittedCheckpointValue() {
        return this.largestPermittedCheckpointValue;
    }

    synchronized void setLargestPermittedCheckpointValue(ExtendedSequenceNumber largestPermittedCheckpointValue) {
        this.largestPermittedCheckpointValue = largestPermittedCheckpointValue;
    }

    synchronized void setSequenceNumberAtShardEnd(ExtendedSequenceNumber extendedSequenceNumber) {
        this.sequenceNumberAtShardEnd = extendedSequenceNumber;
    }

    void advancePosition(String sequenceNumber) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        this.advancePosition(new ExtendedSequenceNumber(sequenceNumber));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void advancePosition(ExtendedSequenceNumber extendedSequenceNumber) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        block10: {
            ExtendedSequenceNumber checkpointToRecord = extendedSequenceNumber;
            if (this.sequenceNumberAtShardEnd != null && this.sequenceNumberAtShardEnd.equals(extendedSequenceNumber)) {
                checkpointToRecord = ExtendedSequenceNumber.SHARD_END;
            }
            boolean unsetMetrics = false;
            try {
                if (!MetricsHelper.isMetricsScopePresent()) {
                    MetricsHelper.setMetricsScope(new ThreadSafeMetricsDelegatingScope(this.metricsFactory.createMetrics()));
                    unsetMetrics = true;
                }
                if (extendedSequenceNumber == null || extendedSequenceNumber.equals(this.lastCheckpointValue)) break block10;
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Setting " + this.shardInfo.getShardId() + ", token " + this.shardInfo.getConcurrencyToken() + " checkpoint to " + checkpointToRecord);
                    }
                    this.checkpoint.setCheckpoint(this.shardInfo.getShardId(), checkpointToRecord, this.shardInfo.getConcurrencyToken());
                    this.lastCheckpointValue = checkpointToRecord;
                }
                catch (InvalidStateException | KinesisClientLibDependencyException | ShutdownException | ThrottlingException e) {
                    throw e;
                }
                catch (KinesisClientLibException e) {
                    LOG.warn("Caught exception setting checkpoint.", e);
                    throw new KinesisClientLibDependencyException("Caught exception while checkpointing", e);
                }
            }
            finally {
                if (unsetMetrics) {
                    MetricsHelper.unsetMetricsScope();
                }
            }
        }
    }

    private IPreparedCheckpointer doPrepareCheckpoint(ExtendedSequenceNumber extendedSequenceNumber) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        ExtendedSequenceNumber newPrepareCheckpoint = extendedSequenceNumber;
        if (this.sequenceNumberAtShardEnd != null && this.sequenceNumberAtShardEnd.equals(extendedSequenceNumber)) {
            newPrepareCheckpoint = ExtendedSequenceNumber.SHARD_END;
        }
        if (newPrepareCheckpoint.equals(this.lastCheckpointValue)) {
            return new DoesNothingPreparedCheckpointer(newPrepareCheckpoint);
        }
        try {
            this.checkpoint.prepareCheckpoint(this.shardInfo.getShardId(), newPrepareCheckpoint, this.shardInfo.getConcurrencyToken());
        }
        catch (InvalidStateException | KinesisClientLibDependencyException | ShutdownException | ThrottlingException e) {
            throw e;
        }
        catch (KinesisClientLibException e) {
            LOG.warn("Caught exception setting prepareCheckpoint.", e);
            throw new KinesisClientLibDependencyException("Caught exception while prepareCheckpointing", e);
        }
        PreparedCheckpointer result = new PreparedCheckpointer(newPrepareCheckpoint, this);
        return result;
    }
}

