/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.aws.processors.instancelookup;

import com.amazonaws.regions.Regions;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.AmazonEC2ClientBuilder;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.DescribeNetworkInterfacesResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceNetworkInterface;
import com.amazonaws.services.ec2.model.InstancePrivateIpAddress;
import com.amazonaws.services.ec2.model.NetworkInterface;
import com.amazonaws.services.ec2.model.NetworkInterfacePrivateIpAddress;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.Tag;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.inject.Singleton;
import okhttp3.HttpUrl;
import org.graylog.aws.auth.AWSAuthProvider;
import org.graylog.aws.config.Proxy;
import org.graylog.aws.processors.instancelookup.DiscoveredEC2Instance;
import org.graylog.aws.processors.instancelookup.DiscoveredELBInstance;
import org.graylog.aws.processors.instancelookup.DiscoveredInstance;
import org.graylog.aws.processors.instancelookup.DiscoveredRDSInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InstanceLookupTable {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceLookupTable.class);
    private boolean loaded = false;
    private ImmutableMap<String, Instance> ec2Instances;
    private ImmutableMap<String, NetworkInterface> networkInterfaces;

    public void reload(List<Regions> regions, AWSAuthProvider awsAuthProvider, HttpUrl proxyUrl) {
        LOG.debug("Reloading AWS instance lookup table.");
        ImmutableMap.Builder ec2InstancesBuilder = ImmutableMap.builder();
        ImmutableMap.Builder networkInterfacesBuilder = ImmutableMap.builder();
        for (Regions region : regions) {
            try {
                AmazonEC2 ec2Client = proxyUrl != null ? (AmazonEC2)((AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)AmazonEC2Client.builder().withCredentials(awsAuthProvider)).withRegion(region)).withClientConfiguration(Proxy.forAWS(proxyUrl))).build() : (AmazonEC2)((AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)AmazonEC2Client.builder().withCredentials(awsAuthProvider)).withRegion(region)).build();
                LOG.debug("Requesting AWS network interface descriptions in [{}].", (Object)region.getName());
                DescribeNetworkInterfacesResult interfaces = ec2Client.describeNetworkInterfaces();
                for (NetworkInterface iface : interfaces.getNetworkInterfaces()) {
                    LOG.debug("Discovered network interface [{}].", (Object)iface.getNetworkInterfaceId());
                    for (NetworkInterfacePrivateIpAddress privateIp : iface.getPrivateIpAddresses()) {
                        LOG.debug("Network interface [{}] has private IP: {}", (Object)iface.getNetworkInterfaceId(), (Object)privateIp);
                        networkInterfacesBuilder.put((Object)privateIp.getPrivateIpAddress(), (Object)iface);
                    }
                    if (iface.getAssociation() == null) continue;
                    String publicIp = iface.getAssociation().getPublicIp();
                    LOG.debug("Network interface [{}] has public IP: {}", (Object)iface.getNetworkInterfaceId(), (Object)publicIp);
                    networkInterfacesBuilder.put((Object)publicIp, (Object)iface);
                }
                LOG.debug("Requesting EC2 instance descriptions in [{}].", (Object)region.getName());
                DescribeInstancesResult ec2Result = ec2Client.describeInstances();
                for (Reservation reservation : ec2Result.getReservations()) {
                    LOG.debug("Fetching instances for reservation [{}].", (Object)reservation.getReservationId());
                    for (Instance instance : reservation.getInstances()) {
                        LOG.debug("Discovered EC2 instance [{}].", (Object)instance.getInstanceId());
                        for (InstanceNetworkInterface iface : instance.getNetworkInterfaces()) {
                            for (InstancePrivateIpAddress privateIp : iface.getPrivateIpAddresses()) {
                                LOG.debug("EC2 instance [{}] has private IP: {}", (Object)instance.getInstanceId(), (Object)privateIp.getPrivateIpAddress());
                                ec2InstancesBuilder.put((Object)privateIp.getPrivateIpAddress(), (Object)instance);
                            }
                        }
                        String publicIp = instance.getPublicIpAddress();
                        if (publicIp == null) continue;
                        LOG.debug("EC2 instance [{}] has public IP: {}", (Object)instance.getInstanceId(), (Object)publicIp);
                        ec2InstancesBuilder.put((Object)publicIp, (Object)instance);
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Error when trying to refresh AWS instance lookup table in [{}]", (Object)region.getName(), (Object)e);
            }
        }
        this.ec2Instances = ec2InstancesBuilder.build();
        this.networkInterfaces = networkInterfacesBuilder.build();
        this.loaded = true;
    }

    public DiscoveredInstance findByIp(String ip) {
        try {
            if (this.ec2Instances.containsKey((Object)ip)) {
                Instance instance = (Instance)this.ec2Instances.get((Object)ip);
                LOG.debug("Found IP [{}] in EC2 instance lookup table.", (Object)ip);
                return new DiscoveredEC2Instance(instance.getInstanceId(), this.getNameOfInstance(instance));
            }
            if (this.networkInterfaces.containsKey((Object)ip)) {
                NetworkInterface iface = (NetworkInterface)this.networkInterfaces.get((Object)ip);
                switch (this.determineType(iface)) {
                    case RDS: {
                        return new DiscoveredRDSInstance(null, null);
                    }
                    case EC2: {
                        break;
                    }
                    case ELB: {
                        return new DiscoveredELBInstance(this.getELBNameFromInterface(iface), null);
                    }
                    case UNKNOWN: {
                        LOG.debug("IP [{}] in table of network interfaces but of unknown instance type.", (Object)ip);
                        return DiscoveredInstance.UNDISCOVERED;
                    }
                }
            }
            return DiscoveredInstance.UNDISCOVERED;
        }
        catch (Exception e) {
            LOG.error("Error when trying to match IP to AWS instance. Marking as undiscovered.", (Throwable)e);
            return DiscoveredInstance.UNDISCOVERED;
        }
    }

    private String getELBNameFromInterface(NetworkInterface iface) {
        try {
            String[] parts = iface.getDescription().split(" ");
            if (parts.length == 2) {
                return parts[1];
            }
            LOG.warn("Unexpected ELB name in network interface description: [{}]", (Object)iface.getDescription());
            return "unknown-name";
        }
        catch (Exception e) {
            LOG.warn("Could not get ELB name from network interface description. Description was [{}]", (Object)iface.getDescription(), (Object)e);
            return "unknown-name";
        }
    }

    private InstanceType determineType(NetworkInterface iface) {
        String ownerId;
        if (iface.getAssociation() != null) {
            ownerId = iface.getAssociation().getIpOwnerId();
        } else if (iface.getRequesterId().equals("amazon-rds")) {
            ownerId = "amazon-rds";
        } else {
            LOG.debug("AWS network interface with no association: [{}]", (Object)iface.getDescription());
            return InstanceType.UNKNOWN;
        }
        if ("amazon".equals(ownerId)) {
            return InstanceType.EC2;
        }
        if ("amazon-elb".equals(ownerId)) {
            return InstanceType.ELB;
        }
        if ("amazon-rds".equals(ownerId)) {
            return InstanceType.RDS;
        }
        return InstanceType.UNKNOWN;
    }

    private String getNameOfInstance(Instance x) {
        for (Tag tag : x.getTags()) {
            if (!"Name".equals(tag.getKey())) continue;
            return tag.getValue();
        }
        return null;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    static enum InstanceType {
        RDS,
        EC2,
        ELB,
        UNKNOWN;

    }
}

