/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc;

import java.util.Arrays;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.CharCollection;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.CharLookupContainer;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.cursors.CharCursor;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.predicates.CharPredicate;

abstract class AbstractCharCollection
implements CharCollection {
    AbstractCharCollection() {
    }

    @Override
    public int removeAll(final CharLookupContainer c) {
        return this.removeAll(new CharPredicate(){

            @Override
            public boolean apply(char k) {
                return c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final CharLookupContainer c) {
        return this.removeAll(new CharPredicate(){

            @Override
            public boolean apply(char k) {
                return !c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final CharPredicate predicate) {
        return this.removeAll(new CharPredicate(){

            @Override
            public boolean apply(char value) {
                return !predicate.apply(value);
            }
        });
    }

    @Override
    public char[] toArray() {
        char[] array = new char[this.size()];
        int i = 0;
        for (CharCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

