/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.index;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.codecs.DocValuesConsumer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.DocValuesWriter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.DocsWithFieldSet;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.EmptyDocValuesProducer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.SegmentWriteState;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.Sorter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.SortingLeafReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Counter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.FixedBitSet;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.packed.PackedLongValues;

class NumericDocValuesWriter
extends DocValuesWriter<NumericDocValues> {
    private PackedLongValues.Builder pending = PackedLongValues.deltaPackedBuilder(0.0f);
    private PackedLongValues finalValues;
    private final Counter iwBytesUsed;
    private long bytesUsed;
    private DocsWithFieldSet docsWithField = new DocsWithFieldSet();
    private final FieldInfo fieldInfo;
    private int lastDocID = -1;

    public NumericDocValuesWriter(FieldInfo fieldInfo, Counter iwBytesUsed) {
        this.bytesUsed = this.pending.ramBytesUsed() + this.docsWithField.ramBytesUsed();
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        iwBytesUsed.addAndGet(this.bytesUsed);
    }

    public void addValue(int docID, long value) {
        if (docID <= this.lastDocID) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
        }
        this.pending.add(value);
        this.docsWithField.add(docID);
        this.updateBytesUsed();
        this.lastDocID = docID;
    }

    private void updateBytesUsed() {
        long newBytesUsed = this.pending.ramBytesUsed() + this.docsWithField.ramBytesUsed();
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    @Override
    NumericDocValues getDocValues() {
        if (this.finalValues == null) {
            this.finalValues = this.pending.build();
        }
        return new BufferedNumericDocValues(this.finalValues, this.docsWithField.iterator());
    }

    static SortingLeafReader.CachedNumericDVs sortDocValues(int maxDoc, Sorter.DocMap sortMap, NumericDocValues oldDocValues) throws IOException {
        int docID;
        FixedBitSet docsWithField = new FixedBitSet(maxDoc);
        long[] values = new long[maxDoc];
        while ((docID = oldDocValues.nextDoc()) != Integer.MAX_VALUE) {
            int newDocID = sortMap.oldToNew(docID);
            docsWithField.set(newDocID);
            values[newDocID] = oldDocValues.longValue();
        }
        return new SortingLeafReader.CachedNumericDVs(values, docsWithField);
    }

    @Override
    public void flush(SegmentWriteState state, Sorter.DocMap sortMap, DocValuesConsumer dvConsumer) throws IOException {
        SortingLeafReader.CachedNumericDVs sorted;
        if (this.finalValues == null) {
            this.finalValues = this.pending.build();
        }
        if (sortMap != null) {
            BufferedNumericDocValues oldValues = new BufferedNumericDocValues(this.finalValues, this.docsWithField.iterator());
            sorted = NumericDocValuesWriter.sortDocValues(state.segmentInfo.maxDoc(), sortMap, oldValues);
        } else {
            sorted = null;
        }
        dvConsumer.addNumericField(this.fieldInfo, new EmptyDocValuesProducer(){

            @Override
            public NumericDocValues getNumeric(FieldInfo fieldInfo) {
                if (fieldInfo != NumericDocValuesWriter.this.fieldInfo) {
                    throw new IllegalArgumentException("wrong fieldInfo");
                }
                if (sorted == null) {
                    return new BufferedNumericDocValues(NumericDocValuesWriter.this.finalValues, NumericDocValuesWriter.this.docsWithField.iterator());
                }
                return new SortingLeafReader.SortingNumericDocValues(sorted);
            }
        });
    }

    private static class BufferedNumericDocValues
    extends NumericDocValues {
        final PackedLongValues.Iterator iter;
        final DocIdSetIterator docsWithField;
        private long value;

        BufferedNumericDocValues(PackedLongValues values, DocIdSetIterator docsWithFields) {
            this.iter = values.iterator();
            this.docsWithField = docsWithFields;
        }

        @Override
        public int docID() {
            return this.docsWithField.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int docID = this.docsWithField.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                this.value = this.iter.next();
            }
            return docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            return this.docsWithField.cost();
        }

        @Override
        public long longValue() {
            return this.value;
        }
    }
}

