/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search.highlight;

import java.util.List;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.highlight.Fragmenter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.highlight.PositionSpan;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.highlight.QueryScorer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.highlight.WeightedSpanTerm;

public class SimpleSpanFragmenter
implements Fragmenter {
    private static final int DEFAULT_FRAGMENT_SIZE = 100;
    private int fragmentSize;
    private int currentNumFrags;
    private int position = -1;
    private QueryScorer queryScorer;
    private int waitForPos = -1;
    private int textSize;
    private CharTermAttribute termAtt;
    private PositionIncrementAttribute posIncAtt;
    private OffsetAttribute offsetAtt;

    public SimpleSpanFragmenter(QueryScorer queryScorer) {
        this(queryScorer, 100);
    }

    public SimpleSpanFragmenter(QueryScorer queryScorer, int fragmentSize) {
        this.fragmentSize = fragmentSize;
        this.queryScorer = queryScorer;
    }

    @Override
    public boolean isNewFragment() {
        boolean isNewFrag;
        this.position += this.posIncAtt.getPositionIncrement();
        if (this.waitForPos <= this.position) {
            this.waitForPos = -1;
        } else if (this.waitForPos != -1) {
            return false;
        }
        WeightedSpanTerm wSpanTerm = this.queryScorer.getWeightedSpanTerm(this.termAtt.toString());
        if (wSpanTerm != null) {
            List<PositionSpan> positionSpans = wSpanTerm.getPositionSpans();
            for (PositionSpan positionSpan : positionSpans) {
                if (positionSpan.start != this.position) continue;
                this.waitForPos = positionSpan.end + 1;
                break;
            }
        }
        boolean bl = isNewFrag = this.offsetAtt.endOffset() >= this.fragmentSize * this.currentNumFrags && this.textSize - this.offsetAtt.endOffset() >= this.fragmentSize >>> 1;
        if (isNewFrag) {
            ++this.currentNumFrags;
        }
        return isNewFrag;
    }

    @Override
    public void start(String originalText, TokenStream tokenStream) {
        this.position = -1;
        this.currentNumFrags = 1;
        this.textSize = originalText.length();
        this.termAtt = tokenStream.addAttribute(CharTermAttribute.class);
        this.posIncAtt = tokenStream.addAttribute(PositionIncrementAttribute.class);
        this.offsetAtt = tokenStream.addAttribute(OffsetAttribute.class);
    }
}

