/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search.similarities;

import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Explanation;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.similarities.BasicStats;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.similarities.Normalization;

public class NormalizationH3
extends Normalization {
    private final float mu;

    public NormalizationH3() {
        this(800.0f);
    }

    public NormalizationH3(float mu) {
        if (!Float.isFinite(mu) || mu < 0.0f) {
            throw new IllegalArgumentException("illegal mu value: " + mu + ", must be a non-negative finite value");
        }
        this.mu = mu;
    }

    @Override
    public double tfn(BasicStats stats, double tf, double len) {
        return (tf + (double)(this.mu * (((float)stats.getTotalTermFreq() + 1.0f) / ((float)stats.getNumberOfFieldTokens() + 1.0f)))) / (len + (double)this.mu) * (double)this.mu;
    }

    @Override
    public Explanation explain(BasicStats stats, double tf, double len) {
        return Explanation.match((Number)Float.valueOf((float)this.tfn(stats, tf, len)), this.getClass().getSimpleName() + ", computed as (tf + mu * ((F+1) / (T+1))) / (fl + mu) * mu from:", Explanation.match((Number)Float.valueOf((float)tf), "tf, number of occurrences of term in the document", new Explanation[0]), Explanation.match((Number)Float.valueOf(this.mu), "mu, smoothing parameter", new Explanation[0]), Explanation.match((Number)Float.valueOf(stats.getTotalTermFreq()), "F,  total number of occurrences of term across all documents", new Explanation[0]), Explanation.match((Number)Float.valueOf(stats.getNumberOfFieldTokens()), "T, total number of tokens of the field across all documents", new Explanation[0]), Explanation.match((Number)Float.valueOf((float)len), "fl, field length of the document", new Explanation[0]));
    }

    @Override
    public String toString() {
        return "3(" + this.mu + ")";
    }

    public float getMu() {
        return this.mu;
    }
}

