/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial;

import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.Field;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DoubleValuesSource;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial.query.SpatialArgs;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial.util.ReciprocalDoubleValuesSource;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;

public abstract class SpatialStrategy {
    protected final SpatialContext ctx;
    private final String fieldName;

    public SpatialStrategy(SpatialContext ctx, String fieldName) {
        if (ctx == null) {
            throw new IllegalArgumentException("ctx is required");
        }
        this.ctx = ctx;
        if (fieldName == null || fieldName.length() == 0) {
            throw new IllegalArgumentException("fieldName is required");
        }
        this.fieldName = fieldName;
    }

    public SpatialContext getSpatialContext() {
        return this.ctx;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public abstract Field[] createIndexableFields(Shape var1);

    public DoubleValuesSource makeDistanceValueSource(Point queryPoint) {
        return this.makeDistanceValueSource(queryPoint, 1.0);
    }

    public abstract DoubleValuesSource makeDistanceValueSource(Point var1, double var2);

    public abstract Query makeQuery(SpatialArgs var1);

    public final DoubleValuesSource makeRecipDistanceValueSource(Shape queryShape) {
        Rectangle bbox = queryShape.getBoundingBox();
        double diagonalDist = this.ctx.getDistCalc().distance(this.ctx.makePoint(bbox.getMinX(), bbox.getMinY()), bbox.getMaxX(), bbox.getMaxY());
        double distToEdge = diagonalDist * 0.5;
        float c = (float)distToEdge * 0.1f;
        DoubleValuesSource distance = this.makeDistanceValueSource(queryShape.getCenter(), 1.0);
        return new ReciprocalDoubleValuesSource(c, distance);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " field:" + this.fieldName + " ctx=" + this.ctx;
    }
}

