/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.asyncsearch;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParserUtils;

public class AsyncSearchResponse
implements ToXContentObject {
    @Nullable
    private final String id;
    @Nullable
    private final SearchResponse searchResponse;
    @Nullable
    private final ElasticsearchException error;
    private final boolean isRunning;
    private final boolean isPartial;
    private final long startTimeMillis;
    private final long expirationTimeMillis;
    public static final ParseField ID_FIELD = new ParseField("id", new String[0]);
    public static final ParseField IS_PARTIAL_FIELD = new ParseField("is_partial", new String[0]);
    public static final ParseField IS_RUNNING_FIELD = new ParseField("is_running", new String[0]);
    public static final ParseField START_TIME_FIELD = new ParseField("start_time_in_millis", new String[0]);
    public static final ParseField EXPIRATION_FIELD = new ParseField("expiration_time_in_millis", new String[0]);
    public static final ParseField RESPONSE_FIELD = new ParseField("response", new String[0]);
    public static final ParseField ERROR_FIELD = new ParseField("error", new String[0]);
    public static final ConstructingObjectParser<AsyncSearchResponse, Void> PARSER = new ConstructingObjectParser("submit_async_search_response", true, args -> new AsyncSearchResponse((Boolean)args[0], (Boolean)args[1], (Long)args[2], (Long)args[3], (String)args[4], (SearchResponse)args[5], (ElasticsearchException)args[6]));

    AsyncSearchResponse(boolean isPartial, boolean isRunning, long startTimeMillis, long expirationTimeMillis, @Nullable String id, @Nullable SearchResponse searchResponse, @Nullable ElasticsearchException error) {
        this.isPartial = isPartial;
        this.isRunning = isRunning;
        this.startTimeMillis = startTimeMillis;
        this.expirationTimeMillis = expirationTimeMillis;
        this.id = id;
        this.searchResponse = searchResponse;
        this.error = error;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public SearchResponse getSearchResponse() {
        return this.searchResponse;
    }

    public ElasticsearchException getFailure() {
        return this.error;
    }

    public boolean isPartial() {
        return this.isPartial;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public long getStartTime() {
        return this.startTimeMillis;
    }

    public long getExpirationTime() {
        return this.expirationTimeMillis;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.id != null) {
            builder.field("id", this.id);
        }
        builder.field("is_partial", this.isPartial);
        builder.field("is_running", this.isRunning);
        builder.field("start_time_in_millis", this.startTimeMillis);
        builder.field("expiration_time_in_millis", this.expirationTimeMillis);
        if (this.searchResponse != null) {
            builder.field("response");
            this.searchResponse.toXContent(builder, params);
        }
        if (this.error != null) {
            builder.startObject("error");
            this.error.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    private static SearchResponse parseSearchResponse(XContentParser p) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, p.currentToken(), p::getTokenLocation);
        p.nextToken();
        return SearchResponse.innerFromXContent(p);
    }

    public static AsyncSearchResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), IS_PARTIAL_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), IS_RUNNING_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), START_TIME_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), EXPIRATION_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ID_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> AsyncSearchResponse.parseSearchResponse(p), RESPONSE_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ElasticsearchException.fromXContent(p), ERROR_FIELD);
    }
}

