/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.common;

import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.time.DateFormatters;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;

public final class TimeUtil {
    public static Date parseTimeField(XContentParser parser, String fieldName) throws IOException {
        if (parser.currentToken() == XContentParser.Token.VALUE_NUMBER) {
            return new Date(parser.longValue());
        }
        if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            return new Date(DateFormatters.from(DateTimeFormatter.ISO_INSTANT.parse(parser.text())).toInstant().toEpochMilli());
        }
        throw new IllegalArgumentException("unexpected token [" + (Object)((Object)parser.currentToken()) + "] for [" + fieldName + "]");
    }

    public static Instant parseTimeFieldToInstant(XContentParser parser, String fieldName) throws IOException {
        if (parser.currentToken() == XContentParser.Token.VALUE_NUMBER) {
            return Instant.ofEpochMilli(parser.longValue());
        }
        if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            return DateFormatters.from(DateTimeFormatter.ISO_INSTANT.parse(parser.text())).toInstant();
        }
        throw new IllegalArgumentException("unexpected token [" + (Object)((Object)parser.currentToken()) + "] for [" + fieldName + "]");
    }
}

