/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRequestValidationException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.core.PageParams;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.job.config.Job;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.job.results.Result;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;

public class GetBucketsRequest
extends ActionRequest
implements ToXContentObject {
    public static final ParseField EXPAND = new ParseField("expand", new String[0]);
    public static final ParseField EXCLUDE_INTERIM = new ParseField("exclude_interim", new String[0]);
    public static final ParseField START = new ParseField("start", new String[0]);
    public static final ParseField END = new ParseField("end", new String[0]);
    public static final ParseField ANOMALY_SCORE = new ParseField("anomaly_score", new String[0]);
    public static final ParseField SORT = new ParseField("sort", new String[0]);
    public static final ParseField DESCENDING = new ParseField("desc", new String[0]);
    public static final ObjectParser<GetBucketsRequest, Void> PARSER = new ObjectParser("get_buckets_request", GetBucketsRequest::new);
    private String jobId;
    private String timestamp;
    private Boolean expand;
    private Boolean excludeInterim;
    private String start;
    private String end;
    private PageParams pageParams;
    private Double anomalyScore;
    private String sort;
    private Boolean descending;

    private GetBucketsRequest() {
    }

    public GetBucketsRequest(String jobId) {
        this.jobId = Objects.requireNonNull(jobId);
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public boolean isExpand() {
        return this.expand;
    }

    public void setExpand(Boolean expand) {
        this.expand = expand;
    }

    public Boolean getExcludeInterim() {
        return this.excludeInterim;
    }

    public void setExcludeInterim(Boolean excludeInterim) {
        this.excludeInterim = excludeInterim;
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public PageParams getPageParams() {
        return this.pageParams;
    }

    public void setPageParams(PageParams pageParams) {
        this.pageParams = pageParams;
    }

    public Double getAnomalyScore() {
        return this.anomalyScore;
    }

    public void setAnomalyScore(Double anomalyScore) {
        this.anomalyScore = anomalyScore;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public Boolean getDescending() {
        return this.descending;
    }

    public void setDescending(boolean descending) {
        this.descending = descending;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        if (this.timestamp != null) {
            builder.field(Result.TIMESTAMP.getPreferredName(), this.timestamp);
        }
        if (this.expand != null) {
            builder.field(EXPAND.getPreferredName(), this.expand);
        }
        if (this.excludeInterim != null) {
            builder.field(EXCLUDE_INTERIM.getPreferredName(), this.excludeInterim);
        }
        if (this.start != null) {
            builder.field(START.getPreferredName(), this.start);
        }
        if (this.end != null) {
            builder.field(END.getPreferredName(), this.end);
        }
        if (this.pageParams != null) {
            builder.field(PageParams.PAGE.getPreferredName(), this.pageParams);
        }
        if (this.anomalyScore != null) {
            builder.field(ANOMALY_SCORE.getPreferredName(), this.anomalyScore);
        }
        if (this.sort != null) {
            builder.field(SORT.getPreferredName(), this.sort);
        }
        if (this.descending != null) {
            builder.field(DESCENDING.getPreferredName(), this.descending);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.timestamp, this.expand, this.excludeInterim, this.anomalyScore, this.pageParams, this.start, this.end, this.sort, this.descending);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetBucketsRequest other = (GetBucketsRequest)obj;
        return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.expand, other.expand) && Objects.equals(this.excludeInterim, other.excludeInterim) && Objects.equals(this.anomalyScore, other.anomalyScore) && Objects.equals(this.pageParams, other.pageParams) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.sort, other.sort) && Objects.equals(this.descending, other.descending);
    }

    static {
        PARSER.declareString((request, jobId) -> {
            request.jobId = jobId;
        }, Job.ID);
        PARSER.declareString(GetBucketsRequest::setTimestamp, Result.TIMESTAMP);
        PARSER.declareBoolean(GetBucketsRequest::setExpand, EXPAND);
        PARSER.declareBoolean(GetBucketsRequest::setExcludeInterim, EXCLUDE_INTERIM);
        PARSER.declareStringOrNull(GetBucketsRequest::setStart, START);
        PARSER.declareStringOrNull(GetBucketsRequest::setEnd, END);
        PARSER.declareObject(GetBucketsRequest::setPageParams, PageParams.PARSER, PageParams.PAGE);
        PARSER.declareDouble(GetBucketsRequest::setAnomalyScore, ANOMALY_SCORE);
        PARSER.declareString(GetBucketsRequest::setSort, SORT);
        PARSER.declareBoolean(GetBucketsRequest::setDescending, DESCENDING);
    }
}

