/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml;

import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRequestValidationException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.datafeed.DatafeedConfig;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;

public class StopDatafeedRequest
extends ActionRequest
implements ToXContentObject {
    public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
    public static final ParseField FORCE = new ParseField("force", new String[0]);
    public static final ParseField ALLOW_NO_DATAFEEDS = new ParseField("allow_no_datafeeds", new String[0]);
    public static final ConstructingObjectParser<StopDatafeedRequest, Void> PARSER = new ConstructingObjectParser("stop_datafeed_request", a -> new StopDatafeedRequest((List)a[0]));
    private static final String ALL_DATAFEEDS = "_all";
    private final List<String> datafeedIds;
    private TimeValue timeout;
    private Boolean force;
    private Boolean allowNoDatafeeds;

    public static StopDatafeedRequest stopAllDatafeedsRequest() {
        return new StopDatafeedRequest(ALL_DATAFEEDS);
    }

    StopDatafeedRequest(List<String> datafeedIds) {
        if (datafeedIds.isEmpty()) {
            throw new InvalidParameterException("datafeedIds must not be empty");
        }
        if (datafeedIds.stream().anyMatch(Objects::isNull)) {
            throw new NullPointerException("datafeedIds must not contain null values");
        }
        this.datafeedIds = new ArrayList<String>(datafeedIds);
    }

    public StopDatafeedRequest(String ... datafeedIds) {
        this(Arrays.asList(datafeedIds));
    }

    public List<String> getDatafeedIds() {
        return this.datafeedIds;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public void setTimeout(TimeValue timeout) {
        this.timeout = timeout;
    }

    public Boolean getForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public Boolean getAllowNoDatafeeds() {
        return this.allowNoDatafeeds;
    }

    public void setAllowNoDatafeeds(boolean allowNoDatafeeds) {
        this.allowNoDatafeeds = allowNoDatafeeds;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.datafeedIds, this.timeout, this.force, this.allowNoDatafeeds);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        StopDatafeedRequest that = (StopDatafeedRequest)other;
        return Objects.equals(this.datafeedIds, that.datafeedIds) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.force, that.force) && Objects.equals(this.allowNoDatafeeds, that.allowNoDatafeeds);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DatafeedConfig.ID.getPreferredName(), Strings.collectionToCommaDelimitedString(this.datafeedIds));
        if (this.timeout != null) {
            builder.field(TIMEOUT.getPreferredName(), this.timeout.getStringRep());
        }
        if (this.force != null) {
            builder.field(FORCE.getPreferredName(), this.force);
        }
        if (this.allowNoDatafeeds != null) {
            builder.field(ALLOW_NO_DATAFEEDS.getPreferredName(), this.allowNoDatafeeds);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> Arrays.asList(Strings.commaDelimitedListToStringArray(p.text())), DatafeedConfig.ID, ObjectParser.ValueType.STRING_ARRAY);
        PARSER.declareString((obj, val) -> obj.setTimeout(TimeValue.parseTimeValue(val, TIMEOUT.getPreferredName())), TIMEOUT);
        PARSER.declareBoolean(StopDatafeedRequest::setForce, FORCE);
        PARSER.declareBoolean(StopDatafeedRequest::setAllowNoDatafeeds, ALLOW_NO_DATAFEEDS);
    }
}

