/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.security.support.expressiondsl.expressions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;

public enum CompositeType {
    ANY("any"),
    ALL("all"),
    EXCEPT("except");

    private static Map<String, CompositeType> nameToType;
    private ParseField field;

    private CompositeType(String name) {
        this.field = new ParseField(name, new String[0]);
    }

    public String getName() {
        return this.field.getPreferredName();
    }

    public ParseField getParseField() {
        return this.field;
    }

    public static CompositeType fromName(String name) {
        return nameToType.get(name);
    }

    private static Map<String, CompositeType> initialize() {
        HashMap<String, CompositeType> map = new HashMap<String, CompositeType>();
        for (CompositeType field : CompositeType.values()) {
            map.put(field.getName(), field);
        }
        return map;
    }

    static {
        nameToType = Collections.unmodifiableMap(CompositeType.initialize());
    }
}

