/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.Field;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.FieldType;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.SortedSetDocValuesField;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexableFieldType;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.Term;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.TermStates;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.BooleanClause;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.BooleanQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ConstantScoreQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.MatchAllDocsQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.MatchNoDocsQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.MultiTermQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TermInSetQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TermQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.WildcardQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lucene.search.Queries;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.plain.ConstantIndexFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.DocumentMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.Mapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MapperParsingException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MapperService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.ParseContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.StringFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.TextSearchInfo;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.support.QueryParsers;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.CoreValuesSourceType;

public class TypeFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_type";
    public static final String CONTENT_TYPE = "_type";

    private TypeFieldMapper(FieldType fieldType) {
        super(fieldType, new TypeFieldType());
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        if (this.fieldType.indexOptions() == IndexOptions.NONE && !this.fieldType.stored()) {
            return;
        }
        context.doc().add(new Field(this.fieldType().name(), context.sourceToParse().type(), (IndexableFieldType)this.fieldType));
        if (this.fieldType().hasDocValues()) {
            context.doc().add(new SortedSetDocValuesField(this.fieldType().name(), new BytesRef("_doc")));
        }
    }

    @Override
    protected String contentType() {
        return "_type";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    public static final class TypeFieldType
    extends StringFieldType {
        public static final TypeFieldType INSTANCE = new TypeFieldType();

        private TypeFieldType() {
            super("_type", true, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return "_type";
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            Function<MapperService, String> typeFunction = mapperService -> mapperService.documentMapper().type();
            return new ConstantIndexFieldData.Builder(typeFunction, CoreValuesSourceType.BYTES);
        }

        @Override
        public boolean isSearchable() {
            return true;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new MatchAllDocsQuery();
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            return this.termsQuery(Arrays.asList(value), context);
        }

        @Override
        public Query termsQuery(List<?> values, QueryShardContext context) {
            DocumentMapper mapper = context.getMapperService().documentMapper();
            if (mapper == null) {
                return new MatchNoDocsQuery("No types");
            }
            BytesRef indexType = this.indexedValueForSearch(mapper.type());
            if (values.stream().map(this::indexedValueForSearch).anyMatch(indexType::equals)) {
                if (context.getMapperService().hasNested()) {
                    return Queries.newNonNestedFilter(context.indexVersionCreated());
                }
                return new MatchAllDocsQuery();
            }
            return new MatchNoDocsQuery("Type list does not contain the index type");
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            Query result = new MatchAllDocsQuery();
            String type = context.getMapperService().documentMapper().type();
            if (type != null) {
                int comp;
                BytesRef typeBytes = new BytesRef(type);
                if (lowerTerm != null && ((comp = this.indexedValueForSearch(lowerTerm).compareTo(typeBytes)) > 0 || comp == 0 && !includeLower)) {
                    result = new MatchNoDocsQuery("[_type] was lexicographically smaller than lower bound of range");
                }
                if (upperTerm != null && ((comp = this.indexedValueForSearch(upperTerm).compareTo(typeBytes)) < 0 || comp == 0 && !includeUpper)) {
                    result = new MatchNoDocsQuery("[_type] was lexicographically greater than upper bound of range");
                }
            }
            return result;
        }

        @Override
        public Query wildcardQuery(String value, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            Query termQuery = this.termQuery(value, context);
            if (termQuery instanceof MatchNoDocsQuery || termQuery instanceof MatchAllDocsQuery) {
                return termQuery;
            }
            if (!context.allowExpensiveQueries()) {
                throw new ElasticsearchException("[wildcard] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
            }
            Term term = MappedFieldType.extractTerm(termQuery);
            WildcardQuery query = new WildcardQuery(term);
            QueryParsers.setRewriteMethod(query, method);
            return query;
        }
    }

    public static class TypesQuery
    extends Query {
        private static final int BOOLEAN_REWRITE_TERM_COUNT_THRESHOLD = 16;
        private final BytesRef[] types;

        public TypesQuery(BytesRef ... types) {
            if (types == null) {
                throw new NullPointerException("types cannot be null.");
            }
            if (types.length == 0) {
                throw new IllegalArgumentException("types must contains at least one value.");
            }
            this.types = types;
        }

        public BytesRef[] getTerms() {
            return this.types;
        }

        @Override
        public Query rewrite(IndexReader reader) throws IOException {
            int threshold = Math.min(16, BooleanQuery.getMaxClauseCount());
            if (this.types.length <= threshold) {
                HashSet<BytesRef> uniqueTypes = new HashSet<BytesRef>();
                BooleanQuery.Builder bq = new BooleanQuery.Builder();
                int totalDocFreq = 0;
                for (BytesRef type : this.types) {
                    if (!uniqueTypes.add(type)) continue;
                    Term term = new Term("_type", type);
                    TermStates context = TermStates.build(reader.getContext(), term, true);
                    if (context.docFreq() == 0) continue;
                    if ((totalDocFreq += context.docFreq()) >= reader.maxDoc()) {
                        assert (totalDocFreq == reader.maxDoc());
                        return new MatchAllDocsQuery();
                    }
                    bq.add(new TermQuery(term, context), BooleanClause.Occur.SHOULD);
                }
                return new ConstantScoreQuery(bq.build());
            }
            return new TermInSetQuery("_type", this.types);
        }

        @Override
        public boolean equals(Object obj) {
            if (!this.sameClassAs(obj)) {
                return false;
            }
            TypesQuery that = (TypesQuery)obj;
            return Arrays.equals(this.types, that.types);
        }

        @Override
        public int hashCode() {
            return 31 * this.classHash() + Arrays.hashCode(this.types);
        }

        @Override
        public String toString(String field) {
            StringBuilder builder = new StringBuilder();
            for (BytesRef type : this.types) {
                if (builder.length() > 0) {
                    builder.append(' ');
                }
                builder.append(new Term("_type", type).toString());
            }
            return builder.toString();
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        @Override
        public MetadataFieldMapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            throw new MapperParsingException("_type is not configurable");
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            IndexSettings indexSettings = context.mapperService().getIndexSettings();
            return new TypeFieldMapper(Defaults.FIELD_TYPE);
        }
    }

    public static class Defaults {
        public static final String NAME = "_type";
        public static final FieldType FIELD_TYPE = new FieldType();
        public static final FieldType NESTED_FIELD_TYPE;

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
            NESTED_FIELD_TYPE = new FieldType(FIELD_TYPE);
            NESTED_FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
        }
    }
}

