/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.transport;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.breaker.CircuitBreaker;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.bytes.BytesReference;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.bytes.CompositeBytesReference;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lease.Releasable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lease.Releasables;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.PageCacheRecycler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.Header;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.InboundAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.InboundDecoder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.InboundMessage;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.RequestHandlerRegistry;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.StatsTracker;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TcpChannel;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportRequest;

public class InboundPipeline
implements Releasable {
    private static final ThreadLocal<ArrayList<Object>> fragmentList = ThreadLocal.withInitial(ArrayList::new);
    private static final InboundMessage PING_MESSAGE = new InboundMessage(null, true);
    private final LongSupplier relativeTimeInMillis;
    private final StatsTracker statsTracker;
    private final InboundDecoder decoder;
    private final InboundAggregator aggregator;
    private final BiConsumer<TcpChannel, InboundMessage> messageHandler;
    private Exception uncaughtException;
    private final ArrayDeque<ReleasableBytesReference> pending = new ArrayDeque(2);
    private boolean isClosed = false;

    public InboundPipeline(Version version, StatsTracker statsTracker, PageCacheRecycler recycler, LongSupplier relativeTimeInMillis, Supplier<CircuitBreaker> circuitBreaker, Function<String, RequestHandlerRegistry<TransportRequest>> registryFunction, BiConsumer<TcpChannel, InboundMessage> messageHandler) {
        this(statsTracker, relativeTimeInMillis, new InboundDecoder(version, recycler), new InboundAggregator(circuitBreaker, registryFunction), messageHandler);
    }

    public InboundPipeline(StatsTracker statsTracker, LongSupplier relativeTimeInMillis, InboundDecoder decoder, InboundAggregator aggregator, BiConsumer<TcpChannel, InboundMessage> messageHandler) {
        this.relativeTimeInMillis = relativeTimeInMillis;
        this.statsTracker = statsTracker;
        this.decoder = decoder;
        this.aggregator = aggregator;
        this.messageHandler = messageHandler;
    }

    @Override
    public void close() {
        this.isClosed = true;
        Releasables.closeWhileHandlingException(this.decoder, this.aggregator);
        Releasables.closeWhileHandlingException(this.pending);
        this.pending.clear();
    }

    public void handleBytes(TcpChannel channel, ReleasableBytesReference reference) throws IOException {
        if (this.uncaughtException != null) {
            throw new IllegalStateException("Pipeline state corrupted by uncaught exception", this.uncaughtException);
        }
        try {
            this.doHandleBytes(channel, reference);
        }
        catch (Exception e) {
            this.uncaughtException = e;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHandleBytes(TcpChannel channel, ReleasableBytesReference reference) throws IOException {
        channel.getChannelStats().markAccessed(this.relativeTimeInMillis.getAsLong());
        this.statsTracker.markBytesRead(reference.length());
        this.pending.add(reference.retain());
        ArrayList<Object> fragments = fragmentList.get();
        boolean continueHandling = true;
        while (continueHandling && !this.isClosed) {
            boolean continueDecoding = true;
            while (continueDecoding && !this.pending.isEmpty()) {
                ReleasableBytesReference toDecode = this.getPendingBytes();
                try {
                    int bytesDecoded = this.decoder.decode(toDecode, fragments::add);
                    if (bytesDecoded != 0) {
                        this.releasePendingBytes(bytesDecoded);
                        if (fragments.isEmpty() || !this.endOfMessage(fragments.get(fragments.size() - 1))) continue;
                        continueDecoding = false;
                        continue;
                    }
                    continueDecoding = false;
                }
                finally {
                    if (toDecode == null) continue;
                    toDecode.close();
                }
            }
            if (fragments.isEmpty()) {
                continueHandling = false;
                continue;
            }
            try {
                this.forwardFragments(channel, fragments);
            }
            finally {
                for (Object fragment : fragments) {
                    if (!(fragment instanceof ReleasableBytesReference)) continue;
                    ((ReleasableBytesReference)fragment).close();
                }
                fragments.clear();
            }
        }
    }

    private void forwardFragments(TcpChannel channel, ArrayList<Object> fragments) throws IOException {
        for (Object fragment : fragments) {
            if (fragment instanceof Header) {
                assert (!this.aggregator.isAggregating());
                this.aggregator.headerReceived((Header)fragment);
                continue;
            }
            if (fragment == InboundDecoder.PING) {
                assert (!this.aggregator.isAggregating());
                this.messageHandler.accept(channel, PING_MESSAGE);
                continue;
            }
            if (fragment == InboundDecoder.END_CONTENT) {
                assert (this.aggregator.isAggregating());
                InboundMessage aggregated = this.aggregator.finishAggregation();
                try {
                    this.statsTracker.markMessageReceived();
                    this.messageHandler.accept(channel, aggregated);
                    continue;
                }
                finally {
                    if (aggregated != null) {
                        aggregated.close();
                    }
                    continue;
                }
            }
            assert (this.aggregator.isAggregating());
            assert (fragment instanceof ReleasableBytesReference);
            this.aggregator.aggregate((ReleasableBytesReference)fragment);
        }
    }

    private boolean endOfMessage(Object fragment) {
        return fragment == InboundDecoder.PING || fragment == InboundDecoder.END_CONTENT || fragment instanceof Exception;
    }

    private ReleasableBytesReference getPendingBytes() {
        if (this.pending.size() == 1) {
            return this.pending.peekFirst().retain();
        }
        BytesReference[] bytesReferences = new ReleasableBytesReference[this.pending.size()];
        int index = 0;
        for (ReleasableBytesReference pendingReference : this.pending) {
            bytesReferences[index] = pendingReference.retain();
            ++index;
        }
        Releasable releasable = () -> InboundPipeline.lambda$getPendingBytes$0((ReleasableBytesReference[])bytesReferences);
        return new ReleasableBytesReference(CompositeBytesReference.of(bytesReferences), releasable);
    }

    private void releasePendingBytes(int bytesConsumed) {
        int bytesToRelease = bytesConsumed;
        while (bytesToRelease != 0) {
            ReleasableBytesReference reference = this.pending.pollFirst();
            try {
                assert (reference != null);
                if (bytesToRelease < reference.length()) {
                    this.pending.addFirst(reference.retainedSlice(bytesToRelease, reference.length() - bytesToRelease));
                    bytesToRelease -= bytesToRelease;
                    continue;
                }
                bytesToRelease -= reference.length();
            }
            finally {
                if (reference == null) continue;
                reference.close();
            }
        }
    }

    private static /* synthetic */ void lambda$getPendingBytes$0(ReleasableBytesReference[] bytesReferences) {
        Releasables.closeWhileHandlingException(bytesReferences);
    }
}

