/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.entity;

import com.google.gson.reflect.TypeToken;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandListener;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAdapter;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.ProxyProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IErrorVisualizer;
import org.jkiss.dbeaver.ui.IProgressControlProvider;
import org.jkiss.dbeaver.ui.IPropertyChangeReflector;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.DataSourcePropertyTester;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceToolbarUtils;
import org.jkiss.dbeaver.ui.controls.CustomFormEditor;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;
import org.jkiss.dbeaver.ui.controls.PropertyPageStandard;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolder;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolderContainer;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolderListener;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorPreferences;
import org.jkiss.dbeaver.ui.editors.DatabaseLazyEditorInput;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.ErrorEditorInput;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.ILazyEditor;
import org.jkiss.dbeaver.ui.editors.ILazyEditorInput;
import org.jkiss.dbeaver.ui.editors.IRevertableEditor;
import org.jkiss.dbeaver.ui.editors.IUnloadableEditorInput;
import org.jkiss.dbeaver.ui.editors.MultiPageDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.ProgressEditorPart;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditorDescriptor;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditorFeatures;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditorPropertyTester;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditorsRegistry;
import org.jkiss.dbeaver.ui.editors.entity.ErrorEditorPartEx;
import org.jkiss.dbeaver.ui.editors.entity.GlobalContributorManager;
import org.jkiss.dbeaver.ui.editors.entity.IEntityDataEditor;
import org.jkiss.dbeaver.ui.editors.entity.IEntityEditorContext;
import org.jkiss.dbeaver.ui.editors.entity.IEntityStructureEditor;
import org.jkiss.dbeaver.ui.editors.entity.properties.ObjectPropertiesEditor;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.breadcrumb.NodeBreadcrumbViewer;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class EntityEditor
extends MultiPageDatabaseEditor
implements IPropertyChangeReflector,
IProgressControlProvider,
ISaveablePart2,
IRevertableEditor,
ILazyEditor,
ITabbedFolderContainer,
DBPDataSourceContainerProvider,
IEntityEditorContext {
    public static final String ID = "org.jkiss.dbeaver.ui.editors.entity.EntityEditor";
    public static final String TABS_CONFIG_FILE = "entity-editor-tabs.json";
    private static final int PROP_OBJECT_INIT = 530;
    private static final Log log = Log.getLog(EntityEditor.class);
    private static Map<String, EditorDefaults> defaultPageMap;
    private final Map<String, IEditorPart> editorMap = new LinkedHashMap<String, IEditorPart>();
    private IEditorPart activeEditor;
    private DBECommandAdapter commandListener;
    private final ITabbedFolderListener folderListener;
    private boolean hasPropertiesEditor;
    private final Map<IEditorPart, IEditorActionBarContributor> actionContributors = new HashMap<IEditorPart, IEditorActionBarContributor>();
    private volatile boolean saveInProgress = false;

    public EntityEditor() {
        if (defaultPageMap == null) {
            defaultPageMap = EntityEditor.loadTabsConfiguration();
        }
        this.folderListener = folderId -> {
            String editorPageId;
            IEditorPart editor = this.getActiveEditor();
            if (editor != null && (editorPageId = this.getEditorPageId(editor)) != null) {
                this.updateEditorDefaults(editorPageId, folderId);
            }
        };
    }

    public void handlePropertyChange(int propId) {
        super.handlePropertyChange(propId);
    }

    @Nullable
    public ProgressPageControl getProgressControl() {
        IEditorPart activeEditor = this.getActiveEditor();
        return activeEditor instanceof IProgressControlProvider ? ((IProgressControlProvider)activeEditor).getProgressControl() : null;
    }

    public DBSObject getDatabaseObject() {
        return this.getEditorInput().getDatabaseObject();
    }

    @Nullable
    public DBECommandContext getCommandContext() {
        return this.getEditorInput().getCommandContext();
    }

    public void dispose() {
        EntityEditor.saveTabsConfiguration();
        for (Map.Entry<IEditorPart, IEditorActionBarContributor> entry : this.actionContributors.entrySet()) {
            GlobalContributorManager.getInstance().removeContributor(entry.getValue(), entry.getKey());
        }
        this.actionContributors.clear();
        DBECommandContext commandContext = this.getCommandContext();
        if (this.commandListener != null && commandContext != null) {
            commandContext.removeCommandListener((DBECommandListener)this.commandListener);
            this.commandListener = null;
        }
        super.dispose();
        if (this.getDatabaseObject() != null && commandContext != null) {
            commandContext.resetChanges(true);
        }
        this.editorMap.clear();
        this.activeEditor = null;
    }

    public boolean isDirty() {
        DBECommandContext commandContext = this.getCommandContext();
        if (commandContext != null && commandContext.isDirty()) {
            return true;
        }
        for (IEditorPart editor : this.editorMap.values()) {
            if (!editor.isDirty()) continue;
            return true;
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return this.activeEditor != null && this.activeEditor.isSaveAsAllowed();
    }

    public void doSaveAs() {
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor != null && activeEditor.isSaveAsAllowed()) {
            activeEditor.doSaveAs();
        }
    }

    public boolean isSaveInProgress() {
        return this.saveInProgress;
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.isDirty()) {
            return;
        }
        if (EditorUtils.isInAutoSaveJob()) {
            return;
        }
        DBPProject ownerProject = this.getEditorInput().getNavigatorNode().getOwnerProject();
        if (DBUtils.isReadOnly((DBSObject)this.getDatabaseObject()) || ownerProject == null || !DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("metadata-editor")) {
            DBWorkbench.getPlatformUI().showNotification("Read-only", "Object [" + DBUtils.getObjectFullName((DBPNamedObject)this.getDatabaseObject(), (DBPEvaluationContext)DBPEvaluationContext.UI) + "] is read-only", true, null);
            return;
        }
        for (IEditorPart editor : this.editorMap.values()) {
            if ((editor instanceof IEntityStructureEditor || editor instanceof IEntityDataEditor) && editor.isDirty()) {
                editor.doSave(monitor);
            }
            if (!monitor.isCanceled()) continue;
            return;
        }
        int previewResult = 10;
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.editor.show.preview")) {
            monitor.beginTask(UINavigatorMessages.editors_entity_monitor_preview_changes, 1);
            previewResult = this.showChanges(true);
            monitor.done();
        }
        if (previewResult == 9) {
            this.firePropertyChange(257);
            return;
        }
        if (previewResult != 10) {
            monitor.setCanceled(true);
            return;
        }
        try {
            this.saveInProgress = true;
            monitor.beginTask("Save changes...", 1);
            try {
                monitor.subTask("Save '" + this.getPartName() + "' changes...");
                SaveJob saveJob = new SaveJob();
                saveJob.schedule();
                UIUtils.waitJobCompletion((AbstractJob)saveJob, (IProgressMonitor)monitor);
                if (!saveJob.success.booleanValue()) {
                    monitor.setCanceled(true);
                    return;
                }
            }
            finally {
                monitor.done();
            }
            {
            }
        }
        finally {
            this.saveInProgress = false;
        }
    }

    public void doRevertToSaved() {
        for (IEditorPart editor : this.editorMap.values()) {
            if (!(editor instanceof IRevertableEditor)) continue;
            ((IRevertableEditor)editor).doRevertToSaved();
        }
        DBECommandContext commandContext = this.getCommandContext();
        if (commandContext != null) {
            commandContext.resetChanges(true);
        }
    }

    public boolean loadEditorInput() {
        IDatabaseEditorInput input = this.getEditorInput();
        if (input instanceof DatabaseLazyEditorInput && !((DatabaseLazyEditorInput)input).canLoadImmediately()) {
            return ((ProgressEditorPart)this.getActiveEditor()).scheduleEditorLoad();
        }
        return false;
    }

    public boolean unloadEditorInput() {
        if (this.getEditorInput() instanceof IUnloadableEditorInput) {
            ILazyEditorInput input = ((IUnloadableEditorInput)this.getEditorInput()).unloadInput();
            this.deactivateEditor();
            this.setInput((IEditorInput)input);
            this.firePropertyChange(258);
            this.recreateEditorControl();
            return true;
        }
        return false;
    }

    private boolean saveCommandContext(DBRProgressMonitor monitor, Map<String, Object> options) {
        boolean isNewObject;
        monitor.beginTask("Save entity", 1);
        DBException error = null;
        DBECommandContext commandContext = this.getCommandContext();
        if (commandContext == null) {
            log.warn((Object)"Null command context");
            return true;
        }
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext == null) {
            log.warn((Object)"Null execution context");
            return true;
        }
        boolean bl = isNewObject = this.getDatabaseObject() == null || !this.getDatabaseObject().isPersisted();
        if (!isNewObject) {
            for (DBECommand cmd : commandContext.getFinalCommands()) {
                if (!(cmd.getObject() instanceof DBSObject) || ((DBSObject)cmd.getObject()).isPersisted()) continue;
                isNewObject = true;
                break;
            }
        }
        try {
            DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)executionContext.getDataSource(), param -> {
                try {
                    commandContext.saveChanges(monitor, options);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (DBException e) {
            error = e;
        }
        if (this.getDatabaseObject() instanceof DBPStatefulObject) {
            try {
                ((DBPStatefulObject)this.getDatabaseObject()).refreshObjectState(monitor);
            }
            catch (DBCException e) {
                log.error((Object)e);
            }
        }
        if (error == null) {
            final DBNDatabaseNode treeNode = this.getEditorInput().getNavigatorNode();
            final boolean doRefresh = isNewObject;
            new AbstractJob("Database node refresh"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        treeNode.refreshNode(monitor, doRefresh ? DBNEvent.FORCE_REFRESH : DBNEvent.UPDATE_ON_SAVE);
                    }
                    catch (DBException e) {
                        return GeneralUtils.makeExceptionStatus((Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
        monitor.done();
        if (error == null) {
            return true;
        }
        DBException vError = error;
        UIUtils.syncExec(() -> {
            IErrorVisualizer errorVisualizer = this.getAdapter(IErrorVisualizer.class);
            if (errorVisualizer != null) {
                errorVisualizer.visualizeError(monitor, vError);
            }
        });
        UIUtils.asyncExec(() -> {
            DBPPlatformUI.UserResponse userResponse = DBWorkbench.getPlatformUI().showError("Can't save '" + this.getDatabaseObject().getName() + "'", null, vError);
        });
        return false;
    }

    public void revertChanges() {
        if (this.isDirty()) {
            if (ConfirmationDialog.confirmAction(null, (String)"entity_revert", (int)3, (Object[])new Object[]{this.getDatabaseObject().getName()}) != 2) {
                return;
            }
            DBECommandContext commandContext = this.getCommandContext();
            if (commandContext != null) {
                commandContext.resetChanges(true);
            }
            this.refreshPart(this, true, false);
            this.firePropertyChange(257);
        }
    }

    public void undoChanges() {
        IUndoManager undoManager = this.getAdapter(IUndoManager.class);
        if (undoManager != null) {
            undoManager.undo();
        } else {
            DBECommandContext commandContext = this.getCommandContext();
            if (commandContext != null && commandContext.getUndoCommand() != null) {
                if (!this.getDatabaseObject().isPersisted() && commandContext.getUndoCommands().size() == 1 && ConfirmationDialog.confirmAction(null, (String)"entity_reject", (int)3, (Object[])new Object[]{this.getDatabaseObject().getName()}) != 2) {
                    return;
                }
                commandContext.undoCommand();
                this.firePropertyChange(257);
            }
        }
    }

    public void redoChanges() {
        IUndoManager undoManager = this.getAdapter(IUndoManager.class);
        if (undoManager != null) {
            undoManager.redo();
        } else {
            DBECommandContext commandContext = this.getCommandContext();
            if (commandContext != null && commandContext.getRedoCommand() != null) {
                commandContext.redoCommand();
                this.firePropertyChange(257);
            }
        }
    }

    public int showChanges(boolean allowSave) {
        DBECommandContext commandContext = this.getCommandContext();
        if (commandContext == null) {
            return 1;
        }
        Collection commands = commandContext.getFinalCommands();
        if (CommonUtils.isEmpty((Collection)commands)) {
            return 9;
        }
        StringBuilder script = new StringBuilder();
        try {
            try {
                this.saveInProgress = true;
                UIUtils.runInProgressService(monitor -> {
                    monitor.beginTask("Generate SQL script", commands.size());
                    HashMap validateOptions = new HashMap();
                    for (DBECommand command : commands) {
                        monitor.subTask(command.getTitle());
                        try {
                            command.validateCommand(monitor, validateOptions);
                        }
                        catch (DBException e) {
                            throw new InvocationTargetException(e);
                        }
                        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                        options.put("object.save", true);
                        DBPDataSource dataSource = this.getDatabaseObject().getDataSource();
                        try {
                            DBEPersistAction[] persistActions = command.getPersistActions(monitor, this.getExecutionContext(), options);
                            script.append(SQLUtils.generateScript((DBPDataSource)dataSource, (DBEPersistAction[])persistActions, (boolean)false));
                        }
                        catch (DBException e) {
                            throw new InvocationTargetException(e);
                        }
                        monitor.worked(1);
                    }
                    monitor.done();
                });
            }
            catch (InterruptedException interruptedException) {
                this.saveInProgress = false;
                return 1;
            }
            catch (InvocationTargetException e) {
                log.error((Object)e);
                DBWorkbench.getPlatformUI().showError("Script generate error", "Couldn't generate alter script", e.getTargetException());
                this.saveInProgress = false;
                return 1;
            }
        }
        finally {
            this.saveInProgress = false;
        }
        if (script.length() == 0) {
            return 10;
        }
        ChangesPreviewer changesPreviewer = new ChangesPreviewer(script, allowSave);
        UIUtils.syncExec((Runnable)changesPreviewer);
        return changesPreviewer.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createPages() {
        super.createPages();
        IDatabaseEditorInput editorInput = this.getEditorInput();
        if (this.createPageForInput((IEditorInput)editorInput)) {
            return;
        }
        this.commandListener = new DBECommandAdapter(){

            public void onCommandChange(DBECommand<?> command) {
                UIUtils.syncExec(() -> EntityEditor.this.firePropertyChange(257));
            }
        };
        DBECommandContext commandContext = this.getCommandContext();
        if (commandContext != null) {
            commandContext.addCommandListener((DBECommandListener)this.commandListener);
        }
        this.addPropertyListener((source, propId) -> {
            if (propId == 257) {
                EntityEditorPropertyTester.firePropertyChange("dirty");
                EntityEditorPropertyTester.firePropertyChange("canUndo");
                EntityEditorPropertyTester.firePropertyChange("canRedo");
            }
        });
        DBSObject databaseObject = editorInput.getDatabaseObject();
        EditorDefaults editorDefaults = null;
        if (databaseObject == null) {
            log.debug((Object)"Null database object in EntityEditor");
        } else {
            Map<String, EditorDefaults> map = defaultPageMap;
            synchronized (map) {
                editorDefaults = defaultPageMap.get(databaseObject.getClass().getName());
            }
            EntityEditorsRegistry editorsRegistry = EntityEditorsRegistry.getInstance();
            EntityEditorDescriptor defaultEditor = editorsRegistry.getMainEntityEditor((DBPObject)databaseObject, this);
            this.hasPropertiesEditor = false;
            if (defaultEditor != null) {
                this.hasPropertiesEditor = this.addEditorTab(defaultEditor);
            }
            if (this.hasPropertiesEditor) {
                DBNDatabaseNode node = editorInput.getNavigatorNode();
                int propEditorIndex = this.getPageCount() - 1;
                this.setPageText(propEditorIndex, UINavigatorMessages.editors_entity_properties_text);
                this.setPageToolTip(propEditorIndex, node.getNodeTypeLabel() + UINavigatorMessages.editors_entity_properties_tooltip_suffix);
                this.setPageImage(propEditorIndex, DBeaverIcons.getImage((DBPImage)node.getNodeIconDefault()));
            }
        }
        this.addContributions("additions_props");
        this.addContributions("additions_start");
        this.addContributions("additions_middle");
        this.addContributions("additions_end");
        if (databaseObject != null) {
            EntityEditorFeatures.ENTITY_EDITOR_OPEN.use(Map.of("className", databaseObject.getClass().getSimpleName(), "driver", databaseObject.getDataSource() == null ? "" : databaseObject.getDataSource().getContainer().getDriver().getPreconfiguredId()));
        }
        String defPageId = editorInput.getDefaultPageId();
        String defFolderId = editorInput.getDefaultFolderId();
        if (defPageId == null && editorDefaults != null) {
            defPageId = editorDefaults.pageId;
        }
        if (defPageId != null) {
            IEditorPart defEditorPage = this.editorMap.get(defPageId);
            if (defEditorPage != null) {
                this.setActiveEditor(defEditorPage);
            }
        } else {
            this.setActiveEditor(this.getEditor(0));
        }
        this.activeEditor = this.getActiveEditor();
        if (this.activeEditor instanceof ITabbedFolderContainer) {
            if (defFolderId == null && editorDefaults != null) {
                defFolderId = editorDefaults.folderId;
            }
            if (defFolderId != null) {
                String folderId = defFolderId;
                UIUtils.asyncExec(() -> ((ITabbedFolderContainer)this.activeEditor).switchFolder(folderId));
            }
        }
        UIUtils.setHelp((Control)this.getContainer(), (String)"entity-editor");
    }

    private boolean createPageForInput(@NotNull IEditorInput editorInput) {
        if (editorInput instanceof DatabaseLazyEditorInput) {
            DatabaseLazyEditorInput input = (DatabaseLazyEditorInput)editorInput;
            try {
                this.addPage((IEditorPart)new ProgressEditorPart((IDatabaseEditor)this), (IEditorInput)input);
                this.setPageText(0, input.canLoadImmediately() ? UINavigatorMessages.editors_entity_title_initializing : UINavigatorMessages.editors_entity_title_uninitialized);
                this.setPageImage(0, DBeaverIcons.getImage((DBPImage)UIIcon.REFRESH));
                this.setActivePage(0);
            }
            catch (PartInitException e) {
                log.error((Object)e);
            }
            return true;
        }
        if (editorInput instanceof ErrorEditorInput) {
            ErrorEditorInput input = (ErrorEditorInput)editorInput;
            try {
                this.addPage((IEditorPart)new ErrorEditorPartEx(input.getError()), (IEditorInput)input);
                this.setPageText(0, "Error");
                this.setPageImage(0, UIUtils.getShardImage((String)"IMG_OBJS_ERROR_TSK"));
                this.setActivePage(0);
            }
            catch (PartInitException e) {
                log.error((Object)e);
            }
            return true;
        }
        return false;
    }

    public IEditorPart getPageEditor(String pageId) {
        return this.editorMap.get(pageId);
    }

    protected void pageChange(int newPageIndex) {
        try {
            super.pageChange(newPageIndex);
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
        this.activeEditor = this.getEditor(newPageIndex);
        for (Map.Entry<IEditorPart, IEditorActionBarContributor> entry : this.actionContributors.entrySet()) {
            if (entry.getKey() == this.activeEditor) {
                entry.getValue().setActiveEditor(this.activeEditor);
                continue;
            }
            entry.getValue().setActiveEditor(null);
        }
        String editorPageId = this.getEditorPageId(this.activeEditor);
        if (editorPageId != null) {
            this.updateEditorDefaults(editorPageId, null);
        }
        this.firePropertyChange(257);
        DataSourcePropertyTester.firePropertyChange((String)"transactionActive");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String getEditorPageId(IEditorPart editorPart) {
        Map<String, IEditorPart> map = this.editorMap;
        synchronized (map) {
            for (Map.Entry<String, IEditorPart> entry : this.editorMap.entrySet()) {
                if (entry.getValue() != editorPart) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    private void updateEditorDefaults(String pageId, @Nullable String folderId) {
        DBSObject object;
        IDatabaseEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof DatabaseEditorInput) {
            DatabaseEditorInput dei = (DatabaseEditorInput)editorInput;
            dei.setDefaultPageId(pageId);
            dei.setDefaultFolderId(folderId);
        }
        if ((object = editorInput.getDatabaseObject()) != null) {
            EditorDefaults editorDefaults = defaultPageMap.get(object.getClass().getName());
            if (editorDefaults == null) {
                editorDefaults = new EditorDefaults(pageId, folderId);
                defaultPageMap.put(object.getClass().getName(), editorDefaults);
            } else {
                if (pageId != null) {
                    editorDefaults.pageId = pageId;
                }
                if (folderId != null) {
                    editorDefaults.folderId = folderId;
                }
            }
        }
    }

    private static Map<String, EditorDefaults> loadTabsConfiguration() {
        Map pageMap = null;
        try {
            Path configFile = DBWorkbench.getPlatform().getLocalConfigurationFile(TABS_CONFIG_FILE);
            if (Files.exists(configFile, new LinkOption[0])) {
                pageMap = (Map)JSONUtils.GSON.fromJson((Reader)Files.newBufferedReader(configFile), new TypeToken<Map<String, EditorDefaults>>(){}.getType());
            }
        }
        catch (Exception e) {
            log.error((Object)"Error loading tabs configuration", (Throwable)e);
        }
        if (pageMap == null) {
            pageMap = new HashMap();
        }
        return pageMap;
    }

    private static void saveTabsConfiguration() {
        try {
            Path configPath = DBWorkbench.getPlatform().getLocalConfigurationFile(TABS_CONFIG_FILE);
            if (!Files.exists(configPath.getParent(), new LinkOption[0])) {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            }
            Files.writeString(configPath, (CharSequence)JSONUtils.GSON.toJson(defaultPageMap), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception e) {
            log.error((Object)"Error saving tabs configuration", (Throwable)e);
        }
    }

    public int promptToSaveOnClose() {
        ArrayList<String> changedSubEditors = new ArrayList<String>();
        DBECommandContext commandContext = this.getCommandContext();
        if (commandContext != null && commandContext.isDirty()) {
            changedSubEditors.add(UINavigatorMessages.registry_entity_editor_descriptor_name);
        }
        for (IEditorPart editor : this.editorMap.values()) {
            EntityEditorDescriptor editorDescriptor;
            if (!editor.isDirty() || (editorDescriptor = EntityEditorsRegistry.getInstance().getEntityEditor(editor)) == null) continue;
            changedSubEditors.add(editorDescriptor.getName());
        }
        String subEditorsString = changedSubEditors.isEmpty() ? "" : "(" + String.join((CharSequence)", ", changedSubEditors) + ")";
        int result = ConfirmationDialog.confirmAction((Shell)this.getSite().getShell(), (String)"close_entity_edit", (int)6, (Object[])new Object[]{this.getEditorInput().getNavigatorNode().getNodeDisplayName(), subEditorsString});
        if (result == 2) {
            return 0;
        }
        if (result == 3) {
            return 1;
        }
        return 2;
    }

    @Nullable
    public ITabbedFolder getActiveFolder() {
        if (this.getActiveEditor() instanceof ITabbedFolderContainer) {
            ((ITabbedFolderContainer)this.getActiveEditor()).getActiveFolder();
        }
        return null;
    }

    public boolean switchFolder(String folderId) {
        boolean changed = false;
        for (IEditorPart editor : this.editorMap.values()) {
            if (!(editor instanceof ITabbedFolderContainer)) continue;
            ITabbedFolderContainer tfc = (ITabbedFolderContainer)editor;
            if (this.getActiveEditor() != editor) {
                this.setActiveEditor(editor);
            }
            if (!tfc.switchFolder(folderId)) continue;
            changed = true;
        }
        return changed;
    }

    public void setActiveEditor(Class<?> editorInterface) {
        int i = 0;
        while (i < this.getPageCount()) {
            if (editorInterface.isAssignableFrom(this.getEditor(i).getClass())) {
                this.setActiveEditor(this.getEditor(i));
                break;
            }
            ++i;
        }
    }

    public void addFolderListener(ITabbedFolderListener listener) {
    }

    public void removeFolderListener(ITabbedFolderListener listener) {
    }

    private void addContributions(String position) {
        EntityEditorsRegistry editorsRegistry = EntityEditorsRegistry.getInstance();
        DBSObject databaseObject = this.getEditorInput().getDatabaseObject();
        Object object = databaseObject instanceof DBPDataSourceContainer && databaseObject.getDataSource() != null ? databaseObject.getDataSource() : databaseObject;
        List<EntityEditorDescriptor> descriptors = editorsRegistry.getEntityEditors((DBPObject)object, this, position);
        for (EntityEditorDescriptor descriptor : descriptors) {
            if (descriptor.getType() != EntityEditorDescriptor.Type.editor) continue;
            this.addEditorTab(descriptor);
        }
    }

    private boolean addEditorTab(EntityEditorDescriptor descriptor) {
        IEditorPart editor;
        block7: {
            try {
                editor = descriptor.createEditor();
                if (editor != null) break block7;
                return false;
            }
            catch (Exception ex) {
                log.error((Object)"Error adding nested editor", (Throwable)ex);
                return false;
            }
        }
        IEditorInput nestedInput = descriptor.getNestedEditorInput(this.getEditorInput());
        Class<? extends IEditorActionBarContributor> contributorClass = descriptor.getContributorClass();
        if (contributorClass != null) {
            this.addActionsContributor(editor, contributorClass);
        }
        int index = this.addPage(editor, nestedInput);
        this.setPageText(index, descriptor.getName());
        if (descriptor.getIcon() != null) {
            this.setPageImage(index, DBeaverIcons.getImage((DBPImage)descriptor.getIcon()));
        }
        if (!CommonUtils.isEmpty((String)descriptor.getDescription())) {
            this.setPageToolTip(index, descriptor.getDescription());
        }
        this.editorMap.put(descriptor.getId(), editor);
        if (editor instanceof ITabbedFolderContainer) {
            ((ITabbedFolderContainer)editor).addFolderListener(this.folderListener);
        }
        return true;
    }

    private void addActionsContributor(IEditorPart editor, Class<? extends IEditorActionBarContributor> contributorClass) throws Exception {
        GlobalContributorManager contributorManager = GlobalContributorManager.getInstance();
        IEditorActionBarContributor contributor = contributorManager.getContributor(contributorClass);
        if (contributor == null) {
            contributor = contributorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        contributorManager.addContributor(contributor, editor);
        this.actionContributors.put(editor, contributor);
    }

    public IRefreshablePart.RefreshResult refreshPart(Object source, boolean force) {
        return this.refreshPart(source, force, true);
    }

    private IRefreshablePart.RefreshResult refreshPart(Object source, boolean force, boolean showConfirmation) {
        DBNDatabaseNode navigatorNode;
        DBECommandContext commandContext;
        boolean isPersistedObject;
        if (this.getContainer() == null || this.getContainer().isDisposed() || this.saveInProgress) {
            return IRefreshablePart.RefreshResult.IGNORED;
        }
        DBSObject databaseObject = this.getEditorInput().getDatabaseObject();
        boolean bl = isPersistedObject = databaseObject != null && databaseObject.isPersisted();
        if (force && isPersistedObject && this.isDirty() && showConfirmation && ConfirmationDialog.confirmAction(null, (String)"entity_revert", (int)3, (Object[])new Object[]{this.getTitle()}) != 2) {
            return IRefreshablePart.RefreshResult.CANCELED;
        }
        boolean isRename = false;
        if (source instanceof DBNEvent) {
            Map options;
            Object uiSource;
            ((DBNEvent)source).getNodeChange();
            Object source2 = ((DBNEvent)source).getSource();
            if (source2 instanceof DBPEvent && ((DBPEvent)source2).getData() == DBPEvent.RENAME && (uiSource = (options = ((DBPEvent)source2).getOptions()).get("uiSource")) != null && !(uiSource instanceof CustomFormEditor)) {
                isRename = true;
            }
        }
        if (force && isPersistedObject && (commandContext = this.getCommandContext()) != null && commandContext.isDirty()) {
            commandContext.resetChanges(true);
        }
        if (databaseObject != null) {
            for (IEditorPart editor : this.editorMap.values()) {
                if (!(editor instanceof IRefreshablePart)) continue;
                boolean refreshNestedPart = force;
                if (!refreshNestedPart && editor instanceof ObjectPropertiesEditor && isRename) {
                    refreshNestedPart = true;
                }
                ((IRefreshablePart)editor).refreshPart(source, refreshNestedPart);
            }
        }
        this.setPartName(this.getEditorInput().getName());
        this.setTitleImage(this.getEditorInput().getImageDescriptor());
        if (this.hasPropertiesEditor && (navigatorNode = this.getEditorInput().getNavigatorNode()) != null) {
            this.setPageImage(0, DBeaverIcons.getImage((DBPImage)navigatorNode.getNodeIconDefault()));
        }
        this.firePropertyChange(257);
        return IRefreshablePart.RefreshResult.REFRESHED;
    }

    public <T> T getAdapter(Class<T> adapter) {
        T activeAdapter = this.getNestedAdapter(adapter);
        if (activeAdapter != null) {
            return activeAdapter;
        }
        if (adapter == IPropertySheetPage.class) {
            return adapter.cast(new PropertyPageStandard());
        }
        if (adapter == DBSObject.class) {
            IDatabaseEditorInput editorInput = this.getEditorInput();
            DBSObject databaseObject = editorInput.getDatabaseObject();
            return adapter.cast(databaseObject);
        }
        return (T)super.getAdapter(adapter);
    }

    public <T> T getNestedAdapter(Class<T> adapter) {
        IEditorPart activeEditor;
        if (Display.getCurrent() != null && (activeEditor = this.getActiveEditor()) != null) {
            Object result = activeEditor.getAdapter(adapter);
            if (result != null) {
                return adapter.cast(result);
            }
            if (adapter.isAssignableFrom(activeEditor.getClass())) {
                return adapter.cast(activeEditor);
            }
        }
        return null;
    }

    protected Control createTopRightControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)GridDataFactory.swtDefaults().grab(false, true).create());
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        NodeBreadcrumbViewer viewer = new NodeBreadcrumbViewer(composite, 128);
        viewer.setInput(this.getEditorInput().getNavigatorNode());
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        DBPPreferenceListener listener = event -> {
            if (event.getProperty().equals("ui.statusBar.show.breadcrumbs")) {
                composite.setVisible(DatabaseEditorPreferences.BreadcrumbLocation.get((DBPPreferenceStore)store) == DatabaseEditorPreferences.BreadcrumbLocation.IN_EDITORS);
                this.updateTopRightControl();
            }
        };
        store.addPropertyChangeListener(listener);
        composite.addDisposeListener(e -> store.removePropertyChangeListener(listener));
        composite.setVisible(DatabaseEditorPreferences.BreadcrumbLocation.get((DBPPreferenceStore)store) == DatabaseEditorPreferences.BreadcrumbLocation.IN_EDITORS);
        return composite;
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        return DBUtils.getContainer((DBSObject)this.getDatabaseObject());
    }

    public void recreateEditorControl() {
        Control control;
        if (this.getContainer() == null || this.getContainer().isDisposed()) {
            return;
        }
        if (this.getContainer() instanceof CTabFolder && (control = ((CTabFolder)this.getContainer()).getTopRight()) != null) {
            control.dispose();
        }
        this.recreatePages();
        this.firePropertyChange(530);
        DataSourceToolbarUtils.refreshSelectorToolbar(this.getSite().getWorkbenchWindow());
    }

    @Override
    public boolean isEntityContainer(DBSObjectContainer object) {
        try {
            Class childType = object.getPrimaryChildType(null);
            return childType != null && DBSTable.class.isAssignableFrom(childType);
        }
        catch (DBException e) {
            log.error((Object)e);
            return false;
        }
    }

    @Override
    public boolean isRelationalObject(DBSObject object) {
        DBPDataSource dataSource = object.getDataSource();
        return dataSource != null && dataSource.getInfo().supportsReferentialIntegrity();
    }

    public String toString() {
        DBSObject databaseObject = this.getDatabaseObject();
        return databaseObject == null ? super.toString() : DBUtils.getObjectFullName((DBPNamedObject)databaseObject, (DBPEvaluationContext)DBPEvaluationContext.UI);
    }

    private class ChangesPreviewer
    implements Runnable {
        private final StringBuilder script;
        private final boolean allowSave;
        private int result;

        ChangesPreviewer(StringBuilder script, boolean allowSave) {
            this.script = script;
            this.allowSave = allowSave;
        }

        @Override
        public void run() {
            UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
            this.result = serviceSQL != null ? serviceSQL.openSQLViewer(EntityEditor.this.getExecutionContext(), EntityEditor.this.getDatabaseObject().getName() + " - " + (this.allowSave ? UINavigatorMessages.editors_entity_dialog_persist_title : UINavigatorMessages.editors_entity_dialog_preview_title), (DBPImage)UIIcon.SQL_PREVIEW, this.script.toString(), this.allowSave, true) : 0;
        }

        public int getResult() {
            return this.result;
        }
    }

    private static class EditorDefaults {
        String pageId;
        String folderId;

        private EditorDefaults(String pageId, String folderId) {
            this.pageId = pageId;
            this.folderId = folderId;
        }
    }

    private class SaveJob
    extends AbstractJob {
        private transient Boolean success;

        SaveJob() {
            super("Save '" + EntityEditor.this.getPartName() + "' changes...");
            this.success = null;
            this.setUser(true);
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            try {
                DBECommandContext commandContext = EntityEditor.this.getCommandContext();
                if (commandContext != null && commandContext.isDirty()) {
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    options.put("object.save", true);
                    this.success = EntityEditor.this.saveCommandContext(monitor, options);
                } else {
                    this.success = true;
                }
                if (this.success.booleanValue()) {
                    ProxyProgressMonitor proxyMonitor = new ProxyProgressMonitor(monitor);
                    for (IEditorPart editor : EntityEditor.this.editorMap.values()) {
                        if (editor.isDirty()) {
                            editor.doSave((IProgressMonitor)proxyMonitor);
                        }
                        if (!monitor.isCanceled()) continue;
                        this.success = false;
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    if (proxyMonitor.isCanceled()) {
                        this.success = false;
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                }
                IStatus iStatus = this.success != false ? Status.OK_STATUS : Status.CANCEL_STATUS;
                return iStatus;
            }
            catch (Throwable e) {
                this.success = false;
                log.error((Object)e);
                IStatus iStatus = GeneralUtils.makeExceptionStatus((Throwable)e);
                return iStatus;
            }
            finally {
                if (this.success == null) {
                    this.success = true;
                }
            }
        }
    }
}

