#define VERSION "v0.0.4"

typedef char brick;

struct map
	{
	int width,height;	// the size of the map
	int startx,starty;	// where the player starts on it
	brick *data;		// [width][height]
	int numApples;		// number of apples left
	int random;		// 1 = add random apples, 0 = don't
	};
typedef struct map map;

struct player
	{
	int xd, yd;	// current direction
	struct cell *cells;	// all of the cells in it's body
	int lives;	// number of lives left
	int grow;	// should it grow or snake
	int level;	// level that the player is on
	int score;	// current score
	int totalApples;// total number of apples collected
	};
typedef struct player player;

struct cell
	{
	int xpos,ypos;	// current cell position
	struct cell *next;
	};
typedef struct cell cell;


#define	EMPTY	' '	// clear space
#define	WALL	'.'	// A wall
#define	START	's'	// Where the player starts
#define APPLE	'a'	// Apple

#define NUMLIVES	3
#define STARTLEN	4
#define LEVELDIR	"/usr/local/games/nibbles.levels/"
#define LEVELSUFFIX	".lev"
#define RCFILENAME	".nibblerc"

#define TIMEOUT		100000		// usleep() time on input
#define DELAYDEC	(15.0/16.0)	// speed factor between levels
#define APPLESNEEDEDFORLIFE	10	// number of apples needed for a new life

#define WALLCHAR	'#'	// code to use for wall
#define APPLECHAR	'@'	// code to use for apple

map *newMap(int width,int height);
void freeMap(map *m);
map *loadMap(char *name);

void initDisplay(void);
void closeDisplay(void);
int cursGetch(unsigned int *usec);
void drawMap(map *m,WINDOW *w);

cell *newCell(int x, int y);
void freeCell(cell *c);
player *newPlayer(map *m);
void freePlayer(player *p);
void drawPlayer(player *p, WINDOW *w);
int movePlayer(player *p,map *m);
void initPlayer(player *p, map *m);

void wipePlayer(player *p, WINDOW *w);
int checkCollision(player *p, map *m);

void addApples(map *m, int numApples);
void showCentreMessage(WINDOW *win, char *str);
map *loadLevel(int level, char *levelDir);
void explode(int x,int y,WINDOW *w);

void cmdline(int argc, char *argv[], unsigned int *basedelay, char **leveldir, char **rcfile, char **playerName);


