/*
 * Decompiled with CFR 0.152.
 */
package com.jsuereth.pgp.cli;

import com.jsuereth.pgp.PublicKey;
import com.jsuereth.pgp.PublicKey$;
import com.jsuereth.pgp.PublicKeyRing;
import com.jsuereth.pgp.Signature;
import java.io.File;
import java.text.SimpleDateFormat;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Traversable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class Display$ {
    public static final Display$ MODULE$;

    static {
        new Display$();
    }

    public String printFileHeader(File f) {
        String path = f.getAbsolutePath();
        String line = package$.MODULE$.Stream().continually((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final char apply() {
                return this.apply$mcC$sp();
            }

            public char apply$mcC$sp() {
                return '-';
            }
        }).take(path.length()).mkString("");
        return new StringBuilder().append((Object)path).append((Object)"\n").append((Object)line).append((Object)"\n").toString();
    }

    public String printKey(PublicKey k) {
        String hexkey = (String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString("%x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)k.keyID())})))).takeRight(8);
        String strength = new StringBuilder().append((Object)k.algorithmName()).append((Object)"@").append((Object)((Object)BoxesRunTime.boxToInteger((int)k.bitStrength())).toString()).toString();
        String head = PublicKey$.MODULE$.unwrap(k).isMasterKey() ? "pub" : "sub";
        String date = new SimpleDateFormat("yyyy-MM-dd").format(PublicKey$.MODULE$.unwrap(k).getCreationTime());
        String userStrings = k.userIDs().isEmpty() ? "" : ((TraversableOnce)k.userIDs().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Object x$1) {
                return new StringBuilder().append((Object)"uid\t                \t").append(x$1).toString();
            }
        }, Traversable$.MODULE$.canBuildFrom())).mkString("", "\n", "\n");
        return new StringBuilder().append((Object)head).append((Object)"\t").append((Object)strength).append((Object)"/").append((Object)hexkey).append((Object)"\t").append((Object)date).append((Object)"\n").append((Object)userStrings).toString();
    }

    public String printSignature(Signature s) {
        String hexKey = (String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString("%x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)s.keyID())})))).takeRight(8);
        String notationsString = s.notations().isEmpty() ? "" : ((TraversableOnce)s.notations().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String l = (String)tuple2._1();
                    String r = (String)tuple2._2();
                    String string = new StringBuilder().append((Object)"note\t\t\t\t").append((Object)l).append((Object)"=").append((Object)r).toString();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Traversable$.MODULE$.canBuildFrom())).mkString("\n", "\n", "");
        String header = "sig";
        String user = (String)s.signerUserID().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        return new StringOps(Predef$.MODULE$.augmentString("%s\t%s@%s\t%s%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{header, hexKey, s.signatureTypeString(), user, notationsString}));
    }

    public String printSignatures(PublicKey k) {
        return ((TraversableOnce)k.signatures().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Signature s) {
                return Display$.MODULE$.printSignature(s);
            }
        }, Traversable$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public String printKeyWithSignatures(PublicKey r) {
        return new StringBuilder().append((Object)this.printKey(r)).append((Object)this.printSignatures(r)).append((Object)"\n").toString();
    }

    public String printRingWithSignatures(PublicKeyRing r) {
        return ((TraversableOnce)r.publicKeys().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(PublicKey r) {
                return Display$.MODULE$.printKeyWithSignatures(r);
            }
        }, Traversable$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public String printRing(PublicKeyRing r) {
        return ((TraversableOnce)r.publicKeys().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(PublicKey k) {
                return Display$.MODULE$.printKey(k);
            }
        }, Traversable$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private Display$() {
        MODULE$ = this;
    }
}

