/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.tempfile;

import java.io.File;
import java.io.IOException;
import org.jruby.CompatVersion;
import org.jruby.Finalizable;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock19;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.io.IOOptions;
import org.jruby.util.io.ModeFlags;

@JRubyClass(name={"Tempfile"}, parent="File")
public class Tempfile
extends RubyFile
implements Finalizable {
    private static ObjectAllocator TEMPFILE_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            Tempfile instance = new Tempfile(runtime, klass);
            return instance;
        }
    };
    private File tmpFile = null;
    protected IRubyObject opts;

    public static RubyClass createTempfileClass(Ruby runtime) {
        RubyClass tempfileClass = runtime.defineClass("Tempfile", runtime.getFile(), TEMPFILE_ALLOCATOR);
        tempfileClass.defineAnnotatedMethods(Tempfile.class);
        return tempfileClass;
    }

    public Tempfile(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @Override
    @JRubyMethod(required=1, optional=1, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        return this.initializeCommon(this.getRuntime().getCurrentContext(), args2);
    }

    @Override
    @JRubyMethod(required=1, optional=2, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.initializeCommon(context, args2);
    }

    private IRubyObject initializeCommon(ThreadContext context, IRubyObject[] args2) {
        TempfileCallback body = new TempfileCallback();
        this.callMethod(context, "create", args2, CallBlock19.newCallClosure(this, this.getMetaClass(), Arity.OPTIONAL, body, context));
        context.runtime.addInternalFinalizer(this);
        return context.nil;
    }

    private void initializeOpen(IOOptions ioOptions) {
        this.getRuntime().getPosix().chmod(this.path, 384);
        this.MakeOpenFile();
        this.openFile.setMode(ioOptions.getModeFlags().getOpenFileFlags());
        this.openFile.setPath(this.path);
        this.sysopenInternal19(this.path, ioOptions.getModeFlags().getOpenFileFlags(), 384);
    }

    @JRubyMethod(visibility=Visibility.PUBLIC)
    public IRubyObject open() {
        if (!this.isClosed()) {
            this.ioClose(this.getRuntime());
        }
        this.openInternal(this.path, this.openFile.getModeAsString(this.getRuntime()));
        return this;
    }

    @JRubyMethod(visibility=Visibility.PROTECTED)
    public IRubyObject _close(ThreadContext context) {
        return !this.isClosed() ? super.close() : context.runtime.getNil();
    }

    @JRubyMethod(optional=1, visibility=Visibility.PUBLIC)
    public IRubyObject close(ThreadContext context, IRubyObject[] args2, Block block) {
        boolean unlink2 = args2.length == 1 ? args2[0].isTrue() : false;
        return unlink2 ? this.close_bang(context) : this._close(context);
    }

    @JRubyMethod(name={"close!"}, visibility=Visibility.PUBLIC)
    public IRubyObject close_bang(ThreadContext context) {
        this._close(context);
        this.tmpFile.delete();
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"unlink", "delete"})
    public IRubyObject unlink(ThreadContext context) {
        if (this.isClosed()) {
            if (!this.tmpFile.exists() || this.tmpFile.delete()) {
                this.path = null;
            }
        } else {
            context.runtime.getWarnings().warn("Tempfile#unlink or delete called on open file; ignoring");
        }
        return context.runtime.getNil();
    }

    @Override
    @JRubyMethod(name={"size", "length"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject size(ThreadContext context) {
        if (!this.isClosed()) {
            this.flush();
            return context.runtime.newFileStat(this.path, false).size();
        }
        return RubyFixnum.zero(context.runtime);
    }

    @JRubyMethod(name={"size", "length"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject size19(ThreadContext context) {
        if (!this.isClosed()) {
            this.flush();
        }
        return context.runtime.newFileStat(this.path, false).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(required=1, optional=1, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = context.runtime;
        RubyClass klass = (RubyClass)recv2;
        Tempfile tempfile2 = (Tempfile)klass.newInstance(context, args2, block);
        if (block.isGiven()) {
            try {
                block.yield(context, tempfile2);
            }
            finally {
                if (!tempfile2.isClosed()) {
                    tempfile2.close();
                }
            }
            return runtime.getNil();
        }
        return tempfile2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(required=1, optional=1, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject open19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = context.runtime;
        RubyClass klass = (RubyClass)recv2;
        Tempfile tempfile2 = (Tempfile)klass.newInstance(context, args2, block);
        if (block.isGiven()) {
            try {
                IRubyObject iRubyObject = block.yield(context, tempfile2);
                return iRubyObject;
            }
            finally {
                if (!tempfile2.isClosed()) {
                    tempfile2.close();
                }
            }
        }
        return tempfile2;
    }

    @Override
    @JRubyMethod
    public IRubyObject inspect() {
        StringBuilder val = new StringBuilder();
        val.append("#<Tempfile:").append(this.path);
        if (!this.openFile.isOpen()) {
            val.append(" (closed)");
        }
        val.append(">");
        return this.getRuntime().newString(val.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.tmpFile.delete();
        }
    }

    private class TempfileCallback
    implements BlockCallback {
        private TempfileCallback() {
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
            Ruby runtime = context.runtime;
            IRubyObject tmpname = args2[0];
            IOOptions ioOptions = RubyIO.newIOOptions(runtime, ModeFlags.RDWR | ModeFlags.EXCL);
            if (context.is19 && args2.length > 1 && args2[args2.length - 1] instanceof RubyHash) {
                RubyHash options2 = (RubyHash)args2[args2.length - 1];
                ioOptions = Tempfile.this.updateIOOptionsFromOptions(context, options2, ioOptions);
                EncodingUtils.ioExtractEncodingOption(context, Tempfile.this, options2, null);
            }
            try {
                File tmp = new File(tmpname.convertToString().toString());
                if (!tmp.createNewFile()) {
                    throw context.runtime.newErrnoEEXISTError(Tempfile.this.path);
                }
                Tempfile.this.tmpFile = tmp;
                Tempfile.this.path = tmp.getPath();
                Tempfile.this.initializeOpen(ioOptions);
            }
            catch (IOException e) {
                throw context.runtime.newIOErrorFromException(e);
            }
            return context.nil;
        }
    }
}

