/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.id;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.MapMatcher;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.NoFilter;

public class ModuleRules {
    private Map rules = new LinkedHashMap();

    public ModuleRules() {
    }

    private ModuleRules(Map map) {
        this.rules = new LinkedHashMap(map);
    }

    public void defineRule(MapMatcher mapMatcher, Object object) {
        Checks.checkNotNull(mapMatcher, "condition");
        Checks.checkNotNull(object, "rule");
        this.rules.put(mapMatcher, object);
    }

    public Object getRule(ModuleId moduleId) {
        return this.getRule(moduleId, NoFilter.INSTANCE);
    }

    public Object[] getRules(ModuleId moduleId) {
        return this.getRules(moduleId.getAttributes(), NoFilter.INSTANCE);
    }

    public Object getRule(ModuleRevisionId moduleRevisionId) {
        return this.getRule(moduleRevisionId, NoFilter.INSTANCE);
    }

    public Object getRule(ModuleId moduleId, Filter filter) {
        Checks.checkNotNull(moduleId, "mid");
        return this.getRule(moduleId.getAttributes(), filter);
    }

    public Object getRule(ModuleRevisionId moduleRevisionId, Filter filter) {
        Checks.checkNotNull(moduleRevisionId, "mrid");
        Checks.checkNotNull(filter, "filter");
        Map map = moduleRevisionId.getAttributes();
        return this.getRule(map, filter);
    }

    private Object getRule(Map map, Filter filter) {
        for (Map.Entry entry : this.rules.entrySet()) {
            Object v;
            MapMatcher mapMatcher = (MapMatcher)entry.getKey();
            if (!mapMatcher.matches(map) || !filter.accept(v = entry.getValue())) continue;
            return v;
        }
        return null;
    }

    public Object[] getRules(ModuleRevisionId moduleRevisionId, Filter filter) {
        Checks.checkNotNull(moduleRevisionId, "mrid");
        Checks.checkNotNull(filter, "filter");
        Map map = moduleRevisionId.getAttributes();
        return this.getRules(map, filter);
    }

    private Object[] getRules(Map map, Filter filter) {
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : this.rules.entrySet()) {
            Object v;
            MapMatcher mapMatcher = (MapMatcher)entry.getKey();
            if (!mapMatcher.matches(map) || !filter.accept(v = entry.getValue())) continue;
            arrayList.add(v);
        }
        return arrayList.toArray();
    }

    public void dump(String string) {
        if (this.rules.isEmpty()) {
            Message.debug(string + "NONE");
        } else {
            for (MapMatcher mapMatcher : this.rules.keySet()) {
                Object v = this.rules.get(mapMatcher);
                Message.debug(string + mapMatcher + " -> " + v);
            }
        }
    }

    public Map getAllRules() {
        return Collections.unmodifiableMap(this.rules);
    }

    public Object clone() {
        return new ModuleRules(this.rules);
    }
}

