/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.jarjar.misplaced;

import java.io.IOException;
import org.objectweb.asm.ClassReader;
import org.pantsbuild.jarjar.util.EntryStruct;
import org.pantsbuild.jarjar.util.JarProcessor;

public abstract class MisplacedClassProcessor
implements JarProcessor {
    public abstract void handleMisplacedClass(EntryStruct var1, String var2);

    public abstract boolean shouldTransform();

    public abstract boolean shouldKeep();

    @Override
    public boolean process(EntryStruct struct) throws IOException {
        String originalClassName;
        if (!struct.name.endsWith(".class")) {
            return true;
        }
        try {
            originalClassName = new ClassReader(struct.data).getClassName() + ".class";
        }
        catch (Exception e) {
            System.err.println("Unable to read classname from bytecode in " + struct.name);
            System.err.println("Shading is therefore impossible, so this entry will be skipped.");
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            struct.skipTransform = true;
            return true;
        }
        if (!originalClassName.equals(struct.name)) {
            System.err.println(this.formatMisplacedClassMessage(struct, originalClassName));
            this.handleMisplacedClass(struct, originalClassName);
            if (!this.shouldTransform()) {
                struct.skipTransform = true;
            }
            return this.shouldKeep();
        }
        return true;
    }

    protected String formatMisplacedClassMessage(EntryStruct classStruct, String className) {
        return "Fully-qualified classname does not match jar entry:\n  jar entry: " + classStruct.name + "\n" + "  class name: " + className;
    }
}

