/*
 * Decompiled with CFR 0.152.
 */
package devplugin;

import devplugin.AbstractTvDataService;
import devplugin.Plugin;
import devplugin.Version;
import java.lang.reflect.Method;
import tvbrowser.core.Settings;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import util.misc.StringPool;

public final class PluginInfo {
    private Version mVersion = null;
    private String mName = "";
    private String mDescription = "";
    private String mAuthor = "";
    private String mLicense = null;
    private String mHelpUrl = null;

    public PluginInfo() {
        this(Class.class, "");
    }

    public PluginInfo(Class<? extends Object> caller, String name) {
        this(caller, name, "");
    }

    public PluginInfo(Class<? extends Object> caller, String name, String desc) {
        this(caller, name, desc, "");
    }

    public PluginInfo(Class<? extends Object> caller, String name, String desc, String author) {
        this(caller, name, desc, author, null, null);
    }

    public PluginInfo(Class<? extends Object> caller, String name, String desc, String author, String license) {
        this(caller, name, desc, author, license, null);
    }

    public PluginInfo(Class<? extends Object> caller, String name, String desc, String author, String license, String helpUrl) {
        this.mName = name;
        this.mDescription = desc;
        this.mAuthor = author;
        this.mHelpUrl = helpUrl;
        if (caller != null && caller.getSuperclass() != null && (caller.getSuperclass().equals(Plugin.class) || caller.equals(Plugin.class) || caller.getSuperclass().equals(AbstractTvDataService.class))) {
            try {
                Method m = caller.getMethod("getVersion", new Class[0]);
                this.mVersion = (Version)m.invoke(caller, new Object[0]);
            }
            catch (Exception e) {
                this.mVersion = new Version(0, 0);
            }
        } else {
            this.mVersion = new Version(0, 0);
        }
        this.mLicense = StringPool.getString(license);
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getAuthor() {
        return this.mAuthor;
    }

    public String getHelpUrl() {
        return this.mHelpUrl;
    }

    public Version getVersion() {
        return this.mVersion;
    }

    public String getLicense() {
        return this.mLicense;
    }

    public static String getHelpUrl(String id) {
        PluginProxy plugin = PluginProxyManager.getInstance().getPluginForId(id);
        Object url = null;
        if (plugin != null) {
            url = plugin.getInfo().getHelpUrl();
        }
        if (url == null) {
            url = "https://www.tvbrowser.org/showHelpFor.php?id=" + id + "&lang=" + Settings.Locales.LANGUAGE.getString();
        }
        return url;
    }
}

