/*
 * Decompiled with CFR 0.152.
 */
package devplugin;

import javax.swing.Icon;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.InfoThemeLoader;
import util.i18n.Localizer;

public class ProgramInfoHelper {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ProgramInfoHelper.class);
    private static final int[] mInfoBitArr = new int[]{2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 16384, 32768, 524288, 4096, 8192, 65536, 131072, 262144, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000};
    private static final String[] mInfoMsgArr = new String[]{mLocalizer.msg("blackAndWhite", "Black and white"), mLocalizer.msg("4to3", "4:3"), mLocalizer.msg("16to9", "16:9"), mLocalizer.msg("mono", "Mono"), mLocalizer.msg("stereo", "Stereo"), mLocalizer.msg("dolbySurround", "Dolby surround"), mLocalizer.msg("dolbyDigital5.1", "Dolby digital 5.1"), mLocalizer.msg("twoChannelTone", "Two channel tone"), mLocalizer.msg("subtitleForAurallyHandicapped", "Subtitle for aurally handicapped"), mLocalizer.msg("live", "Live"), mLocalizer.msg("originalWithSubtitle", "Original with subtitle"), mLocalizer.msg("new", "New"), mLocalizer.msg("audioDescription", "Audio Description"), mLocalizer.msg("hd", "high definition"), mLocalizer.msg("categorie_movie", "Movie"), mLocalizer.msg("categorie_series", "Series"), mLocalizer.msg("categorie_news", "News"), mLocalizer.msg("categorie_show", "Show/Entertainment"), mLocalizer.msg("categorie_magazine_infotainment", "Magazine/Infotainment"), mLocalizer.msg("categorie_documentary", "Documentary/Reportage"), mLocalizer.msg("categorie_arts", "Theater/Concert"), mLocalizer.msg("categorie_sports", "Sports"), mLocalizer.msg("categorie_childrens", "Children's Programming"), mLocalizer.msg("categorie_others", "Other Program"), mLocalizer.msg("sign_language", "Sign language")};

    public static boolean bitSet(int num, int pattern) {
        return (num & pattern) == pattern;
    }

    public static final int[] getInfoBits() {
        return (int[])mInfoBitArr.clone();
    }

    public static final Icon[] getInfoIcons() {
        return InfoThemeLoader.getInstance().getIconThemeForIDOrDefault(Settings.LookAndFeel.INFO_ICON_THEME_ID.getString()).getInfoIcons();
    }

    @Deprecated(since="3.3.4")
    public static final String[] getInfoIconFilenames() {
        return ProgramInfoHelper.getInfoIconURLs();
    }

    public static final String[] getInfoIconURLs() {
        return InfoThemeLoader.getInstance().getIconThemeForIDOrDefault(Settings.LookAndFeel.INFO_ICON_THEME_ID.getString()).getInfoIconURLs();
    }

    public static final String[] getInfoIconMessages() {
        return (String[])mInfoMsgArr.clone();
    }

    public static String getMessageForBit(int bit) {
        int[] bits = ProgramInfoHelper.getInfoBits();
        String[] names = ProgramInfoHelper.getInfoIconMessages();
        for (int i = 0; i < bits.length; ++i) {
            if (bits[i] != bit) continue;
            return names[i];
        }
        return "Unknown";
    }

    public static int getIndexForBit(int bit) {
        int[] bits = ProgramInfoHelper.getInfoBits();
        for (int i = 0; i < bits.length; ++i) {
            if (bits[i] != bit) continue;
            return i;
        }
        return -1;
    }

    public static int getBitForIndex(int index) {
        int[] bits = ProgramInfoHelper.getInfoBits();
        if (index >= 0 && index < bits.length) {
            return bits[index];
        }
        return 0;
    }
}

