/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core;

import devplugin.Channel;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.swing.SwingUtilities;
import tvbrowser.core.DummyChannel;
import tvbrowser.core.Settings;
import tvbrowser.core.TvDataBase;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.programtable.DefaultProgramTableModel;
import util.io.IOUtilities;
import util.io.stream.ObjectInputStreamProcessor;
import util.io.stream.ObjectOutputStreamProcessor;
import util.io.stream.StreamUtilities;

public class ChannelList {
    private static final String[] DEFAULT_CHANNELS_DE = new String[]{"tvbrowserdataservice.TvBrowserDataService_main_de_ard", "tvbrowserdataservice.TvBrowserDataService_main_de_zdf", "tvbrowserdataservice.TvBrowserDataService_main_de_rtl", "tvbrowserdataservice.TvBrowserDataService_main_de_sat1", "tvbrowserdataservice.TvBrowserDataService_main_de_pro7", "tvbrowserdataservice.TvBrowserDataService_main_de_kabel1", "tvbrowserdataservice.TvBrowserDataService_main_de_rtl2", "tvbrowserdataservice.TvBrowserDataService_main_de_vox", "tvbrowserdataservice.TvBrowserDataService_main_de_superrtl", "tvbrowserdataservice.TvBrowserDataService_others_at_3sat"};
    private static final String[] DEFAULT_CHANNELS_AT = new String[]{"tvbrowserdataservice.TvBrowserDataService_austria_at_orf1", "tvbrowserdataservice.TvBrowserDataService_austria_at_orf2", "tvbrowserdataservice.TvBrowserDataService_main_de_ard", "tvbrowserdataservice.TvBrowserDataService_main_de_zdf", "tvbrowserdataservice.TvBrowserDataService_main_de_rtl", "tvbrowserdataservice.TvBrowserDataService_main_de_sat1", "tvbrowserdataservice.TvBrowserDataService_main_de_pro7", "tvbrowserdataservice.TvBrowserDataService_main_de_vox", "tvbrowserdataservice.TvBrowserDataService_austria_at_atvplus", "tvbrowserdataservice.TvBrowserDataService_austria_at_puls4", "tvbrowserdataservice.TvBrowserDataService_main_de_kabel1", "tvbrowserdataservice.TvBrowserDataService_main_de_rtl2", "tvbrowserdataservice.TvBrowserDataService_others_at_3sat"};
    private static final String[] DEFAULT_CHANNELS_CH = new String[]{"tvbrowserdataservice.TvBrowserDataService_others_ch_sfdrs1", "tvbrowserdataservice.TvBrowserDataService_others_ch_sfdrs2", "tvbrowserdataservice.TvBrowserDataService_others_ch_sfinfo", "tvbrowserdataservice.TvBrowserDataService_main_de_ard", "tvbrowserdataservice.TvBrowserDataService_main_de_zdf", "tvbrowserdataservice.TvBrowserDataService_main_de_rtl", "tvbrowserdataservice.TvBrowserDataService_main_de_sat1", "tvbrowserdataservice.TvBrowserDataService_main_de_pro7", "tvbrowserdataservice.TvBrowserDataService_austria_at_orf1", "tvbrowserdataservice.TvBrowserDataService_bronkotv_ch_3plus", "tvbrowserdataservice.TvBrowserDataService_main_de_vox", "tvbrowserdataservice.TvBrowserDataService_main_de_kabel1", "tvbrowserdataservice.TvBrowserDataService_main_de_rtl2", "tvbrowserdataservice.TvBrowserDataService_main_de_superrtl", "tvbrowserdataservice.TvBrowserDataService_others_at_3sat"};
    private static final String[] DEFAULT_CHANNELS_SE = new String[]{"swedbtvdataservice.SweDBTvDataService_SweDB_se_svt1.svt.se", "swedbtvdataservice.SweDBTvDataService_SweDB_se_svt2.svt.se", "swedbtvdataservice.SweDBTvDataService_SweDB_se_tv3.viasat.se", "swedbtvdataservice.SweDBTvDataService_SweDB_se_tv4.se", "swedbtvdataservice.SweDBTvDataService_SweDB_se_kanal5.se", "swedbtvdataservice.SweDBTvDataService_SweDB_se_tv6.viasat.se", "swedbtvdataservice.SweDBTvDataService_SweDB_se_plus.tv4.se", "swedbtvdataservice.SweDBTvDataService_SweDB_se_tv8.se", "swedbtvdataservice.SweDBTvDataService_SweDB_se_kanal9.se", "swedbtvdataservice.SweDBTvDataService_SweDB_se_svtb-svt24.svt.se"};
    private static final String[] DEFAULT_CHANNELS_NO = new String[]{"tvbrowserdataservice.TvBrowserDataService_norge_no_NRK1", "tvbrowserdataservice.TvBrowserDataService_norge_no_TV2", "tvbrowserdataservice.TvBrowserDataService_norge_no_TV3", "swedbtvdataservice.SweDBTvDataService_MSPC_no_tvnorge.no", "tvbrowserdataservice.TvBrowserDataService_norge_no_NRK2", "tvbrowserdataservice.TvBrowserDataService_norge_no_NRK3", "tvbrowserdataservice.TvBrowserDataService_norge_no_Viasat-4", "swedbtvdataservice.SweDBTvDataService_MSPC_no_femtv.no", "tvbrowserdataservice.TvBrowserDataService_norge_no_TV2Zebra", "tvbrowserdataservice.TvBrowserDataService_norge_no_NRK-Super-TV", "swedbtvdataservice.SweDBTvDataService_SweDB_se_svt1.svt.se"};
    private static final String[] DEFAULT_CHANNELS_DK = new String[]{"tvbrowserdataservice.TvBrowserDataService_Euro-TV_dk_DR1", "tvbrowserdataservice.TvBrowserDataService_Euro-TV_dk_TV-2", "tvbrowserdataservice.TvBrowserDataService_Euro-TV_dk_TV3", "tvbrowserdataservice.TvBrowserDataService_Euro-TV_dk_DR2", "tvbrowserdataservice.TvBrowserDataService_Euro-TV_dk_TV-2.Charlie", "tvbrowserdataservice.TvBrowserDataService_Euro-TV_dk_TV-2.Zulu", "tvbrowserdataservice.TvBrowserDataService_Euro-TV_dk_TV3+", "tvbrowserdataservice.TvBrowserDataService_Euro-TV_dk_Kanal4", "tvbrowserdataservice.TvBrowserDataService_Euro-TV_dk_Kanal5", "tvbrowserdataservice.TvBrowserDataService_Euro-TV_dk_SBSNET", "tvbrowserdataservice.TvBrowserDataService_Euro-TV_dk_DR.K", "tvbrowserdataservice.TvBrowserDataService_Euro-TV_dk_DR.Ramasjang"};
    private static final String FILENAME_DAYLIGHT_CORRECTION = "daylight_correction.txt";
    private static final String FILENAME_CHANNEL_NAMES = "channel_names.txt";
    private static final String FILENAME_CHANNEL_ICONS = "channel_icons.txt";
    private static final String FILENAME_CHANNEL_WEBPAGES = "channel_webpages.txt";
    private static final String FILENAME_CHANNEL_TIME_LIMIT = "channelTimeLimit.dat";
    private static final String FILENAME_CHANNEL_SORT_NUMBERS = "channel_sort_numbers.txt";
    private static final String FILENAME_CHANNEL_BACKGROUND_COLORS = "channel_background_colors.txt";
    private static final Logger mLog = Logger.getLogger(ChannelList.class.getName());
    private static ArrayList<Channel> mAvailableChannels = new ArrayList();
    private static HashMap<String, Channel> mAvailableChannelsMap = new HashMap();
    private static ArrayList<Channel> mSubscribedChannels = new ArrayList();
    private static HashMap<String, DummyChannel> mDummyChannelMap = new HashMap();
    private static HashMap<String, Integer> mSubscribedChannelPosition = new HashMap();
    private static Thread mCompleteChannelThread;
    private static HashMap<String, String> mChannelIconMap;
    private static HashMap<String, String> mChannelNameMap;
    private static HashMap<String, String> mChannelWebpagesMap;
    private static HashMap<String, String> mChannelDayLightCorrectionMap;
    private static HashMap<String, String> mChannelSortNumberMap;
    private static HashMap<String, String> mChannelBackgroundColorMap;
    private static Channel mCurrentChangeChannel;

    public static void completeChannelLoading() {
        ChannelList.getChannelLoadThread();
    }

    public static void reload() {
        ChannelList.loadChannelMaps();
        ChannelList.create();
        ChannelList.checkForJointChannels();
        FavoritesPlugin.getInstance().reValidateChannelLimitation();
    }

    private static void create() {
        Channel[] channelArr;
        TvDataServiceProxy[] dataServiceArr = TvDataServiceProxyManager.getInstance().getDataServices();
        HashMap<Channel, Channel> availableChannels = new HashMap<Channel, Channel>(mAvailableChannelsMap.size());
        boolean dummyRemoved = false;
        for (TvDataServiceProxy proxy : dataServiceArr) {
            dummyRemoved = ChannelList.addDataServiceChannels(proxy, availableChannels) || dummyRemoved;
        }
        if (dummyRemoved) {
            Settings.Channels.SUBSCRIBED.clearCacheExternal();
            if (!MainFrame.isStarting()) {
                SwingUtilities.invokeLater(() -> {
                    DefaultProgramTableModel model = MainFrame.getInstance().getProgramTableModel();
                    model.setChannels(ChannelList.getSubscribedChannels());
                    MainFrame.getInstance().updateChannellist();
                });
            }
        }
        for (Channel channel : channelArr = Settings.Channels.SUBSCRIBED.getChannelArray()) {
            if (!(channel instanceof DummyChannel)) continue;
            ChannelList.addChannelToAvailableChannels(channel, availableChannels);
        }
        boolean removed = false;
        for (int i = mAvailableChannels.size() - 1; i >= 0; --i) {
            Channel ch = mAvailableChannels.get(i);
            if (availableChannels.containsKey(ch)) continue;
            mAvailableChannels.remove(i);
            mAvailableChannelsMap.remove(ch.getUniqueId());
            if (!mSubscribedChannels.contains(ch)) continue;
            mLog.warning(ch + " is not available any more");
            ChannelList.unsubscribeChannel(ch);
            removed = true;
        }
        if (removed) {
            Settings.Channels.SUBSCRIBED.setChannelArray(mSubscribedChannels.toArray(new Channel[mSubscribedChannels.size()]));
            ChannelList.calculateChannelPositions();
        }
        SwingUtilities.invokeLater(() -> MainFrame.resetOnAirArrays());
    }

    private static void unsubscribeChannel(Channel channel) {
        mSubscribedChannels.remove(channel);
        mSubscribedChannelPosition.remove(channel.getUniqueId());
        TvDataBase.getInstance().unsubscribeChannels(new Channel[]{channel});
    }

    public static void initSubscribedChannels() {
        Channel[] channelArr = Settings.Channels.SUBSCRIBED.getChannelArray();
        if (channelArr.length == 0 && mSubscribedChannels.isEmpty()) {
            channelArr = ChannelList.getDefaultChannels(Settings.getCountry());
        }
        for (Channel channel : channelArr) {
            if (channel == null) continue;
            ChannelList.subscribeChannel(channel);
        }
        ChannelList.loadChannelTimeLimits();
    }

    public static void storeAllSettings() {
        try {
            ChannelList.store(FILENAME_DAYLIGHT_CORRECTION, mChannelDayLightCorrectionMap, false, false, channel -> {
                String result = null;
                int corr = channel.getTimeZoneCorrectionMinutes();
                if (corr != 0) {
                    result = String.valueOf((double)corr / 60.0);
                }
                return result;
            });
            ChannelList.store(FILENAME_CHANNEL_ICONS, mChannelIconMap, true, false, channel -> {
                Object filename = IOUtilities.checkForRelativePath(channel.getUserIconFileName());
                if (filename != null && ((String)filename).trim().length() > 0) {
                    filename = channel.isUsingUserIcon() + ";" + ((String)filename).trim();
                }
                return filename;
            });
            ChannelList.store(FILENAME_CHANNEL_SORT_NUMBERS, mChannelSortNumberMap, true, false, channel -> channel.getSortNumber());
            ChannelList.store(FILENAME_CHANNEL_NAMES, mChannelNameMap, true, true, channel -> channel.getUserChannelName());
            ChannelList.store(FILENAME_CHANNEL_BACKGROUND_COLORS, mChannelBackgroundColorMap, true, true, channel -> {
                String result = null;
                Color c = channel.getUserBackgroundColor();
                if (c != null) {
                    result = String.valueOf(c.getRed()) + "," + String.valueOf(c.getGreen()) + "," + String.valueOf(c.getBlue()) + "," + String.valueOf(c.getAlpha());
                }
                return result;
            });
            ChannelList.store(FILENAME_CHANNEL_WEBPAGES, mChannelWebpagesMap, true, false, channel -> {
                String userWebPage = channel.getUserWebPage();
                if (userWebPage != null && channel.getDefaultWebPage() != null && channel.getDefaultWebPage().equalsIgnoreCase(userWebPage)) {
                    userWebPage = null;
                }
                return userWebPage;
            });
            ChannelList.storeChannelTimeLimits();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static boolean addDataServiceChannels(TvDataServiceProxy dataService, HashMap<Channel, Channel> availableChannels) {
        Channel[] channelArr = dataService.getAvailableChannels();
        boolean dummyRemoved = false;
        for (Channel channel : channelArr) {
            dummyRemoved = ChannelList.addChannelToAvailableChannels(channel, availableChannels) || dummyRemoved;
        }
        return dummyRemoved;
    }

    private static void addDataServiceChannelsForTvBrowserStart(TvDataServiceProxy dataService) {
        Channel[] channelArr;
        for (Channel channel : channelArr = dataService.getChannelsForTvBrowserStart()) {
            ChannelList.addChannelToAvailableChannels(channel, new HashMap<Channel, Channel>());
        }
    }

    private static boolean addChannelToAvailableChannels(Channel channel, HashMap<Channel, Channel> availableChannels) {
        String channelId = channel.getUniqueId();
        mCurrentChangeChannel = mAvailableChannelsMap.get(channelId);
        boolean dummyRemoved = false;
        if (mCurrentChangeChannel instanceof DummyChannel && !(channel instanceof DummyChannel)) {
            mAvailableChannels.remove(mCurrentChangeChannel);
            mAvailableChannelsMap.remove(channelId);
            int pos = ChannelList.getPos(mCurrentChangeChannel);
            if (pos >= 0) {
                mSubscribedChannelPosition.remove(channel.getUniqueId());
                mSubscribedChannelPosition.put(channel.getUniqueId(), pos);
                mSubscribedChannels.remove(pos);
                mSubscribedChannels.add(pos, channel);
            }
            mCurrentChangeChannel.setIcon(channel.getDefaultIcon());
            ((DummyChannel)mCurrentChangeChannel).setOriginal(channel);
            mCurrentChangeChannel = null;
            dummyRemoved = true;
        }
        if (mCurrentChangeChannel == null) {
            availableChannels.put(channel, channel);
            mAvailableChannels.add(channel);
            mAvailableChannelsMap.put(channelId, channel);
            if (!mChannelDayLightCorrectionMap.isEmpty()) {
                ChannelList.setDayLightSavingTimeCorrectionsForChannel(channel);
            }
            if (!mChannelIconMap.isEmpty()) {
                ChannelList.setChannelIconForChannel(channel);
            }
            if (!mChannelSortNumberMap.isEmpty()) {
                ChannelList.setChannelSortNumberForChannel(channel);
            }
            if (!mChannelNameMap.isEmpty()) {
                ChannelList.setChannelNameForChannel(channel);
            }
            if (!mChannelWebpagesMap.isEmpty()) {
                ChannelList.setWebPageForChannel(channel);
            }
            if (!mChannelBackgroundColorMap.isEmpty()) {
                ChannelList.setChannelBackgroundForChannel(channel);
            }
        } else {
            mCurrentChangeChannel.setChannelName(channel.getDefaultName());
            mCurrentChangeChannel.setDefaultIcon(channel.getDefaultIcon());
            mCurrentChangeChannel.setChannelCopyrightNotice(channel.getCopyrightNotice());
            mCurrentChangeChannel.setChannelWebpage(channel.getDefaultWebPage());
            availableChannels.put(mCurrentChangeChannel, mCurrentChangeChannel);
        }
        mCurrentChangeChannel = null;
        return dummyRemoved;
    }

    private static void loadChannelMaps() {
        mChannelIconMap = ChannelList.createMap(new File(Settings.getUserSettingsDirName(), FILENAME_CHANNEL_ICONS));
        mChannelSortNumberMap = ChannelList.createMap(new File(Settings.getUserSettingsDirName(), FILENAME_CHANNEL_SORT_NUMBERS));
        mChannelNameMap = ChannelList.createMap(new File(Settings.getUserSettingsDirName(), FILENAME_CHANNEL_NAMES));
        mChannelWebpagesMap = ChannelList.createMap(new File(Settings.getUserSettingsDirName(), FILENAME_CHANNEL_WEBPAGES));
        mChannelDayLightCorrectionMap = ChannelList.createMap(new File(Settings.getUserSettingsDirName(), FILENAME_DAYLIGHT_CORRECTION));
        mChannelBackgroundColorMap = ChannelList.createMap(new File(Settings.getUserSettingsDirName(), FILENAME_CHANNEL_BACKGROUND_COLORS));
    }

    public static void createForTvBrowserStart() {
        mAvailableChannels.clear();
        mAvailableChannelsMap.clear();
        TvDataServiceProxy[] dataServiceArr = TvDataServiceProxyManager.getInstance().getDataServices();
        ChannelList.loadChannelMaps();
        for (TvDataServiceProxy proxy : dataServiceArr) {
            ChannelList.addDataServiceChannelsForTvBrowserStart(proxy);
        }
    }

    public static void subscribeChannel(Channel channel) {
        if (!mSubscribedChannels.contains(channel)) {
            mSubscribedChannels.add(channel);
            ChannelList.calculateChannelPositions();
        }
    }

    private static void calculateChannelPositions() {
        mSubscribedChannelPosition = new HashMap();
        for (int i = 0; i < mSubscribedChannels.size(); ++i) {
            Channel ch = mSubscribedChannels.get(i);
            if (ch == null) continue;
            mSubscribedChannelPosition.put(ch.getUniqueId(), i);
        }
    }

    public static void setSubscribeChannels(Channel[] channelArr) {
        ChannelList.setSubscribeChannels(channelArr, false);
    }

    public static void setSubscribeChannels(Channel[] channelArr, boolean update) {
        boolean channelsAdded = false;
        if (update) {
            for (Channel channel : channelArr) {
                if (mSubscribedChannels.contains(channel)) continue;
                channelsAdded = true;
            }
        }
        ArrayList<Channel> unsubscribedChannels = new ArrayList<Channel>();
        for (Channel channel : mSubscribedChannels) {
            boolean found = false;
            for (Channel newChannel : channelArr) {
                if (channel != newChannel) continue;
                found = true;
            }
            if (found) continue;
            unsubscribedChannels.add(channel);
        }
        mSubscribedChannels = new ArrayList(channelArr.length);
        for (int i = 0; i < channelArr.length; ++i) {
            Channel channel = channelArr[i];
            if (channel == null) {
                mLog.warning("cannot subscribe channel #" + i + " - is null");
                continue;
            }
            mSubscribedChannels.add(channel);
        }
        ChannelList.calculateChannelPositions();
        TvDataBase.getInstance().unsubscribeChannels(unsubscribedChannels.toArray(new Channel[unsubscribedChannels.size()]));
        if (channelsAdded && update) {
            SwingUtilities.invokeLater(() -> MainFrame.getInstance().askForDataUpdateChannelsAdded());
        }
    }

    public static Channel getChannel(String dataServiceId, String groupId, String country, String channelId) {
        return ChannelList.getChannel(dataServiceId, groupId, country, channelId, "Dummy");
    }

    public static Channel getChannel(String dataServiceId, String groupId, String country, String channelId, String channelName) {
        TvDataServiceProxy dataService = null;
        Channel returnValue = null;
        if (dataServiceId != null) {
            dataService = TvDataServiceProxyManager.getInstance().findDataServiceById(dataServiceId);
        }
        if (dataService != null) {
            int n = mAvailableChannels.size();
            for (int i = 0; i < n; ++i) {
                Channel channel = mAvailableChannels.get(i);
                if (channel.getId().compareTo(channelId) != 0 || (dataServiceId == null || channel.getDataServiceId().compareTo(dataService.getId()) != 0) && dataServiceId != null || (groupId == null || channel.getGroup().getId().compareTo(groupId) != 0) && groupId != null || (country == null || channel.getBaseCountry().compareTo(country) != 0) && country != null) continue;
                returnValue = channel;
                break;
            }
        }
        if (returnValue == null) {
            returnValue = ChannelList.getDummyChannel(dataServiceId, groupId, country, channelId, channelName);
        }
        return returnValue;
    }

    private static Channel getDummyChannel(String dataServiceId, String groupId, String country, String channelId, String channelName) {
        if (dataServiceId != null && groupId != null && country != null && channelId != null) {
            StringBuilder key = new StringBuilder();
            key.append(dataServiceId).append(";").append(groupId).append(";").append(country).append(";").append(channelId);
            DummyChannel dummy = mDummyChannelMap.get(key.toString());
            if (dummy == null) {
                dummy = new DummyChannel(dataServiceId, groupId, country, channelId, channelName);
                mDummyChannelMap.put(key.toString(), dummy);
            }
            return dummy;
        }
        return null;
    }

    public static int getPos(Channel channel) {
        if (channel != null) {
            Integer pos = mSubscribedChannelPosition.get(channel.getUniqueId());
            if (pos == null) {
                return -1;
            }
            return pos;
        }
        return -1;
    }

    public static Channel[] getAvailableChannels() {
        Channel[] result = new Channel[mAvailableChannels.size()];
        mAvailableChannels.toArray(result);
        return result;
    }

    public static boolean isSubscribedChannel(Channel channel) {
        if (channel == null) {
            return false;
        }
        for (Channel subscribed : mSubscribedChannels) {
            if (subscribed == null || !subscribed.equals(channel)) continue;
            return true;
        }
        return false;
    }

    public static int getNumberOfSubscribedChannels() {
        return mSubscribedChannels.size();
    }

    public static Channel[] getSubscribedChannels() {
        return ChannelList.getSubscribedChannels(true);
    }

    public static Channel[] getSubscribedChannels(boolean withDummyChannels) {
        ArrayList<Channel> result = new ArrayList<Channel>();
        for (Channel channel : mSubscribedChannels) {
            if (!withDummyChannels && channel instanceof DummyChannel) continue;
            result.add(channel);
        }
        return result.toArray(new Channel[result.size()]);
    }

    private static void setDayLightSavingTimeCorrectionsForChannel(Channel channel) {
        String value = ChannelList.getMapValueForChannel(channel, mChannelDayLightCorrectionMap);
        if (value != null && value.length() > 0) {
            Double corr = Double.valueOf(value);
            channel.setTimeZoneCorrectionMinutes((int)(corr * 60.0));
        }
    }

    private static void setChannelIconForChannel(Channel channel) {
        String[] settings;
        String value = ChannelList.getMapValueForChannel(channel, mChannelIconMap);
        if (value != null && value.length() > 0 && (settings = value.split(";")).length == 2) {
            channel.setUserIconFileName(settings[1]);
            if (settings[0].equals("true")) {
                channel.useUserIcon(true);
            } else {
                channel.useUserIcon(false);
            }
        }
    }

    private static void setChannelSortNumberForChannel(Channel channel) {
        String value = ChannelList.getMapValueForChannel(channel, mChannelSortNumberMap);
        channel.setSortNumber(value);
    }

    private static void setChannelBackgroundForChannel(Channel channel) {
        String value = ChannelList.getMapValueForChannel(channel, mChannelBackgroundColorMap);
        if (value != null) {
            try {
                String[] parts = value.split(",");
                if (parts.length == 4) {
                    channel.setUserBackgroundColor(new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3])));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static void setChannelNameForChannel(Channel channel) {
        String value = ChannelList.getMapValueForChannel(channel, mChannelNameMap);
        if (value != null && value.length() > 0) {
            channel.setUserChannelName(value);
        }
    }

    private static void setWebPageForChannel(Channel channel) {
        String value = ChannelList.getMapValueForChannel(channel, mChannelWebpagesMap);
        if (value != null && value.length() > 0) {
            channel.setUserWebPage(value);
        }
    }

    private static void store(String fileName, HashMap<String, String> map, boolean writeUnsubscribed, boolean storeCurrentSubscription, InterfaceStore interfaceStore) {
        File f = new File(Settings.getUserSettingsDirName(), fileName);
        PrintWriter out = null;
        try {
            FileWriter fw = new FileWriter(f);
            out = new PrintWriter(fw);
            ArrayList<String> subscribedServices = storeCurrentSubscription ? new ArrayList<String>() : null;
            for (Channel channel : ChannelList.getSubscribedChannels()) {
                String value = interfaceStore.handleChannel(channel);
                if (value != null && value.trim().length() > 0) {
                    out.println(ChannelList.createPropertyForChannel(channel, value.trim()));
                }
                if (subscribedServices == null) continue;
                subscribedServices.add(channel.getDataServiceId());
            }
            if (subscribedServices != null) {
                Settings.Channels.DATA_SERVICE_IDS_USED_CURRENTLY.setStringArray(subscribedServices.toArray(new String[subscribedServices.size()]));
            }
            if (map != null && writeUnsubscribed) {
                Set<String> keys = map.keySet();
                for (String key : keys) {
                    if (ChannelList.isSubscribedChannel(ChannelList.getChannelForKey(key))) continue;
                    out.print(key);
                    out.print("=");
                    out.println(map.get(key));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (out != null) {
            out.close();
        }
    }

    private static String createPropertyForChannel(Channel channel, String value) {
        return channel.getDataServiceId() + ":" + channel.getGroup().getId() + ":" + channel.getBaseCountry() + ":" + channel.getId() + "=" + value;
    }

    private static String getMapValueForChannel(Channel channel, HashMap<String, String> map) {
        StringBuilder key = new StringBuilder(channel.getDataServiceId()).append(":").append(channel.getGroup().getId()).append(":").append(channel.getBaseCountry()).append(":").append(channel.getId());
        String value = map.get(key.toString());
        if (value == null) {
            value = map.get(channel.getDataServiceId() + ":" + channel.getGroup().getId() + ":" + channel.getId());
        }
        if (value == null) {
            value = map.get(channel.getDataServiceId() + ":" + channel.getId());
        }
        return value;
    }

    private static HashMap<String, String> createMap(File f) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!f.exists()) {
            return map;
        }
        BufferedReader reader = null;
        try {
            String line;
            FileReader fr = new FileReader(f);
            reader = new BufferedReader(fr);
            while ((line = reader.readLine()) != null) {
                int pos = line.indexOf(61);
                try {
                    String key = line.substring(0, pos);
                    String val = line.substring(pos + 1);
                    if (val == null) continue;
                    map.put(key, val);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return map;
    }

    public static synchronized Thread getChannelLoadThread() {
        if (mCompleteChannelThread == null) {
            mCompleteChannelThread = new Thread("Load not subscribed channels"){

                @Override
                public void run() {
                    mLog.info("Loading the not subscribed services and channels");
                    TvDataServiceProxyManager.getInstance().loadNotSubscribed();
                    ChannelList.create();
                    mLog.info("Loading of all channels complete");
                }
            };
            mCompleteChannelThread.setPriority(1);
            mCompleteChannelThread.start();
        }
        return mCompleteChannelThread;
    }

    public static void loadChannelTimeLimits() {
        File f = new File(Settings.getUserSettingsDirName(), FILENAME_CHANNEL_TIME_LIMIT);
        if (f.isFile() && f.canRead()) {
            StreamUtilities.objectInputStreamIgnoringExceptions(f, new ObjectInputStreamProcessor(){

                @Override
                public void process(ObjectInputStream in) throws IOException {
                    in.readShort();
                    int n = in.readShort();
                    for (int i = 0; i < n; ++i) {
                        try {
                            Channel ch = Channel.readData(in, true);
                            short startTimeLimit = in.readShort();
                            short endTimeLimit = in.readShort();
                            if (ch == null) continue;
                            ch.setStartTimeLimit(startTimeLimit);
                            ch.setEndTimeLimit(endTimeLimit);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                    in.close();
                }
            });
        }
    }

    public static void storeChannelTimeLimits() {
        File f = new File(Settings.getUserSettingsDirName(), FILENAME_CHANNEL_TIME_LIMIT);
        StreamUtilities.objectOutputStreamIgnoringExceptions(f, new ObjectOutputStreamProcessor(){

            @Override
            public void process(ObjectOutputStream out) throws IOException {
                out.writeShort(1);
                Channel[] channels = ChannelList.getSubscribedChannels();
                out.writeShort(channels.length);
                for (Channel channel : channels) {
                    channel.writeData(out);
                    out.writeShort(channel.getStartTimeLimit());
                    out.writeShort(channel.getEndTimeLimit());
                }
                out.close();
            }
        });
    }

    private static Channel getChannelForKey(String key) {
        Channel ch = null;
        if (key != null) {
            String[] keyParts = key.split(":");
            ch = keyParts.length == 4 ? ChannelList.getChannel(keyParts[0], keyParts[1], keyParts[2], keyParts[3]) : (keyParts.length == 3 ? ChannelList.getChannel(keyParts[0], keyParts[1], null, keyParts[2]) : ChannelList.getChannel(keyParts[0], null, null, keyParts[1]));
        }
        return ch;
    }

    public static boolean hasCalledChannelValueChangeForChannel(Channel ch) {
        return mCurrentChangeChannel != null && ch != null && mCurrentChangeChannel.equals(ch);
    }

    public static Channel getChannel(String uniqueId) {
        return mAvailableChannelsMap.get(uniqueId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Channel[] getDefaultChannels(String country) {
        ArrayList<Channel> list = new ArrayList<Channel>();
        File testForDefaultList = new File(Settings.getUserSettingsDirName(), "channellist_" + country + ".gz");
        if (testForDefaultList.isFile()) {
            BufferedReader in;
            block19: {
                in = null;
                try {
                    in = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(testForDefaultList)), "UTF-8"));
                    String line = null;
                    ArrayList<String> availableList = new ArrayList<String>();
                    while ((line = in.readLine()) != null) {
                        availableList.add(line);
                    }
                    if (availableList.isEmpty()) break block19;
                    ChannelList.addChannels(list, availableList.toArray(new String[availableList.size()]));
                }
                catch (Throwable t) {
                    try {
                        t.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        IOUtilities.close(in);
                    }
                }
            }
            IOUtilities.close(in);
        }
        if (list.isEmpty()) {
            if (country.equalsIgnoreCase("de")) {
                ChannelList.addChannels(list, DEFAULT_CHANNELS_DE);
            } else if (country.equalsIgnoreCase("at")) {
                ChannelList.addChannels(list, DEFAULT_CHANNELS_AT);
            } else if (country.equalsIgnoreCase("ch")) {
                ChannelList.addChannels(list, DEFAULT_CHANNELS_CH);
            } else if (country.equalsIgnoreCase("se")) {
                ChannelList.addChannels(list, DEFAULT_CHANNELS_SE);
            } else if (country.equalsIgnoreCase("no")) {
                ChannelList.addChannels(list, DEFAULT_CHANNELS_NO);
            } else if (country.equalsIgnoreCase("dk")) {
                ChannelList.addChannels(list, DEFAULT_CHANNELS_DK);
            }
        }
        return list.toArray(new Channel[list.size()]);
    }

    private static void addChannels(ArrayList<Channel> list, String[] channels) {
        block0: for (String id : channels) {
            Channel channel = ChannelList.getChannel(id);
            if (channel != null) {
                list.add(channel);
                continue;
            }
            if (!id.contains(":")) continue;
            String[] parts = id.split(":");
            for (Channel ch : mAvailableChannels) {
                if (!ch.getDataServicePackageName().equals(parts[0])) continue;
                if (parts[0].equals("epgdonatedata")) {
                    if (!ch.getId().equals(parts[1])) continue;
                    list.add(ch);
                    continue block0;
                }
                if (!ch.getGroup().getId().equals(parts[1]) || !ch.getId().equals(parts[2])) continue;
                list.add(ch);
                continue block0;
            }
        }
    }

    public static void checkForJointChannels() {
        Channel previousChannel = null;
        HashSet<Channel> jointChannels = new HashSet<Channel>();
        for (Channel ch : ChannelList.getSubscribedChannels()) {
            if (previousChannel != null && (previousChannel.isTimeLimited() && ch.isTimeLimited() && previousChannel.getStartTimeLimit() == ch.getEndTimeLimit() && previousChannel.getEndTimeLimit() == ch.getStartTimeLimit() || previousChannel.getSharedChannelId() != null && ch.getSharedChannelId() != null && previousChannel.getGroup() != null && ch.getGroup() != null && previousChannel.getSharedChannelId().equals(ch.getId()) && previousChannel.getDataServicePackageName().equals(ch.getDataServicePackageName()) && previousChannel.getGroup().equals(ch.getGroup())) && !jointChannels.contains(previousChannel)) {
                jointChannels.add(ch);
                previousChannel.setJointChannel(ch);
            } else if (previousChannel != null) {
                previousChannel.setJointChannel(null);
            }
            previousChannel = ch;
        }
        jointChannels.clear();
        jointChannels = null;
    }

    static {
        mCurrentChangeChannel = null;
    }

    @FunctionalInterface
    private static interface InterfaceStore {
        public String handleChannel(Channel var1);
    }
}

