/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters;

import devplugin.Channel;
import devplugin.Program;
import devplugin.ProgramFilter;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.regex.Pattern;
import tvbrowser.core.Settings;
import tvbrowser.core.filters.AndNode;
import tvbrowser.core.filters.Excludable;
import tvbrowser.core.filters.FilterComponent;
import tvbrowser.core.filters.FilterComponentList;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.ItemNode;
import tvbrowser.core.filters.Node;
import tvbrowser.core.filters.NotNode;
import tvbrowser.core.filters.OrNode;
import tvbrowser.core.filters.ParserException;
import tvbrowser.core.filters.Token;
import tvbrowser.core.filters.filtercomponents.AcceptNoneFilterComponent;
import tvbrowser.core.filters.filtercomponents.FavoritesFilterComponent;
import tvbrowser.core.filters.filtercomponents.SingleChannelFilterComponent;
import tvbrowser.extras.favoritesplugin.core.FilterComponentNewFavoritePrograms;
import util.exc.ErrorHandler;
import util.i18n.Localizer;
import util.io.stream.ObjectInputStreamProcessor;
import util.io.stream.ObjectOutputStreamProcessor;
import util.io.stream.StreamUtilities;

public class UserFilter
implements ProgramFilter {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(UserFilter.class);
    private String mName;
    private String mRule;
    private File mFile;
    private static Token[] mTokenList = null;
    private static int mCurInx;
    private static int curTokenInx;
    private static char[] mRuleLine;
    private static Token mCurToken;
    private Node mRoot;

    public static final String getLabelForBrokenPartially(String label) {
        return "<html><span style=\"color:orange;text-decoration:underline\">" + label + "</span></html>";
    }

    public static final String getLabelForBrokenCompletely(String label) {
        return "<html><span style=\"color:red;text-decoration:line-through\">" + label + "</span></html>";
    }

    public UserFilter(String name) {
        this.mName = name;
    }

    public UserFilter(File file) throws ParserException {
        this.mFile = file;
        try {
            StreamUtilities.objectInputStream(file, 4096, new ObjectInputStreamProcessor(){

                @Override
                public void process(ObjectInputStream in) throws IOException {
                    in.readInt();
                    try {
                        UserFilter.this.mName = (String)in.readObject();
                        UserFilter.this.mRule = (String)in.readObject();
                        UserFilter.this.mRule = UserFilter.this.modifyRule(UserFilter.this.mRule, false);
                    }
                    catch (ClassNotFoundException e) {
                        ErrorHandler.handle("Could not read filter from file", e);
                    }
                }
            });
        }
        catch (IOException e) {
            ErrorHandler.handle("Could not read filter from file", e);
        }
        this.createTokenTree(true);
    }

    public void store() {
        this.store(FilterList.FILTER_DIRECTORY, this.mName);
    }

    public void store(String directoy, String fileName) {
        try {
            this.mRule = this.modifyRule(this.mRule, true);
            File file = new File(directoy, fileName + ".filter");
            StreamUtilities.objectOutputStream(file, new ObjectOutputStreamProcessor(){

                @Override
                public void process(ObjectOutputStream out) throws IOException {
                    out.writeInt(1);
                    out.writeObject(UserFilter.this.mName);
                    out.writeObject(UserFilter.this.mRule);
                }
            });
        }
        catch (IOException e) {
            ErrorHandler.handle("Could not write filter to file", e);
        }
    }

    private String modifyRule(String rule, boolean normalize) {
        if (rule == null) {
            return rule;
        }
        for (String keyWord : new String[]{"or", "and", "not"}) {
            String localized = mLocalizer.msg(keyWord, keyWord);
            if (localized.length() <= 0) continue;
            String normalized = keyWord.toUpperCase();
            rule = normalize ? rule.replaceAll("\\b" + Pattern.quote(localized) + "\\b", normalized) : rule.replaceAll("\\b" + Pattern.quote(normalized) + "\\b", localized);
        }
        return rule;
    }

    public void delete() {
        if (this.mFile != null) {
            this.mFile.delete();
        }
    }

    private void createTokenTree(boolean add) throws ParserException {
        mTokenList = UserFilter.createTokenList(this.mRule);
        curTokenInx = -1;
        mCurToken = UserFilter.getNextToken();
        if (mCurToken != null) {
            Node rule = UserFilter.rule(add);
            if (mCurToken != null) {
                // empty if block
            }
            this.mRoot = rule;
        }
    }

    private static Token getNextToken() throws ParserException {
        if (mTokenList.length > ++curTokenInx) {
            return mTokenList[curTokenInx];
        }
        return null;
    }

    public static void testTokenTree(String rule) throws ParserException {
        UserFilter.testTokenTree(rule, true);
    }

    public static void testTokenTree(String rule, boolean add) throws ParserException {
        mTokenList = UserFilter.createTokenList(rule);
        curTokenInx = -1;
        mCurToken = UserFilter.getNextToken();
        if (mCurToken != null) {
            UserFilter.rule(add);
            if (mCurToken != null) {
                throw new ParserException(UserFilter.mCurToken.pos, mLocalizer.msg("EOLExpected", "end of rule expected"));
            }
        }
    }

    private static Token[] createTokenList(String rule) {
        mRuleLine = rule.toCharArray();
        mCurInx = 0;
        Token curToken = null;
        ArrayList<Token> list = new ArrayList<Token>();
        do {
            if ((curToken = UserFilter.readNextToken()) == null) continue;
            list.add(curToken);
        } while (curToken != null);
        Token[] result = new Token[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Token)list.get(i);
        }
        return result;
    }

    private static Token readNextToken() {
        UserFilter.ignoreSpaces();
        int i = mCurInx;
        if (mCurInx == mRuleLine.length) {
            return null;
        }
        Token result = new Token();
        result.pos = mCurInx;
        if (mRuleLine[mCurInx] == '(') {
            result.type = 4;
            ++mCurInx;
        } else if (mRuleLine[mCurInx] == ')') {
            result.type = 5;
            ++mCurInx;
        } else {
            UserFilter.readString();
            result.value = new String(mRuleLine, i, mCurInx - i);
            result.type = "or".equalsIgnoreCase(result.value) || "oder".equalsIgnoreCase(result.value) || mLocalizer.msg("or", "or").equalsIgnoreCase(result.value) ? 0 : ("and".equalsIgnoreCase(result.value) || "und".equalsIgnoreCase(result.value) || mLocalizer.msg("and", "and").equalsIgnoreCase(result.value) ? 1 : ("not".equalsIgnoreCase(result.value) || "nicht".equalsIgnoreCase(result.value) || mLocalizer.msg("not", "not").equalsIgnoreCase(result.value) ? 2 : 3));
        }
        return result;
    }

    private static void readString() {
        while (mCurInx < mRuleLine.length && !Character.isWhitespace(mRuleLine[mCurInx]) && mRuleLine[mCurInx] != '(' && mRuleLine[mCurInx] != ')') {
            ++mCurInx;
        }
    }

    private static void ignoreSpaces() {
        while (mCurInx < mRuleLine.length && Character.isWhitespace(mRuleLine[mCurInx])) {
            ++mCurInx;
        }
    }

    private static void expectToken(int[] expectedTypes, Token foundToken) throws ParserException {
        if (foundToken == null) {
            throw new ParserException(mLocalizer.msg("unexpectedEOL", "unexpected end of rule"));
        }
        for (int expectedType : expectedTypes) {
            if (expectedType != foundToken.type) continue;
            return;
        }
        StringBuilder msg = new StringBuilder();
        for (int i = 0; i < expectedTypes.length; ++i) {
            if (expectedTypes[i] == 1) {
                msg.append("'").append(mLocalizer.msg("and", "and")).append("'");
            } else if (expectedTypes[i] == 3) {
                msg.append(mLocalizer.msg("componentName", "component name"));
            } else if (expectedTypes[i] == 4) {
                msg.append("'('");
            } else if (expectedTypes[i] == 5) {
                msg.append("')'");
            } else if (expectedTypes[i] == 2) {
                msg.append("'").append(mLocalizer.msg("not", "not")).append("'");
            } else if (expectedTypes[i] == 0) {
                msg.append("'").append(mLocalizer.msg("or", "or")).append("'");
            }
            if (i >= expectedTypes.length - 1) continue;
            msg.append(", ");
        }
        msg.append(mLocalizer.msg("expected", "expected"));
        throw new ParserException(foundToken.pos, msg.toString());
    }

    private static Node rule(boolean add) throws ParserException {
        OrNode result = new OrNode();
        result.addNode(UserFilter.condTerm(add));
        while (mCurToken != null && UserFilter.mCurToken.type == 0) {
            mCurToken = UserFilter.getNextToken();
            if (mCurToken == null) {
                // empty if block
            }
            result.addNode(UserFilter.condTerm(add));
        }
        return ((Node)result).optimize();
    }

    private static Node condTerm(boolean add) throws ParserException {
        AndNode result = new AndNode();
        result.addNode(UserFilter.condFact(add));
        while (mCurToken != null && UserFilter.mCurToken.type == 1) {
            mCurToken = UserFilter.getNextToken();
            if (mCurToken == null) {
                // empty if block
            }
            result.addNode(UserFilter.condFact(add));
        }
        return result;
    }

    private static Node condFact(boolean add) throws ParserException {
        Node result;
        NotNode notNode = null;
        if (mCurToken == null) {
            throw new ParserException(mLocalizer.msg("unexpectedEOL", "unexpected end of rule"));
        }
        if (UserFilter.mCurToken.type == 2) {
            notNode = new NotNode();
            mCurToken = UserFilter.getNextToken();
            if (mCurToken == null) {
                throw new ParserException(mLocalizer.msg("unexpectedEOL", "unexpected end of rule"));
            }
        }
        if (UserFilter.mCurToken.type == 4) {
            mCurToken = UserFilter.getNextToken();
            result = UserFilter.rule(add);
            UserFilter.expectToken(new int[]{5}, mCurToken);
            mCurToken = UserFilter.getNextToken();
        } else {
            result = UserFilter.item(add);
            mCurToken = UserFilter.getNextToken();
        }
        if (notNode != null) {
            ((Node)notNode).addNode(result);
            return notNode;
        }
        return result;
    }

    private static Node item(boolean add) throws ParserException {
        Token tk = mCurToken;
        if (tk.type != 3) {
            throw new ParserException(mLocalizer.msg("compExpected", "component name expected."));
        }
        FilterComponent component = FilterComponentList.getInstance().getFilterComponentByName(tk.value);
        ItemNode result = null;
        if (component != null) {
            result = new ItemNode(component);
        } else {
            FilterComponent[] filterComponents;
            for (FilterComponent filterComponent : filterComponents = FilterComponentList.getInstance().getAvailableFilterComponents()) {
                if (!(filterComponent instanceof SingleChannelFilterComponent) || !((SingleChannelFilterComponent)filterComponent).isNameToUpdate() || !tk.value.equals(((SingleChannelFilterComponent)filterComponent).getLoadName())) continue;
                result = new ItemNode(filterComponent);
                break;
            }
        }
        if (result == null) {
            AcceptNoneFilterComponent acceptNone = new AcceptNoneFilterComponent(tk.value, "");
            if (add) {
                FilterComponentList.getInstance().add(acceptNone);
            }
            result = new ItemNode(acceptNone);
        }
        return result;
    }

    @Override
    public boolean accept(Program prog) {
        if (this.mRoot == null) {
            return false;
        }
        return this.mRoot.accept(prog);
    }

    public void setName(String name) {
        if (!name.equals(this.mName) && this.mFile != null) {
            this.mFile.delete();
        }
        this.mName = name;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String toString() {
        return this.mName;
    }

    public void setRule(String rule) throws ParserException {
        this.mRule = rule;
        if (this.mRule.isBlank()) {
            this.mRoot = null;
        } else {
            this.createTokenTree(true);
        }
    }

    public String getRule() {
        return this.mRule;
    }

    public boolean containsRuleComponent(String comp) {
        if (this.mRoot == null) {
            return false;
        }
        return this.mRoot.containsRuleComponent(comp);
    }

    public boolean containsRuleComponent(Class<? extends Excludable> comp) {
        if (this.mRoot == null) {
            return false;
        }
        return this.mRoot.containsRuleComponent(comp);
    }

    public boolean isBrokenCompletely() {
        boolean result = true;
        if (this.mRoot != null) {
            result = this.mRoot.isBrokenCompletely();
        }
        return result;
    }

    public boolean isBrokenPartially() {
        boolean result = false;
        if (this.mRoot != null) {
            result = this.mRoot.isBrokenPartially();
        }
        return result;
    }

    public String getViewString() {
        String result = this.mName;
        if (this.isBrokenCompletely()) {
            result = UserFilter.getLabelForBrokenCompletely(result);
        } else if (this.isBrokenPartially()) {
            result = UserFilter.getLabelForBrokenPartially(result);
        }
        return result;
    }

    public void updateSingleChannelFilters(Channel[] channels) {
        if (this.mRoot != null) {
            this.mRoot.updateChannelFilters(channels);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof ProgramFilter) {
            return this.getClass().equals(o.getClass()) && this.getName().equals(((ProgramFilter)o).getName());
        }
        return false;
    }

    public boolean acceptableForFilterFavorite() {
        boolean acceptable = false;
        Token[] tokens = UserFilter.createTokenList(this.mRule);
        if (tokens != null) {
            acceptable = true;
            for (Token token : tokens) {
                String[] blocked;
                FilterComponent component;
                if (token.type != 3 || (component = FilterComponentList.getInstance().getFilterComponentByName(token.value)) == null) continue;
                boolean bl = acceptable = !(component instanceof FavoritesFilterComponent) && !(component instanceof FilterComponentNewFavoritePrograms);
                if (!acceptable) continue;
                for (String test : blocked = Settings.Other.FAVORITE_BLOCKED_FILTER_COMPONENTS.getStringArray()) {
                    String name = component.getClass().getCanonicalName();
                    if (!name.equals(test)) continue;
                    acceptable = false;
                    break;
                }
                if (!acceptable) break;
            }
        }
        return acceptable;
    }
}

