/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.tvdataservice;

import devplugin.AbstractTvDataService;
import devplugin.ActionMenu;
import devplugin.Channel;
import devplugin.ChannelGroup;
import devplugin.Date;
import devplugin.PluginInfo;
import devplugin.Program;
import devplugin.ProgressMonitor;
import devplugin.Version;
import java.awt.Frame;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.logging.Logger;
import tvbrowser.core.tvdataservice.AbstractTvDataServiceProxy;
import tvdataservice.SettingsPanel;
import tvdataservice.TvDataUpdateManager;
import util.exc.TvBrowserException;

public class DefaultTvDataServiceProxy
extends AbstractTvDataServiceProxy {
    private static final Logger mLog = Logger.getLogger(DefaultTvDataServiceProxy.class.getName());
    private AbstractTvDataService mTvDataService;

    public DefaultTvDataServiceProxy(AbstractTvDataService service) {
        this.mTvDataService = service;
    }

    private void logError(Throwable e, String action) {
        StringBuilder errorMsg = new StringBuilder("The TV data service '");
        errorMsg.append(this.mTvDataService.getInfo().getName());
        errorMsg.append("' has caused an error during ");
        errorMsg.append(action).append(": ");
        errorMsg.append(e.getLocalizedMessage()).append("\n");
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        e.printStackTrace(printWriter);
        printWriter.flush();
        stringWriter.flush();
        errorMsg.append(stringWriter.toString());
        mLog.severe(errorMsg.toString());
    }

    @Override
    public void setWorkingDirectory(File dataDir) {
        try {
            this.mTvDataService.setWorkingDirectory(dataDir);
        }
        catch (Throwable e) {
            this.logError(e, "set working directory");
        }
    }

    @Override
    public ChannelGroup[] getAvailableGroups() {
        try {
            return this.mTvDataService.getAvailableGroups();
        }
        catch (Throwable t) {
            this.logError(t, "get available groups");
            return null;
        }
    }

    @Override
    public void updateTvData(TvDataUpdateManager updateManager, Channel[] channelArr, Date startDate, int dateCount, ProgressMonitor monitor) throws TvBrowserException {
        try {
            this.mTvDataService.updateTvData(updateManager, channelArr, startDate, dateCount, monitor);
        }
        catch (Throwable t) {
            this.logError(t, "update TV data");
        }
    }

    @Override
    public void loadSettings(Properties settings) {
        try {
            this.mTvDataService.loadSettings(settings);
        }
        catch (Throwable t) {
            this.logError(t, "load settings");
        }
    }

    @Override
    public Properties storeSettings() {
        Properties result = null;
        if (this.mTvDataService.hasToSaveSettings()) {
            try {
                result = this.mTvDataService.storeSettings();
            }
            catch (Throwable e) {
                this.logError(e, "store settings");
            }
        }
        return result;
    }

    @Override
    public boolean hasSettingsPanel() {
        try {
            return this.mTvDataService.hasSettingsPanel();
        }
        catch (Throwable t) {
            this.logError(t, "has settings panel");
            return false;
        }
    }

    @Override
    public SettingsPanel getSettingsPanel() {
        try {
            return this.mTvDataService.getSettingsPanel();
        }
        catch (Throwable t) {
            this.logError(t, "get settings panel");
            return null;
        }
    }

    @Override
    public Channel[] getAvailableChannels(ChannelGroup group) {
        try {
            return this.mTvDataService.getAvailableChannels(group);
        }
        catch (Throwable t) {
            this.logError(t, "get available channels");
            return null;
        }
    }

    @Override
    public Channel[] checkForAvailableChannels(ChannelGroup group, ProgressMonitor monitor) throws TvBrowserException {
        try {
            return this.mTvDataService.checkForAvailableChannels(group, monitor);
        }
        catch (Throwable t) {
            this.logError(t, "check available channels");
            return null;
        }
    }

    @Override
    public ChannelGroup[] checkForAvailableGroups(ProgressMonitor monitor) throws TvBrowserException {
        try {
            return this.mTvDataService.checkForAvailableChannelGroups(monitor);
        }
        catch (Throwable t) {
            this.logError(t, "check available groups");
            return null;
        }
    }

    @Override
    public boolean supportsDynamicChannelList() {
        try {
            return this.mTvDataService.supportsDynamicChannelList();
        }
        catch (Throwable t) {
            this.logError(t, "supports dynamic channels");
            return false;
        }
    }

    @Override
    public boolean supportsDynamicChannelGroups() {
        try {
            return this.mTvDataService.supportsDynamicChannelGroups();
        }
        catch (Throwable t) {
            this.logError(t, "supports dynamic groups");
            return false;
        }
    }

    @Override
    public PluginInfo getInfo() {
        try {
            return this.mTvDataService.getInfo();
        }
        catch (Throwable t) {
            this.logError(t, "get plugin info");
            return null;
        }
    }

    @Override
    public String getId() {
        return this.mTvDataService.getClass().getName();
    }

    @Override
    public final void setParent(Frame parent) {
        try {
            this.mTvDataService.setParent(parent);
        }
        catch (Throwable t) {
            this.logError(t, "set parent frame");
        }
    }

    @Override
    public final Frame getParentFrame() {
        try {
            return this.mTvDataService.getParentFrame();
        }
        catch (Throwable t) {
            this.logError(t, "get parent frame");
            return null;
        }
    }

    @Override
    public void handleTvBrowserStartFinished() {
        try {
            this.mTvDataService.handleTvBrowserStartFinished();
        }
        catch (Throwable t) {
            this.logError(t, "handle start finished");
        }
    }

    @Override
    public boolean supportsAutoUpdate() {
        try {
            return this.mTvDataService.supportsAutoUpdate();
        }
        catch (Throwable t) {
            this.logError(t, "supports auto update");
            return false;
        }
    }

    @Override
    public ActionMenu getButtonAction() {
        return this.mTvDataService.getButtonAction();
    }

    @Override
    public String getButtonActionDescription() {
        return this.mTvDataService.getButtonActionDescription();
    }

    @Override
    public ActionMenu getContextMenuActions(Program program) {
        return this.mTvDataService.getContextMenuActions(program);
    }

    @Override
    public String getDataServicePackageName() {
        return this.mTvDataService.getClass().getPackage().getName();
    }

    @Override
    public String getPluginCategory() {
        return this.mTvDataService.getPluginCategory();
    }

    @Override
    public SettingsPanel getAuthenticationPanel() {
        return this.mTvDataService.getAuthenticationPanel();
    }

    @Override
    public void receiveProtocolMessage(String[] values) {
        this.mTvDataService.receiveProtocolMessage(values);
    }

    @Override
    public void handleTvBrowserVersionUpdate(Version previousVersion) {
        this.mTvDataService.handleTvBrowserVersionUpdate(previousVersion);
    }

    @Override
    public boolean hasToSaveSettings() {
        return this.mTvDataService.hasToSaveSettings();
    }
}

