/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.core;

import devplugin.Channel;
import devplugin.Program;
import devplugin.ProgramFieldType;
import devplugin.ProgramFilter;
import devplugin.ProgramInfoHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import tvbrowser.core.filters.FilterManagerImpl;
import tvbrowser.extras.common.ChannelItem;
import tvbrowser.extras.common.LimitationConfiguration;
import tvbrowser.extras.favoritesplugin.core.FavoriteFilter;
import util.i18n.Localizer;
import util.ui.WrapperFilter;

public class Exclusion
implements Comparable<Exclusion> {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(Exclusion.class);
    public static final int TYPE_DURATION_NONE = 0;
    public static final int TYPE_DURATION_TOO_SHORT = 1;
    public static final int TYPE_DURATION_TOO_LONG = 2;
    public static final int DAYLIMIT_DAILY = -1;
    private static final int DAYLIMIT_WEEKEND = -2;
    private static final int DAYLIMIT_SUNDAY = 1;
    private static final int DAYLIMIT_SATURDAY = 7;
    private ChannelItem mChannel;
    private StringExclusion mTopic;
    private StringExclusion mTitle;
    private StringExclusion mEpisodeTitle;
    private int mTimeFrom;
    private int mTimeTo;
    private int mDayOfWeek;
    private ProgramFilter mFilter;
    private String mFilterName;
    private int mCategory;
    private int mDuration;
    private int mTypeDuration;
    private ProgramFieldExclusion mProgramFieldExclusion;

    public Exclusion(String title, String topic, Channel channel, int timeFrom, int timeTo, int dayOfWeek, String filterName, String episodeTitle, int category, ProgramFieldExclusion programFieldExclusion, int typeDuration, int duration) {
        this.mTitle = StringExclusion.create(title);
        this.mTopic = StringExclusion.create(topic);
        this.mChannel = new ChannelItem(channel);
        this.mTimeFrom = timeFrom;
        this.mTimeTo = timeTo;
        this.mDayOfWeek = dayOfWeek;
        this.mFilterName = filterName;
        this.mEpisodeTitle = StringExclusion.create(episodeTitle);
        this.mCategory = category;
        this.mProgramFieldExclusion = programFieldExclusion;
        this.mTypeDuration = typeDuration;
        this.mDuration = duration;
    }

    public Exclusion(ObjectInputStream in) throws ClassNotFoundException, IOException {
        boolean hasEpisodeTitle;
        boolean hasTopic;
        boolean hasTitle;
        int version = in.readInt();
        boolean hasChannel = in.readBoolean();
        if (hasChannel) {
            if (version < 3) {
                String channelServiceClassName = (String)in.readObject();
                String channelGroupId = null;
                if (version >= 2) {
                    channelGroupId = (String)in.readObject();
                }
                String channelId = (String)in.readObject();
                Channel ch = Channel.getChannel(channelServiceClassName, channelGroupId, null, channelId);
                this.mChannel = new ChannelItem(ch);
            } else if (version < 5) {
                Channel ch = Channel.readData(in, true);
                this.mChannel = new ChannelItem(ch);
            } else {
                this.mChannel = new ChannelItem(in, 3);
            }
        }
        if (hasTitle = in.readBoolean()) {
            this.mTitle = new StringExclusion((String)in.readObject());
        }
        if (hasTopic = in.readBoolean()) {
            this.mTopic = new StringExclusion((String)in.readObject());
        }
        if (version > 3 && in.readBoolean()) {
            this.mFilterName = (String)in.readObject();
        }
        this.mTimeFrom = in.readInt();
        this.mTimeTo = in.readInt();
        this.mDayOfWeek = in.readInt();
        if (this.mChannel == null) {
            this.mChannel = new ChannelItem(null);
        }
        if (version > 5 && (hasEpisodeTitle = in.readBoolean())) {
            this.mEpisodeTitle = new StringExclusion(in.readUTF());
        }
        if (version > 6) {
            this.mCategory = in.readInt();
        }
        this.mProgramFieldExclusion = version > 7 ? (in.readBoolean() ? new ProgramFieldExclusion(in, version) : null) : null;
        if (version > 8) {
            this.mTypeDuration = in.readInt();
            this.mDuration = in.readInt();
        } else {
            this.mTypeDuration = 0;
            this.mDuration = 0;
        }
    }

    public void writeData(ObjectOutputStream out) throws IOException {
        out.writeInt(9);
        out.writeBoolean(this.mChannel != null);
        if (this.mChannel != null) {
            this.mChannel.saveItem(out);
        }
        out.writeBoolean(this.mTitle != null);
        if (this.mTitle != null) {
            out.writeObject(this.mTitle.mText);
        }
        out.writeBoolean(this.mTopic != null);
        if (this.mTopic != null) {
            out.writeObject(this.mTopic.mText);
        }
        out.writeBoolean(this.mFilterName != null);
        if (this.mFilterName != null) {
            out.writeObject(this.mFilterName);
        }
        out.writeInt(this.mTimeFrom);
        out.writeInt(this.mTimeTo);
        out.writeInt(this.mDayOfWeek);
        out.writeBoolean(this.mEpisodeTitle != null);
        if (this.mEpisodeTitle != null) {
            out.writeUTF(this.mEpisodeTitle.mText);
        }
        out.writeInt(this.mCategory);
        out.writeBoolean(this.mProgramFieldExclusion != null);
        if (this.mProgramFieldExclusion != null) {
            this.mProgramFieldExclusion.writeData(out);
        }
        out.writeInt(this.mTypeDuration);
        out.writeInt(this.mDuration);
    }

    public int getTypeDuration() {
        return this.mTypeDuration;
    }

    public int getDuration() {
        return this.mDuration;
    }

    public String getTitle() {
        return Exclusion.getValue(this.mTitle);
    }

    public String getTopic() {
        return Exclusion.getValue(this.mTopic);
    }

    public String getEpisodeTitle() {
        return Exclusion.getValue(this.mEpisodeTitle);
    }

    private static String getValue(StringExclusion exclusion) {
        return exclusion != null ? exclusion.mText : null;
    }

    public ProgramFilter getFilter() {
        if (this.mFilter == null) {
            ProgramFilter[] filters;
            for (ProgramFilter filter : filters = FilterManagerImpl.getInstance().getAvailableFilters()) {
                if (!filter.getName().equals(this.mFilterName) || filter instanceof FavoriteFilter) continue;
                this.mFilter = filter;
                break;
            }
        }
        return this.mFilter;
    }

    public void setFilter(ProgramFilter filter) {
        this.mFilter = filter;
        this.mFilterName = filter.getName();
    }

    public Channel getChannel() {
        return this.mChannel.getChannel();
    }

    public int getTimeLowerBound() {
        return this.mTimeFrom;
    }

    public int getTimeUpperBound() {
        return this.mTimeTo;
    }

    public int getDayOfWeek() {
        return this.mDayOfWeek;
    }

    public int getCategory() {
        return this.mCategory;
    }

    public ProgramFieldExclusion getProgramFieldExclusion() {
        return this.mProgramFieldExclusion;
    }

    public boolean isProgramExcluded(Program prog) {
        ProgramFilter filter;
        boolean channelExcl = false;
        boolean titleExcl = false;
        boolean topicExcl = false;
        boolean timeExcl = false;
        boolean dayExcl = false;
        boolean filterExclusion = false;
        boolean episodeTitleExcl = false;
        boolean categoryExcl = false;
        boolean programFieldExcl = false;
        boolean durationExcl = false;
        if (this.isInvalid()) {
            return false;
        }
        if (this.mChannel != null && !this.mChannel.isNullChannel()) {
            Channel ch = prog.getChannel();
            if (ch.equals(this.mChannel.getChannel())) {
                channelExcl = true;
            }
        } else {
            channelExcl = true;
        }
        if (this.mTitle != null) {
            if (this.mTitle.isExcludedFrom(prog.getTitle(), true, true)) {
                titleExcl = true;
            }
        } else {
            titleExcl = true;
        }
        if (this.mTopic != null) {
            Iterator<ProgramFieldType> types = ProgramFieldType.getTypeIterator();
            StringBuilder value = new StringBuilder();
            while (types.hasNext()) {
                ProgramFieldType type = types.next();
                if (type.getFormat() != 3 || !prog.hasFieldValue(type)) continue;
                value.append(prog.getTextField(type)).append(' ');
            }
            if (value.toString() != null && this.mTopic.isExcludedFrom(value.toString(), false, true)) {
                topicExcl = true;
            }
        } else {
            topicExcl = true;
        }
        filterExclusion = this.mFilterName != null ? ((filter = this.getFilter()) != null ? filter.accept(prog) : true) : true;
        int timeFromParsed = this.mTimeFrom;
        int progTime = prog.getHours() * 60 + prog.getMinutes();
        if (this.mTimeFrom > this.mTimeTo) {
            timeFromParsed -= 1440;
            if (progTime > this.mTimeTo) {
                progTime -= 1440;
            }
        }
        if (this.mTimeFrom >= 0 && this.mTimeTo >= 0) {
            if (progTime >= timeFromParsed && progTime <= this.mTimeTo) {
                timeExcl = true;
            }
        } else if (this.mTimeFrom >= 0) {
            if (progTime >= timeFromParsed) {
                timeExcl = true;
            }
        } else if (this.mTimeTo >= 0) {
            if (progTime <= this.mTimeTo) {
                timeExcl = true;
            }
        } else {
            timeExcl = true;
        }
        if (this.mDayOfWeek != -1) {
            int dayOfWeek = prog.getDate().getCalendar().get(7);
            if (this.mDayOfWeek >= 1 && this.mDayOfWeek <= 7) {
                if (dayOfWeek == this.mDayOfWeek) {
                    dayExcl = true;
                }
            } else {
                dayExcl = this.mDayOfWeek == -2 ? dayOfWeek == 1 || dayOfWeek == 7 : dayOfWeek > 1 && dayOfWeek < 7;
            }
        } else {
            dayExcl = true;
        }
        if (this.mEpisodeTitle != null) {
            if (prog.getTextField(ProgramFieldType.EPISODE_TYPE) != null && this.mEpisodeTitle.isExcludedFrom(prog.getTextField(ProgramFieldType.EPISODE_TYPE), true, true)) {
                episodeTitleExcl = true;
            }
        } else {
            episodeTitleExcl = true;
        }
        categoryExcl = this.mCategory != 0 ? ProgramInfoHelper.bitSet(prog.getInfo(), this.mCategory) : true;
        if (this.mProgramFieldExclusion != null) {
            ProgramFieldType type = this.mProgramFieldExclusion.getProgramFieldType();
            String value = null;
            switch (type.getFormat()) {
                case 4: {
                    value = prog.getIntFieldAsString(type);
                    break;
                }
                case 5: {
                    value = prog.getTimeFieldAsString(type);
                    break;
                }
                case 3: {
                    value = prog.getTextField(type);
                }
            }
            programFieldExcl = value != null ? this.mProgramFieldExclusion.isExcludedFrom(value) : true;
        } else {
            programFieldExcl = true;
        }
        if (this.mTypeDuration != 0) {
            switch (this.mTypeDuration) {
                case 1: {
                    durationExcl = prog.getLength() <= this.mDuration;
                    break;
                }
                case 2: {
                    durationExcl = prog.getLength() >= this.mDuration;
                }
            }
        } else {
            durationExcl = true;
        }
        return channelExcl && titleExcl && topicExcl && timeExcl && dayExcl && filterExclusion && episodeTitleExcl && categoryExcl && programFieldExcl && durationExcl;
    }

    public boolean isInvalid() {
        return this.mTitle == null && this.mTopic == null && this.mEpisodeTitle == null && !this.mChannel.isAvailableOrNullChannel() && this.mFilterName == null && this.mTimeFrom == -1 && this.mTimeTo == -1 && this.mDayOfWeek == -1 && this.mProgramFieldExclusion == null || !this.mChannel.isAvailableOrNullChannel();
    }

    @Override
    public int compareTo(Exclusion other) {
        return this.toString().compareToIgnoreCase(other.toString());
    }

    public String toString() {
        StringBuilder textValue = new StringBuilder("<html>");
        ProgramFilter filter = this.getFilter();
        String timeMsg = Exclusion.createTimeMessage(this.getTimeLowerBound(), this.getTimeUpperBound(), this.getDayOfWeek());
        if (this.mTitle != null) {
            Exclusion.append(textValue, LOCALIZER.msg("exclude.title", "Exclude all programs with title '"), this.mTitle.toString(), "'", "b");
        }
        if (this.mTitle != null && this.mTopic != null) {
            Exclusion.append(textValue, LOCALIZER.msg("exclude.appendTopic", "with topic '"), this.mTopic.toString(), "'", "b");
        } else if (this.mTopic != null) {
            Exclusion.append(textValue, LOCALIZER.msg("exclude.topic", "Exclude all programs with topic '"), this.mTopic.toString(), "'", "b");
        }
        if (this.mEpisodeTitle != null && this.mTopic != null && this.mTitle != null) {
            Exclusion.append(textValue, LOCALIZER.msg("exclude.appendEpisodeTitle", "Exclude all programs with episode '"), this.mEpisodeTitle.toString(), "'", "b");
        } else if (this.mEpisodeTitle != null) {
            Exclusion.append(textValue, LOCALIZER.msg("exclude.episodeTitle", "Exclude all programs with topic '"), this.mEpisodeTitle.toString(), "'", "b");
        }
        if (filter != null && (this.mTitle != null || this.mTopic != null || this.mEpisodeTitle != null)) {
            Exclusion.append(textValue, LOCALIZER.msg("exclude.appendFilter", "of the filter '"), filter.getName(), "'", "b");
        } else if (filter != null) {
            Exclusion.append(textValue, LOCALIZER.msg("exclude.filter", "Exclude all programs of the filter '"), new WrapperFilter(filter).toString().replaceAll("</*html>", ""), "'", "b");
        }
        if (this.mChannel.getChannel() != null && (this.mTitle != null || this.mTopic != null || this.mEpisodeTitle != null || filter != null)) {
            Exclusion.append(textValue, LOCALIZER.msg("exclude.appendChannel", "on channel '"), this.mChannel.getChannel().getName(), "'", "b");
        } else if (this.mChannel.getChannel() != null) {
            Exclusion.append(textValue, LOCALIZER.msg("exclude.channel", "Exclude all programs on channel '"), this.mChannel.getChannel().getName(), "'", "b");
        }
        if (timeMsg != null && (this.mTitle != null || this.mTopic != null || this.mEpisodeTitle != null || filter != null || this.mChannel.getChannel() != null)) {
            textValue.append(" ").append(timeMsg);
        } else if (timeMsg != null) {
            textValue.append(LOCALIZER.msg("exclude.time", "Exclude all programs ")).append(timeMsg);
        }
        if (this.mCategory != 0) {
            if (timeMsg != null || this.mTitle != null || this.mTopic != null || this.mEpisodeTitle != null || filter != null || this.mChannel.getChannel() != null) {
                Exclusion.append(textValue, LOCALIZER.msg("exclude.appendCategory", "with category '"), ProgramInfoHelper.getMessageForBit(this.mCategory), "'", "b");
            } else {
                Exclusion.append(textValue, LOCALIZER.msg("exclude.category", "Exclude all programs with category '"), ProgramInfoHelper.getMessageForBit(this.mCategory), "'", "b");
            }
        }
        if (this.mTypeDuration != 0) {
            if (timeMsg != null || this.mTitle != null || this.mTopic != null || this.mEpisodeTitle != null || filter != null || this.mChannel.getChannel() != null || this.mCategory != 0) {
                textValue.append(" ").append(LOCALIZER.msg("exclude.append", "with '"));
            } else {
                textValue.append(LOCALIZER.msg("exclude.single", "Exclude all programs with '"));
            }
            if (this.mTypeDuration == 1) {
                textValue.append("<b>").append(LOCALIZER.msg("exclude.duration.tooShort", "duration shorter than {0} minutes'", this.mDuration + 1)).append("</b>");
            } else if (this.mTypeDuration == 2) {
                textValue.append("<b>").append(LOCALIZER.msg("exclude.duration.tooLong", "duration longer than {0} minutes'", this.mDuration - 1)).append("</b>");
            }
        }
        if (this.mProgramFieldExclusion != null) {
            ProgramFieldType exclusion = this.mProgramFieldExclusion.getProgramFieldType();
            if (timeMsg != null || this.mTitle != null || this.mTopic != null || this.mEpisodeTitle != null || filter != null || this.mChannel.getChannel() != null || this.mCategory != 0 || this.mTypeDuration != 0) {
                textValue.append(" ").append(LOCALIZER.msg("exclude.append", "with '"));
            } else {
                textValue.append(LOCALIZER.msg("exclude.single", "Exclude all programs with '"));
            }
            textValue.append("<b>").append(exclusion.getLocalizedName()).append("'='").append(this.mProgramFieldExclusion).append("</b>'");
        }
        if (textValue.length() < 7) {
            textValue.append(LOCALIZER.msg("exclude.invalid", "&lt;invalid&gt;"));
        } else {
            if (LOCALIZER.msg("exclude.appendix", ".").length() > 1) {
                textValue.append(" ");
            }
            textValue.append(LOCALIZER.msg("exclude.appendix", "."));
        }
        textValue.append("</html>");
        return textValue.toString();
    }

    private static final StringBuilder append(StringBuilder b, String prefix, String text, String suffix, String htmlTag) {
        if (b.length() > 0) {
            b.append(" ");
        }
        if (prefix != null) {
            b.append(prefix);
        }
        if (htmlTag != null) {
            b.append("<").append(htmlTag).append(">");
        }
        b.append(text);
        if (htmlTag != null) {
            b.append("</").append(htmlTag).append(">");
        }
        if (suffix != null) {
            b.append(suffix);
        }
        return b;
    }

    private static String createTimeMessage(int lowBnd, int upBnd, int dayOfWeek) {
        int mLow = lowBnd % 60;
        int hLow = lowBnd / 60;
        int mUp = upBnd % 60;
        int hUp = upBnd / 60;
        String lowTime = "<b>" + hLow + ":" + (mLow < 10 ? "0" : "") + mLow + "</b>";
        String upTime = "<b>" + hUp + ":" + (mUp < 10 ? "0" : "") + mUp + "</b>";
        if (dayOfWeek != -1) {
            String dayStr = "<b>" + LimitationConfiguration.getDayString(dayOfWeek) + "</b>";
            if (lowBnd >= 0 && upBnd >= 0) {
                return LOCALIZER.msg("datetimestring.between", "on {0} between {1} and {2}", dayStr, lowTime, upTime);
            }
            if (lowBnd >= 0) {
                return LOCALIZER.msg("datetimestring.after", "on {0} after {1}", dayStr, lowTime);
            }
            if (upBnd >= 0) {
                return LOCALIZER.msg("datetimestring.before", "on {0} after {1}", dayStr, upTime);
            }
            return LOCALIZER.msg("datetimestring.on", "on {0}", dayStr);
        }
        if (lowBnd >= 0 && upBnd >= 0) {
            return LOCALIZER.msg("timestring.between", "on {0} between {1} and {2}", lowTime, upTime);
        }
        if (lowBnd >= 0) {
            return LOCALIZER.msg("timestring.after", "on {0} after {1}", lowTime);
        }
        if (upBnd >= 0) {
            return LOCALIZER.msg("timestring.before", "on {0} after {1}", upTime);
        }
        return null;
    }

    private static final class StringExclusion {
        private String mText;

        public static StringExclusion create(String text) {
            return text != null ? new StringExclusion(text) : null;
        }

        private StringExclusion(String text) {
            this.mText = text.replaceAll("\\s+", " ").replaceAll(" +", " ").replaceAll("[\uff0d\ufe63\u2010\u2011\u2012\u2013\u2014\u2015]", "-");
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            String[] parts = this.mText.split(";;");
            for (int i = 0; i < Math.min(parts.length, 3); ++i) {
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append(parts[i]);
            }
            if (parts.length > 3) {
                b.append(", ").append(LOCALIZER.msg("others", "and more"));
            }
            return b.toString();
        }

        public boolean isExcludedFrom(String value, boolean exactMatch, boolean ignoreCase) {
            String[] parts;
            value = value.replaceAll("\\s+", " ").replaceAll(" +", " ").replaceAll("[\uff0d\ufe63\u2010\u2011\u2012\u2013\u2014\u2015]", "-");
            for (String part : parts = this.mText.split(";;")) {
                if (!(exactMatch && !ignoreCase && value.equals(part) || exactMatch && ignoreCase && value.equalsIgnoreCase(part)) && (exactMatch || (!ignoreCase || !value.toLowerCase().contains(part.toLowerCase())) && (ignoreCase || !value.contains(part)))) continue;
                return true;
            }
            return false;
        }
    }

    public static final class ProgramFieldExclusion {
        private int mProgramField;
        private StringExclusion mProgramFieldText;

        public ProgramFieldExclusion(int programField, String programFieldText) {
            this.mProgramField = programField;
            this.mProgramFieldText = StringExclusion.create(programFieldText);
        }

        private ProgramFieldExclusion(ObjectInputStream in, int version) throws IOException {
            this.mProgramField = in.readInt();
            this.mProgramFieldText = new StringExclusion(in.readUTF());
        }

        public int getProgramFieldTypeId() {
            return this.mProgramField;
        }

        public ProgramFieldType getProgramFieldType() {
            return ProgramFieldType.getTypeForId(this.mProgramField);
        }

        public String getProgramFieldText() {
            return Exclusion.getValue(this.mProgramFieldText);
        }

        public String toString() {
            return this.mProgramFieldText.toString();
        }

        public void setmProgramField(int programField) {
            this.mProgramField = programField;
        }

        public void setmProgramFieldText(String programFieldText) {
            this.mProgramFieldText.mText = programFieldText;
        }

        private void writeData(ObjectOutputStream out) throws IOException {
            out.writeInt(this.mProgramField);
            out.writeUTF(this.mProgramFieldText.mText);
        }

        public boolean isExcludedFrom(String text) {
            return this.mProgramFieldText.isExcludedFrom(text, true, true);
        }
    }
}

