/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.mainframe.actions;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import tvbrowser.core.TvDataUpdater;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.mainframe.actions.TVBrowserAction;
import tvbrowser.ui.mainframe.actions.TVBrowserUpdateAction;
import util.misc.OperatingSystem;
import util.ui.TVBrowserIcons;

public final class TVBrowserActions {
    private static ArrayList<TVBrowserAction> mAllActions = new ArrayList();
    public static final TVBrowserAction showMenu = new TVBrowserAction("showMenu", TVBrowserIcons.showMenu(16), TVBrowserIcons.showMenu(22), 118, 0, 0){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.getInstance().toggleShowMenuBar();
        }
    };
    public static final TVBrowserAction fontSizeLarger = new TVBrowserAction("fontSizeLarger", TVBrowserIcons.zoomIn(16), TVBrowserIcons.zoomIn(22), 521, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), 0){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.getInstance().changeFontSize(1);
        }
    };
    public static final TVBrowserAction fontSizeLargerNumPad = new TVBrowserAction("fontSizeLargerNumPad", TVBrowserIcons.zoomIn(16), TVBrowserIcons.zoomIn(22), 107, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), 0){

        @Override
        public void actionPerformed(ActionEvent e) {
            fontSizeLarger.actionPerformed(e);
        }
    };
    public static final TVBrowserAction fontSizeSmaller = new TVBrowserAction("fontSizeSmaller", TVBrowserIcons.zoomOut(16), TVBrowserIcons.zoomOut(22), 45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), 0){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.getInstance().changeFontSize(-1);
        }
    };
    public static final TVBrowserAction fontSizeSmallerNumPad = new TVBrowserAction("fontSizeSmallerNumPad", TVBrowserIcons.zoomOut(16), TVBrowserIcons.zoomOut(22), 109, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), 0){

        @Override
        public void actionPerformed(ActionEvent e) {
            fontSizeSmaller.actionPerformed(e);
        }
    };
    public static final TVBrowserAction fontSizeDefault = new TVBrowserAction("fontSizeDefault", 48, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.getInstance().changeFontSize(0);
        }
    };
    public static final TVBrowserAction fontSizeDefaultNumPad = new TVBrowserAction("fontSizeDefaultNumPad", 96, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()){

        @Override
        public void actionPerformed(ActionEvent e) {
            fontSizeDefault.actionPerformed(e);
        }
    };
    public static final TVBrowserAction columnWidthLarger = new TVBrowserAction("columnWidthLarger", TVBrowserIcons.zoomIn(16), TVBrowserIcons.zoomIn(22), 521, 512, 0){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.getInstance().changeColumnWidth(1);
        }
    };
    public static final TVBrowserAction columnWidthLargerNumPad = new TVBrowserAction("columnWidthLargerNumPad", TVBrowserIcons.zoomIn(16), TVBrowserIcons.zoomIn(22), 107, 512, 0){

        @Override
        public void actionPerformed(ActionEvent e) {
            columnWidthLarger.actionPerformed(e);
        }
    };
    public static final TVBrowserAction columnWidthSmaller = new TVBrowserAction("columnWidthSmaller", TVBrowserIcons.zoomOut(16), TVBrowserIcons.zoomOut(22), 45, 512, 0){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.getInstance().changeColumnWidth(-1);
        }
    };
    public static final TVBrowserAction columnWidthSmallerNumPad = new TVBrowserAction("columnWidthSmallerNumPad", TVBrowserIcons.zoomOut(16), TVBrowserIcons.zoomOut(22), 109, 512, 0){

        @Override
        public void actionPerformed(ActionEvent e) {
            columnWidthSmaller.actionPerformed(e);
        }
    };
    public static final TVBrowserAction columnWidthDefault = new TVBrowserAction("columnWidthDefault", 48, 512){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.getInstance().changeColumnWidth(0);
        }
    };
    public static final TVBrowserAction columnWidthDefaultNumPad = new TVBrowserAction("columnWidthDefaultNumPad", 96, 512){

        @Override
        public void actionPerformed(ActionEvent e) {
            columnWidthDefault.actionPerformed(e);
        }
    };
    public static final TVBrowserUpdateAction update = new TVBrowserUpdateAction("update", TVBrowserIcons.update(16), TVBrowserIcons.update(22), 116, 0, 0){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isUpdating()) {
                TvDataUpdater.getInstance().stopDownload();
            } else {
                MainFrame.getInstance().updateTvData();
            }
        }

        @Override
        public boolean useEllipsis() {
            return true;
        }
    };
    public static final TVBrowserAction settings = new TVBrowserAction("settings", TVBrowserIcons.preferences(16), TVBrowserIcons.preferences(22), 83, 128, 0){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.getInstance().showSettingsDialog();
        }

        @Override
        public String getMenuText() {
            if (OperatingSystem.isWindows()) {
                return mLocalizer.msg(this.getKey() + ".menu.win", "&Options");
            }
            return mLocalizer.msg(this.getKey() + ".menu", "&Settings");
        }

        @Override
        public boolean useEllipsis() {
            return true;
        }
    };
    public static final TVBrowserAction filter = new TVBrowserAction("filter", TVBrowserIcons.filter(16), TVBrowserIcons.filter(22), 0, 0, 1){

        @Override
        public void actionPerformed(ActionEvent e) {
            this.showPopupMenu();
        }
    };
    public static final TVBrowserAction pluginView = new TVBrowserAction("pluginView", TVBrowserIcons.viewTree(16), TVBrowserIcons.viewTree(22), 113, 0, 1){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.getInstance().setShowPluginOverview(!MainFrame.getInstance().isShowingPluginOverview());
        }
    };
    public static final TVBrowserAction scrollToNow = new TVBrowserAction("scrollToNow", TVBrowserIcons.scrollToNow(16), TVBrowserIcons.scrollToNow(22), 120, 0, 0){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.getInstance().scrollToNow();
        }
    };
    public static final TVBrowserAction goToPreviousDay = new TVBrowserAction("goToPreviousDay", TVBrowserIcons.left(16), TVBrowserIcons.left(22), 37, 512, 0){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.getInstance().goToPreviousDay();
        }
    };
    public static final TVBrowserAction goToToday = new TVBrowserAction("goToToday", TVBrowserIcons.down(16), TVBrowserIcons.down(22), 0, 0, 0){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.getInstance().goToToday();
        }
    };
    public static final TVBrowserAction goToNextDay = new TVBrowserAction("goToNextDay", TVBrowserIcons.right(16), TVBrowserIcons.right(22), 39, 512, 0){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.getInstance().goToNextDay();
        }
    };
    public static final TVBrowserAction goToPreviousWeek = new TVBrowserAction("goToPreviousWeek", TVBrowserIcons.previousWeek(16), TVBrowserIcons.previousWeek(22), 0, 0, 0){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.getInstance().goToPreviousWeek();
        }
    };
    public static final TVBrowserAction goToNextWeek = new TVBrowserAction("goToNextWeek", TVBrowserIcons.nextWeek(16), TVBrowserIcons.nextWeek(22), 0, 0, 0){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.getInstance().goToNextWeek();
        }
    };
    public static final TVBrowserAction goToDate = new TVBrowserAction("goToDate", TVBrowserIcons.goToDate(16), TVBrowserIcons.goToDate(22), 0, 0, 0){

        @Override
        public void actionPerformed(ActionEvent e) {
            this.showPopupMenu();
        }
    };
    public static final TVBrowserAction scrollToChannel = new TVBrowserAction("scrollToChannel", TVBrowserIcons.scrollToChannel(16), TVBrowserIcons.scrollToChannel(22), 0, 0, 0){

        @Override
        public void actionPerformed(ActionEvent e) {
            this.showPopupMenu();
        }
    };
    public static final TVBrowserAction scrollToTime = new TVBrowserAction("scrollToTime", TVBrowserIcons.scrollToTime(16), TVBrowserIcons.scrollToTime(22), 0, 0, 0){

        @Override
        public void actionPerformed(ActionEvent e) {
            this.showPopupMenu();
        }
    };
    public static final TVBrowserAction fullScreen = new TVBrowserAction("fullscreen", TVBrowserIcons.fullScreen(16), TVBrowserIcons.fullScreen(22), 122, 0, 0){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.getInstance().switchFullscreenMode();
        }
    };
    public static final TVBrowserAction configureChannels = new TVBrowserAction("configureChannels", TVBrowserIcons.preferences(16), TVBrowserIcons.preferences(22), 0, 0, 0){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.getInstance().showSettingsDialog("#channels");
        }

        @Override
        public boolean useEllipsis() {
            return true;
        }
    };

    public static void register(TVBrowserAction tvBrowserAction) {
        mAllActions.add(tvBrowserAction);
    }

    public static List<TVBrowserAction> getActions() {
        return (List)mAllActions.clone();
    }
}

