/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.mainframe.toolbar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.mainframe.MenuHelpTextAdapter;
import tvbrowser.ui.mainframe.toolbar.ContextMenu;
import tvbrowser.ui.mainframe.toolbar.DefaultToolBarModel;
import tvbrowser.ui.mainframe.toolbar.ToolBar;
import util.i18n.Localizer;
import util.ui.UiUtilities;
import util.ui.persona.Persona;

public class MoreButton
extends JToggleButton
implements ActionListener {
    private JToolBar toolbar;
    private JPopupMenu mPopupMenu;
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(MoreButton.class);
    private JLabel mLabel;

    private MoreButton(final JToolBar toolbar, MainFrame mainFrame, final JLabel statusLabel) {
        this.mLabel = statusLabel;
        if (((ToolBar)toolbar).getStyle() == 3 || ((ToolBar)toolbar).getStyle() == 1) {
            this.setText(mLocalizer.msg("more", "more"));
        }
        this.setToolTipText(mLocalizer.msg("moreTooltip", "Opens a menu with the Toolbar Buttons that aren't visible"));
        if (((ToolBar)toolbar).getStyle() != 1) {
            if (((ToolBar)toolbar).useBigIcons()) {
                this.setIcon(IconLoader.getInstance().getIconFromTheme("emblems", "emblem-symbolic-link", 22));
            } else {
                this.setIcon(IconLoader.getInstance().getIconFromTheme("emblems", "emblem-symbolic-link", 16));
            }
        }
        this.toolbar = toolbar;
        this.addActionListener(this);
        this.setBorderPainted(false);
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(3);
        this.setFont(ToolBar.TEXT_FONT);
        MoreButton.addMouseAdapter(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!MoreButton.this.isSelected()) {
                    MoreButton.this.setBorderPainted(true);
                }
                if (MoreButton.this.getToolTipText() != null && MoreButton.this.getToolTipText().trim().length() > 0) {
                    statusLabel.setText(MoreButton.this.getToolTipText());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!MoreButton.this.isSelected()) {
                    MoreButton.this.setBorderPainted(false);
                }
                if (MoreButton.this.getToolTipText() != null && MoreButton.this.getToolTipText().equals(statusLabel.getText())) {
                    statusLabel.setText("");
                }
            }
        });
        this.setFocusPainted(false);
        this.setOpaque(false);
        toolbar.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MoreButton.this.setVisible(toolbar.getComponentCount() > 1 && !MoreButton.this.isVisible(toolbar.getComponent(toolbar.getComponentCount() - 1), null));
            }
        });
        mainFrame.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                if (MoreButton.this.mPopupMenu != null && MoreButton.this.mPopupMenu.isVisible()) {
                    MoreButton.this.mPopupMenu.setVisible(false);
                }
            }
        });
    }

    private boolean isVisible(Component comp, Rectangle rect) {
        String location;
        if (rect == null) {
            rect = this.toolbar.getVisibleRect();
        }
        if ((location = ((ToolBar)this.toolbar).getToolbarLocation()).compareTo("North") == 0) {
            return (double)(comp.getLocation().x + comp.getWidth()) <= rect.getWidth();
        }
        return (double)(comp.getLocation().y + comp.getHeight()) <= rect.getHeight();
    }

    private static void addMouseAdapter(final JComponent c) {
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ContextMenu menu = new ContextMenu(c);
                    menu.show(e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ContextMenu menu = new ContextMenu(c);
                    menu.show(e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Component[] comp = this.toolbar.getComponents();
        Action[] actions = DefaultToolBarModel.getInstance().getActions();
        Rectangle visibleRect = this.toolbar.getVisibleRect();
        for (int i = 0; i < comp.length; ++i) {
            if (this.isVisible(comp[i], visibleRect)) continue;
            this.mPopupMenu = new JPopupMenu();
            while (i < comp.length) {
                if (comp[i] instanceof AbstractButton) {
                    if (actions[i] != null) {
                        MenuHelpTextAdapter.create(this.mPopupMenu.add(actions[i]), actions[i].getValue("ShortDescription").toString(), this.mLabel);
                    }
                } else if (comp[i] instanceof JSeparator) {
                    this.mPopupMenu.addSeparator();
                }
                ++i;
            }
            this.mPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    MoreButton.this.setSelected(false);
                    MoreButton.this.setBorderPainted(false);
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }
            });
            this.mPopupMenu.show(this, 0, this.getHeight());
        }
    }

    public static Component wrapToolBar(ToolBar toolbar, MainFrame mainFrame, JLabel statusLabel) {
        JToolBar moreToolbar = new JToolBar(){

            @Override
            protected void paintComponent(Graphics g) {
                if (!UiUtilities.isGTKLookAndFeel() || Persona.getInstance().getHeaderImage() == null) {
                    super.paintComponent(g);
                }
            }
        };
        moreToolbar.setOpaque(false);
        moreToolbar.setLayout(new GridLayout());
        moreToolbar.setRollover(true);
        moreToolbar.setFloatable(false);
        moreToolbar.add(new MoreButton(toolbar, mainFrame, statusLabel));
        MoreButton.addMouseAdapter(moreToolbar);
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        panel.setOpaque(false);
        panel.add((Component)toolbar, "Center");
        if (toolbar.getToolbarLocation().compareTo("North") == 0) {
            moreToolbar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            panel.add((Component)moreToolbar, "East");
        } else {
            moreToolbar.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            panel.add((Component)moreToolbar, "South");
        }
        return panel;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (Persona.getInstance().getHeaderImage() != null && Persona.getInstance().getTextColor() != null && Persona.getInstance().getShadowColor() != null) {
            if (UiUtilities.isGTKLookAndFeel()) {
                if (this.isBorderPainted()) {
                    g.setColor(UIManager.getColor("List.selectionBackground"));
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                if (this.isSelected()) {
                    g.draw3DRect(0, 0, this.getWidth(), this.getHeight(), false);
                }
            }
            if (Settings.ToolBar.BUTTON_STYLE.getString().equals("text&icon")) {
                this.getIcon().paintIcon(this, g, this.getWidth() / 2 - this.getIcon().getIconWidth() / 2, this.getInsets().top);
            }
            if (Settings.ToolBar.BUTTON_STYLE.getString().contains("text")) {
                FontMetrics metrics = g.getFontMetrics(this.getFont());
                int textWidth = metrics.stringWidth(this.getText());
                if (!Persona.getInstance().getShadowColor().equals(Persona.getInstance().getTextColor())) {
                    g.setColor(Persona.getInstance().getShadowColor());
                    g.drawString(this.getText(), this.getWidth() / 2 - textWidth / 2 + 1, this.getHeight() - this.getInsets().bottom - this.getInsets().top + 1);
                    g.drawString(this.getText(), this.getWidth() / 2 - textWidth / 2 + 2, this.getHeight() - this.getInsets().bottom - this.getInsets().top + 2);
                }
                g.setColor(Persona.getInstance().getTextColor());
                g.drawString(this.getText(), this.getWidth() / 2 - textWidth / 2, this.getHeight() - this.getInsets().bottom - this.getInsets().top);
            } else {
                super.paintComponent(g);
            }
        } else {
            super.paintComponent(g);
        }
    }
}

