/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.PluginCenterPanel;
import devplugin.PluginCenterPanelWrapper;
import devplugin.SettingsTab;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import tvbrowser.core.Settings;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.extras.common.InternalPluginProxyIf;
import tvbrowser.extras.common.InternalPluginProxyList;
import tvbrowser.ui.DontShowAgainOptionBox;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.settings.ToolBarDragAndDropSettings;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;
import util.ui.OrderChooser;
import util.ui.UiUtilities;

public class CenterPanelSettingsTab
implements SettingsTab {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(CenterPanelSettingsTab.class);
    private OrderChooser<PluginCenterPanel> mPanelChooser;
    private JCheckBox mTabBarAlwaysVisible;
    private JCheckBox mShowPluginActionsInMenu;
    private ArrayList<PluginCenterPanel> mAllPanelList;
    private JRadioButton mNameOnly;
    private JRadioButton mIconOnly;
    private JRadioButton mNameAndIcon;

    @Override
    public JPanel createSettingsPanel() {
        PluginCenterPanel[] panels;
        PluginCenterPanelWrapper wrapper2;
        PluginProxy[] plugins = PluginProxyManager.getInstance().getActivatedPlugins();
        InternalPluginProxyIf[] internalPlugins = InternalPluginProxyList.getInstance().getAvailableProxys();
        this.mAllPanelList = new ArrayList();
        ArrayList<PluginCenterPanel> currentOrderList = new ArrayList<PluginCenterPanel>();
        this.mAllPanelList.add(MainFrame.getInstance().getProgramTableScrollPaneWrapper());
        this.mAllPanelList.add(MainFrame.getInstance().getPluginViewWrapper());
        for (PluginProxy plugin : plugins) {
            try {
                wrapper2 = plugin.getPluginCenterPanelWrapper();
                if (wrapper2 == null) continue;
                for (PluginCenterPanel panel : panels = wrapper2.getCenterPanels()) {
                    if (panel == null || panel.getName() == null || panel.getPanel() == null || panel.getId() == null) continue;
                    this.mAllPanelList.add(panel);
                }
            }
            catch (Throwable wrapper2) {
                // empty catch block
            }
        }
        for (InternalPluginProxyIf internalPlugin : internalPlugins) {
            try {
                wrapper2 = internalPlugin.getPluginCenterPanelWrapper();
                if (wrapper2 == null) continue;
                for (PluginCenterPanel panel : panels = wrapper2.getCenterPanels()) {
                    if (panel == null || panel.getName() == null || panel.getPanel() == null || panel.getId() == null) continue;
                    this.mAllPanelList.add(panel);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        for (String id : Settings.CenterPanels.CENTER_PANEL_ARR.getStringArray()) {
            for (PluginCenterPanel centerPanel : this.mAllPanelList) {
                if (!id.equals(centerPanel.getId())) continue;
                currentOrderList.add(centerPanel);
            }
        }
        this.mPanelChooser = new OrderChooser<PluginCenterPanel>(currentOrderList.toArray(new PluginCenterPanel[currentOrderList.size()]), this.mAllPanelList.toArray(new PluginCenterPanel[this.mAllPanelList.size()]));
        this.mTabBarAlwaysVisible = new JCheckBox(LOCALIZER.msg("alwaysShowTabs", "Always show tabs"), Settings.CenterPanels.ALWAYS_SHOW_TAB_BAR_FOR_CENTER_PANEL.getBoolean());
        this.mShowPluginActionsInMenu = new JCheckBox(ToolBarDragAndDropSettings.LOCALIZER.msg("showPluginAction", "Show plugin actions in context menu"), Settings.CenterPanels.PLUGIN_FUNCTIONS_IN_MENU_SHOW.getBoolean());
        this.mNameOnly = new JRadioButton(LOCALIZER.msg("nameOnly", "Name only"), Settings.CenterPanels.TAB_BAR_CENTER_PANEL_NAME_ICON_CONFIG.getInt() == 0);
        this.mIconOnly = new JRadioButton(LOCALIZER.msg("iconOnly", "Icon only (if available)"), Settings.CenterPanels.TAB_BAR_CENTER_PANEL_NAME_ICON_CONFIG.getInt() == 1);
        this.mNameAndIcon = new JRadioButton(LOCALIZER.msg("nameAndIcon", "Name and icon"), Settings.CenterPanels.TAB_BAR_CENTER_PANEL_NAME_ICON_CONFIG.getInt() == 2);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.mNameOnly);
        bg.add(this.mIconOnly);
        bg.add(this.mNameAndIcon);
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder(new FormLayout("5dlu,default:grow,5dlu"));
        pb.border(Borders.DIALOG);
        pb.addSeparatorRowFull(false, LOCALIZER.msg("info", "Shown tabs in the main window"));
        pb.addGrowingRow(this.mPanelChooser, 2);
        pb.addRow(this.mTabBarAlwaysVisible, 2);
        pb.addRow("1dlu,default", (Component)this.mShowPluginActionsInMenu, 2);
        pb.addParagraph(LOCALIZER.msg("nameAndIconSep", "Name and icon display"));
        pb.addRow(this.mNameOnly, 2);
        pb.addRow("1dlu,default", (Component)this.mIconOnly, 2);
        pb.addRow("1dlu,default", (Component)this.mNameAndIcon, 2);
        return pb.getPanel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveSettings() {
        void var4_9;
        List<PluginCenterPanel> order = this.mPanelChooser.getOrderList();
        ArrayList<String> idList = new ArrayList<String>(order.size());
        for (PluginCenterPanel pluginCenterPanel : order) {
            if (pluginCenterPanel == null) continue;
            this.mAllPanelList.remove(pluginCenterPanel);
            idList.add(pluginCenterPanel.getId());
        }
        if (!idList.contains(MainFrame.getInstance().getProgramTableScrollPaneWrapper().getId())) {
            Object[] options = new String[]{LOCALIZER.msg("programTableTabKeepDeactivated", "Keep deactivated"), LOCALIZER.msg("programTableTabActivate", "Activate program table tab again")};
            if (DontShowAgainOptionBox.showOptionDialog("CenterPanelSettings.programTableTabdeselected", (Component)UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("programTableDeselected", "You have deselected the program table you might miss some programs in the future.\nAre you sure?"), LOCALIZER.msg("programTableDeselectedTitle", "Program table deselected"), 3, 0, options, (Object)options[1], null) == 1) {
                idList.add(0, MainFrame.getInstance().getProgramTableScrollPaneWrapper().getId());
            }
        }
        if (idList.isEmpty()) {
            idList.add(MainFrame.getInstance().getProgramTableScrollPaneWrapper().getId());
        }
        ArrayList<String> disabledIdList = new ArrayList<String>(this.mAllPanelList.size());
        for (PluginCenterPanel centerPanel : this.mAllPanelList) {
            disabledIdList.add(centerPanel.getId());
        }
        Settings.CenterPanels.CENTER_PANEL_ARR.setStringArray(idList.toArray(new String[idList.size()]));
        Settings.CenterPanels.ALWAYS_SHOW_TAB_BAR_FOR_CENTER_PANEL.setBoolean(this.mTabBarAlwaysVisible.isSelected());
        Settings.CenterPanels.PLUGIN_FUNCTIONS_IN_MENU_SHOW.setBoolean(this.mShowPluginActionsInMenu.isSelected());
        Settings.CenterPanels.DISABLED_CENTER_PANEL_ARR.setStringArray(disabledIdList.toArray(new String[0]));
        int n = 2;
        if (this.mNameOnly.isSelected()) {
            boolean bl = false;
        } else if (this.mIconOnly.isSelected()) {
            boolean bl = true;
        }
        Settings.CenterPanels.TAB_BAR_CENTER_PANEL_NAME_ICON_CONFIG.setInt((int)var4_9);
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("title", "Main window");
    }
}

