/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormSpecs;
import devplugin.CancelableSettingsTab;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import tvbrowser.core.Settings;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.plugin.SettingsTabProxy;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.settings.AbstractSettingsTab;
import tvbrowser.ui.settings.PluginInfoPanel;
import tvbrowser.ui.settings.SettingsDialog;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;

public class ConfigPluginSettingsTab
extends AbstractSettingsTab
implements CancelableSettingsTab {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(ConfigPluginSettingsTab.class);
    private PluginProxy mPlugin;
    private SettingsTabProxy mSettingsTab;
    private JPanel mContentPanel;
    private boolean mPluginWasActivatedLastTime;
    private JPanel mPluginPanel;

    public ConfigPluginSettingsTab(PluginProxy plugin) {
        this.mPlugin = plugin;
        this.mSettingsTab = this.mPlugin.isActivated() ? this.mPlugin.getSettingsTab() : null;
    }

    @Override
    public JPanel createSettingsPanel() {
        this.mContentPanel = new JPanel(new BorderLayout());
        this.mContentPanel.setBorder(Borders.DIALOG);
        PluginInfoPanel pluginInfoPanel = new PluginInfoPanel(this.mPlugin.getInfo(), this.mSettingsTab != null);
        pluginInfoPanel.setDefaultBorder(true);
        this.mContentPanel.add((Component)pluginInfoPanel, "North");
        this.updatePluginPanel();
        this.mContentPanel.add((Component)this.mPluginPanel, "Center");
        return this.mContentPanel;
    }

    public void invalidate() {
        this.mPluginPanel = null;
    }

    public void updatePluginPanel() {
        if (this.mPluginPanel != null && this.mPlugin.isActivated() == this.mPluginWasActivatedLastTime) {
            return;
        }
        if (this.mPluginPanel == null) {
            this.mPluginPanel = new JPanel(new BorderLayout());
        } else {
            this.mPluginPanel.removeAll();
        }
        if (this.mPlugin.isActivated()) {
            if (this.mSettingsTab != null) {
                this.mPluginPanel.add((Component)this.mSettingsTab.createSettingsPanel(), "Center");
            } else {
                this.mPluginPanel.add((Component)this.createEmptyPanel(LOCALIZER.msg("noSettings", "No settings"), LOCALIZER.msg("noSettings.text", "This plugin has no settings.")), "North");
            }
        } else if (Settings.Plugins.BLOCKED_ARRAY.isBlocked(this.mPlugin)) {
            this.mPluginPanel.add((Component)this.createEmptyPanel(LOCALIZER.msg("blocked", "Blocked"), LOCALIZER.msg("blocked.text", "This plugin is blocked and cannot be activated.")), "North");
        } else {
            EnhancedPanelBuilder panelActivate = new EnhancedPanelBuilder(FormSpecs.RELATED_GAP_COLSPEC.encode() + "," + FormSpecs.PREF_COLSPEC.encode() + "," + FormSpecs.RELATED_GAP_COLSPEC.encode() + "," + FormSpecs.PREF_COLSPEC.encode() + ",default:grow");
            panelActivate.addParagraph(LOCALIZER.msg("activation", "Activation"));
            panelActivate.addLabelRow(LOCALIZER.msg("notactivated", "This Plugin is currently not activated."), 2);
            JButton btnActivate = new JButton(LOCALIZER.msg("activate", "Activate"));
            btnActivate.addActionListener(e -> {
                try {
                    btnActivate.setEnabled(false);
                    PluginProxyManager.getInstance().activatePlugin(this.mPlugin);
                    SettingsDialog settingsDialog = SettingsDialog.getInstance();
                    settingsDialog.invalidateTree();
                    settingsDialog.createPluginTreeItems();
                    settingsDialog.showSettingsTab(this.mPlugin.getId());
                    MainFrame.getInstance().getToolbar().updatePluginButtons();
                    String[] deactivatedPlugins = PluginProxyManager.getInstance().getDeactivatedPluginIds();
                    Settings.Plugins.DEACTIVATED.setStringArray(deactivatedPlugins);
                }
                catch (TvBrowserException e1) {
                    e1.printStackTrace();
                }
            });
            panelActivate.add(btnActivate, 4);
            this.mPluginPanel.add((Component)panelActivate.getPanel(), "North");
        }
        this.mPluginWasActivatedLastTime = this.mPlugin.isActivated();
        this.mContentPanel.repaint();
    }

    @Override
    public void saveSettings() {
        if (this.mSettingsTab != null) {
            this.mSettingsTab.saveSettings();
        }
    }

    @Override
    public Icon getIcon() {
        if (this.mSettingsTab != null && this.mSettingsTab.getIcon() != null) {
            return this.mSettingsTab.getIcon();
        }
        Icon icon = this.mPlugin.getPluginIcon();
        if (icon != null && icon instanceof ImageIcon && ((ImageIcon)icon).toString().equals("imgs/Jar16.gif")) {
            return null;
        }
        return icon;
    }

    @Override
    public String getTitle() {
        return this.mPlugin.getInfo().getName();
    }

    @Override
    public void cancel() {
        if (this.mSettingsTab != null) {
            this.mSettingsTab.cancel();
        }
    }
}

