/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.update;

import java.awt.Dialog;
import java.awt.Window;
import java.io.File;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import tvbrowser.core.Settings;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.update.PluginSoftwareUpdateItem;
import tvbrowser.ui.update.SoftwareUpdateItem;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.io.IOUtilities;
import util.ui.UiUtilities;

public class PluginsSoftwareUpdateItem
extends SoftwareUpdateItem {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(PluginsSoftwareUpdateItem.class);

    public PluginsSoftwareUpdateItem(String name) {
        super(name);
    }

    @Override
    protected boolean downloadFrom(String url) throws TvBrowserException {
        if (!this.isStable() && Settings.Plugins.BETA_WARNING.getBoolean()) {
            JOptionPane pane = new JOptionPane();
            String ok = mLocalizer.msg("betawarning.oktext", "Install beta version");
            String cancel = mLocalizer.msg("betawarning.canceltext", "Cancel installation");
            pane.setOptions(new String[]{ok, cancel});
            pane.setMessageType(3);
            pane.setOptionType(0);
            pane.setInitialValue(cancel);
            pane.setMessage(mLocalizer.msg("betawarning.text", "<html>The plugin <b>{0}</b> is a beta version.<br>Beta versions are possible unstable and could contain errors.<br><br>Are you sure that you want to install this version?</html>", this.getName() + " " + this.getVersion()));
            Window w = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
            JDialog dialog = pane.createDialog(w, mLocalizer.msg("betawarning.title", "Beta version"));
            dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            dialog.setLocationRelativeTo(w);
            dialog.setVisible(true);
            if (!ok.equals(pane.getValue())) {
                return false;
            }
        }
        File toFile = new File(Settings.Directories.PLUGINS.getString(), this.getClassName() + ".jar.inst");
        try {
            IOUtilities.download(new URL(url), toFile);
        }
        catch (Exception exc) {
            throw new TvBrowserException(SoftwareUpdateItem.class, "error.1", "Download failed", (Object)url, (Object)toFile.getAbsolutePath(), exc);
        }
        return true;
    }

    public String getId() {
        StringBuilder id = new StringBuilder();
        if (this instanceof PluginSoftwareUpdateItem) {
            id.append("java.");
        }
        return id.append(this.getClassName().toLowerCase()).append(".").append(this.getClassName()).toString();
    }
}

