/*
 * Decompiled with CFR 0.152.
 */
package util.io.windows.registry;

import java.io.File;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import util.browserlauncher.Launch;
import util.io.ExecutionHandler;
import util.io.windows.registry.RegistryValue;

public class RegistryKey {
    public static final String HKEY_LOCAL_MACHINE = "HKLM";
    public static final String HKEY_CURRENT_USER = "HKCU";
    public static final String HKEY_CLASS_ROOT = "HKCR";
    private String mKey;
    private String mPath;
    private static final File REG_TOOL = new File(System.getenv("windir") + File.separator + (System.getProperty("os.arch").contains("64") ? "SysWOW64" : "System32") + File.separator + "reg.exe");
    private static final Pattern PATTERN_QUERY = Pattern.compile("\\s{2,}(.*?)\\s+(REG_.*?)\\s+(.*?)$", 32);

    public static boolean isUsable() {
        return REG_TOOL.isFile();
    }

    public RegistryKey(String hkey, String path) throws RuntimeException {
        if (!RegistryKey.isUsable() || Launch.getOs() != 1) {
            throw new RuntimeException("Reg tool '" + REG_TOOL.getAbsolutePath() + "' not available. No access to Windows Registry");
        }
        this.mKey = hkey;
        this.mPath = path;
    }

    public RegistryValue getValue(String key) {
        ArrayList<Object> cmdList = new ArrayList<Object>();
        cmdList.add(REG_TOOL.getAbsolutePath());
        cmdList.add("query");
        cmdList.add(this.mKey + "\\" + this.mPath);
        if (key.equals("default")) {
            cmdList.add("/ve");
            key = "";
        } else if (!key.isBlank()) {
            cmdList.add("/v");
            cmdList.add(key);
        }
        ExecutionHandler handler = new ExecutionHandler(cmdList.toArray(new String[0]));
        RegistryValue result = new RegistryValue(key, 0, "");
        try {
            handler.execute(true);
            handler.getProcess().waitFor();
            Matcher m = PATTERN_QUERY.matcher(handler.getOutput());
            int pos = 0;
            while (m.find(pos)) {
                if (key.equals(m.group(1)) || key.isBlank()) {
                    if ("REG_DWORD".equals(m.group(2))) {
                        result = new RegistryValue(key, 3, String.valueOf(Long.parseLong(m.group(3).trim().replace("0x", ""), 16)));
                    } else if ("REG_SZ".equals(m.group(2))) {
                        result = new RegistryValue(key, 1, m.group(3).trim());
                    } else if ("REG_QWORD".equals(m.group(2))) {
                        result = new RegistryValue(key, 4, String.valueOf(Long.parseLong(m.group(3).trim().replace("0x", ""))));
                    } else if ("REG_BINARY".equals(m.group(2))) {
                        result = new RegistryValue(key, 2, m.group(3).trim());
                    }
                    break;
                }
                pos = m.end();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean setValue(RegistryValue value) {
        boolean result = false;
        ArrayList<Object> cmdList = new ArrayList<Object>();
        cmdList.add(REG_TOOL.getAbsolutePath());
        cmdList.add("add");
        cmdList.add(this.mKey + "\\" + this.mPath);
        cmdList.add("/t");
        switch (value.getType()) {
            case 1: {
                cmdList.add("REG_SZ");
                break;
            }
            case 2: {
                cmdList.add("REG_BINARY");
                break;
            }
            case 3: {
                cmdList.add("REG_DWORD");
                break;
            }
            case 4: {
                cmdList.add("REG_QWORD");
                break;
            }
            default: {
                return result;
            }
        }
        cmdList.add("/v");
        cmdList.add(value.getName());
        cmdList.add("/d");
        cmdList.add(value.getData());
        cmdList.add("/f");
        ExecutionHandler handler = new ExecutionHandler(cmdList.toArray(new String[0]));
        try {
            handler.execute(true);
            handler.getProcess().waitFor();
            result = handler.getProcess().exitValue() != 0;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return result;
    }

    public boolean delete() {
        boolean result = false;
        ArrayList<Object> cmdList = new ArrayList<Object>();
        cmdList.add(REG_TOOL.getAbsolutePath());
        cmdList.add("delete");
        cmdList.add(this.mKey + "\\" + this.mPath);
        cmdList.add("/f");
        ExecutionHandler handler = new ExecutionHandler(cmdList.toArray(new String[0]));
        try {
            handler.execute(true);
            handler.getProcess().waitFor();
            result = handler.getProcess().exitValue() != 0;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return result;
    }
}

