/*
 * Decompiled with CFR 0.152.
 */
package util.misc;

import devplugin.Date;
import devplugin.ProgramFieldType;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import util.io.IOUtilities;

public abstract class AbstractXmlTvDataHandler
extends DefaultHandler {
    private static final String PRESENTED_BY = "presented by";
    private static final String ACTOR_ROLE_SEPARATOR = "\t\t-\t\t";
    private static final String COMMA_SPACE = ", ";
    private static final String COMMA_LINE_BREAK = ",\n";
    private static final Pattern ACTOR_PATTERN = Pattern.compile("(.*)\\((.*)\\)");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss ZZZZ");
    private StringBuffer mText = new StringBuffer();
    private String mValue = null;
    private String mLang;
    private String mChannelId;
    private boolean mIsValid = false;
    private String mEpisodeType;
    private String mTitle;
    private boolean mSetTitle;
    private String mRole;
    private String mLengthUnit;
    private String mSubtitles;

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.mText.append(ch, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            this.mText.setLength(0);
            this.mLang = attributes.getValue("lang");
            if (qName.equals("programme")) {
                this.mIsValid = false;
                this.mSetTitle = false;
                this.mTitle = null;
                String startDateTime = attributes.getValue("start");
                this.mChannelId = attributes.getValue("channel");
                if (startDateTime == null) {
                    this.logMessage("Start time missing in programme tag");
                } else if (this.mChannelId == null) {
                    this.logMessage("Channel missing in programme tag");
                } else {
                    Date startDate = this.extractDate(startDateTime);
                    int startTime = this.extractTime(startDateTime);
                    if (startDate != null && startTime > -1) {
                        String endDateTime;
                        this.startProgram(startDate, startTime);
                        this.addField(ProgramFieldType.START_TIME_TYPE, startTime);
                        String vps = attributes.getValue("vps-start");
                        if (vps != null) {
                            int time = this.extractTime(vps);
                            this.addField(ProgramFieldType.VPS_TYPE, time);
                        }
                        if ((endDateTime = attributes.getValue("stop")) != null) {
                            int endTime = this.extractTime(endDateTime);
                            this.addField(ProgramFieldType.END_TIME_TYPE, endTime);
                        }
                        this.mIsValid = true;
                    }
                }
            } else if (qName.equals("previously-shown")) {
                Date prevDate = this.extractDate(attributes.getValue("start"));
                if (prevDate != null) {
                    this.addField(ProgramFieldType.REPETITION_OF_TYPE, prevDate.toString());
                }
            } else if (qName.equals("next-time-shown")) {
                Date nextDate = this.extractDate(attributes.getValue("start"));
                if (nextDate != null) {
                    this.addField(ProgramFieldType.REPETITION_ON_TYPE, nextDate.toString());
                }
            } else if ("episode-num".equals(qName)) {
                this.mEpisodeType = attributes.getValue("system");
            } else if ("actor".equals(qName)) {
                this.mRole = attributes.getValue("role");
            } else if ("length".equals(qName)) {
                this.mLengthUnit = attributes.getValue("units");
            } else if ("subtitles".equals(qName)) {
                this.mSubtitles = attributes.getValue("type");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract void startProgram(Date var1, int var2);

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        block112: {
            try {
                if (!this.isValid()) break block112;
                Object text = this.mText.toString().trim();
                if ("title".equalsIgnoreCase(qName)) {
                    this.mTitle = text;
                    if (this.mLang == null || this.mLang.equals(this.getChannelCountry()) || AbstractXmlTvDataHandler.getCountries(this.mLang).contains(this.getChannelCountry())) {
                        this.addField(ProgramFieldType.TITLE_TYPE, (String)text);
                        this.mSetTitle = true;
                    } else {
                        this.addField(ProgramFieldType.ORIGINAL_TITLE_TYPE, (String)text);
                    }
                    break block112;
                }
                if ("sub-title".equalsIgnoreCase(qName)) {
                    if (this.mLang == null || this.mLang.equals(this.getChannelCountry())) {
                        this.addField(ProgramFieldType.EPISODE_TYPE, (String)text);
                    } else {
                        this.addField(ProgramFieldType.ORIGINAL_EPISODE_TYPE, (String)text);
                    }
                    break block112;
                }
                if ("desc".equalsIgnoreCase(qName)) {
                    this.addField(ProgramFieldType.DESCRIPTION_TYPE, (String)text);
                    break block112;
                }
                if ("date".equalsIgnoreCase(qName)) {
                    if (((String)text).length() < 4) {
                        this.logMessage("WARNING: The date value must have at least 4 chars: '" + (String)text + "'");
                    } else {
                        try {
                            int year = Integer.parseInt(((String)text).substring(0, 4));
                            this.addField(ProgramFieldType.PRODUCTION_YEAR_TYPE, year);
                        }
                        catch (NumberFormatException e) {
                            this.logMessage("WARNING: The date value doesn't start with a year: '" + (String)text + "'");
                        }
                    }
                    break block112;
                }
                if ("rating".equalsIgnoreCase(qName)) {
                    try {
                        int ageLimit = Integer.valueOf((String)text);
                        this.addField(ProgramFieldType.AGE_LIMIT_TYPE, ageLimit);
                    }
                    catch (NumberFormatException exc) {
                        this.addField(ProgramFieldType.AGE_RATING_TYPE, (String)text);
                    }
                    break block112;
                }
                if ("url".equalsIgnoreCase(qName)) {
                    this.addField(ProgramFieldType.URL_TYPE, (String)text);
                    break block112;
                }
                if ("category".equalsIgnoreCase(qName)) {
                    if (((String)(text = ((String)text).substring(0, 1).toUpperCase() + ((String)text).substring(1))).toLowerCase().indexOf("serie") > -1) {
                        this.setInfoBit(8192);
                    } else if (((String)text).toLowerCase().indexOf("movie") > -1) {
                        this.setInfoBit(4096);
                    } else if (((String)text).toLowerCase().indexOf("sport") > -1) {
                        this.setInfoBit(0x400000);
                    } else if (((String)text).toLowerCase().indexOf("music") > -1) {
                        this.setInfoBit(0x200000);
                    } else if (((String)text).toLowerCase().indexOf("news") > -1) {
                        this.setInfoBit(65536);
                    }
                    this.addToList(ProgramFieldType.GENRE_TYPE, (String)text, COMMA_SPACE);
                    break block112;
                }
                if ("country".equalsIgnoreCase(qName)) {
                    this.addField(ProgramFieldType.ORIGIN_TYPE, (String)text);
                    break block112;
                }
                if ("subtitles".equalsIgnoreCase(qName)) {
                    if ("deaf-signed".equalsIgnoreCase(this.mSubtitles)) {
                        this.setInfoBit(0x2000000);
                    } else if (this.mLang == null || this.mLang.equals(this.getChannelCountry())) {
                        this.setInfoBit(512);
                    } else {
                        this.setInfoBit(2048);
                    }
                    break block112;
                }
                if ("live".equalsIgnoreCase(qName)) {
                    this.setInfoBit(1024);
                    break block112;
                }
                if ("length".equalsIgnoreCase(qName)) {
                    try {
                        int length = Integer.parseInt((String)text);
                        if ("seconds".equalsIgnoreCase(this.mLengthUnit)) {
                            this.addField(ProgramFieldType.NET_PLAYING_TIME_TYPE, length / 60);
                            break block112;
                        }
                        if ("minutes".equalsIgnoreCase(this.mLengthUnit)) {
                            this.addField(ProgramFieldType.NET_PLAYING_TIME_TYPE, length);
                            break block112;
                        }
                        if ("hours".equalsIgnoreCase(this.mLengthUnit)) {
                            this.addField(ProgramFieldType.NET_PLAYING_TIME_TYPE, length * 60);
                            break block112;
                        }
                        this.addField(ProgramFieldType.NET_PLAYING_TIME_TYPE, length);
                    }
                    catch (NumberFormatException exc) {
                        this.logMessage("WARNING: length is no number: '" + (String)text + "' and will be ignored.");
                    }
                    break block112;
                }
                if ("actor".equalsIgnoreCase(qName)) {
                    if (this.mRole != null && this.mRole.length() > 0) {
                        text = (String)text + ACTOR_ROLE_SEPARATOR + this.mRole;
                    } else {
                        Matcher m = ACTOR_PATTERN.matcher((CharSequence)text);
                        if (m.matches()) {
                            text = m.group(2).trim() + ACTOR_ROLE_SEPARATOR + m.group(1).trim();
                        }
                    }
                    if (((String)text).toLowerCase().startsWith(PRESENTED_BY)) {
                        text = ((String)text).substring(PRESENTED_BY.length()).trim();
                        this.addToList(ProgramFieldType.MODERATION_TYPE, (String)text, COMMA_SPACE);
                    } else {
                        this.addToList(ProgramFieldType.ACTOR_LIST_TYPE, (String)text, COMMA_LINE_BREAK);
                    }
                    break block112;
                }
                if ("director".equalsIgnoreCase(qName)) {
                    this.addToList(ProgramFieldType.DIRECTOR_TYPE, (String)text, COMMA_SPACE);
                    break block112;
                }
                if ("writer".equalsIgnoreCase(qName) || "adapter".equalsIgnoreCase(qName)) {
                    this.addToList(ProgramFieldType.SCRIPT_TYPE, (String)text, COMMA_SPACE);
                    break block112;
                }
                if ("presenter".equalsIgnoreCase(qName) || "commentator".equalsIgnoreCase(qName)) {
                    this.addToList(ProgramFieldType.MODERATION_TYPE, (String)text, COMMA_SPACE);
                    break block112;
                }
                if ("music".equalsIgnoreCase(qName) || "composer".equalsIgnoreCase(qName)) {
                    this.addToList(ProgramFieldType.MUSIC_TYPE, (String)text, COMMA_SPACE);
                    break block112;
                }
                if ("producer".equalsIgnoreCase(qName)) {
                    this.addToList(ProgramFieldType.PRODUCER_TYPE, (String)text, COMMA_SPACE);
                    break block112;
                }
                if ("guest".equalsIgnoreCase(qName) || "editor".equalsIgnoreCase(qName)) {
                    this.addToList(ProgramFieldType.ADDITIONAL_PERSONS_TYPE, (String)text, COMMA_SPACE);
                    break block112;
                }
                if ("colour".equalsIgnoreCase(qName)) {
                    if (((String)text).equals("no")) {
                        this.setInfoBit(2);
                    } else if (!((String)text).equals("yes")) {
                        this.logMessage("WARNING: value of colour tag must be 'yes' or 'no', but it is '" + (String)text + "'");
                    }
                    break block112;
                }
                if ("quality".equalsIgnoreCase(qName)) {
                    if (((String)text).equals("HDTV") || ((String)text).equals("HD")) {
                        this.setInfoBit(524288);
                    } else if (!((String)text).equals("SD")) {
                        this.logMessage("WARNING: unsupported value of quality tag: '" + (String)text + "'");
                    }
                    break block112;
                }
                if ("aspect".equalsIgnoreCase(qName)) {
                    if (((String)text).equals("4:3")) {
                        this.setInfoBit(4);
                    } else if (((String)text).equals("16:9")) {
                        this.setInfoBit(8);
                    } else {
                        this.logMessage("WARNING: value of aspect tag must be '4:3' or '16:9', but it is '" + (String)text + "'");
                    }
                    break block112;
                }
                if ("stereo".equalsIgnoreCase(qName)) {
                    if (((String)text).equals("mono")) {
                        this.setInfoBit(16);
                    } else if (((String)text).equals("stereo")) {
                        this.setInfoBit(32);
                    } else if (((String)text).equals("surround")) {
                        this.setInfoBit(64);
                    } else if (((String)text).equals("dolby")) {
                        this.setInfoBit(64);
                    } else if (((String)text).equals("5.1")) {
                        this.setInfoBit(128);
                    } else if (((String)text).equals("dolby digital")) {
                        this.setInfoBit(128);
                    } else if (((String)text).equals("two channel tone")) {
                        this.setInfoBit(256);
                    } else if (((String)text).equals("bilingual")) {
                        this.setInfoBit(256);
                    } else if (((String)text).equals("audio description")) {
                        this.setInfoBit(32768);
                    } else {
                        this.logMessage("WARNING: value of stereo tag must be one of 'mono', 'stereo', 'surround', '5.1' or 'two channel tone' but it is '" + (String)text + "'");
                    }
                    break block112;
                }
                if ("picture".equalsIgnoreCase(qName)) {
                    File file = new File((String)text);
                    if (file.exists() && file.isFile()) {
                        try {
                            this.addField(ProgramFieldType.PICTURE_TYPE, IOUtilities.getBytesFromFile(file));
                        }
                        catch (IOException e) {
                            this.logException(e);
                        }
                    } else {
                        this.logMessage("Warning: File does not exist: " + (String)text);
                    }
                    break block112;
                }
                if ("picture-copyright".equalsIgnoreCase(qName)) {
                    this.addField(ProgramFieldType.PICTURE_COPYRIGHT_TYPE, (String)text);
                    break block112;
                }
                if ("picture-description".equalsIgnoreCase(qName)) {
                    this.addField(ProgramFieldType.PICTURE_DESCRIPTION_TYPE, (String)text);
                    break block112;
                }
                if ("value".equalsIgnoreCase(qName)) {
                    this.mValue = text;
                    break block112;
                }
                if ("star-rating".equalsIgnoreCase(qName)) {
                    if (this.mValue != null) {
                        if (this.mValue.contains("/")) {
                            try {
                                int num = Integer.valueOf(this.mValue.substring(0, this.mValue.indexOf(47)).trim());
                                int max = Integer.valueOf(this.mValue.substring(this.mValue.indexOf(47) + 1).trim());
                                this.addField(ProgramFieldType.RATING_TYPE, num * 100 / max);
                            }
                            catch (NumberFormatException ex) {
                                this.logException(ex);
                            }
                        } else {
                            this.logMessage("Star-rating must be in form 8/10");
                        }
                    }
                    this.mValue = null;
                    break block112;
                }
                if ("new".equalsIgnoreCase(qName) || "premiere".equalsIgnoreCase(qName)) {
                    this.setInfoBit(16384);
                    break block112;
                }
                if ("programme".equalsIgnoreCase(qName)) {
                    if (!this.mSetTitle && this.mTitle != null) {
                        this.addField(ProgramFieldType.TITLE_TYPE, this.mTitle);
                    }
                    this.endProgram();
                    break block112;
                }
                if ("episode-num".equals(qName)) {
                    if ("onscreen".equals(this.mEpisodeType)) {
                        this.addField(ProgramFieldType.EPISODE_TYPE, (String)text);
                        break block112;
                    }
                    if (!"xmltv_ns".equals(this.mEpisodeType)) break block112;
                    try {
                        if (((String)text).length() > 0) {
                            String[] parts;
                            int season;
                            String[] seasons;
                            String[] ep = ((String)text).split("\\.");
                            if (ep.length > 0 && ep[0].length() > 0 && (seasons = ep[0].trim().split("/")).length > 0 && seasons[0].trim().length() > 0 && (season = Integer.parseInt(seasons[0].trim()) + 1) > 0) {
                                this.addField(ProgramFieldType.SEASON_NUMBER_TYPE, season);
                            }
                            if (ep.length > 1 && ep[1].length() > 0 && (parts = ep[1].trim().split("/")).length == 2) {
                                int total;
                                String totalString;
                                int current;
                                String currentString = parts[0].trim();
                                if (currentString.length() > 0 && (current = Integer.parseInt(currentString) + 1) > 0) {
                                    this.addField(ProgramFieldType.EPISODE_NUMBER_TYPE, current);
                                }
                                if ((totalString = parts[1].trim()).length() > 0 && (total = Integer.parseInt(totalString)) > 0) {
                                    this.addField(ProgramFieldType.EPISODE_TOTAL_NUMBER_TYPE, total);
                                }
                            }
                        }
                        break block112;
                    }
                    catch (NumberFormatException e) {
                        this.logMessage("WARNING: the value of xmltv_ns doesn't meet the specifications: '" + (String)text + "'");
                    }
                    break block112;
                }
                if (!("credits".equalsIgnoreCase(qName) || "tv".equalsIgnoreCase(qName) || "video".equalsIgnoreCase(qName))) {
                    this.logMessage("Warning: Unknown element '" + qName + "'");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mLang = null;
    }

    private static String getCountries(String language) {
        if (language == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (Locale locale : Locale.getAvailableLocales()) {
            String country;
            if (!locale.getLanguage().equalsIgnoreCase(language) || (country = locale.getCountry()) == null || country.length() <= 0) continue;
            result.append(',').append(country);
        }
        return result.toString().toLowerCase();
    }

    protected abstract String getChannelCountry();

    protected abstract void endProgram();

    protected boolean isValid() {
        return this.mIsValid;
    }

    protected abstract void setInfoBit(int var1);

    protected abstract void addField(ProgramFieldType var1, byte[] var2);

    protected abstract void addField(ProgramFieldType var1, String var2);

    protected abstract void addField(ProgramFieldType var1, int var2);

    protected abstract void logMessage(String var1);

    protected abstract void logException(Exception var1);

    private int extractTime(String dateTime) {
        Calendar cal = this.parseDateTime(dateTime);
        if (cal == null) {
            return -1;
        }
        int hour = cal.get(11);
        int minute = cal.get(12);
        return hour * 60 + minute;
    }

    private Date extractDate(String dateTime) {
        Calendar cal = this.parseDateTime(dateTime);
        if (cal == null) {
            return null;
        }
        return new Date(cal.get(1), cal.get(2) + 1, cal.get(5));
    }

    private synchronized Calendar parseDateTime(String time) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(DATE_FORMAT.parse(time.substring(0, 20)));
            calendar.setTimeInMillis(calendar.getTimeInMillis() - (long)calendar.getTimeZone().getRawOffset());
            return calendar;
        }
        catch (ParseException e) {
            this.logMessage("invalid time format: " + time);
            return null;
        }
    }

    protected final String getChannelId() {
        return this.mChannelId;
    }

    protected abstract void addToList(ProgramFieldType var1, String var2, String var3);
}

