/*
 * Decompiled with CFR 0.152.
 */
package util.misc;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import util.io.stream.OutputStreamProcessor;
import util.io.stream.StreamUtilities;

public class ChangeTrackingProperties
extends Properties {
    private boolean mChanged = false;

    @Override
    public synchronized Object setProperty(String key, String value) {
        this.mChanged = true;
        return super.setProperty(key, value);
    }

    public synchronized boolean changed() {
        return this.mChanged;
    }

    public void store(File file) throws IOException {
        if (this.changed()) {
            StreamUtilities.outputStream(file, new OutputStreamProcessor(){

                @Override
                public void process(OutputStream outputStream) throws IOException {
                    ChangeTrackingProperties.this.store(outputStream, null);
                }
            });
        }
    }
}

