/*
 * Decompiled with CFR 0.152.
 */
package util.settings;

import devplugin.Date;
import util.settings.Property;
import util.settings.PropertyManager;

public class DateProperty
extends Property {
    private Date mDefaultValue;
    private Date mCachedValue;

    public DateProperty(PropertyManager manager, String key, Date defaultValue) {
        super(manager, key);
        this.mDefaultValue = defaultValue;
        this.mCachedValue = null;
    }

    public Date getDefault() {
        return this.mDefaultValue;
    }

    public Date getDate() {
        if (this.mCachedValue == null) {
            String[] splits;
            String asString = this.getProperty();
            if (asString != null && (splits = asString.split("-")).length == 3) {
                try {
                    this.mCachedValue = new Date(Integer.parseInt(splits[0]), Integer.parseInt(splits[1]), Integer.parseInt(splits[2]));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.mCachedValue == null) {
                this.mCachedValue = this.mDefaultValue;
            }
        }
        return this.mCachedValue;
    }

    public void setDate(Date value) {
        if (value == null) {
            throw new IllegalArgumentException("You can't set a null value");
        }
        if (value.equals(this.mDefaultValue)) {
            this.setProperty(null);
        } else {
            String asString = value.getYear() + "-" + value.getMonth() + "-" + value.getDayOfMonth();
            this.setProperty(asString);
        }
        this.mCachedValue = value;
    }

    @Override
    protected void clearCache() {
        this.mCachedValue = null;
    }
}

