/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import util.browserlauncher.Launch;

public class LinkButton
extends JButton
implements ActionListener {
    private String mUrl;

    public LinkButton(String url) {
        this(url, url);
    }

    public LinkButton(String text, String url) {
        this(text, url, 0);
    }

    public LinkButton(String text, String url, int halignment) {
        this(text, url, halignment, true);
    }

    public LinkButton(String text, String url, int halignment, boolean useLinkAction) {
        super("<html><font color=\"blue\"><u>" + text + "</u></font></html>");
        this.mUrl = url;
        this.setHorizontalAlignment(halignment);
        this.createButton(useLinkAction);
    }

    private void createButton(boolean useLinkAction) {
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.setCursor(new Cursor(12));
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.setRolloverEnabled(true);
        this.setToolTipText(this.mUrl);
        if (useLinkAction) {
            this.addActionListener(this);
        }
    }

    @Override
    public void setText(String text) {
        this.setText(text, "blue");
    }

    public void setText(String text, String color) {
        super.setText("<html><font color=\"" + color + "\"><u>" + text + "</u></font></html>");
    }

    public void setUrl(String url) {
        this.mUrl = url;
        this.setToolTipText(this.mUrl);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.mUrl != null) {
            Launch.openURL(this.mUrl);
        }
    }
}

