/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import devplugin.Marker;
import devplugin.Plugin;
import devplugin.PluginAccess;
import devplugin.ProgramReceiveIf;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.extras.favoritesplugin.FavoritesPluginProxy;
import tvbrowser.extras.reminderplugin.ReminderPluginProxy;
import util.i18n.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;
import util.ui.customizableitems.SelectableItemList;

public class MarkerChooserDlg
extends JDialog
implements WindowClosingIf {
    private static final long serialVersionUID = 1L;
    private Marker[] mResultPluginArr;
    private Marker[] mPluginArr;
    private SelectableItemList<Marker> mPluginItemList;
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(MarkerChooserDlg.class);

    public MarkerChooserDlg(Window parent, Marker[] pluginArr, String description) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.init(pluginArr, description);
    }

    private void init(Marker[] channelArr, String description) {
        this.setTitle(LOCALIZER.msg("title", "Choose Plugins"));
        UiUtilities.registerForClosing(this);
        if (channelArr == null) {
            this.mPluginArr = new Marker[0];
            this.mResultPluginArr = new Marker[0];
        } else {
            this.mPluginArr = channelArr;
            this.mResultPluginArr = channelArr;
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        FormLayout layout = new FormLayout("fill:pref:grow", "");
        contentPane.setLayout((LayoutManager)layout);
        contentPane.setBorder(Borders.DLU4);
        CellConstraints cc = new CellConstraints();
        PluginAccess[] pluginAccess = Plugin.getPluginManager().getActivatedPlugins();
        ArrayList<ProgramReceiveIf> list = new ArrayList<ProgramReceiveIf>();
        list.add(FavoritesPluginProxy.getInstance());
        list.add(ReminderPluginProxy.getInstance());
        for (PluginAccess plugin : pluginAccess) {
            Icon[] markIcons = plugin.getMarkIcons(PluginManagerImpl.getInstance().getExampleProgram());
            if (markIcons == null || markIcons.length <= 0) continue;
            list.add(plugin);
        }
        Collections.sort(list, new Comparator<Marker>(){

            @Override
            public int compare(Marker arg0, Marker arg1) {
                return arg0.toString().compareTo(arg1.toString());
            }
        });
        this.mPluginItemList = new SelectableItemList<Marker>(this.mResultPluginArr, list.toArray(new Marker[list.size()]));
        int pos = 1;
        layout.appendRow(RowSpec.decode((String)"fill:default:grow"));
        layout.appendRow(RowSpec.decode((String)"3dlu"));
        contentPane.add(this.mPluginItemList, cc.xy(1, pos));
        pos += 2;
        if (description != null) {
            JLabel lb = new JLabel(description);
            layout.appendRow(RowSpec.decode((String)"pref"));
            layout.appendRow(RowSpec.decode((String)"3dlu"));
            contentPane.add((Component)lb, cc.xy(1, pos));
            pos += 2;
        }
        JButton okBt = new JButton(Localizer.getLocalization("i18n_ok"));
        JButton cancelBt = new JButton(Localizer.getLocalization("i18n_cancel"));
        okBt.addActionListener(event -> {
            List<Marker> list1 = this.mPluginItemList.getSelectionList();
            this.mResultPluginArr = new Marker[list1.size()];
            for (int i = 0; i < list1.size(); ++i) {
                this.mResultPluginArr[i] = list1.get(i);
            }
            this.setVisible(false);
        });
        cancelBt.addActionListener(event -> {
            this.mResultPluginArr = null;
            this.setVisible(false);
        });
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addGlue();
        builder.addButton((JComponent[])new JButton[]{okBt, cancelBt});
        layout.appendRow(RowSpec.decode((String)"pref"));
        contentPane.add((Component)builder.getPanel(), cc.xy(1, pos));
        this.pack();
    }

    public Marker[] getMarker() {
        if (this.mResultPluginArr == null) {
            return this.mPluginArr;
        }
        return this.mResultPluginArr;
    }

    @Override
    public void close() {
        this.setVisible(false);
    }
}

