/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import devplugin.Program;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import tvbrowser.core.Settings;
import tvbrowser.ui.mainframe.MainFrame;
import util.io.IOUtilities;
import util.misc.StringPool;
import util.ui.ImageIconEnhanced;
import util.ui.ObjectSelectionListener;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class ObjectSelectionButton<E>
extends JButton
implements ActionListener {
    private E[] mObjectArr;
    private ListCellRenderer mListCellRenderer;
    private ArrayList<ObjectSelectionListener<E>> mListenerList = new ArrayList();
    private long mLastClosedDialogTime = 0L;

    public ObjectSelectionButton(E[] objects, ImageIcon icon) {
        this.mListCellRenderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, final Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel c = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof Program) {
                    c.setText(StringPool.getString(((Program)value).getTimeString()) + " " + ((Program)value).getTitle());
                    if (!isSelected && !cellHasFocus) {
                        if (((Program)value).isExpired()) {
                            c.setForeground(Color.lightGray);
                        } else if (((Program)value).isOnAir()) {
                            c = new JLabel(c.getText()){

                                @Override
                                protected void paintComponent(Graphics g) {
                                    g.setColor(Color.white);
                                    g.fillRect(0, 1, this.getWidth(), this.getHeight() - 2);
                                    int runTime = IOUtilities.getMinutesAfterMidnight() - ((Program)value).getStartTime();
                                    if (runTime < 0) {
                                        runTime += 1440;
                                    }
                                    int progressX = (int)((double)this.getWidth() / (double)((Program)value).getLength() * (double)runTime);
                                    g.setColor(Settings.ProgramPanel.COLOR_ON_AIR_DARK.getColor());
                                    g.fillRect(0, 1, progressX, this.getHeight() - 2);
                                    g.setColor(Settings.ProgramPanel.COLOR_ON_AIR_LIGHT.getColor());
                                    g.fillRect(0 + progressX, 1, this.getWidth() - progressX, this.getHeight() - 2);
                                    this.setForeground(Color.black);
                                    super.paintComponent(g);
                                }
                            };
                        }
                    }
                }
                return c;
            }
        };
        this.setIcon(new ImageIconEnhanced(icon.getImage()){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                super.paintIcon(c, g, x, y);
                int x1 = x + super.getIconWidth() + 2;
                int y1 = y + this.getIconHeight() / 2 - 1;
                int[] xPoints = new int[]{x1, x1 + 3, x1 + 6};
                int[] yPoints = new int[]{y1, y1 + 4, y1};
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(Color.gray);
                g.fillPolygon(xPoints, yPoints, 3);
                g.setColor(Color.gray);
                g.drawPolygon(xPoints, yPoints, 3);
            }

            @Override
            public int getIconWidth() {
                return super.getIconWidth() + 11;
            }
        });
        this.addActionListener(this);
        this.mObjectArr = objects;
        this.setHorizontalTextPosition(4);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.showDialog();
    }

    private void showDialog() {
        if (this.mObjectArr != null && this.mLastClosedDialogTime + 800L < System.currentTimeMillis()) {
            final JList<E> list = new JList<E>(this.mObjectArr);
            final JDialog dialog = new JDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()));
            list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        ObjectSelectionButton.this.objectSelected(list, dialog);
                    }
                }
            });
            list.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    int index = list.locationToIndex(e.getPoint());
                    if (index != -1) {
                        list.setSelectedIndex(index);
                    }
                }
            });
            list.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                        ObjectSelectionButton.this.objectSelected(list, dialog);
                    }
                }
            });
            list.setCellRenderer(this.mListCellRenderer);
            JScrollPane scrollPane = new JScrollPane(list);
            Toolkit t = Toolkit.getDefaultToolkit();
            scrollPane.setMaximumSize(new Dimension(t.getScreenSize().width / 2, t.getScreenSize().height / 2));
            dialog.setModal(false);
            dialog.setUndecorated(true);
            dialog.getContentPane().setLayout(new BorderLayout());
            dialog.getContentPane().add((Component)scrollPane, "Center");
            dialog.pack();
            Point p = this.getLocationOnScreen();
            int x = p.x;
            int y = p.y + this.getHeight();
            if (x + dialog.getWidth() > t.getScreenSize().width) {
                x = p.x + this.getWidth() - dialog.getWidth();
            }
            if (x < 0) {
                x = 0;
            }
            if (y + dialog.getHeight() > t.getScreenSize().height) {
                y = p.y - dialog.getHeight();
            }
            if (y < 0) {
                y = 0;
            }
            dialog.setLocation(x, y);
            UiUtilities.registerForClosing(new WindowClosingIf(){

                @Override
                public void close() {
                    dialog.removeWindowListener(dialog.getWindowListeners()[0]);
                    dialog.dispose();
                }

                @Override
                public JRootPane getRootPane() {
                    return dialog.getRootPane();
                }
            });
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowDeactivated(WindowEvent e) {
                    ((JDialog)e.getSource()).dispose();
                }

                @Override
                public void windowClosed(WindowEvent e) {
                    ObjectSelectionButton.this.mLastClosedDialogTime = System.currentTimeMillis();
                }
            });
            dialog.setVisible(true);
        }
    }

    private void objectSelected(JList<E> list, JDialog dialog) {
        if (list.getSelectedIndex() >= 0) {
            dialog.dispose();
            E object = list.getSelectedValue();
            for (ObjectSelectionListener<E> listener : this.mListenerList) {
                listener.objectSeleted(object);
            }
        }
    }

    public void setObjectArr(E[] objectArr) {
        this.mObjectArr = objectArr;
    }

    public void setListCellRenderer(ListCellRenderer renderer) {
        this.mListCellRenderer = renderer;
    }

    public void addProgramSelectionListener(ObjectSelectionListener<E> listener) {
        this.mListenerList.add(listener);
    }

    public void removeProgramSelectionListener(ObjectSelectionListener<E> listener) {
        this.mListenerList.remove(listener);
    }
}

