/*
 * Decompiled with CFR 0.152.
 */
package util.ui.html;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.htmlparser.util.Translate;
import util.io.IOUtilities;

public class HTMLTextHelper {
    public static String convertTextToHtml(String text) {
        return HTMLTextHelper.convertTextToHtml(text, true);
    }

    public static String convertTextToHtml(String text, boolean createLinks) {
        text = text.replaceAll("(?i)<script.*?(>.*?</script>|/>)", "");
        text = IOUtilities.replace(text.trim(), "<", "&lt;");
        text = IOUtilities.replace(text.trim(), ">", "&gt;");
        text = IOUtilities.replace(text.trim(), "\n", "<br>");
        if (createLinks) {
            Matcher matcher = Pattern.compile("(http[s]?://|www\\.)[^\\s<\"']*").matcher(text);
            StringBuilder result = new StringBuilder();
            int end = 0;
            while (matcher.find()) {
                result.append(text.substring(end, matcher.start()));
                end = matcher.end();
                String linkText = text.substring(matcher.start(), matcher.end());
                if (linkText.endsWith(")") && result.length() > 0 && result.charAt(result.length() - 1) == '(') {
                    linkText = linkText.substring(0, linkText.length() - 1);
                    --end;
                }
                while (linkText.endsWith(".")) {
                    linkText = linkText.substring(0, linkText.length() - 1);
                    --end;
                }
                result.append("<a href=\"");
                if (!linkText.toLowerCase().startsWith("http://") && !linkText.toLowerCase().startsWith("https://")) {
                    result.append("http://");
                }
                result.append(linkText);
                result.append("\">");
                if (linkText.startsWith("http://")) {
                    linkText = linkText.substring("http://".length());
                }
                if (linkText.startsWith("https://")) {
                    linkText = linkText.substring("https://".length());
                }
                if (linkText.endsWith("/")) {
                    linkText = linkText.substring(0, linkText.length() - "/".length());
                }
                result.append((String)(linkText.length() > 40 ? linkText.substring(0, 40) + "..." : linkText));
                result.append("</a>");
            }
            result.append(text.substring(end));
            text = result.toString();
        }
        return text;
    }

    public static String convertHtmlToText(String html) {
        if (html == null) {
            return null;
        }
        String temp = Translate.decode((String)html);
        temp = temp.replace("<br>", "\n");
        return temp;
    }

    public static String getCssRgbColorEntry(Color c) {
        StringBuilder builder = new StringBuilder("rgb(");
        builder.append(c.getRed());
        builder.append(",");
        builder.append(c.getGreen());
        builder.append(",");
        builder.append(c.getBlue());
        builder.append(")");
        return builder.toString();
    }

    public static String getLink(int pos, JEditorPane html) {
        HTMLDocument hdoc;
        Element e;
        AttributeSet a;
        AttributeSet anchor;
        Document doc = html.getDocument();
        if (doc instanceof HTMLDocument && (anchor = (AttributeSet)(a = (e = (hdoc = (HTMLDocument)doc).getCharacterElement(pos)).getAttributes()).getAttribute(HTML.Tag.A)) != null) {
            return (String)anchor.getAttribute(HTML.Attribute.HREF);
        }
        return null;
    }

    public static String checkTextForTextFormatingTags(String text) {
        if (!((String)text).startsWith("<html>") && (((String)text).contains("</div>") || ((String)text).contains("<i>") || ((String)text).contains("<b>") || ((String)text).contains("<u>") || ((String)text).contains("<strong>") || ((String)text).contains("<em>") || ((String)text).contains("<mark>") || ((String)text).contains("<small>") || ((String)text).contains("<del>") || ((String)text).contains("<ins>") || ((String)text).contains("<sub>") || ((String)text).contains("<sup>"))) {
            text = "<html>" + (String)text + "</html>";
        }
        return text;
    }

    public static String getPathWithClosingSlash(String path) {
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        return path;
    }
}

