/*
 * Decompiled with CFR 0.152.
 */
package net.davidashen.util;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Hashtable
extends Dictionary
implements Cloneable {
    private Object[] table;
    private int halfTableLength;
    private int used;
    private int usedLimit;
    private static final int INIT_SIZE = 1;
    private static final float LOAD_FACTOR = 0.5f;

    private final int nextIndex(int i) {
        return i == 0 ? this.halfTableLength - 1 : i - 1;
    }

    private final int firstIndex(Object key) {
        return key.hashCode() & this.halfTableLength - 1;
    }

    public Hashtable() {
        this(1);
    }

    public Hashtable(int n) {
        n = (int)((float)(n + 1) / 0.5f);
        this.halfTableLength = 1;
        while (this.halfTableLength < n) {
            this.halfTableLength <<= 1;
        }
        this.table = new Object[this.halfTableLength << 1];
        this.usedLimit = (int)((float)n * 0.5f);
    }

    public final int size() {
        return this.used;
    }

    public final boolean isEmpty() {
        return this.used == 0;
    }

    public final Object get(Object key) {
        if (this.used != 0) {
            int i = this.firstIndex(key);
            while (this.table[i] != null) {
                if (this.table[i].equals(key)) {
                    return this.table[i | this.halfTableLength];
                }
                i = this.nextIndex(i);
            }
        }
        return null;
    }

    public final boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public final Object put(Object key, Object value) {
        int h = this.firstIndex(key);
        while (this.table[h] != null) {
            if (key.equals(this.table[h])) {
                Object tem = this.table[h |= this.halfTableLength];
                this.table[h] = value;
                return tem;
            }
            h = this.nextIndex(h);
        }
        if (this.used >= this.usedLimit) {
            this.halfTableLength = this.table.length;
            this.usedLimit = (int)((float)this.halfTableLength * 0.5f);
            Object[] oldTable = this.table;
            this.table = new Object[this.halfTableLength << 1];
            int i = oldTable.length >> 1;
            while (i > 0) {
                if (oldTable[--i] == null) continue;
                int j = this.firstIndex(oldTable[i]);
                while (this.table[j] != null) {
                    j = this.nextIndex(j);
                }
                this.table[j] = oldTable[i];
                this.table[j | this.halfTableLength] = oldTable[i + (oldTable.length >> 1)];
            }
            h = this.firstIndex(key);
            while (this.table[h] != null) {
                h = this.nextIndex(h);
            }
        }
        ++this.used;
        this.table[h] = key;
        this.table[h | this.halfTableLength] = value;
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        try {
            void e;
            Hashtable other = (Hashtable)super.clone();
            other.table = new Object[this.table.length];
            System.arraycopy(this.table, 0, other.table, 0, this.table.length);
            return e;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public final Enumeration keys() {
        return new Enumerator(this.table, 0);
    }

    public final Enumeration elements() {
        return new Enumerator(this.table, this.halfTableLength);
    }

    public final Object remove(Object key) {
        if (this.used > 0) {
            int i = this.firstIndex(key);
            while (this.table[i] != null) {
                if (this.table[i].equals(key)) {
                    Object obj = this.table[i | this.halfTableLength];
                    do {
                        int r;
                        this.table[i] = null;
                        this.table[i | this.halfTableLength] = null;
                        int j = i;
                        while (this.table[i = this.nextIndex(i)] != null && (i <= (r = this.firstIndex(this.table[i])) && r < j || r < j && j < i || j < i && i <= r)) {
                        }
                        this.table[j] = this.table[i];
                        this.table[j | this.halfTableLength] = this.table[i | this.halfTableLength];
                    } while (this.table[i] != null);
                    --this.used;
                    return obj;
                }
                i = this.nextIndex(i);
            }
        }
        return null;
    }

    public final void clear() {
        int i = this.halfTableLength;
        while (--i >= 0) {
            this.table[i] = null;
            this.table[i | this.halfTableLength] = null;
        }
        this.used = 0;
    }

    private static class Enumerator
    implements Enumeration {
        private final Object[] table;
        private final int add;
        private int i;

        Enumerator(Object[] table, int add) {
            this.table = table;
            this.add = add;
            if (table == null) {
                this.i = -1;
            } else {
                this.i = table.length >> 1;
                while (--this.i >= 0 && table[this.i] == null) {
                }
            }
        }

        public boolean hasMoreElements() {
            return this.i >= 0;
        }

        public Object nextElement() {
            if (this.i < 0) {
                throw new NoSuchElementException();
            }
            Object tem = this.table[this.i + this.add];
            while (--this.i >= 0 && this.table[this.i] == null) {
            }
            return tem;
        }
    }
}

