/*
 * Decompiled with CFR 0.152.
 */
package compat;

import compat.PersonaCompatListener;
import devplugin.Version;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import tvbrowser.TVBrowser;

public final class PersonaCompat {
    private static PersonaCompat INSTANCE;
    private static Object PERSONA_OBJECT;
    private ArrayList<PersonaCompatListener> mListPersonaListeners;

    private PersonaCompat() {
        INSTANCE = this;
        PERSONA_OBJECT = null;
        this.mListPersonaListeners = new ArrayList();
        if (this.isSupported()) {
            try {
                Method m = Class.forName("util.ui.persona.Persona").getDeclaredMethod("getInstance", new Class[0]);
                PERSONA_OBJECT = m.invoke(null, new Object[0]);
                Class<?> personaListenerClass = Class.forName("util.ui.persona.PersonaListener");
                Method addPersonaListener = PERSONA_OBJECT.getClass().getDeclaredMethod("registerPersonaListener", personaListenerClass);
                Object personaListener = Proxy.newProxyInstance(personaListenerClass.getClassLoader(), new Class[]{personaListenerClass}, (InvocationHandler)new HandlerPersonaListener(this));
                addPersonaListener.invoke(PERSONA_OBJECT, personaListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static synchronized PersonaCompat getInstance() {
        if (INSTANCE == null) {
            new PersonaCompat();
        }
        return INSTANCE;
    }

    public boolean isSupported() {
        return TVBrowser.VERSION.compareTo(new Version(3, 10, true)) >= 0;
    }

    public void registerPersonaListener(PersonaCompatListener listener) {
        if (this.mListPersonaListeners.contains(listener)) {
            this.mListPersonaListeners.add(listener);
        }
    }

    public void removePersonaListener(PersonaCompatListener listener) {
        this.mListPersonaListeners.remove(listener);
    }

    public static Color testPersonaForegroundAgainst(Color c) {
        Color result = null;
        if (PERSONA_OBJECT != null) {
            result = (Color)PersonaCompat.invoke("testPersonaForegroundAgainst", new Class[]{Color.class}, c);
        }
        if (result == null) {
            double test = 0.2126 * (double)PersonaCompat.getInstance().getTextColor().getRed() + 0.7152 * (double)PersonaCompat.getInstance().getTextColor().getGreen() + 0.0722 * (double)PersonaCompat.getInstance().getTextColor().getBlue();
            int alpha = 100;
            if (test <= 30.0) {
                c = Color.white;
                alpha = 200;
            } else if (test <= 40.0) {
                c = c.brighter().brighter().brighter().brighter().brighter().brighter();
                alpha = 200;
            } else if (test <= 60.0) {
                c = c.brighter().brighter().brighter();
                alpha = 160;
            } else if (test <= 100.0) {
                c = c.brighter().brighter();
                alpha = 140;
            } else if (test <= 145.0) {
                alpha = 120;
            } else if (test <= 170.0) {
                c = c.darker();
                alpha = 120;
            } else if (test <= 205.0) {
                c = c.darker().darker();
                alpha = 120;
            } else if (test <= 220.0) {
                c = c.darker().darker().darker();
                alpha = 100;
            } else if (test <= 235.0) {
                c = c.darker().darker().darker().darker();
                alpha = 100;
            } else {
                c = Color.black;
                alpha = 100;
            }
            result = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
        }
        return result;
    }

    public BufferedImage getHeaderImage() {
        return (BufferedImage)PersonaCompat.invoke("getHeaderImage");
    }

    public BufferedImage getFooterImage() {
        return (BufferedImage)PersonaCompat.invoke("getFooterImage");
    }

    public Color getTextColor() {
        return (Color)PersonaCompat.invoke("getTextColor");
    }

    public Color getShadowColor() {
        return (Color)PersonaCompat.invoke("getShadowColor");
    }

    public Color getAccentColor() {
        return (Color)PersonaCompat.invoke("getAccentColor");
    }

    private void handlePersonaUpdate() {
        for (PersonaCompatListener l : this.mListPersonaListeners) {
            l.updatePersona();
        }
    }

    private static Object invoke(String methodName) {
        return PersonaCompat.invoke(methodName, null, new Object[0]);
    }

    private static Object invoke(String methodName, Class<?>[] clazz, Object ... parameters) {
        Object result = null;
        if (PERSONA_OBJECT != null) {
            try {
                Method m = PERSONA_OBJECT.getClass().getDeclaredMethod(methodName, clazz);
                result = m.invoke(PERSONA_OBJECT, parameters);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private static final class HandlerPersonaListener
    implements InvocationHandler {
        private PersonaCompat mPersonaCompat;

        private HandlerPersonaListener(PersonaCompat personaCompat) {
            this.mPersonaCompat = personaCompat;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method != null && (args == null || args.length == 0) && method.getName().equals("updatePersona")) {
                this.mPersonaCompat.handlePersonaUpdate();
            }
            return null;
        }
    }
}

