/*
 * Decompiled with CFR 0.152.
 */
package newsplugin;

import devplugin.ActionMenu;
import devplugin.Plugin;
import devplugin.PluginInfo;
import devplugin.Version;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import newsplugin.News;
import newsplugin.NewsDialog;
import newsplugin.NewsList;
import util.io.IOUtilities;
import util.ui.Localizer;

public class NewsPlugin
extends Plugin {
    private static final Version mVersion = new Version(3, 18);
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(NewsPlugin.class);
    private static final String NEWS_URL = "http://download.tvbrowser.org/newsplugin/static-news.xml";
    private static int MAX_NEWS_AGE = 90;
    private NewsList mNewsList = new NewsList();
    private static NewsPlugin mInstance;
    private boolean hasRightToDownload = false;
    private NewsDialog mNewsDialog;
    private long mNoConnectionTime = 0L;
    private long mLastNewsFileModified = 0L;
    private PluginInfo mPluginInfo;
    private boolean mShowOnlyNew = true;
    private int mSelectedNewsTypeIndex = 0;

    public NewsPlugin() {
        mInstance = this;
    }

    public static NewsPlugin getInstance() {
        return mInstance;
    }

    public void handleTvBrowserStartFinished() {
        this.hasRightToDownload = true;
    }

    public ActionMenu getButtonAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (NewsPlugin.this.mNewsDialog == null || !NewsPlugin.this.mNewsDialog.isVisible()) {
                    NewsPlugin.this.mNewsDialog = new NewsDialog(NewsPlugin.this.getParentFrame(), NewsPlugin.this.mNewsList.getList(), -1, NewsPlugin.this.mShowOnlyNew, NewsPlugin.this.mSelectedNewsTypeIndex);
                    NewsPlugin.this.mNewsDialog.show();
                }
            }
        };
        action.putValue("Name", mLocalizer.msg("news", "News"));
        action.putValue("SmallIcon", this.createImageIcon("apps", "internet-news-reader", 16));
        action.putValue("BigIcon", this.createImageIcon("apps", "internet-news-reader", 22));
        action.putValue("ShortDescription", this.getInfo().getDescription());
        return new ActionMenu((Action)action);
    }

    public static Version getVersion() {
        return mVersion;
    }

    public PluginInfo getInfo() {
        if (this.mPluginInfo == null) {
            String name = mLocalizer.msg("news", "News");
            String desc = mLocalizer.msg("description", "Gets the TV-Browser news after each TV data update.");
            String author = "Til Schneider, www.murfman.de";
            this.mPluginInfo = new PluginInfo(NewsPlugin.class, name, desc, author);
        }
        return this.mPluginInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleTvDataUpdateFinished() {
        long currentTime = System.currentTimeMillis();
        if (!this.hasRightToDownload || this.mNoConnectionTime >= currentTime || !NewsPlugin.getPluginManager().getTvBrowserSettings().getLastDownloadDate().equals((Object)devplugin.Date.getCurrentDate())) return;
        int serverWaitDays = -1;
        try {
            long lastNews = this.mNewsList.getLastNewsTime(this.mLastNewsFileModified);
            URL url = new URL(NEWS_URL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setIfModifiedSince(this.mLastNewsFileModified);
            conn.connect();
            if (conn.getResponseCode() != 304) {
                this.mLastNewsFileModified = conn.getLastModified();
                byte[] newsData = IOUtilities.loadFileFromHttpServer((URL)url, (int)60000);
                String news = new String(newsData, "ISO-8859-1");
                if (news.startsWith("<?xml version=\"1.0\" ")) {
                    News[] newsArr = this.parseNews(news);
                    int addCount = 0;
                    News[] newsArray = newsArr;
                    int n = newsArr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        News element = newsArray[n2];
                        if (element.getTime().getTime() - lastNews > 5000L) {
                            this.mNewsList.add(element);
                            ++addCount;
                        }
                        ++n2;
                    }
                    if (addCount > 0) {
                        final int newNewsCount = addCount;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                NewsDialog dlg = new NewsDialog(NewsPlugin.this.getParentFrame(), NewsPlugin.this.mNewsList.getList(), newNewsCount, NewsPlugin.this.mShowOnlyNew, NewsPlugin.this.mSelectedNewsTypeIndex);
                                if (dlg.hasNews()) {
                                    dlg.show();
                                }
                            }
                        });
                    }
                    serverWaitDays = this.getServerNoConnectionDays(news);
                } else {
                    if (!news.startsWith("No news available")) throw new IOException("News script returned error: " + news);
                    serverWaitDays = this.getServerNoConnectionDays(news);
                }
            } else {
                serverWaitDays = this.getServerNoConnectionDays("");
            }
        }
        catch (Exception lastNews) {
            // empty catch block
        }
        long randomNoConnectionTime = (long)((1.0 + Math.random() * 2.0) * 24.0 * 60.0 * 60.0 * 1000.0) + currentTime;
        long serverNoConnectionTime = (long)serverWaitDays * 24L * 60L * 60L * 1000L + currentTime;
        this.mNoConnectionTime = Math.max(randomNoConnectionTime, serverNoConnectionTime);
    }

    private int getServerNoConnectionDays(String news) {
        try {
            int index1 = news.indexOf("<noconnection days");
            int index2 = news.indexOf("<noconnection date");
            if (index1 != -1) {
                int startPos = news.indexOf(34, index1) + 1;
                int endPos = news.indexOf(34, startPos);
                return Integer.parseInt(news.substring(startPos, endPos));
            }
            if (index2 != -1) {
                int startPos = news.indexOf(34, index1) + 1;
                int endPos = news.indexOf(34, startPos);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                long value = format.parse(news.substring(startPos, endPos)).getTime();
                value -= System.currentTimeMillis();
                return (int)(value /= 86400000L) + 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private News[] parseNews(String news) {
        String regex = "<news date=\"([^\"]*)\" author=\"([^\"]*)\" type=\"([^\"]*)\">\\s*<title>([^<]*)</title>\\s*<text>([^<]*)</text>";
        if (news.indexOf("<title-en>") != -1) {
            regex = String.valueOf(regex) + "\\s*<title-en>([^<]*)</title-en>\\s*<text-en>([^<]*)</text-en>";
        }
        Matcher matcher = Pattern.compile(regex).matcher(news);
        ArrayList<News> list = new ArrayList<News>();
        int lastPos = 0;
        while (matcher.find(lastPos)) {
            String dateAsString = matcher.group(1);
            String author = matcher.group(2);
            String type = matcher.group(3);
            String title = matcher.group(4);
            String text = matcher.group(5);
            String engTitle = null;
            String engText = null;
            if (matcher.groupCount() > 5) {
                engTitle = matcher.group(6);
                engText = matcher.group(7);
            }
            Calendar cal = Calendar.getInstance();
            cal.set(1, Integer.parseInt(dateAsString.substring(0, 4)));
            cal.set(2, Integer.parseInt(dateAsString.substring(5, 7)) - 1);
            cal.set(5, Integer.parseInt(dateAsString.substring(8, 10)));
            cal.set(11, Integer.parseInt(dateAsString.substring(11, 13)));
            cal.set(12, Integer.parseInt(dateAsString.substring(14, 16)));
            cal.set(13, Integer.parseInt(dateAsString.substring(17, 19)));
            Date date = cal.getTime();
            list.add(new News(date, author, type, title, text, engTitle, engText));
            lastPos = matcher.end();
        }
        News[] newsArr = new News[list.size()];
        list.toArray(newsArr);
        return newsArr;
    }

    public void writeData(ObjectOutputStream out) throws IOException {
        out.writeInt(4);
        out.writeInt(this.mNewsList.getList().size());
        int i = 0;
        while (i < this.mNewsList.getList().size()) {
            News news = this.mNewsList.getList().get(i);
            news.writeData(out);
            ++i;
        }
        out.writeLong(this.mNoConnectionTime);
        out.writeLong(this.mLastNewsFileModified);
        out.writeBoolean(this.mShowOnlyNew);
        out.writeInt(this.mSelectedNewsTypeIndex);
    }

    public void readData(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        int size = in.readInt();
        this.mNewsList.getList().clear();
        this.mNewsList.getList().ensureCapacity(size);
        Date deadline = new Date(System.currentTimeMillis() - (long)MAX_NEWS_AGE * 24L * 60L * 60L * 1000L);
        int i = 0;
        while (i < size) {
            News news = News.readData(in, version);
            if (news.getTime().after(deadline)) {
                this.mNewsList.add(news);
            }
            ++i;
        }
        if (version >= 2) {
            this.mNoConnectionTime = in.readLong();
        }
        if (version >= 3) {
            this.mLastNewsFileModified = in.readLong();
        }
        if (version >= 4) {
            this.mShowOnlyNew = in.readBoolean();
            this.mSelectedNewsTypeIndex = in.readInt();
        }
    }

    public boolean saveMeInternal(boolean save, boolean showOnlyNew, int newsTypeIndex) {
        if (save) {
            this.mShowOnlyNew = showOnlyNew;
            this.mSelectedNewsTypeIndex = newsTypeIndex;
        }
        return super.saveMe();
    }

    public String getPluginCategory() {
        return "misc";
    }
}

