/*

Copyright (C) 2001  Gopal Narayanan <gopal@astro.umass.edu>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

*/

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>

#include "transcalc.h"
#include "body.h"


/* callback function for changing the type of transmission line */
void 
transtype (GtkWidget *widget, gpointer parent)
{
  const gchar *text;

  /*  if ((text = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO(transtype_combo)->entry))) != 
      NULL)*/
  if ((text = gtk_entry_get_text (GTK_ENTRY (widget))) != NULL)
    {
      if ((strcmp(text,"Microstrip")) == 0) {
	current_transtype = MICROSTRIP;
	microstrip_win (parent);
      } else if ((strcmp(text,"Rectangular Waveguide")) == 0) {
	current_transtype = RECTWAVEGUIDE;
	rectwaveguide_win (parent);
      } else if ((strcmp(text,"Coaxial Line")) == 0) {
	current_transtype = COAX;
	coax_win (parent);
      } else if ((strcmp(text,"Coupled Microstrip")) == 0) {
	current_transtype = C_MICROSTRIP;
	c_microstrip_win (parent);
      }/* else {
	fprintf(stderr, "transtype(): unknown transmission line type!\n");
      }
       */
    }
}

/*
 * returns integer value that indicates the type of transmission line
 */

short 
transtype_int ()
{
  const gchar *text;
  
  if ((text = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO(transtype_combo)->entry))) != NULL) {
    if ((strcmp(text,"Microstrip")) == 0) return MICROSTRIP;
    if ((strcmp(text,"Rectangular Waveguide")) == 0) return RECTWAVEGUIDE;
    if ((strcmp(text,"Coaxial Line")) == 0) return COAX;
    if ((strcmp(text,"Coupled Microstrip")) == 0) return C_MICROSTRIP;
    return (-1); /* error */
  }
  return (-1); /* error */
}


/* setup_body.c by Gopal Narayanan
 * This file contains the program that builds the main body
 * everything happens here
 */

/*GtkWidget *setup_body (GtkWidget *parent)*/
GtkWidget 
*setup_body (trans_gui *tg)
{

  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *frame;
  GList *glist = NULL;
  /*  trans_win *twin;*/

  /* g_print("Inside body\n"); */

 
  /* Add a vbox and hbox to start the packing */
  vbox = gtk_vbox_new (FALSE, 5);
  hbox = gtk_hbox_new (FALSE, 5);

  
  /* pack these in the parent window */
  /*  gtk_container_add (GTK_CONTAINER (tg->vertbox), hbox);*/
  gtk_box_pack_start (GTK_BOX (tg->vertbox), vbox, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

  frame = gtk_frame_new ("Transmission Line Type");

  transtype_combo = gtk_combo_new ();
  gtk_widget_set_usize (GTK_WIDGET (transtype_combo), 200, -1);

  /* set the transtype_combo GList */
  glist = g_list_append(glist, "Microstrip");
  glist = g_list_append(glist, "Rectangular Waveguide");
  glist = g_list_append(glist, "Coaxial Line");
  glist = g_list_append(glist, "Coupled Microstrip");
  /*      glist = g_list_append(glist, "Stripline");*/


  gtk_combo_set_popdown_strings (GTK_COMBO (transtype_combo), glist);

  /* Now we can free the glist from memory */
  g_list_free (glist);
  
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (transtype_combo)->entry),
		      "Microstrip");

  /* make the combo entry box uneditable*/
  gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (transtype_combo)->entry), FALSE);

  /* hook it upto a callback function to sense when a change has occured */
  gtk_signal_connect (GTK_OBJECT (GTK_COMBO (transtype_combo)->entry), 
			     "changed", GTK_SIGNAL_FUNC (transtype),
			     (gpointer) vbox);
  /*			     GTK_OBJECT (tg->vertbox));*/

  /* add the combo box to frame */
  gtk_container_add (GTK_CONTAINER (frame), transtype_combo);
  gtk_box_pack_start (GTK_BOX (hbox), frame, FALSE, TRUE, 0);

  gtk_widget_show (transtype_combo);
  gtk_widget_show (frame);
  gtk_widget_show (hbox);

  gtk_widget_show (vbox);

  current_transtype = MICROSTRIP;
  transtype(GTK_WIDGET (GTK_ENTRY (GTK_COMBO (transtype_combo)->entry)), tg->vertbox);
  /*  transtype(vbox);*/
    /*microstrip_win (tg); */

  /*  current_transtype = RECTWAVEGUIDE;
      rectwaveguide_win (tg); */

  return vbox;
  /*return twin;*/
}




