/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.Pointcut;

public class PerObjectInterfaceTypeMunger
extends ResolvedTypeMunger {
    private ResolvedMember getMethod;
    private ResolvedMember setMethod;
    private TypeX aspectType;
    private TypeX interfaceType;
    private Pointcut testPointcut;

    public PerObjectInterfaceTypeMunger(TypeX aspectType, Pointcut testPointcut) {
        super(ResolvedTypeMunger.PerObjectInterface, null);
        this.aspectType = aspectType;
        this.testPointcut = testPointcut;
        this.interfaceType = AjcMemberMaker.perObjectInterfaceType(aspectType);
        this.getMethod = AjcMemberMaker.perObjectInterfaceGet(aspectType);
        this.setMethod = AjcMemberMaker.perObjectInterfaceSet(aspectType);
    }

    public void write(DataOutputStream s) throws IOException {
        throw new RuntimeException("shouldn't be serialized");
    }

    public TypeX getAspectType() {
        return this.aspectType;
    }

    public ResolvedMember getGetMethod() {
        return this.getMethod;
    }

    public TypeX getInterfaceType() {
        return this.interfaceType;
    }

    public ResolvedMember getSetMethod() {
        return this.setMethod;
    }

    public Pointcut getTestPointcut() {
        return this.testPointcut;
    }

    public boolean matches(ResolvedTypeX matchType, ResolvedTypeX aspectType) {
        return !matchType.isInterface() && !matchType.isAnnotationStyleAspect();
    }

    private FuzzyBoolean isWithinType(ResolvedTypeX type) {
        return this.testPointcut.fastMatch(new FastMatchInfo(type, null));
    }
}

