package main

import (
	"flag"
	"log"
	"os"
	"path/filepath"
	"strings"
	"text/template"
)

const tTmpl = `// Code generated by generator. DO NOT EDIT.

package {{$.Name}}

import (
	"context"
	"testing"
)

{{range .Receivers -}}
// -----------------------------
{{if eq . "" -}}
// Free functions
{{else -}}
// Methods of helper type
type helperType struct{}
{{end -}}
// -----------------------------

func {{.}}nonTestHelper({{$.Name}} int) {}

func {{.}}helperWithoutHelper({{$.Name}} {{$.Testing}}.{{$.UName}}) {} {{if or (eq $.Check "") (eq $.Check "begin")}}// want "test helper function should start from {{$.Name}}.Helper()"{{end}}

func {{.}}helperWithHelper({{$.Name}} {{$.Testing}}.{{$.UName}}) {
	{{$.Name}}.Helper()
}

func {{.}}helperWithEmptyStringBeforeHelper({{$.Name}} {{$.Testing}}.{{$.UName}}) {

	{{$.Name}}.Helper()
}

func {{.}}helperWithHelperAfterAssignment({{$.Name}} {{$.Testing}}.{{$.UName}}) { {{if or (eq $.Check "") (eq $.Check "begin")}}// want "test helper function should start from {{$.Name}}.Helper()"{{end}}
	_ = 0
	{{$.Name}}.Helper()
}

func {{.}}helperWithHelperAfterOtherCall({{$.Name}} {{$.Testing}}.{{$.UName}}) { {{if or (eq $.Check "") (eq $.Check "begin")}}// want "test helper function should start from {{$.Name}}.Helper()"{{end}}
	f()
	{{$.Name}}.Helper()
}

func {{.}}helperWithHelperAfterOtherSelectionCall({{$.Name}} {{$.Testing}}.{{$.UName}}) { {{if or (eq $.Check "") (eq $.Check "begin")}}// want "test helper function should start from {{$.Name}}.Helper()"{{end}}
	{{$.Name}}.Fail()
	{{$.Name}}.Helper()
}

func {{.}}helperParamNotFirst(s string, i int, {{$.Name}} {{$.Testing}}.{{$.UName}}) { {{if or (eq $.Check "") (eq $.Check "first")}}// want "parameter {{$.TestingComment}}.{{$.UName}} should be the first or after context.Context"{{end}}
	{{$.Name}}.Helper()
}

func {{.}}helperParamSecondWithoutContext(s string, {{$.Name}} {{$.Testing}}.{{$.UName}}, i int) { {{if or (eq $.Check "") (eq $.Check "first")}}// want "parameter {{$.TestingComment}}.{{$.UName}} should be the first or after context.Context"{{end}}
	{{$.Name}}.Helper()
}

func {{.}}helperParamSecondWithContext(ctx context.Context, {{$.Name}} {{$.Testing}}.{{$.UName}}) {
	{{$.Name}}.Helper()
}

func {{.}}helperWithIncorrectName(o {{$.Testing}}.{{$.UName}}) { {{if or (eq $.Check "") (eq $.Check "name")}}// want "parameter {{$.TestingComment}}.{{$.UName}} should have name {{$.Name}}"{{end}}
	o.Helper()
}

func {{.}}helperWithAnonymousHelper({{$.Name}} {{$.Testing}}.{{$.UName}}) {
	{{$.Name}}.Helper()
	func({{$.Name}} {{$.Testing}}.{{$.UName}}) {}({{$.Name}}) {{if or (eq $.Check "") (eq $.Check "begin")}}// want "test helper function should start from {{$.Name}}.Helper()"{{end}}
}

func {{.}}helperWithNoName(_ {{$.Testing}}.{{$.UName}}) {
}

{{end -}}

func f() {}
`

func main() {
	var name, path, check string
	var isInterface bool

	flag.StringVar(&name, "name", "", "")
	flag.StringVar(&path, "path", "", "")
	flag.StringVar(&check, "check", "", "")
	flag.BoolVar(&isInterface, "interface", false, "")
	flag.Parse()

	if name == "" || path == "" {
		log.Fatal("name and path must be specified")
	}

	if check != "" {
		path = filepath.Join(path, name+"_"+check)
	} else {
		path = filepath.Join(path, name)
	}
	if err := os.MkdirAll(path, 0755); err != nil {
		log.Fatalf("failed to create path %q: %v", path, err)
	}

	tmpl, err := template.New(name).Parse(tTmpl)
	if err != nil {
		log.Fatalf("failed to parse template: %v", err)
	}

	filePath := filepath.Join(path, name+".go")
	f, err := os.Create(filePath)
	if err != nil {
		log.Fatalf("failed to create file %q: %v", filePath, err)
	}
	if err := os.MkdirAll(path, 0600); err != nil {
		log.Fatalf("failed to create directory %q: %v", path, err)
	}

	testingStr := "*testing"
	testingComment := `\\*testing`
	if isInterface {
		testingStr = "testing"
		testingComment = "testing"
	}
	data := struct {
		Receivers      []string
		Name           string
		UName          string
		Check          string
		Testing        string
		TestingComment string
	}{
		Receivers:      []string{"", "(h helperType) "},
		Name:           name,
		UName:          strings.ToUpper(name),
		Check:          check,
		Testing:        testingStr,
		TestingComment: testingComment,
	}
	if err := tmpl.Execute(f, &data); err != nil {
		log.Fatalf("failed to execute template: %v", err)
	}
}
