// Code generated by github.com/Khan/genqlient, DO NOT EDIT.

package integration

import (
	"context"
	"encoding/json"
	"fmt"
	"time"

	"github.com/Khan/genqlient/graphql"
	"github.com/Khan/genqlient/internal/testutil"
)

// AnimalFields includes the GraphQL fields of Animal requested by the fragment AnimalFields.
type AnimalFields struct {
	Id    string                     `json:"id"`
	Hair  AnimalFieldsHairBeingsHair `json:"hair"`
	Owner AnimalFieldsOwnerBeing     `json:"-"`
}

// GetId returns AnimalFields.Id, and is useful for accessing the field via an interface.
func (v *AnimalFields) GetId() string { return v.Id }

// GetHair returns AnimalFields.Hair, and is useful for accessing the field via an interface.
func (v *AnimalFields) GetHair() AnimalFieldsHairBeingsHair { return v.Hair }

// GetOwner returns AnimalFields.Owner, and is useful for accessing the field via an interface.
func (v *AnimalFields) GetOwner() AnimalFieldsOwnerBeing { return v.Owner }

func (v *AnimalFields) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*AnimalFields
		Owner json.RawMessage `json:"owner"`
		graphql.NoUnmarshalJSON
	}
	firstPass.AnimalFields = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	{
		dst := &v.Owner
		src := firstPass.Owner
		if len(src) != 0 && string(src) != "null" {
			err = __unmarshalAnimalFieldsOwnerBeing(
				src, dst)
			if err != nil {
				return fmt.Errorf(
					"unable to unmarshal AnimalFields.Owner: %w", err)
			}
		}
	}
	return nil
}

type __premarshalAnimalFields struct {
	Id string `json:"id"`

	Hair AnimalFieldsHairBeingsHair `json:"hair"`

	Owner json.RawMessage `json:"owner"`
}

func (v *AnimalFields) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *AnimalFields) __premarshalJSON() (*__premarshalAnimalFields, error) {
	var retval __premarshalAnimalFields

	retval.Id = v.Id
	retval.Hair = v.Hair
	{

		dst := &retval.Owner
		src := v.Owner
		var err error
		*dst, err = __marshalAnimalFieldsOwnerBeing(
			&src)
		if err != nil {
			return nil, fmt.Errorf(
				"unable to marshal AnimalFields.Owner: %w", err)
		}
	}
	return &retval, nil
}

// AnimalFieldsHairBeingsHair includes the requested fields of the GraphQL type BeingsHair.
type AnimalFieldsHairBeingsHair struct {
	HasHair bool `json:"hasHair"`
}

// GetHasHair returns AnimalFieldsHairBeingsHair.HasHair, and is useful for accessing the field via an interface.
func (v *AnimalFieldsHairBeingsHair) GetHasHair() bool { return v.HasHair }

// AnimalFieldsOwnerAnimal includes the requested fields of the GraphQL type Animal.
type AnimalFieldsOwnerAnimal struct {
	Typename string `json:"__typename"`
	Id       string `json:"id"`
}

// GetTypename returns AnimalFieldsOwnerAnimal.Typename, and is useful for accessing the field via an interface.
func (v *AnimalFieldsOwnerAnimal) GetTypename() string { return v.Typename }

// GetId returns AnimalFieldsOwnerAnimal.Id, and is useful for accessing the field via an interface.
func (v *AnimalFieldsOwnerAnimal) GetId() string { return v.Id }

// AnimalFieldsOwnerBeing includes the requested fields of the GraphQL interface Being.
//
// AnimalFieldsOwnerBeing is implemented by the following types:
// AnimalFieldsOwnerAnimal
// AnimalFieldsOwnerUser
type AnimalFieldsOwnerBeing interface {
	implementsGraphQLInterfaceAnimalFieldsOwnerBeing()
	// GetTypename returns the receiver's concrete GraphQL type-name (see interface doc for possible values).
	GetTypename() string
	// GetId returns the interface-field "id" from its implementation.
	GetId() string
}

func (v *AnimalFieldsOwnerAnimal) implementsGraphQLInterfaceAnimalFieldsOwnerBeing() {}
func (v *AnimalFieldsOwnerUser) implementsGraphQLInterfaceAnimalFieldsOwnerBeing()   {}

func __unmarshalAnimalFieldsOwnerBeing(b []byte, v *AnimalFieldsOwnerBeing) error {
	if string(b) == "null" {
		return nil
	}

	var tn struct {
		TypeName string `json:"__typename"`
	}
	err := json.Unmarshal(b, &tn)
	if err != nil {
		return err
	}

	switch tn.TypeName {
	case "Animal":
		*v = new(AnimalFieldsOwnerAnimal)
		return json.Unmarshal(b, *v)
	case "User":
		*v = new(AnimalFieldsOwnerUser)
		return json.Unmarshal(b, *v)
	case "":
		return fmt.Errorf(
			"response was missing Being.__typename")
	default:
		return fmt.Errorf(
			`unexpected concrete type for AnimalFieldsOwnerBeing: "%v"`, tn.TypeName)
	}
}

func __marshalAnimalFieldsOwnerBeing(v *AnimalFieldsOwnerBeing) ([]byte, error) {

	var typename string
	switch v := (*v).(type) {
	case *AnimalFieldsOwnerAnimal:
		typename = "Animal"

		result := struct {
			TypeName string `json:"__typename"`
			*AnimalFieldsOwnerAnimal
		}{typename, v}
		return json.Marshal(result)
	case *AnimalFieldsOwnerUser:
		typename = "User"

		premarshaled, err := v.__premarshalJSON()
		if err != nil {
			return nil, err
		}
		result := struct {
			TypeName string `json:"__typename"`
			*__premarshalAnimalFieldsOwnerUser
		}{typename, premarshaled}
		return json.Marshal(result)
	case nil:
		return []byte("null"), nil
	default:
		return nil, fmt.Errorf(
			`unexpected concrete type for AnimalFieldsOwnerBeing: "%T"`, v)
	}
}

// AnimalFieldsOwnerUser includes the requested fields of the GraphQL type User.
type AnimalFieldsOwnerUser struct {
	Typename        string `json:"__typename"`
	Id              string `json:"id"`
	UserFields      `json:"-"`
	LuckyFieldsUser `json:"-"`
}

// GetTypename returns AnimalFieldsOwnerUser.Typename, and is useful for accessing the field via an interface.
func (v *AnimalFieldsOwnerUser) GetTypename() string { return v.Typename }

// GetId returns AnimalFieldsOwnerUser.Id, and is useful for accessing the field via an interface.
func (v *AnimalFieldsOwnerUser) GetId() string { return v.Id }

// GetLuckyNumber returns AnimalFieldsOwnerUser.LuckyNumber, and is useful for accessing the field via an interface.
func (v *AnimalFieldsOwnerUser) GetLuckyNumber() int { return v.LuckyFieldsUser.LuckyNumber }

// GetHair returns AnimalFieldsOwnerUser.Hair, and is useful for accessing the field via an interface.
func (v *AnimalFieldsOwnerUser) GetHair() MoreUserFieldsHair { return v.UserFields.MoreUserFields.Hair }

func (v *AnimalFieldsOwnerUser) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*AnimalFieldsOwnerUser
		graphql.NoUnmarshalJSON
	}
	firstPass.AnimalFieldsOwnerUser = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	err = json.Unmarshal(
		b, &v.UserFields)
	if err != nil {
		return err
	}
	err = json.Unmarshal(
		b, &v.LuckyFieldsUser)
	if err != nil {
		return err
	}
	return nil
}

type __premarshalAnimalFieldsOwnerUser struct {
	Typename string `json:"__typename"`

	Id string `json:"id"`

	LuckyNumber int `json:"luckyNumber"`

	Hair MoreUserFieldsHair `json:"hair"`
}

func (v *AnimalFieldsOwnerUser) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *AnimalFieldsOwnerUser) __premarshalJSON() (*__premarshalAnimalFieldsOwnerUser, error) {
	var retval __premarshalAnimalFieldsOwnerUser

	retval.Typename = v.Typename
	retval.Id = v.Id
	retval.LuckyNumber = v.LuckyFieldsUser.LuckyNumber
	retval.Hair = v.UserFields.MoreUserFields.Hair
	return &retval, nil
}

// FriendsFields includes the GraphQL fields of User requested by the fragment FriendsFields.
type FriendsFields struct {
	Id   string `json:"id"`
	Name string `json:"name"`
}

// GetId returns FriendsFields.Id, and is useful for accessing the field via an interface.
func (v *FriendsFields) GetId() string { return v.Id }

// GetName returns FriendsFields.Name, and is useful for accessing the field via an interface.
func (v *FriendsFields) GetName() string { return v.Name }

// InnerBeingFields includes the GraphQL fields of Being requested by the fragment InnerBeingFields.
//
// InnerBeingFields is implemented by the following types:
// InnerBeingFieldsAnimal
// InnerBeingFieldsUser
type InnerBeingFields interface {
	implementsGraphQLInterfaceInnerBeingFields()
	// GetId returns the interface-field "id" from its implementation.
	GetId() string
	// GetName returns the interface-field "name" from its implementation.
	GetName() string
}

func (v *InnerBeingFieldsAnimal) implementsGraphQLInterfaceInnerBeingFields() {}
func (v *InnerBeingFieldsUser) implementsGraphQLInterfaceInnerBeingFields()   {}

func __unmarshalInnerBeingFields(b []byte, v *InnerBeingFields) error {
	if string(b) == "null" {
		return nil
	}

	var tn struct {
		TypeName string `json:"__typename"`
	}
	err := json.Unmarshal(b, &tn)
	if err != nil {
		return err
	}

	switch tn.TypeName {
	case "Animal":
		*v = new(InnerBeingFieldsAnimal)
		return json.Unmarshal(b, *v)
	case "User":
		*v = new(InnerBeingFieldsUser)
		return json.Unmarshal(b, *v)
	case "":
		return fmt.Errorf(
			"response was missing Being.__typename")
	default:
		return fmt.Errorf(
			`unexpected concrete type for InnerBeingFields: "%v"`, tn.TypeName)
	}
}

func __marshalInnerBeingFields(v *InnerBeingFields) ([]byte, error) {

	var typename string
	switch v := (*v).(type) {
	case *InnerBeingFieldsAnimal:
		typename = "Animal"

		result := struct {
			TypeName string `json:"__typename"`
			*InnerBeingFieldsAnimal
		}{typename, v}
		return json.Marshal(result)
	case *InnerBeingFieldsUser:
		typename = "User"

		result := struct {
			TypeName string `json:"__typename"`
			*InnerBeingFieldsUser
		}{typename, v}
		return json.Marshal(result)
	case nil:
		return []byte("null"), nil
	default:
		return nil, fmt.Errorf(
			`unexpected concrete type for InnerBeingFields: "%T"`, v)
	}
}

// InnerBeingFields includes the GraphQL fields of Animal requested by the fragment InnerBeingFields.
type InnerBeingFieldsAnimal struct {
	Id   string `json:"id"`
	Name string `json:"name"`
}

// GetId returns InnerBeingFieldsAnimal.Id, and is useful for accessing the field via an interface.
func (v *InnerBeingFieldsAnimal) GetId() string { return v.Id }

// GetName returns InnerBeingFieldsAnimal.Name, and is useful for accessing the field via an interface.
func (v *InnerBeingFieldsAnimal) GetName() string { return v.Name }

// InnerBeingFields includes the GraphQL fields of User requested by the fragment InnerBeingFields.
type InnerBeingFieldsUser struct {
	Id      string          `json:"id"`
	Name    string          `json:"name"`
	Friends []FriendsFields `json:"friends"`
}

// GetId returns InnerBeingFieldsUser.Id, and is useful for accessing the field via an interface.
func (v *InnerBeingFieldsUser) GetId() string { return v.Id }

// GetName returns InnerBeingFieldsUser.Name, and is useful for accessing the field via an interface.
func (v *InnerBeingFieldsUser) GetName() string { return v.Name }

// GetFriends returns InnerBeingFieldsUser.Friends, and is useful for accessing the field via an interface.
func (v *InnerBeingFieldsUser) GetFriends() []FriendsFields { return v.Friends }

// InnerLuckyFields includes the GraphQL fields of Lucky requested by the fragment InnerLuckyFields.
//
// InnerLuckyFields is implemented by the following types:
// InnerLuckyFieldsUser
type InnerLuckyFields interface {
	implementsGraphQLInterfaceInnerLuckyFields()
	// GetLuckyNumber returns the interface-field "luckyNumber" from its implementation.
	GetLuckyNumber() int
}

func (v *InnerLuckyFieldsUser) implementsGraphQLInterfaceInnerLuckyFields() {}

func __unmarshalInnerLuckyFields(b []byte, v *InnerLuckyFields) error {
	if string(b) == "null" {
		return nil
	}

	var tn struct {
		TypeName string `json:"__typename"`
	}
	err := json.Unmarshal(b, &tn)
	if err != nil {
		return err
	}

	switch tn.TypeName {
	case "User":
		*v = new(InnerLuckyFieldsUser)
		return json.Unmarshal(b, *v)
	case "":
		return fmt.Errorf(
			"response was missing Lucky.__typename")
	default:
		return fmt.Errorf(
			`unexpected concrete type for InnerLuckyFields: "%v"`, tn.TypeName)
	}
}

func __marshalInnerLuckyFields(v *InnerLuckyFields) ([]byte, error) {

	var typename string
	switch v := (*v).(type) {
	case *InnerLuckyFieldsUser:
		typename = "User"

		result := struct {
			TypeName string `json:"__typename"`
			*InnerLuckyFieldsUser
		}{typename, v}
		return json.Marshal(result)
	case nil:
		return []byte("null"), nil
	default:
		return nil, fmt.Errorf(
			`unexpected concrete type for InnerLuckyFields: "%T"`, v)
	}
}

// InnerLuckyFields includes the GraphQL fields of User requested by the fragment InnerLuckyFields.
type InnerLuckyFieldsUser struct {
	LuckyNumber int `json:"luckyNumber"`
}

// GetLuckyNumber returns InnerLuckyFieldsUser.LuckyNumber, and is useful for accessing the field via an interface.
func (v *InnerLuckyFieldsUser) GetLuckyNumber() int { return v.LuckyNumber }

// LuckyFields includes the GraphQL fields of Lucky requested by the fragment LuckyFields.
//
// LuckyFields is implemented by the following types:
// LuckyFieldsUser
type LuckyFields interface {
	implementsGraphQLInterfaceLuckyFields()
	// GetLuckyNumber returns the interface-field "luckyNumber" from its implementation.
	GetLuckyNumber() int
}

func (v *LuckyFieldsUser) implementsGraphQLInterfaceLuckyFields() {}

func __unmarshalLuckyFields(b []byte, v *LuckyFields) error {
	if string(b) == "null" {
		return nil
	}

	var tn struct {
		TypeName string `json:"__typename"`
	}
	err := json.Unmarshal(b, &tn)
	if err != nil {
		return err
	}

	switch tn.TypeName {
	case "User":
		*v = new(LuckyFieldsUser)
		return json.Unmarshal(b, *v)
	case "":
		return fmt.Errorf(
			"response was missing Lucky.__typename")
	default:
		return fmt.Errorf(
			`unexpected concrete type for LuckyFields: "%v"`, tn.TypeName)
	}
}

func __marshalLuckyFields(v *LuckyFields) ([]byte, error) {

	var typename string
	switch v := (*v).(type) {
	case *LuckyFieldsUser:
		typename = "User"

		premarshaled, err := v.__premarshalJSON()
		if err != nil {
			return nil, err
		}
		result := struct {
			TypeName string `json:"__typename"`
			*__premarshalLuckyFieldsUser
		}{typename, premarshaled}
		return json.Marshal(result)
	case nil:
		return []byte("null"), nil
	default:
		return nil, fmt.Errorf(
			`unexpected concrete type for LuckyFields: "%T"`, v)
	}
}

// LuckyFields includes the GraphQL fields of User requested by the fragment LuckyFields.
type LuckyFieldsUser struct {
	MoreUserFields `json:"-"`
	LuckyNumber    int `json:"luckyNumber"`
}

// GetLuckyNumber returns LuckyFieldsUser.LuckyNumber, and is useful for accessing the field via an interface.
func (v *LuckyFieldsUser) GetLuckyNumber() int { return v.LuckyNumber }

// GetId returns LuckyFieldsUser.Id, and is useful for accessing the field via an interface.
func (v *LuckyFieldsUser) GetId() string { return v.MoreUserFields.Id }

// GetHair returns LuckyFieldsUser.Hair, and is useful for accessing the field via an interface.
func (v *LuckyFieldsUser) GetHair() MoreUserFieldsHair { return v.MoreUserFields.Hair }

func (v *LuckyFieldsUser) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*LuckyFieldsUser
		graphql.NoUnmarshalJSON
	}
	firstPass.LuckyFieldsUser = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	err = json.Unmarshal(
		b, &v.MoreUserFields)
	if err != nil {
		return err
	}
	return nil
}

type __premarshalLuckyFieldsUser struct {
	LuckyNumber int `json:"luckyNumber"`

	Id string `json:"id"`

	Hair MoreUserFieldsHair `json:"hair"`
}

func (v *LuckyFieldsUser) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *LuckyFieldsUser) __premarshalJSON() (*__premarshalLuckyFieldsUser, error) {
	var retval __premarshalLuckyFieldsUser

	retval.LuckyNumber = v.LuckyNumber
	retval.Id = v.MoreUserFields.Id
	retval.Hair = v.MoreUserFields.Hair
	return &retval, nil
}

// MoreUserFields includes the GraphQL fields of User requested by the fragment MoreUserFields.
type MoreUserFields struct {
	Id   string             `json:"id"`
	Hair MoreUserFieldsHair `json:"hair"`
}

// GetId returns MoreUserFields.Id, and is useful for accessing the field via an interface.
func (v *MoreUserFields) GetId() string { return v.Id }

// GetHair returns MoreUserFields.Hair, and is useful for accessing the field via an interface.
func (v *MoreUserFields) GetHair() MoreUserFieldsHair { return v.Hair }

// MoreUserFieldsHair includes the requested fields of the GraphQL type Hair.
type MoreUserFieldsHair struct {
	Color string `json:"color"`
}

// GetColor returns MoreUserFieldsHair.Color, and is useful for accessing the field via an interface.
func (v *MoreUserFieldsHair) GetColor() string { return v.Color }

type NewUser struct {
	Name string `json:"name"`
}

// GetName returns NewUser.Name, and is useful for accessing the field via an interface.
func (v *NewUser) GetName() string { return v.Name }

// QueryFragment includes the GraphQL fields of Query requested by the fragment QueryFragment.
type QueryFragment struct {
	Beings []QueryFragmentBeingsBeing `json:"-"`
}

// GetBeings returns QueryFragment.Beings, and is useful for accessing the field via an interface.
func (v *QueryFragment) GetBeings() []QueryFragmentBeingsBeing { return v.Beings }

func (v *QueryFragment) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*QueryFragment
		Beings []json.RawMessage `json:"beings"`
		graphql.NoUnmarshalJSON
	}
	firstPass.QueryFragment = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	{
		dst := &v.Beings
		src := firstPass.Beings
		*dst = make(
			[]QueryFragmentBeingsBeing,
			len(src))
		for i, src := range src {
			dst := &(*dst)[i]
			if len(src) != 0 && string(src) != "null" {
				err = __unmarshalQueryFragmentBeingsBeing(
					src, dst)
				if err != nil {
					return fmt.Errorf(
						"unable to unmarshal QueryFragment.Beings: %w", err)
				}
			}
		}
	}
	return nil
}

type __premarshalQueryFragment struct {
	Beings []json.RawMessage `json:"beings"`
}

func (v *QueryFragment) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *QueryFragment) __premarshalJSON() (*__premarshalQueryFragment, error) {
	var retval __premarshalQueryFragment

	{

		dst := &retval.Beings
		src := v.Beings
		*dst = make(
			[]json.RawMessage,
			len(src))
		for i, src := range src {
			dst := &(*dst)[i]
			var err error
			*dst, err = __marshalQueryFragmentBeingsBeing(
				&src)
			if err != nil {
				return nil, fmt.Errorf(
					"unable to marshal QueryFragment.Beings: %w", err)
			}
		}
	}
	return &retval, nil
}

// QueryFragmentBeingsAnimal includes the requested fields of the GraphQL type Animal.
type QueryFragmentBeingsAnimal struct {
	Typename string           `json:"__typename"`
	Id       string           `json:"id"`
	Owner    InnerBeingFields `json:"-"`
}

// GetTypename returns QueryFragmentBeingsAnimal.Typename, and is useful for accessing the field via an interface.
func (v *QueryFragmentBeingsAnimal) GetTypename() string { return v.Typename }

// GetId returns QueryFragmentBeingsAnimal.Id, and is useful for accessing the field via an interface.
func (v *QueryFragmentBeingsAnimal) GetId() string { return v.Id }

// GetOwner returns QueryFragmentBeingsAnimal.Owner, and is useful for accessing the field via an interface.
func (v *QueryFragmentBeingsAnimal) GetOwner() InnerBeingFields { return v.Owner }

func (v *QueryFragmentBeingsAnimal) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*QueryFragmentBeingsAnimal
		Owner json.RawMessage `json:"owner"`
		graphql.NoUnmarshalJSON
	}
	firstPass.QueryFragmentBeingsAnimal = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	{
		dst := &v.Owner
		src := firstPass.Owner
		if len(src) != 0 && string(src) != "null" {
			err = __unmarshalInnerBeingFields(
				src, dst)
			if err != nil {
				return fmt.Errorf(
					"unable to unmarshal QueryFragmentBeingsAnimal.Owner: %w", err)
			}
		}
	}
	return nil
}

type __premarshalQueryFragmentBeingsAnimal struct {
	Typename string `json:"__typename"`

	Id string `json:"id"`

	Owner json.RawMessage `json:"owner"`
}

func (v *QueryFragmentBeingsAnimal) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *QueryFragmentBeingsAnimal) __premarshalJSON() (*__premarshalQueryFragmentBeingsAnimal, error) {
	var retval __premarshalQueryFragmentBeingsAnimal

	retval.Typename = v.Typename
	retval.Id = v.Id
	{

		dst := &retval.Owner
		src := v.Owner
		var err error
		*dst, err = __marshalInnerBeingFields(
			&src)
		if err != nil {
			return nil, fmt.Errorf(
				"unable to marshal QueryFragmentBeingsAnimal.Owner: %w", err)
		}
	}
	return &retval, nil
}

// QueryFragmentBeingsBeing includes the requested fields of the GraphQL interface Being.
//
// QueryFragmentBeingsBeing is implemented by the following types:
// QueryFragmentBeingsAnimal
// QueryFragmentBeingsUser
type QueryFragmentBeingsBeing interface {
	implementsGraphQLInterfaceQueryFragmentBeingsBeing()
	// GetTypename returns the receiver's concrete GraphQL type-name (see interface doc for possible values).
	GetTypename() string
	// GetId returns the interface-field "id" from its implementation.
	GetId() string
}

func (v *QueryFragmentBeingsAnimal) implementsGraphQLInterfaceQueryFragmentBeingsBeing() {}
func (v *QueryFragmentBeingsUser) implementsGraphQLInterfaceQueryFragmentBeingsBeing()   {}

func __unmarshalQueryFragmentBeingsBeing(b []byte, v *QueryFragmentBeingsBeing) error {
	if string(b) == "null" {
		return nil
	}

	var tn struct {
		TypeName string `json:"__typename"`
	}
	err := json.Unmarshal(b, &tn)
	if err != nil {
		return err
	}

	switch tn.TypeName {
	case "Animal":
		*v = new(QueryFragmentBeingsAnimal)
		return json.Unmarshal(b, *v)
	case "User":
		*v = new(QueryFragmentBeingsUser)
		return json.Unmarshal(b, *v)
	case "":
		return fmt.Errorf(
			"response was missing Being.__typename")
	default:
		return fmt.Errorf(
			`unexpected concrete type for QueryFragmentBeingsBeing: "%v"`, tn.TypeName)
	}
}

func __marshalQueryFragmentBeingsBeing(v *QueryFragmentBeingsBeing) ([]byte, error) {

	var typename string
	switch v := (*v).(type) {
	case *QueryFragmentBeingsAnimal:
		typename = "Animal"

		premarshaled, err := v.__premarshalJSON()
		if err != nil {
			return nil, err
		}
		result := struct {
			TypeName string `json:"__typename"`
			*__premarshalQueryFragmentBeingsAnimal
		}{typename, premarshaled}
		return json.Marshal(result)
	case *QueryFragmentBeingsUser:
		typename = "User"

		premarshaled, err := v.__premarshalJSON()
		if err != nil {
			return nil, err
		}
		result := struct {
			TypeName string `json:"__typename"`
			*__premarshalQueryFragmentBeingsUser
		}{typename, premarshaled}
		return json.Marshal(result)
	case nil:
		return []byte("null"), nil
	default:
		return nil, fmt.Errorf(
			`unexpected concrete type for QueryFragmentBeingsBeing: "%T"`, v)
	}
}

// QueryFragmentBeingsUser includes the requested fields of the GraphQL type User.
type QueryFragmentBeingsUser struct {
	Typename             string `json:"__typename"`
	Id                   string `json:"id"`
	InnerLuckyFieldsUser `json:"-"`
}

// GetTypename returns QueryFragmentBeingsUser.Typename, and is useful for accessing the field via an interface.
func (v *QueryFragmentBeingsUser) GetTypename() string { return v.Typename }

// GetId returns QueryFragmentBeingsUser.Id, and is useful for accessing the field via an interface.
func (v *QueryFragmentBeingsUser) GetId() string { return v.Id }

// GetLuckyNumber returns QueryFragmentBeingsUser.LuckyNumber, and is useful for accessing the field via an interface.
func (v *QueryFragmentBeingsUser) GetLuckyNumber() int { return v.InnerLuckyFieldsUser.LuckyNumber }

func (v *QueryFragmentBeingsUser) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*QueryFragmentBeingsUser
		graphql.NoUnmarshalJSON
	}
	firstPass.QueryFragmentBeingsUser = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	err = json.Unmarshal(
		b, &v.InnerLuckyFieldsUser)
	if err != nil {
		return err
	}
	return nil
}

type __premarshalQueryFragmentBeingsUser struct {
	Typename string `json:"__typename"`

	Id string `json:"id"`

	LuckyNumber int `json:"luckyNumber"`
}

func (v *QueryFragmentBeingsUser) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *QueryFragmentBeingsUser) __premarshalJSON() (*__premarshalQueryFragmentBeingsUser, error) {
	var retval __premarshalQueryFragmentBeingsUser

	retval.Typename = v.Typename
	retval.Id = v.Id
	retval.LuckyNumber = v.InnerLuckyFieldsUser.LuckyNumber
	return &retval, nil
}

type Species string

const (
	SpeciesDog        Species = "DOG"
	SpeciesCoelacanth Species = "COELACANTH"
)

// UserFields includes the GraphQL fields of User requested by the fragment UserFields.
type UserFields struct {
	Id              string `json:"id"`
	LuckyFieldsUser `json:"-"`
	MoreUserFields  `json:"-"`
}

// GetId returns UserFields.Id, and is useful for accessing the field via an interface.
func (v *UserFields) GetId() string { return v.Id }

// GetLuckyNumber returns UserFields.LuckyNumber, and is useful for accessing the field via an interface.
func (v *UserFields) GetLuckyNumber() int { return v.LuckyFieldsUser.LuckyNumber }

// GetHair returns UserFields.Hair, and is useful for accessing the field via an interface.
func (v *UserFields) GetHair() MoreUserFieldsHair { return v.MoreUserFields.Hair }

func (v *UserFields) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*UserFields
		graphql.NoUnmarshalJSON
	}
	firstPass.UserFields = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	err = json.Unmarshal(
		b, &v.LuckyFieldsUser)
	if err != nil {
		return err
	}
	err = json.Unmarshal(
		b, &v.MoreUserFields)
	if err != nil {
		return err
	}
	return nil
}

type __premarshalUserFields struct {
	Id string `json:"id"`

	LuckyNumber int `json:"luckyNumber"`

	Hair MoreUserFieldsHair `json:"hair"`
}

func (v *UserFields) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *UserFields) __premarshalJSON() (*__premarshalUserFields, error) {
	var retval __premarshalUserFields

	retval.Id = v.Id
	retval.LuckyNumber = v.LuckyFieldsUser.LuckyNumber
	retval.Hair = v.MoreUserFields.Hair
	return &retval, nil
}

// __createUserInput is used internally by genqlient
type __createUserInput struct {
	User NewUser `json:"user"`
}

// GetUser returns __createUserInput.User, and is useful for accessing the field via an interface.
func (v *__createUserInput) GetUser() NewUser { return v.User }

// __queryWithCustomMarshalInput is used internally by genqlient
type __queryWithCustomMarshalInput struct {
	Date time.Time `json:"-"`
}

// GetDate returns __queryWithCustomMarshalInput.Date, and is useful for accessing the field via an interface.
func (v *__queryWithCustomMarshalInput) GetDate() time.Time { return v.Date }

func (v *__queryWithCustomMarshalInput) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*__queryWithCustomMarshalInput
		Date json.RawMessage `json:"date"`
		graphql.NoUnmarshalJSON
	}
	firstPass.__queryWithCustomMarshalInput = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	{
		dst := &v.Date
		src := firstPass.Date
		if len(src) != 0 && string(src) != "null" {
			err = testutil.UnmarshalDate(
				src, dst)
			if err != nil {
				return fmt.Errorf(
					"unable to unmarshal __queryWithCustomMarshalInput.Date: %w", err)
			}
		}
	}
	return nil
}

type __premarshal__queryWithCustomMarshalInput struct {
	Date json.RawMessage `json:"date"`
}

func (v *__queryWithCustomMarshalInput) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *__queryWithCustomMarshalInput) __premarshalJSON() (*__premarshal__queryWithCustomMarshalInput, error) {
	var retval __premarshal__queryWithCustomMarshalInput

	{

		dst := &retval.Date
		src := v.Date
		var err error
		*dst, err = testutil.MarshalDate(
			&src)
		if err != nil {
			return nil, fmt.Errorf(
				"unable to marshal __queryWithCustomMarshalInput.Date: %w", err)
		}
	}
	return &retval, nil
}

// __queryWithCustomMarshalOptionalInput is used internally by genqlient
type __queryWithCustomMarshalOptionalInput struct {
	Date *time.Time `json:"-"`
	Id   *string    `json:"id"`
}

// GetDate returns __queryWithCustomMarshalOptionalInput.Date, and is useful for accessing the field via an interface.
func (v *__queryWithCustomMarshalOptionalInput) GetDate() *time.Time { return v.Date }

// GetId returns __queryWithCustomMarshalOptionalInput.Id, and is useful for accessing the field via an interface.
func (v *__queryWithCustomMarshalOptionalInput) GetId() *string { return v.Id }

func (v *__queryWithCustomMarshalOptionalInput) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*__queryWithCustomMarshalOptionalInput
		Date json.RawMessage `json:"date"`
		graphql.NoUnmarshalJSON
	}
	firstPass.__queryWithCustomMarshalOptionalInput = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	{
		dst := &v.Date
		src := firstPass.Date
		if len(src) != 0 && string(src) != "null" {
			*dst = new(time.Time)
			err = testutil.UnmarshalDate(
				src, *dst)
			if err != nil {
				return fmt.Errorf(
					"unable to unmarshal __queryWithCustomMarshalOptionalInput.Date: %w", err)
			}
		}
	}
	return nil
}

type __premarshal__queryWithCustomMarshalOptionalInput struct {
	Date json.RawMessage `json:"date"`

	Id *string `json:"id"`
}

func (v *__queryWithCustomMarshalOptionalInput) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *__queryWithCustomMarshalOptionalInput) __premarshalJSON() (*__premarshal__queryWithCustomMarshalOptionalInput, error) {
	var retval __premarshal__queryWithCustomMarshalOptionalInput

	{

		dst := &retval.Date
		src := v.Date
		if src != nil {
			var err error
			*dst, err = testutil.MarshalDate(
				src)
			if err != nil {
				return nil, fmt.Errorf(
					"unable to marshal __queryWithCustomMarshalOptionalInput.Date: %w", err)
			}
		}
	}
	retval.Id = v.Id
	return &retval, nil
}

// __queryWithCustomMarshalSliceInput is used internally by genqlient
type __queryWithCustomMarshalSliceInput struct {
	Dates []time.Time `json:"-"`
}

// GetDates returns __queryWithCustomMarshalSliceInput.Dates, and is useful for accessing the field via an interface.
func (v *__queryWithCustomMarshalSliceInput) GetDates() []time.Time { return v.Dates }

func (v *__queryWithCustomMarshalSliceInput) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*__queryWithCustomMarshalSliceInput
		Dates []json.RawMessage `json:"dates"`
		graphql.NoUnmarshalJSON
	}
	firstPass.__queryWithCustomMarshalSliceInput = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	{
		dst := &v.Dates
		src := firstPass.Dates
		*dst = make(
			[]time.Time,
			len(src))
		for i, src := range src {
			dst := &(*dst)[i]
			if len(src) != 0 && string(src) != "null" {
				err = testutil.UnmarshalDate(
					src, dst)
				if err != nil {
					return fmt.Errorf(
						"unable to unmarshal __queryWithCustomMarshalSliceInput.Dates: %w", err)
				}
			}
		}
	}
	return nil
}

type __premarshal__queryWithCustomMarshalSliceInput struct {
	Dates []json.RawMessage `json:"dates"`
}

func (v *__queryWithCustomMarshalSliceInput) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *__queryWithCustomMarshalSliceInput) __premarshalJSON() (*__premarshal__queryWithCustomMarshalSliceInput, error) {
	var retval __premarshal__queryWithCustomMarshalSliceInput

	{

		dst := &retval.Dates
		src := v.Dates
		*dst = make(
			[]json.RawMessage,
			len(src))
		for i, src := range src {
			dst := &(*dst)[i]
			var err error
			*dst, err = testutil.MarshalDate(
				&src)
			if err != nil {
				return nil, fmt.Errorf(
					"unable to marshal __queryWithCustomMarshalSliceInput.Dates: %w", err)
			}
		}
	}
	return &retval, nil
}

// __queryWithFlattenInput is used internally by genqlient
type __queryWithFlattenInput struct {
	Ids []string `json:"ids"`
}

// GetIds returns __queryWithFlattenInput.Ids, and is useful for accessing the field via an interface.
func (v *__queryWithFlattenInput) GetIds() []string { return v.Ids }

// __queryWithFragmentsInput is used internally by genqlient
type __queryWithFragmentsInput struct {
	Ids []string `json:"ids"`
}

// GetIds returns __queryWithFragmentsInput.Ids, and is useful for accessing the field via an interface.
func (v *__queryWithFragmentsInput) GetIds() []string { return v.Ids }

// __queryWithInterfaceListFieldInput is used internally by genqlient
type __queryWithInterfaceListFieldInput struct {
	Ids []string `json:"ids"`
}

// GetIds returns __queryWithInterfaceListFieldInput.Ids, and is useful for accessing the field via an interface.
func (v *__queryWithInterfaceListFieldInput) GetIds() []string { return v.Ids }

// __queryWithInterfaceListPointerFieldInput is used internally by genqlient
type __queryWithInterfaceListPointerFieldInput struct {
	Ids []string `json:"ids"`
}

// GetIds returns __queryWithInterfaceListPointerFieldInput.Ids, and is useful for accessing the field via an interface.
func (v *__queryWithInterfaceListPointerFieldInput) GetIds() []string { return v.Ids }

// __queryWithInterfaceNoFragmentsInput is used internally by genqlient
type __queryWithInterfaceNoFragmentsInput struct {
	Id string `json:"id"`
}

// GetId returns __queryWithInterfaceNoFragmentsInput.Id, and is useful for accessing the field via an interface.
func (v *__queryWithInterfaceNoFragmentsInput) GetId() string { return v.Id }

// __queryWithNamedFragmentsInput is used internally by genqlient
type __queryWithNamedFragmentsInput struct {
	Ids []string `json:"ids"`
}

// GetIds returns __queryWithNamedFragmentsInput.Ids, and is useful for accessing the field via an interface.
func (v *__queryWithNamedFragmentsInput) GetIds() []string { return v.Ids }

// __queryWithOmitemptyInput is used internally by genqlient
type __queryWithOmitemptyInput struct {
	Id string `json:"id,omitempty"`
}

// GetId returns __queryWithOmitemptyInput.Id, and is useful for accessing the field via an interface.
func (v *__queryWithOmitemptyInput) GetId() string { return v.Id }

// __queryWithVariablesInput is used internally by genqlient
type __queryWithVariablesInput struct {
	Id string `json:"id"`
}

// GetId returns __queryWithVariablesInput.Id, and is useful for accessing the field via an interface.
func (v *__queryWithVariablesInput) GetId() string { return v.Id }

// createUserCreateUser includes the requested fields of the GraphQL type User.
type createUserCreateUser struct {
	Id   string `json:"id"`
	Name string `json:"name"`
}

// GetId returns createUserCreateUser.Id, and is useful for accessing the field via an interface.
func (v *createUserCreateUser) GetId() string { return v.Id }

// GetName returns createUserCreateUser.Name, and is useful for accessing the field via an interface.
func (v *createUserCreateUser) GetName() string { return v.Name }

// createUserResponse is returned by createUser on success.
type createUserResponse struct {
	CreateUser createUserCreateUser `json:"createUser"`
}

// GetCreateUser returns createUserResponse.CreateUser, and is useful for accessing the field via an interface.
func (v *createUserResponse) GetCreateUser() createUserCreateUser { return v.CreateUser }

// failingQueryMeUser includes the requested fields of the GraphQL type User.
type failingQueryMeUser struct {
	Id string `json:"id"`
}

// GetId returns failingQueryMeUser.Id, and is useful for accessing the field via an interface.
func (v *failingQueryMeUser) GetId() string { return v.Id }

// failingQueryResponse is returned by failingQuery on success.
type failingQueryResponse struct {
	Fail bool               `json:"fail"`
	Me   failingQueryMeUser `json:"me"`
}

// GetFail returns failingQueryResponse.Fail, and is useful for accessing the field via an interface.
func (v *failingQueryResponse) GetFail() bool { return v.Fail }

// GetMe returns failingQueryResponse.Me, and is useful for accessing the field via an interface.
func (v *failingQueryResponse) GetMe() failingQueryMeUser { return v.Me }

// queryWithCustomMarshalOptionalResponse is returned by queryWithCustomMarshalOptional on success.
type queryWithCustomMarshalOptionalResponse struct {
	UserSearch []queryWithCustomMarshalOptionalUserSearchUser `json:"userSearch"`
}

// GetUserSearch returns queryWithCustomMarshalOptionalResponse.UserSearch, and is useful for accessing the field via an interface.
func (v *queryWithCustomMarshalOptionalResponse) GetUserSearch() []queryWithCustomMarshalOptionalUserSearchUser {
	return v.UserSearch
}

// queryWithCustomMarshalOptionalUserSearchUser includes the requested fields of the GraphQL type User.
type queryWithCustomMarshalOptionalUserSearchUser struct {
	Id        string    `json:"id"`
	Name      string    `json:"name"`
	Birthdate time.Time `json:"-"`
}

// GetId returns queryWithCustomMarshalOptionalUserSearchUser.Id, and is useful for accessing the field via an interface.
func (v *queryWithCustomMarshalOptionalUserSearchUser) GetId() string { return v.Id }

// GetName returns queryWithCustomMarshalOptionalUserSearchUser.Name, and is useful for accessing the field via an interface.
func (v *queryWithCustomMarshalOptionalUserSearchUser) GetName() string { return v.Name }

// GetBirthdate returns queryWithCustomMarshalOptionalUserSearchUser.Birthdate, and is useful for accessing the field via an interface.
func (v *queryWithCustomMarshalOptionalUserSearchUser) GetBirthdate() time.Time { return v.Birthdate }

func (v *queryWithCustomMarshalOptionalUserSearchUser) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*queryWithCustomMarshalOptionalUserSearchUser
		Birthdate json.RawMessage `json:"birthdate"`
		graphql.NoUnmarshalJSON
	}
	firstPass.queryWithCustomMarshalOptionalUserSearchUser = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	{
		dst := &v.Birthdate
		src := firstPass.Birthdate
		if len(src) != 0 && string(src) != "null" {
			err = testutil.UnmarshalDate(
				src, dst)
			if err != nil {
				return fmt.Errorf(
					"unable to unmarshal queryWithCustomMarshalOptionalUserSearchUser.Birthdate: %w", err)
			}
		}
	}
	return nil
}

type __premarshalqueryWithCustomMarshalOptionalUserSearchUser struct {
	Id string `json:"id"`

	Name string `json:"name"`

	Birthdate json.RawMessage `json:"birthdate"`
}

func (v *queryWithCustomMarshalOptionalUserSearchUser) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *queryWithCustomMarshalOptionalUserSearchUser) __premarshalJSON() (*__premarshalqueryWithCustomMarshalOptionalUserSearchUser, error) {
	var retval __premarshalqueryWithCustomMarshalOptionalUserSearchUser

	retval.Id = v.Id
	retval.Name = v.Name
	{

		dst := &retval.Birthdate
		src := v.Birthdate
		var err error
		*dst, err = testutil.MarshalDate(
			&src)
		if err != nil {
			return nil, fmt.Errorf(
				"unable to marshal queryWithCustomMarshalOptionalUserSearchUser.Birthdate: %w", err)
		}
	}
	return &retval, nil
}

// queryWithCustomMarshalResponse is returned by queryWithCustomMarshal on success.
type queryWithCustomMarshalResponse struct {
	UsersBornOn []queryWithCustomMarshalUsersBornOnUser `json:"usersBornOn"`
}

// GetUsersBornOn returns queryWithCustomMarshalResponse.UsersBornOn, and is useful for accessing the field via an interface.
func (v *queryWithCustomMarshalResponse) GetUsersBornOn() []queryWithCustomMarshalUsersBornOnUser {
	return v.UsersBornOn
}

// queryWithCustomMarshalSliceResponse is returned by queryWithCustomMarshalSlice on success.
type queryWithCustomMarshalSliceResponse struct {
	UsersBornOnDates []queryWithCustomMarshalSliceUsersBornOnDatesUser `json:"usersBornOnDates"`
}

// GetUsersBornOnDates returns queryWithCustomMarshalSliceResponse.UsersBornOnDates, and is useful for accessing the field via an interface.
func (v *queryWithCustomMarshalSliceResponse) GetUsersBornOnDates() []queryWithCustomMarshalSliceUsersBornOnDatesUser {
	return v.UsersBornOnDates
}

// queryWithCustomMarshalSliceUsersBornOnDatesUser includes the requested fields of the GraphQL type User.
type queryWithCustomMarshalSliceUsersBornOnDatesUser struct {
	Id        string    `json:"id"`
	Name      string    `json:"name"`
	Birthdate time.Time `json:"-"`
}

// GetId returns queryWithCustomMarshalSliceUsersBornOnDatesUser.Id, and is useful for accessing the field via an interface.
func (v *queryWithCustomMarshalSliceUsersBornOnDatesUser) GetId() string { return v.Id }

// GetName returns queryWithCustomMarshalSliceUsersBornOnDatesUser.Name, and is useful for accessing the field via an interface.
func (v *queryWithCustomMarshalSliceUsersBornOnDatesUser) GetName() string { return v.Name }

// GetBirthdate returns queryWithCustomMarshalSliceUsersBornOnDatesUser.Birthdate, and is useful for accessing the field via an interface.
func (v *queryWithCustomMarshalSliceUsersBornOnDatesUser) GetBirthdate() time.Time {
	return v.Birthdate
}

func (v *queryWithCustomMarshalSliceUsersBornOnDatesUser) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*queryWithCustomMarshalSliceUsersBornOnDatesUser
		Birthdate json.RawMessage `json:"birthdate"`
		graphql.NoUnmarshalJSON
	}
	firstPass.queryWithCustomMarshalSliceUsersBornOnDatesUser = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	{
		dst := &v.Birthdate
		src := firstPass.Birthdate
		if len(src) != 0 && string(src) != "null" {
			err = testutil.UnmarshalDate(
				src, dst)
			if err != nil {
				return fmt.Errorf(
					"unable to unmarshal queryWithCustomMarshalSliceUsersBornOnDatesUser.Birthdate: %w", err)
			}
		}
	}
	return nil
}

type __premarshalqueryWithCustomMarshalSliceUsersBornOnDatesUser struct {
	Id string `json:"id"`

	Name string `json:"name"`

	Birthdate json.RawMessage `json:"birthdate"`
}

func (v *queryWithCustomMarshalSliceUsersBornOnDatesUser) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *queryWithCustomMarshalSliceUsersBornOnDatesUser) __premarshalJSON() (*__premarshalqueryWithCustomMarshalSliceUsersBornOnDatesUser, error) {
	var retval __premarshalqueryWithCustomMarshalSliceUsersBornOnDatesUser

	retval.Id = v.Id
	retval.Name = v.Name
	{

		dst := &retval.Birthdate
		src := v.Birthdate
		var err error
		*dst, err = testutil.MarshalDate(
			&src)
		if err != nil {
			return nil, fmt.Errorf(
				"unable to marshal queryWithCustomMarshalSliceUsersBornOnDatesUser.Birthdate: %w", err)
		}
	}
	return &retval, nil
}

// queryWithCustomMarshalUsersBornOnUser includes the requested fields of the GraphQL type User.
type queryWithCustomMarshalUsersBornOnUser struct {
	Id        string    `json:"id"`
	Name      string    `json:"name"`
	Birthdate time.Time `json:"-"`
}

// GetId returns queryWithCustomMarshalUsersBornOnUser.Id, and is useful for accessing the field via an interface.
func (v *queryWithCustomMarshalUsersBornOnUser) GetId() string { return v.Id }

// GetName returns queryWithCustomMarshalUsersBornOnUser.Name, and is useful for accessing the field via an interface.
func (v *queryWithCustomMarshalUsersBornOnUser) GetName() string { return v.Name }

// GetBirthdate returns queryWithCustomMarshalUsersBornOnUser.Birthdate, and is useful for accessing the field via an interface.
func (v *queryWithCustomMarshalUsersBornOnUser) GetBirthdate() time.Time { return v.Birthdate }

func (v *queryWithCustomMarshalUsersBornOnUser) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*queryWithCustomMarshalUsersBornOnUser
		Birthdate json.RawMessage `json:"birthdate"`
		graphql.NoUnmarshalJSON
	}
	firstPass.queryWithCustomMarshalUsersBornOnUser = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	{
		dst := &v.Birthdate
		src := firstPass.Birthdate
		if len(src) != 0 && string(src) != "null" {
			err = testutil.UnmarshalDate(
				src, dst)
			if err != nil {
				return fmt.Errorf(
					"unable to unmarshal queryWithCustomMarshalUsersBornOnUser.Birthdate: %w", err)
			}
		}
	}
	return nil
}

type __premarshalqueryWithCustomMarshalUsersBornOnUser struct {
	Id string `json:"id"`

	Name string `json:"name"`

	Birthdate json.RawMessage `json:"birthdate"`
}

func (v *queryWithCustomMarshalUsersBornOnUser) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *queryWithCustomMarshalUsersBornOnUser) __premarshalJSON() (*__premarshalqueryWithCustomMarshalUsersBornOnUser, error) {
	var retval __premarshalqueryWithCustomMarshalUsersBornOnUser

	retval.Id = v.Id
	retval.Name = v.Name
	{

		dst := &retval.Birthdate
		src := v.Birthdate
		var err error
		*dst, err = testutil.MarshalDate(
			&src)
		if err != nil {
			return nil, fmt.Errorf(
				"unable to marshal queryWithCustomMarshalUsersBornOnUser.Birthdate: %w", err)
		}
	}
	return &retval, nil
}

// queryWithFragmentsBeingsAnimal includes the requested fields of the GraphQL type Animal.
type queryWithFragmentsBeingsAnimal struct {
	Typename string                                       `json:"__typename"`
	Id       string                                       `json:"id"`
	Name     string                                       `json:"name"`
	Hair     queryWithFragmentsBeingsAnimalHairBeingsHair `json:"hair"`
	Species  Species                                      `json:"species"`
	Owner    queryWithFragmentsBeingsAnimalOwnerBeing     `json:"-"`
}

// GetTypename returns queryWithFragmentsBeingsAnimal.Typename, and is useful for accessing the field via an interface.
func (v *queryWithFragmentsBeingsAnimal) GetTypename() string { return v.Typename }

// GetId returns queryWithFragmentsBeingsAnimal.Id, and is useful for accessing the field via an interface.
func (v *queryWithFragmentsBeingsAnimal) GetId() string { return v.Id }

// GetName returns queryWithFragmentsBeingsAnimal.Name, and is useful for accessing the field via an interface.
func (v *queryWithFragmentsBeingsAnimal) GetName() string { return v.Name }

// GetHair returns queryWithFragmentsBeingsAnimal.Hair, and is useful for accessing the field via an interface.
func (v *queryWithFragmentsBeingsAnimal) GetHair() queryWithFragmentsBeingsAnimalHairBeingsHair {
	return v.Hair
}

// GetSpecies returns queryWithFragmentsBeingsAnimal.Species, and is useful for accessing the field via an interface.
func (v *queryWithFragmentsBeingsAnimal) GetSpecies() Species { return v.Species }

// GetOwner returns queryWithFragmentsBeingsAnimal.Owner, and is useful for accessing the field via an interface.
func (v *queryWithFragmentsBeingsAnimal) GetOwner() queryWithFragmentsBeingsAnimalOwnerBeing {
	return v.Owner
}

func (v *queryWithFragmentsBeingsAnimal) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*queryWithFragmentsBeingsAnimal
		Owner json.RawMessage `json:"owner"`
		graphql.NoUnmarshalJSON
	}
	firstPass.queryWithFragmentsBeingsAnimal = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	{
		dst := &v.Owner
		src := firstPass.Owner
		if len(src) != 0 && string(src) != "null" {
			err = __unmarshalqueryWithFragmentsBeingsAnimalOwnerBeing(
				src, dst)
			if err != nil {
				return fmt.Errorf(
					"unable to unmarshal queryWithFragmentsBeingsAnimal.Owner: %w", err)
			}
		}
	}
	return nil
}

type __premarshalqueryWithFragmentsBeingsAnimal struct {
	Typename string `json:"__typename"`

	Id string `json:"id"`

	Name string `json:"name"`

	Hair queryWithFragmentsBeingsAnimalHairBeingsHair `json:"hair"`

	Species Species `json:"species"`

	Owner json.RawMessage `json:"owner"`
}

func (v *queryWithFragmentsBeingsAnimal) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *queryWithFragmentsBeingsAnimal) __premarshalJSON() (*__premarshalqueryWithFragmentsBeingsAnimal, error) {
	var retval __premarshalqueryWithFragmentsBeingsAnimal

	retval.Typename = v.Typename
	retval.Id = v.Id
	retval.Name = v.Name
	retval.Hair = v.Hair
	retval.Species = v.Species
	{

		dst := &retval.Owner
		src := v.Owner
		var err error
		*dst, err = __marshalqueryWithFragmentsBeingsAnimalOwnerBeing(
			&src)
		if err != nil {
			return nil, fmt.Errorf(
				"unable to marshal queryWithFragmentsBeingsAnimal.Owner: %w", err)
		}
	}
	return &retval, nil
}

// queryWithFragmentsBeingsAnimalHairBeingsHair includes the requested fields of the GraphQL type BeingsHair.
type queryWithFragmentsBeingsAnimalHairBeingsHair struct {
	HasHair bool `json:"hasHair"`
}

// GetHasHair returns queryWithFragmentsBeingsAnimalHairBeingsHair.HasHair, and is useful for accessing the field via an interface.
func (v *queryWithFragmentsBeingsAnimalHairBeingsHair) GetHasHair() bool { return v.HasHair }

// queryWithFragmentsBeingsAnimalOwnerAnimal includes the requested fields of the GraphQL type Animal.
type queryWithFragmentsBeingsAnimalOwnerAnimal struct {
	Typename string `json:"__typename"`
	Id       string `json:"id"`
	Name     string `json:"name"`
}

// GetTypename returns queryWithFragmentsBeingsAnimalOwnerAnimal.Typename, and is useful for accessing the field via an interface.
func (v *queryWithFragmentsBeingsAnimalOwnerAnimal) GetTypename() string { return v.Typename }

// GetId returns queryWithFragmentsBeingsAnimalOwnerAnimal.Id, and is useful for accessing the field via an interface.
func (v *queryWithFragmentsBeingsAnimalOwnerAnimal) GetId() string { return v.Id }

// GetName returns queryWithFragmentsBeingsAnimalOwnerAnimal.Name, and is useful for accessing the field via an interface.
func (v *queryWithFragmentsBeingsAnimalOwnerAnimal) GetName() string { return v.Name }

// queryWithFragmentsBeingsAnimalOwnerBeing includes the requested fields of the GraphQL interface Being.
//
// queryWithFragmentsBeingsAnimalOwnerBeing is implemented by the following types:
// queryWithFragmentsBeingsAnimalOwnerAnimal
// queryWithFragmentsBeingsAnimalOwnerUser
type queryWithFragmentsBeingsAnimalOwnerBeing interface {
	implementsGraphQLInterfacequeryWithFragmentsBeingsAnimalOwnerBeing()
	// GetTypename returns the receiver's concrete GraphQL type-name (see interface doc for possible values).
	GetTypename() string
	// GetId returns the interface-field "id" from its implementation.
	GetId() string
	// GetName returns the interface-field "name" from its implementation.
	GetName() string
}

func (v *queryWithFragmentsBeingsAnimalOwnerAnimal) implementsGraphQLInterfacequeryWithFragmentsBeingsAnimalOwnerBeing() {
}
func (v *queryWithFragmentsBeingsAnimalOwnerUser) implementsGraphQLInterfacequeryWithFragmentsBeingsAnimalOwnerBeing() {
}

func __unmarshalqueryWithFragmentsBeingsAnimalOwnerBeing(b []byte, v *queryWithFragmentsBeingsAnimalOwnerBeing) error {
	if string(b) == "null" {
		return nil
	}

	var tn struct {
		TypeName string `json:"__typename"`
	}
	err := json.Unmarshal(b, &tn)
	if err != nil {
		return err
	}

	switch tn.TypeName {
	case "Animal":
		*v = new(queryWithFragmentsBeingsAnimalOwnerAnimal)
		return json.Unmarshal(b, *v)
	case "User":
		*v = new(queryWithFragmentsBeingsAnimalOwnerUser)
		return json.Unmarshal(b, *v)
	case "":
		return fmt.Errorf(
			"response was missing Being.__typename")
	default:
		return fmt.Errorf(
			`unexpected concrete type for queryWithFragmentsBeingsAnimalOwnerBeing: "%v"`, tn.TypeName)
	}
}

func __marshalqueryWithFragmentsBeingsAnimalOwnerBeing(v *queryWithFragmentsBeingsAnimalOwnerBeing) ([]byte, error) {

	var typename string
	switch v := (*v).(type) {
	case *queryWithFragmentsBeingsAnimalOwnerAnimal:
		typename = "Animal"

		result := struct {
			TypeName string `json:"__typename"`
			*queryWithFragmentsBeingsAnimalOwnerAnimal
		}{typename, v}
		return json.Marshal(result)
	case *queryWithFragmentsBeingsAnimalOwnerUser:
		typename = "User"

		result := struct {
			TypeName string `json:"__typename"`
			*queryWithFragmentsBeingsAnimalOwnerUser
		}{typename, v}
		return json.Marshal(result)
	case nil:
		return []byte("null"), nil
	default:
		return nil, fmt.Errorf(
			`unexpected concrete type for queryWithFragmentsBeingsAnimalOwnerBeing: "%T"`, v)
	}
}

// queryWithFragmentsBeingsAnimalOwnerUser includes the requested fields of the GraphQL type User.
type queryWithFragmentsBeingsAnimalOwnerUser struct {
	Typename    string `json:"__typename"`
	Id          string `json:"id"`
	Name        string `json:"name"`
	LuckyNumber int    `json:"luckyNumber"`
}

// GetTypename returns queryWithFragmentsBeingsAnimalOwnerUser.Typename, and is useful for accessing the field via an interface.
func (v *queryWithFragmentsBeingsAnimalOwnerUser) GetTypename() string { return v.Typename }

// GetId returns queryWithFragmentsBeingsAnimalOwnerUser.Id, and is useful for accessing the field via an interface.
func (v *queryWithFragmentsBeingsAnimalOwnerUser) GetId() string { return v.Id }

// GetName returns queryWithFragmentsBeingsAnimalOwnerUser.Name, and is useful for accessing the field via an interface.
func (v *queryWithFragmentsBeingsAnimalOwnerUser) GetName() string { return v.Name }

// GetLuckyNumber returns queryWithFragmentsBeingsAnimalOwnerUser.LuckyNumber, and is useful for accessing the field via an interface.
func (v *queryWithFragmentsBeingsAnimalOwnerUser) GetLuckyNumber() int { return v.LuckyNumber }

// queryWithFragmentsBeingsBeing includes the requested fields of the GraphQL interface Being.
//
// queryWithFragmentsBeingsBeing is implemented by the following types:
// queryWithFragmentsBeingsAnimal
// queryWithFragmentsBeingsUser
type queryWithFragmentsBeingsBeing interface {
	implementsGraphQLInterfacequeryWithFragmentsBeingsBeing()
	// GetTypename returns the receiver's concrete GraphQL type-name (see interface doc for possible values).
	GetTypename() string
	// GetId returns the interface-field "id" from its implementation.
	GetId() string
	// GetName returns the interface-field "name" from its implementation.
	GetName() string
}

func (v *queryWithFragmentsBeingsAnimal) implementsGraphQLInterfacequeryWithFragmentsBeingsBeing() {}
func (v *queryWithFragmentsBeingsUser) implementsGraphQLInterfacequeryWithFragmentsBeingsBeing()   {}

func __unmarshalqueryWithFragmentsBeingsBeing(b []byte, v *queryWithFragmentsBeingsBeing) error {
	if string(b) == "null" {
		return nil
	}

	var tn struct {
		TypeName string `json:"__typename"`
	}
	err := json.Unmarshal(b, &tn)
	if err != nil {
		return err
	}

	switch tn.TypeName {
	case "Animal":
		*v = new(queryWithFragmentsBeingsAnimal)
		return json.Unmarshal(b, *v)
	case "User":
		*v = new(queryWithFragmentsBeingsUser)
		return json.Unmarshal(b, *v)
	case "":
		return fmt.Errorf(
			"response was missing Being.__typename")
	default:
		return fmt.Errorf(
			`unexpected concrete type for queryWithFragmentsBeingsBeing: "%v"`, tn.TypeName)
	}
}

func __marshalqueryWithFragmentsBeingsBeing(v *queryWithFragmentsBeingsBeing) ([]byte, error) {

	var typename string
	switch v := (*v).(type) {
	case *queryWithFragmentsBeingsAnimal:
		typename = "Animal"

		premarshaled, err := v.__premarshalJSON()
		if err != nil {
			return nil, err
		}
		result := struct {
			TypeName string `json:"__typename"`
			*__premarshalqueryWithFragmentsBeingsAnimal
		}{typename, premarshaled}
		return json.Marshal(result)
	case *queryWithFragmentsBeingsUser:
		typename = "User"

		result := struct {
			TypeName string `json:"__typename"`
			*queryWithFragmentsBeingsUser
		}{typename, v}
		return json.Marshal(result)
	case nil:
		return []byte("null"), nil
	default:
		return nil, fmt.Errorf(
			`unexpected concrete type for queryWithFragmentsBeingsBeing: "%T"`, v)
	}
}

// queryWithFragmentsBeingsUser includes the requested fields of the GraphQL type User.
type queryWithFragmentsBeingsUser struct {
	Typename    string                           `json:"__typename"`
	Id          string                           `json:"id"`
	Name        string                           `json:"name"`
	LuckyNumber int                              `json:"luckyNumber"`
	Hair        queryWithFragmentsBeingsUserHair `json:"hair"`
}

// GetTypename returns queryWithFragmentsBeingsUser.Typename, and is useful for accessing the field via an interface.
func (v *queryWithFragmentsBeingsUser) GetTypename() string { return v.Typename }

// GetId returns queryWithFragmentsBeingsUser.Id, and is useful for accessing the field via an interface.
func (v *queryWithFragmentsBeingsUser) GetId() string { return v.Id }

// GetName returns queryWithFragmentsBeingsUser.Name, and is useful for accessing the field via an interface.
func (v *queryWithFragmentsBeingsUser) GetName() string { return v.Name }

// GetLuckyNumber returns queryWithFragmentsBeingsUser.LuckyNumber, and is useful for accessing the field via an interface.
func (v *queryWithFragmentsBeingsUser) GetLuckyNumber() int { return v.LuckyNumber }

// GetHair returns queryWithFragmentsBeingsUser.Hair, and is useful for accessing the field via an interface.
func (v *queryWithFragmentsBeingsUser) GetHair() queryWithFragmentsBeingsUserHair { return v.Hair }

// queryWithFragmentsBeingsUserHair includes the requested fields of the GraphQL type Hair.
type queryWithFragmentsBeingsUserHair struct {
	Color string `json:"color"`
}

// GetColor returns queryWithFragmentsBeingsUserHair.Color, and is useful for accessing the field via an interface.
func (v *queryWithFragmentsBeingsUserHair) GetColor() string { return v.Color }

// queryWithFragmentsResponse is returned by queryWithFragments on success.
type queryWithFragmentsResponse struct {
	Beings []queryWithFragmentsBeingsBeing `json:"-"`
}

// GetBeings returns queryWithFragmentsResponse.Beings, and is useful for accessing the field via an interface.
func (v *queryWithFragmentsResponse) GetBeings() []queryWithFragmentsBeingsBeing { return v.Beings }

func (v *queryWithFragmentsResponse) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*queryWithFragmentsResponse
		Beings []json.RawMessage `json:"beings"`
		graphql.NoUnmarshalJSON
	}
	firstPass.queryWithFragmentsResponse = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	{
		dst := &v.Beings
		src := firstPass.Beings
		*dst = make(
			[]queryWithFragmentsBeingsBeing,
			len(src))
		for i, src := range src {
			dst := &(*dst)[i]
			if len(src) != 0 && string(src) != "null" {
				err = __unmarshalqueryWithFragmentsBeingsBeing(
					src, dst)
				if err != nil {
					return fmt.Errorf(
						"unable to unmarshal queryWithFragmentsResponse.Beings: %w", err)
				}
			}
		}
	}
	return nil
}

type __premarshalqueryWithFragmentsResponse struct {
	Beings []json.RawMessage `json:"beings"`
}

func (v *queryWithFragmentsResponse) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *queryWithFragmentsResponse) __premarshalJSON() (*__premarshalqueryWithFragmentsResponse, error) {
	var retval __premarshalqueryWithFragmentsResponse

	{

		dst := &retval.Beings
		src := v.Beings
		*dst = make(
			[]json.RawMessage,
			len(src))
		for i, src := range src {
			dst := &(*dst)[i]
			var err error
			*dst, err = __marshalqueryWithFragmentsBeingsBeing(
				&src)
			if err != nil {
				return nil, fmt.Errorf(
					"unable to marshal queryWithFragmentsResponse.Beings: %w", err)
			}
		}
	}
	return &retval, nil
}

// queryWithInterfaceListFieldBeingsAnimal includes the requested fields of the GraphQL type Animal.
type queryWithInterfaceListFieldBeingsAnimal struct {
	Typename string `json:"__typename"`
	Id       string `json:"id"`
	Name     string `json:"name"`
}

// GetTypename returns queryWithInterfaceListFieldBeingsAnimal.Typename, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceListFieldBeingsAnimal) GetTypename() string { return v.Typename }

// GetId returns queryWithInterfaceListFieldBeingsAnimal.Id, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceListFieldBeingsAnimal) GetId() string { return v.Id }

// GetName returns queryWithInterfaceListFieldBeingsAnimal.Name, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceListFieldBeingsAnimal) GetName() string { return v.Name }

// queryWithInterfaceListFieldBeingsBeing includes the requested fields of the GraphQL interface Being.
//
// queryWithInterfaceListFieldBeingsBeing is implemented by the following types:
// queryWithInterfaceListFieldBeingsAnimal
// queryWithInterfaceListFieldBeingsUser
type queryWithInterfaceListFieldBeingsBeing interface {
	implementsGraphQLInterfacequeryWithInterfaceListFieldBeingsBeing()
	// GetTypename returns the receiver's concrete GraphQL type-name (see interface doc for possible values).
	GetTypename() string
	// GetId returns the interface-field "id" from its implementation.
	GetId() string
	// GetName returns the interface-field "name" from its implementation.
	GetName() string
}

func (v *queryWithInterfaceListFieldBeingsAnimal) implementsGraphQLInterfacequeryWithInterfaceListFieldBeingsBeing() {
}
func (v *queryWithInterfaceListFieldBeingsUser) implementsGraphQLInterfacequeryWithInterfaceListFieldBeingsBeing() {
}

func __unmarshalqueryWithInterfaceListFieldBeingsBeing(b []byte, v *queryWithInterfaceListFieldBeingsBeing) error {
	if string(b) == "null" {
		return nil
	}

	var tn struct {
		TypeName string `json:"__typename"`
	}
	err := json.Unmarshal(b, &tn)
	if err != nil {
		return err
	}

	switch tn.TypeName {
	case "Animal":
		*v = new(queryWithInterfaceListFieldBeingsAnimal)
		return json.Unmarshal(b, *v)
	case "User":
		*v = new(queryWithInterfaceListFieldBeingsUser)
		return json.Unmarshal(b, *v)
	case "":
		return fmt.Errorf(
			"response was missing Being.__typename")
	default:
		return fmt.Errorf(
			`unexpected concrete type for queryWithInterfaceListFieldBeingsBeing: "%v"`, tn.TypeName)
	}
}

func __marshalqueryWithInterfaceListFieldBeingsBeing(v *queryWithInterfaceListFieldBeingsBeing) ([]byte, error) {

	var typename string
	switch v := (*v).(type) {
	case *queryWithInterfaceListFieldBeingsAnimal:
		typename = "Animal"

		result := struct {
			TypeName string `json:"__typename"`
			*queryWithInterfaceListFieldBeingsAnimal
		}{typename, v}
		return json.Marshal(result)
	case *queryWithInterfaceListFieldBeingsUser:
		typename = "User"

		result := struct {
			TypeName string `json:"__typename"`
			*queryWithInterfaceListFieldBeingsUser
		}{typename, v}
		return json.Marshal(result)
	case nil:
		return []byte("null"), nil
	default:
		return nil, fmt.Errorf(
			`unexpected concrete type for queryWithInterfaceListFieldBeingsBeing: "%T"`, v)
	}
}

// queryWithInterfaceListFieldBeingsUser includes the requested fields of the GraphQL type User.
type queryWithInterfaceListFieldBeingsUser struct {
	Typename string `json:"__typename"`
	Id       string `json:"id"`
	Name     string `json:"name"`
}

// GetTypename returns queryWithInterfaceListFieldBeingsUser.Typename, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceListFieldBeingsUser) GetTypename() string { return v.Typename }

// GetId returns queryWithInterfaceListFieldBeingsUser.Id, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceListFieldBeingsUser) GetId() string { return v.Id }

// GetName returns queryWithInterfaceListFieldBeingsUser.Name, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceListFieldBeingsUser) GetName() string { return v.Name }

// queryWithInterfaceListFieldResponse is returned by queryWithInterfaceListField on success.
type queryWithInterfaceListFieldResponse struct {
	Beings []queryWithInterfaceListFieldBeingsBeing `json:"-"`
}

// GetBeings returns queryWithInterfaceListFieldResponse.Beings, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceListFieldResponse) GetBeings() []queryWithInterfaceListFieldBeingsBeing {
	return v.Beings
}

func (v *queryWithInterfaceListFieldResponse) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*queryWithInterfaceListFieldResponse
		Beings []json.RawMessage `json:"beings"`
		graphql.NoUnmarshalJSON
	}
	firstPass.queryWithInterfaceListFieldResponse = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	{
		dst := &v.Beings
		src := firstPass.Beings
		*dst = make(
			[]queryWithInterfaceListFieldBeingsBeing,
			len(src))
		for i, src := range src {
			dst := &(*dst)[i]
			if len(src) != 0 && string(src) != "null" {
				err = __unmarshalqueryWithInterfaceListFieldBeingsBeing(
					src, dst)
				if err != nil {
					return fmt.Errorf(
						"unable to unmarshal queryWithInterfaceListFieldResponse.Beings: %w", err)
				}
			}
		}
	}
	return nil
}

type __premarshalqueryWithInterfaceListFieldResponse struct {
	Beings []json.RawMessage `json:"beings"`
}

func (v *queryWithInterfaceListFieldResponse) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *queryWithInterfaceListFieldResponse) __premarshalJSON() (*__premarshalqueryWithInterfaceListFieldResponse, error) {
	var retval __premarshalqueryWithInterfaceListFieldResponse

	{

		dst := &retval.Beings
		src := v.Beings
		*dst = make(
			[]json.RawMessage,
			len(src))
		for i, src := range src {
			dst := &(*dst)[i]
			var err error
			*dst, err = __marshalqueryWithInterfaceListFieldBeingsBeing(
				&src)
			if err != nil {
				return nil, fmt.Errorf(
					"unable to marshal queryWithInterfaceListFieldResponse.Beings: %w", err)
			}
		}
	}
	return &retval, nil
}

// queryWithInterfaceListPointerFieldBeingsAnimal includes the requested fields of the GraphQL type Animal.
type queryWithInterfaceListPointerFieldBeingsAnimal struct {
	Typename string `json:"__typename"`
	Id       string `json:"id"`
	Name     string `json:"name"`
}

// GetTypename returns queryWithInterfaceListPointerFieldBeingsAnimal.Typename, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceListPointerFieldBeingsAnimal) GetTypename() string { return v.Typename }

// GetId returns queryWithInterfaceListPointerFieldBeingsAnimal.Id, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceListPointerFieldBeingsAnimal) GetId() string { return v.Id }

// GetName returns queryWithInterfaceListPointerFieldBeingsAnimal.Name, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceListPointerFieldBeingsAnimal) GetName() string { return v.Name }

// queryWithInterfaceListPointerFieldBeingsBeing includes the requested fields of the GraphQL interface Being.
//
// queryWithInterfaceListPointerFieldBeingsBeing is implemented by the following types:
// queryWithInterfaceListPointerFieldBeingsAnimal
// queryWithInterfaceListPointerFieldBeingsUser
type queryWithInterfaceListPointerFieldBeingsBeing interface {
	implementsGraphQLInterfacequeryWithInterfaceListPointerFieldBeingsBeing()
	// GetTypename returns the receiver's concrete GraphQL type-name (see interface doc for possible values).
	GetTypename() string
	// GetId returns the interface-field "id" from its implementation.
	GetId() string
	// GetName returns the interface-field "name" from its implementation.
	GetName() string
}

func (v *queryWithInterfaceListPointerFieldBeingsAnimal) implementsGraphQLInterfacequeryWithInterfaceListPointerFieldBeingsBeing() {
}
func (v *queryWithInterfaceListPointerFieldBeingsUser) implementsGraphQLInterfacequeryWithInterfaceListPointerFieldBeingsBeing() {
}

func __unmarshalqueryWithInterfaceListPointerFieldBeingsBeing(b []byte, v *queryWithInterfaceListPointerFieldBeingsBeing) error {
	if string(b) == "null" {
		return nil
	}

	var tn struct {
		TypeName string `json:"__typename"`
	}
	err := json.Unmarshal(b, &tn)
	if err != nil {
		return err
	}

	switch tn.TypeName {
	case "Animal":
		*v = new(queryWithInterfaceListPointerFieldBeingsAnimal)
		return json.Unmarshal(b, *v)
	case "User":
		*v = new(queryWithInterfaceListPointerFieldBeingsUser)
		return json.Unmarshal(b, *v)
	case "":
		return fmt.Errorf(
			"response was missing Being.__typename")
	default:
		return fmt.Errorf(
			`unexpected concrete type for queryWithInterfaceListPointerFieldBeingsBeing: "%v"`, tn.TypeName)
	}
}

func __marshalqueryWithInterfaceListPointerFieldBeingsBeing(v *queryWithInterfaceListPointerFieldBeingsBeing) ([]byte, error) {

	var typename string
	switch v := (*v).(type) {
	case *queryWithInterfaceListPointerFieldBeingsAnimal:
		typename = "Animal"

		result := struct {
			TypeName string `json:"__typename"`
			*queryWithInterfaceListPointerFieldBeingsAnimal
		}{typename, v}
		return json.Marshal(result)
	case *queryWithInterfaceListPointerFieldBeingsUser:
		typename = "User"

		result := struct {
			TypeName string `json:"__typename"`
			*queryWithInterfaceListPointerFieldBeingsUser
		}{typename, v}
		return json.Marshal(result)
	case nil:
		return []byte("null"), nil
	default:
		return nil, fmt.Errorf(
			`unexpected concrete type for queryWithInterfaceListPointerFieldBeingsBeing: "%T"`, v)
	}
}

// queryWithInterfaceListPointerFieldBeingsUser includes the requested fields of the GraphQL type User.
type queryWithInterfaceListPointerFieldBeingsUser struct {
	Typename string `json:"__typename"`
	Id       string `json:"id"`
	Name     string `json:"name"`
}

// GetTypename returns queryWithInterfaceListPointerFieldBeingsUser.Typename, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceListPointerFieldBeingsUser) GetTypename() string { return v.Typename }

// GetId returns queryWithInterfaceListPointerFieldBeingsUser.Id, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceListPointerFieldBeingsUser) GetId() string { return v.Id }

// GetName returns queryWithInterfaceListPointerFieldBeingsUser.Name, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceListPointerFieldBeingsUser) GetName() string { return v.Name }

// queryWithInterfaceListPointerFieldResponse is returned by queryWithInterfaceListPointerField on success.
type queryWithInterfaceListPointerFieldResponse struct {
	Beings []*queryWithInterfaceListPointerFieldBeingsBeing `json:"-"`
}

// GetBeings returns queryWithInterfaceListPointerFieldResponse.Beings, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceListPointerFieldResponse) GetBeings() []*queryWithInterfaceListPointerFieldBeingsBeing {
	return v.Beings
}

func (v *queryWithInterfaceListPointerFieldResponse) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*queryWithInterfaceListPointerFieldResponse
		Beings []json.RawMessage `json:"beings"`
		graphql.NoUnmarshalJSON
	}
	firstPass.queryWithInterfaceListPointerFieldResponse = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	{
		dst := &v.Beings
		src := firstPass.Beings
		*dst = make(
			[]*queryWithInterfaceListPointerFieldBeingsBeing,
			len(src))
		for i, src := range src {
			dst := &(*dst)[i]
			if len(src) != 0 && string(src) != "null" {
				*dst = new(queryWithInterfaceListPointerFieldBeingsBeing)
				err = __unmarshalqueryWithInterfaceListPointerFieldBeingsBeing(
					src, *dst)
				if err != nil {
					return fmt.Errorf(
						"unable to unmarshal queryWithInterfaceListPointerFieldResponse.Beings: %w", err)
				}
			}
		}
	}
	return nil
}

type __premarshalqueryWithInterfaceListPointerFieldResponse struct {
	Beings []json.RawMessage `json:"beings"`
}

func (v *queryWithInterfaceListPointerFieldResponse) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *queryWithInterfaceListPointerFieldResponse) __premarshalJSON() (*__premarshalqueryWithInterfaceListPointerFieldResponse, error) {
	var retval __premarshalqueryWithInterfaceListPointerFieldResponse

	{

		dst := &retval.Beings
		src := v.Beings
		*dst = make(
			[]json.RawMessage,
			len(src))
		for i, src := range src {
			dst := &(*dst)[i]
			if src != nil {
				var err error
				*dst, err = __marshalqueryWithInterfaceListPointerFieldBeingsBeing(
					src)
				if err != nil {
					return nil, fmt.Errorf(
						"unable to marshal queryWithInterfaceListPointerFieldResponse.Beings: %w", err)
				}
			}
		}
	}
	return &retval, nil
}

// queryWithInterfaceNoFragmentsBeing includes the requested fields of the GraphQL interface Being.
//
// queryWithInterfaceNoFragmentsBeing is implemented by the following types:
// queryWithInterfaceNoFragmentsBeingAnimal
// queryWithInterfaceNoFragmentsBeingUser
type queryWithInterfaceNoFragmentsBeing interface {
	implementsGraphQLInterfacequeryWithInterfaceNoFragmentsBeing()
	// GetTypename returns the receiver's concrete GraphQL type-name (see interface doc for possible values).
	GetTypename() string
	// GetId returns the interface-field "id" from its implementation.
	GetId() string
	// GetName returns the interface-field "name" from its implementation.
	GetName() string
}

func (v *queryWithInterfaceNoFragmentsBeingAnimal) implementsGraphQLInterfacequeryWithInterfaceNoFragmentsBeing() {
}
func (v *queryWithInterfaceNoFragmentsBeingUser) implementsGraphQLInterfacequeryWithInterfaceNoFragmentsBeing() {
}

func __unmarshalqueryWithInterfaceNoFragmentsBeing(b []byte, v *queryWithInterfaceNoFragmentsBeing) error {
	if string(b) == "null" {
		return nil
	}

	var tn struct {
		TypeName string `json:"__typename"`
	}
	err := json.Unmarshal(b, &tn)
	if err != nil {
		return err
	}

	switch tn.TypeName {
	case "Animal":
		*v = new(queryWithInterfaceNoFragmentsBeingAnimal)
		return json.Unmarshal(b, *v)
	case "User":
		*v = new(queryWithInterfaceNoFragmentsBeingUser)
		return json.Unmarshal(b, *v)
	case "":
		return fmt.Errorf(
			"response was missing Being.__typename")
	default:
		return fmt.Errorf(
			`unexpected concrete type for queryWithInterfaceNoFragmentsBeing: "%v"`, tn.TypeName)
	}
}

func __marshalqueryWithInterfaceNoFragmentsBeing(v *queryWithInterfaceNoFragmentsBeing) ([]byte, error) {

	var typename string
	switch v := (*v).(type) {
	case *queryWithInterfaceNoFragmentsBeingAnimal:
		typename = "Animal"

		result := struct {
			TypeName string `json:"__typename"`
			*queryWithInterfaceNoFragmentsBeingAnimal
		}{typename, v}
		return json.Marshal(result)
	case *queryWithInterfaceNoFragmentsBeingUser:
		typename = "User"

		result := struct {
			TypeName string `json:"__typename"`
			*queryWithInterfaceNoFragmentsBeingUser
		}{typename, v}
		return json.Marshal(result)
	case nil:
		return []byte("null"), nil
	default:
		return nil, fmt.Errorf(
			`unexpected concrete type for queryWithInterfaceNoFragmentsBeing: "%T"`, v)
	}
}

// queryWithInterfaceNoFragmentsBeingAnimal includes the requested fields of the GraphQL type Animal.
type queryWithInterfaceNoFragmentsBeingAnimal struct {
	Typename string `json:"__typename"`
	Id       string `json:"id"`
	Name     string `json:"name"`
}

// GetTypename returns queryWithInterfaceNoFragmentsBeingAnimal.Typename, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceNoFragmentsBeingAnimal) GetTypename() string { return v.Typename }

// GetId returns queryWithInterfaceNoFragmentsBeingAnimal.Id, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceNoFragmentsBeingAnimal) GetId() string { return v.Id }

// GetName returns queryWithInterfaceNoFragmentsBeingAnimal.Name, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceNoFragmentsBeingAnimal) GetName() string { return v.Name }

// queryWithInterfaceNoFragmentsBeingUser includes the requested fields of the GraphQL type User.
type queryWithInterfaceNoFragmentsBeingUser struct {
	Typename string `json:"__typename"`
	Id       string `json:"id"`
	Name     string `json:"name"`
}

// GetTypename returns queryWithInterfaceNoFragmentsBeingUser.Typename, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceNoFragmentsBeingUser) GetTypename() string { return v.Typename }

// GetId returns queryWithInterfaceNoFragmentsBeingUser.Id, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceNoFragmentsBeingUser) GetId() string { return v.Id }

// GetName returns queryWithInterfaceNoFragmentsBeingUser.Name, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceNoFragmentsBeingUser) GetName() string { return v.Name }

// queryWithInterfaceNoFragmentsMeUser includes the requested fields of the GraphQL type User.
type queryWithInterfaceNoFragmentsMeUser struct {
	Id   string `json:"id"`
	Name string `json:"name"`
}

// GetId returns queryWithInterfaceNoFragmentsMeUser.Id, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceNoFragmentsMeUser) GetId() string { return v.Id }

// GetName returns queryWithInterfaceNoFragmentsMeUser.Name, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceNoFragmentsMeUser) GetName() string { return v.Name }

// queryWithInterfaceNoFragmentsResponse is returned by queryWithInterfaceNoFragments on success.
type queryWithInterfaceNoFragmentsResponse struct {
	Being queryWithInterfaceNoFragmentsBeing  `json:"-"`
	Me    queryWithInterfaceNoFragmentsMeUser `json:"me"`
}

// GetBeing returns queryWithInterfaceNoFragmentsResponse.Being, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceNoFragmentsResponse) GetBeing() queryWithInterfaceNoFragmentsBeing {
	return v.Being
}

// GetMe returns queryWithInterfaceNoFragmentsResponse.Me, and is useful for accessing the field via an interface.
func (v *queryWithInterfaceNoFragmentsResponse) GetMe() queryWithInterfaceNoFragmentsMeUser {
	return v.Me
}

func (v *queryWithInterfaceNoFragmentsResponse) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*queryWithInterfaceNoFragmentsResponse
		Being json.RawMessage `json:"being"`
		graphql.NoUnmarshalJSON
	}
	firstPass.queryWithInterfaceNoFragmentsResponse = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	{
		dst := &v.Being
		src := firstPass.Being
		if len(src) != 0 && string(src) != "null" {
			err = __unmarshalqueryWithInterfaceNoFragmentsBeing(
				src, dst)
			if err != nil {
				return fmt.Errorf(
					"unable to unmarshal queryWithInterfaceNoFragmentsResponse.Being: %w", err)
			}
		}
	}
	return nil
}

type __premarshalqueryWithInterfaceNoFragmentsResponse struct {
	Being json.RawMessage `json:"being"`

	Me queryWithInterfaceNoFragmentsMeUser `json:"me"`
}

func (v *queryWithInterfaceNoFragmentsResponse) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *queryWithInterfaceNoFragmentsResponse) __premarshalJSON() (*__premarshalqueryWithInterfaceNoFragmentsResponse, error) {
	var retval __premarshalqueryWithInterfaceNoFragmentsResponse

	{

		dst := &retval.Being
		src := v.Being
		var err error
		*dst, err = __marshalqueryWithInterfaceNoFragmentsBeing(
			&src)
		if err != nil {
			return nil, fmt.Errorf(
				"unable to marshal queryWithInterfaceNoFragmentsResponse.Being: %w", err)
		}
	}
	retval.Me = v.Me
	return &retval, nil
}

// queryWithNamedFragmentsBeingsAnimal includes the requested fields of the GraphQL type Animal.
type queryWithNamedFragmentsBeingsAnimal struct {
	Typename     string `json:"__typename"`
	Id           string `json:"id"`
	AnimalFields `json:"-"`
}

// GetTypename returns queryWithNamedFragmentsBeingsAnimal.Typename, and is useful for accessing the field via an interface.
func (v *queryWithNamedFragmentsBeingsAnimal) GetTypename() string { return v.Typename }

// GetId returns queryWithNamedFragmentsBeingsAnimal.Id, and is useful for accessing the field via an interface.
func (v *queryWithNamedFragmentsBeingsAnimal) GetId() string { return v.Id }

// GetHair returns queryWithNamedFragmentsBeingsAnimal.Hair, and is useful for accessing the field via an interface.
func (v *queryWithNamedFragmentsBeingsAnimal) GetHair() AnimalFieldsHairBeingsHair {
	return v.AnimalFields.Hair
}

// GetOwner returns queryWithNamedFragmentsBeingsAnimal.Owner, and is useful for accessing the field via an interface.
func (v *queryWithNamedFragmentsBeingsAnimal) GetOwner() AnimalFieldsOwnerBeing {
	return v.AnimalFields.Owner
}

func (v *queryWithNamedFragmentsBeingsAnimal) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*queryWithNamedFragmentsBeingsAnimal
		graphql.NoUnmarshalJSON
	}
	firstPass.queryWithNamedFragmentsBeingsAnimal = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	err = json.Unmarshal(
		b, &v.AnimalFields)
	if err != nil {
		return err
	}
	return nil
}

type __premarshalqueryWithNamedFragmentsBeingsAnimal struct {
	Typename string `json:"__typename"`

	Id string `json:"id"`

	Hair AnimalFieldsHairBeingsHair `json:"hair"`

	Owner json.RawMessage `json:"owner"`
}

func (v *queryWithNamedFragmentsBeingsAnimal) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *queryWithNamedFragmentsBeingsAnimal) __premarshalJSON() (*__premarshalqueryWithNamedFragmentsBeingsAnimal, error) {
	var retval __premarshalqueryWithNamedFragmentsBeingsAnimal

	retval.Typename = v.Typename
	retval.Id = v.Id
	retval.Hair = v.AnimalFields.Hair
	{

		dst := &retval.Owner
		src := v.AnimalFields.Owner
		var err error
		*dst, err = __marshalAnimalFieldsOwnerBeing(
			&src)
		if err != nil {
			return nil, fmt.Errorf(
				"unable to marshal queryWithNamedFragmentsBeingsAnimal.AnimalFields.Owner: %w", err)
		}
	}
	return &retval, nil
}

// queryWithNamedFragmentsBeingsBeing includes the requested fields of the GraphQL interface Being.
//
// queryWithNamedFragmentsBeingsBeing is implemented by the following types:
// queryWithNamedFragmentsBeingsAnimal
// queryWithNamedFragmentsBeingsUser
type queryWithNamedFragmentsBeingsBeing interface {
	implementsGraphQLInterfacequeryWithNamedFragmentsBeingsBeing()
	// GetTypename returns the receiver's concrete GraphQL type-name (see interface doc for possible values).
	GetTypename() string
	// GetId returns the interface-field "id" from its implementation.
	GetId() string
}

func (v *queryWithNamedFragmentsBeingsAnimal) implementsGraphQLInterfacequeryWithNamedFragmentsBeingsBeing() {
}
func (v *queryWithNamedFragmentsBeingsUser) implementsGraphQLInterfacequeryWithNamedFragmentsBeingsBeing() {
}

func __unmarshalqueryWithNamedFragmentsBeingsBeing(b []byte, v *queryWithNamedFragmentsBeingsBeing) error {
	if string(b) == "null" {
		return nil
	}

	var tn struct {
		TypeName string `json:"__typename"`
	}
	err := json.Unmarshal(b, &tn)
	if err != nil {
		return err
	}

	switch tn.TypeName {
	case "Animal":
		*v = new(queryWithNamedFragmentsBeingsAnimal)
		return json.Unmarshal(b, *v)
	case "User":
		*v = new(queryWithNamedFragmentsBeingsUser)
		return json.Unmarshal(b, *v)
	case "":
		return fmt.Errorf(
			"response was missing Being.__typename")
	default:
		return fmt.Errorf(
			`unexpected concrete type for queryWithNamedFragmentsBeingsBeing: "%v"`, tn.TypeName)
	}
}

func __marshalqueryWithNamedFragmentsBeingsBeing(v *queryWithNamedFragmentsBeingsBeing) ([]byte, error) {

	var typename string
	switch v := (*v).(type) {
	case *queryWithNamedFragmentsBeingsAnimal:
		typename = "Animal"

		premarshaled, err := v.__premarshalJSON()
		if err != nil {
			return nil, err
		}
		result := struct {
			TypeName string `json:"__typename"`
			*__premarshalqueryWithNamedFragmentsBeingsAnimal
		}{typename, premarshaled}
		return json.Marshal(result)
	case *queryWithNamedFragmentsBeingsUser:
		typename = "User"

		premarshaled, err := v.__premarshalJSON()
		if err != nil {
			return nil, err
		}
		result := struct {
			TypeName string `json:"__typename"`
			*__premarshalqueryWithNamedFragmentsBeingsUser
		}{typename, premarshaled}
		return json.Marshal(result)
	case nil:
		return []byte("null"), nil
	default:
		return nil, fmt.Errorf(
			`unexpected concrete type for queryWithNamedFragmentsBeingsBeing: "%T"`, v)
	}
}

// queryWithNamedFragmentsBeingsUser includes the requested fields of the GraphQL type User.
type queryWithNamedFragmentsBeingsUser struct {
	Typename   string `json:"__typename"`
	Id         string `json:"id"`
	UserFields `json:"-"`
}

// GetTypename returns queryWithNamedFragmentsBeingsUser.Typename, and is useful for accessing the field via an interface.
func (v *queryWithNamedFragmentsBeingsUser) GetTypename() string { return v.Typename }

// GetId returns queryWithNamedFragmentsBeingsUser.Id, and is useful for accessing the field via an interface.
func (v *queryWithNamedFragmentsBeingsUser) GetId() string { return v.Id }

// GetLuckyNumber returns queryWithNamedFragmentsBeingsUser.LuckyNumber, and is useful for accessing the field via an interface.
func (v *queryWithNamedFragmentsBeingsUser) GetLuckyNumber() int {
	return v.UserFields.LuckyFieldsUser.LuckyNumber
}

// GetHair returns queryWithNamedFragmentsBeingsUser.Hair, and is useful for accessing the field via an interface.
func (v *queryWithNamedFragmentsBeingsUser) GetHair() MoreUserFieldsHair {
	return v.UserFields.MoreUserFields.Hair
}

func (v *queryWithNamedFragmentsBeingsUser) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*queryWithNamedFragmentsBeingsUser
		graphql.NoUnmarshalJSON
	}
	firstPass.queryWithNamedFragmentsBeingsUser = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	err = json.Unmarshal(
		b, &v.UserFields)
	if err != nil {
		return err
	}
	return nil
}

type __premarshalqueryWithNamedFragmentsBeingsUser struct {
	Typename string `json:"__typename"`

	Id string `json:"id"`

	LuckyNumber int `json:"luckyNumber"`

	Hair MoreUserFieldsHair `json:"hair"`
}

func (v *queryWithNamedFragmentsBeingsUser) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *queryWithNamedFragmentsBeingsUser) __premarshalJSON() (*__premarshalqueryWithNamedFragmentsBeingsUser, error) {
	var retval __premarshalqueryWithNamedFragmentsBeingsUser

	retval.Typename = v.Typename
	retval.Id = v.Id
	retval.LuckyNumber = v.UserFields.LuckyFieldsUser.LuckyNumber
	retval.Hair = v.UserFields.MoreUserFields.Hair
	return &retval, nil
}

// queryWithNamedFragmentsResponse is returned by queryWithNamedFragments on success.
type queryWithNamedFragmentsResponse struct {
	Beings []queryWithNamedFragmentsBeingsBeing `json:"-"`
}

// GetBeings returns queryWithNamedFragmentsResponse.Beings, and is useful for accessing the field via an interface.
func (v *queryWithNamedFragmentsResponse) GetBeings() []queryWithNamedFragmentsBeingsBeing {
	return v.Beings
}

func (v *queryWithNamedFragmentsResponse) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*queryWithNamedFragmentsResponse
		Beings []json.RawMessage `json:"beings"`
		graphql.NoUnmarshalJSON
	}
	firstPass.queryWithNamedFragmentsResponse = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	{
		dst := &v.Beings
		src := firstPass.Beings
		*dst = make(
			[]queryWithNamedFragmentsBeingsBeing,
			len(src))
		for i, src := range src {
			dst := &(*dst)[i]
			if len(src) != 0 && string(src) != "null" {
				err = __unmarshalqueryWithNamedFragmentsBeingsBeing(
					src, dst)
				if err != nil {
					return fmt.Errorf(
						"unable to unmarshal queryWithNamedFragmentsResponse.Beings: %w", err)
				}
			}
		}
	}
	return nil
}

type __premarshalqueryWithNamedFragmentsResponse struct {
	Beings []json.RawMessage `json:"beings"`
}

func (v *queryWithNamedFragmentsResponse) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *queryWithNamedFragmentsResponse) __premarshalJSON() (*__premarshalqueryWithNamedFragmentsResponse, error) {
	var retval __premarshalqueryWithNamedFragmentsResponse

	{

		dst := &retval.Beings
		src := v.Beings
		*dst = make(
			[]json.RawMessage,
			len(src))
		for i, src := range src {
			dst := &(*dst)[i]
			var err error
			*dst, err = __marshalqueryWithNamedFragmentsBeingsBeing(
				&src)
			if err != nil {
				return nil, fmt.Errorf(
					"unable to marshal queryWithNamedFragmentsResponse.Beings: %w", err)
			}
		}
	}
	return &retval, nil
}

// queryWithOmitemptyResponse is returned by queryWithOmitempty on success.
type queryWithOmitemptyResponse struct {
	User queryWithOmitemptyUser `json:"user"`
}

// GetUser returns queryWithOmitemptyResponse.User, and is useful for accessing the field via an interface.
func (v *queryWithOmitemptyResponse) GetUser() queryWithOmitemptyUser { return v.User }

// queryWithOmitemptyUser includes the requested fields of the GraphQL type User.
type queryWithOmitemptyUser struct {
	Id          string `json:"id"`
	Name        string `json:"name"`
	LuckyNumber int    `json:"luckyNumber"`
}

// GetId returns queryWithOmitemptyUser.Id, and is useful for accessing the field via an interface.
func (v *queryWithOmitemptyUser) GetId() string { return v.Id }

// GetName returns queryWithOmitemptyUser.Name, and is useful for accessing the field via an interface.
func (v *queryWithOmitemptyUser) GetName() string { return v.Name }

// GetLuckyNumber returns queryWithOmitemptyUser.LuckyNumber, and is useful for accessing the field via an interface.
func (v *queryWithOmitemptyUser) GetLuckyNumber() int { return v.LuckyNumber }

// queryWithVariablesResponse is returned by queryWithVariables on success.
type queryWithVariablesResponse struct {
	User queryWithVariablesUser `json:"user"`
}

// GetUser returns queryWithVariablesResponse.User, and is useful for accessing the field via an interface.
func (v *queryWithVariablesResponse) GetUser() queryWithVariablesUser { return v.User }

// queryWithVariablesUser includes the requested fields of the GraphQL type User.
type queryWithVariablesUser struct {
	Id          string `json:"id"`
	Name        string `json:"name"`
	LuckyNumber int    `json:"luckyNumber"`
}

// GetId returns queryWithVariablesUser.Id, and is useful for accessing the field via an interface.
func (v *queryWithVariablesUser) GetId() string { return v.Id }

// GetName returns queryWithVariablesUser.Name, and is useful for accessing the field via an interface.
func (v *queryWithVariablesUser) GetName() string { return v.Name }

// GetLuckyNumber returns queryWithVariablesUser.LuckyNumber, and is useful for accessing the field via an interface.
func (v *queryWithVariablesUser) GetLuckyNumber() int { return v.LuckyNumber }

// simpleQueryExtMeUser includes the requested fields of the GraphQL type User.
type simpleQueryExtMeUser struct {
	Id          string `json:"id"`
	Name        string `json:"name"`
	LuckyNumber int    `json:"luckyNumber"`
}

// GetId returns simpleQueryExtMeUser.Id, and is useful for accessing the field via an interface.
func (v *simpleQueryExtMeUser) GetId() string { return v.Id }

// GetName returns simpleQueryExtMeUser.Name, and is useful for accessing the field via an interface.
func (v *simpleQueryExtMeUser) GetName() string { return v.Name }

// GetLuckyNumber returns simpleQueryExtMeUser.LuckyNumber, and is useful for accessing the field via an interface.
func (v *simpleQueryExtMeUser) GetLuckyNumber() int { return v.LuckyNumber }

// simpleQueryExtResponse is returned by simpleQueryExt on success.
type simpleQueryExtResponse struct {
	Me simpleQueryExtMeUser `json:"me"`
}

// GetMe returns simpleQueryExtResponse.Me, and is useful for accessing the field via an interface.
func (v *simpleQueryExtResponse) GetMe() simpleQueryExtMeUser { return v.Me }

// simpleQueryMeUser includes the requested fields of the GraphQL type User.
type simpleQueryMeUser struct {
	Id          string `json:"id"`
	Name        string `json:"name"`
	LuckyNumber int    `json:"luckyNumber"`
}

// GetId returns simpleQueryMeUser.Id, and is useful for accessing the field via an interface.
func (v *simpleQueryMeUser) GetId() string { return v.Id }

// GetName returns simpleQueryMeUser.Name, and is useful for accessing the field via an interface.
func (v *simpleQueryMeUser) GetName() string { return v.Name }

// GetLuckyNumber returns simpleQueryMeUser.LuckyNumber, and is useful for accessing the field via an interface.
func (v *simpleQueryMeUser) GetLuckyNumber() int { return v.LuckyNumber }

// simpleQueryResponse is returned by simpleQuery on success.
type simpleQueryResponse struct {
	Me simpleQueryMeUser `json:"me"`
}

// GetMe returns simpleQueryResponse.Me, and is useful for accessing the field via an interface.
func (v *simpleQueryResponse) GetMe() simpleQueryMeUser { return v.Me }

// The query or mutation executed by createUser.
const createUser_Operation = `
mutation createUser ($user: NewUser!) {
	createUser(input: $user) {
		id
		name
	}
}
`

func createUser(
	ctx context.Context,
	client graphql.Client,
	user NewUser,
) (*createUserResponse, map[string]interface{}, error) {
	req := &graphql.Request{
		OpName: "createUser",
		Query:  createUser_Operation,
		Variables: &__createUserInput{
			User: user,
		},
	}
	var err error

	var data createUserResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, resp.Extensions, err
}

// The query or mutation executed by failingQuery.
const failingQuery_Operation = `
query failingQuery {
	fail
	me {
		id
	}
}
`

func failingQuery(
	ctx context.Context,
	client graphql.Client,
) (*failingQueryResponse, map[string]interface{}, error) {
	req := &graphql.Request{
		OpName: "failingQuery",
		Query:  failingQuery_Operation,
	}
	var err error

	var data failingQueryResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, resp.Extensions, err
}

// The query or mutation executed by queryWithCustomMarshal.
const queryWithCustomMarshal_Operation = `
query queryWithCustomMarshal ($date: Date!) {
	usersBornOn(date: $date) {
		id
		name
		birthdate
	}
}
`

func queryWithCustomMarshal(
	ctx context.Context,
	client graphql.Client,
	date time.Time,
) (*queryWithCustomMarshalResponse, map[string]interface{}, error) {
	req := &graphql.Request{
		OpName: "queryWithCustomMarshal",
		Query:  queryWithCustomMarshal_Operation,
		Variables: &__queryWithCustomMarshalInput{
			Date: date,
		},
	}
	var err error

	var data queryWithCustomMarshalResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, resp.Extensions, err
}

// The query or mutation executed by queryWithCustomMarshalOptional.
const queryWithCustomMarshalOptional_Operation = `
query queryWithCustomMarshalOptional ($date: Date, $id: ID) {
	userSearch(birthdate: $date, id: $id) {
		id
		name
		birthdate
	}
}
`

func queryWithCustomMarshalOptional(
	ctx context.Context,
	client graphql.Client,
	date *time.Time,
	id *string,
) (*queryWithCustomMarshalOptionalResponse, map[string]interface{}, error) {
	req := &graphql.Request{
		OpName: "queryWithCustomMarshalOptional",
		Query:  queryWithCustomMarshalOptional_Operation,
		Variables: &__queryWithCustomMarshalOptionalInput{
			Date: date,
			Id:   id,
		},
	}
	var err error

	var data queryWithCustomMarshalOptionalResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, resp.Extensions, err
}

// The query or mutation executed by queryWithCustomMarshalSlice.
const queryWithCustomMarshalSlice_Operation = `
query queryWithCustomMarshalSlice ($dates: [Date!]!) {
	usersBornOnDates(dates: $dates) {
		id
		name
		birthdate
	}
}
`

func queryWithCustomMarshalSlice(
	ctx context.Context,
	client graphql.Client,
	dates []time.Time,
) (*queryWithCustomMarshalSliceResponse, map[string]interface{}, error) {
	req := &graphql.Request{
		OpName: "queryWithCustomMarshalSlice",
		Query:  queryWithCustomMarshalSlice_Operation,
		Variables: &__queryWithCustomMarshalSliceInput{
			Dates: dates,
		},
	}
	var err error

	var data queryWithCustomMarshalSliceResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, resp.Extensions, err
}

// The query or mutation executed by queryWithFlatten.
const queryWithFlatten_Operation = `
query queryWithFlatten ($ids: [ID!]!) {
	... QueryFragment
}
fragment QueryFragment on Query {
	beings(ids: $ids) {
		__typename
		id
		... FlattenedUserFields
		... on Animal {
			owner {
				__typename
				... BeingFields
			}
		}
	}
}
fragment FlattenedUserFields on User {
	... FlattenedLuckyFields
}
fragment BeingFields on Being {
	... InnerBeingFields
}
fragment FlattenedLuckyFields on Lucky {
	... InnerLuckyFields
}
fragment InnerBeingFields on Being {
	id
	name
	... on User {
		friends {
			... FriendsFields
		}
	}
}
fragment InnerLuckyFields on Lucky {
	luckyNumber
}
fragment FriendsFields on User {
	id
	name
}
`

func queryWithFlatten(
	ctx context.Context,
	client graphql.Client,
	ids []string,
) (*QueryFragment, map[string]interface{}, error) {
	req := &graphql.Request{
		OpName: "queryWithFlatten",
		Query:  queryWithFlatten_Operation,
		Variables: &__queryWithFlattenInput{
			Ids: ids,
		},
	}
	var err error

	var data QueryFragment
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, resp.Extensions, err
}

// The query or mutation executed by queryWithFragments.
const queryWithFragments_Operation = `
query queryWithFragments ($ids: [ID!]!) {
	beings(ids: $ids) {
		__typename
		id
		... on Being {
			id
			name
		}
		... on Animal {
			id
			hair {
				hasHair
			}
			species
			owner {
				__typename
				id
				... on Being {
					name
				}
				... on User {
					luckyNumber
				}
			}
		}
		... on Lucky {
			luckyNumber
		}
		... on User {
			hair {
				color
			}
		}
	}
}
`

func queryWithFragments(
	ctx context.Context,
	client graphql.Client,
	ids []string,
) (*queryWithFragmentsResponse, map[string]interface{}, error) {
	req := &graphql.Request{
		OpName: "queryWithFragments",
		Query:  queryWithFragments_Operation,
		Variables: &__queryWithFragmentsInput{
			Ids: ids,
		},
	}
	var err error

	var data queryWithFragmentsResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, resp.Extensions, err
}

// The query or mutation executed by queryWithInterfaceListField.
const queryWithInterfaceListField_Operation = `
query queryWithInterfaceListField ($ids: [ID!]!) {
	beings(ids: $ids) {
		__typename
		id
		name
	}
}
`

func queryWithInterfaceListField(
	ctx context.Context,
	client graphql.Client,
	ids []string,
) (*queryWithInterfaceListFieldResponse, map[string]interface{}, error) {
	req := &graphql.Request{
		OpName: "queryWithInterfaceListField",
		Query:  queryWithInterfaceListField_Operation,
		Variables: &__queryWithInterfaceListFieldInput{
			Ids: ids,
		},
	}
	var err error

	var data queryWithInterfaceListFieldResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, resp.Extensions, err
}

// The query or mutation executed by queryWithInterfaceListPointerField.
const queryWithInterfaceListPointerField_Operation = `
query queryWithInterfaceListPointerField ($ids: [ID!]!) {
	beings(ids: $ids) {
		__typename
		id
		name
	}
}
`

func queryWithInterfaceListPointerField(
	ctx context.Context,
	client graphql.Client,
	ids []string,
) (*queryWithInterfaceListPointerFieldResponse, map[string]interface{}, error) {
	req := &graphql.Request{
		OpName: "queryWithInterfaceListPointerField",
		Query:  queryWithInterfaceListPointerField_Operation,
		Variables: &__queryWithInterfaceListPointerFieldInput{
			Ids: ids,
		},
	}
	var err error

	var data queryWithInterfaceListPointerFieldResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, resp.Extensions, err
}

// The query or mutation executed by queryWithInterfaceNoFragments.
const queryWithInterfaceNoFragments_Operation = `
query queryWithInterfaceNoFragments ($id: ID!) {
	being(id: $id) {
		__typename
		id
		name
	}
	me {
		id
		name
	}
}
`

func queryWithInterfaceNoFragments(
	ctx context.Context,
	client graphql.Client,
	id string,
) (*queryWithInterfaceNoFragmentsResponse, map[string]interface{}, error) {
	req := &graphql.Request{
		OpName: "queryWithInterfaceNoFragments",
		Query:  queryWithInterfaceNoFragments_Operation,
		Variables: &__queryWithInterfaceNoFragmentsInput{
			Id: id,
		},
	}
	var err error

	var data queryWithInterfaceNoFragmentsResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, resp.Extensions, err
}

// The query or mutation executed by queryWithNamedFragments.
const queryWithNamedFragments_Operation = `
query queryWithNamedFragments ($ids: [ID!]!) {
	beings(ids: $ids) {
		__typename
		id
		... AnimalFields
		... UserFields
	}
}
fragment AnimalFields on Animal {
	id
	hair {
		hasHair
	}
	owner {
		__typename
		id
		... UserFields
		... LuckyFields
	}
}
fragment UserFields on User {
	id
	... LuckyFields
	... MoreUserFields
}
fragment LuckyFields on Lucky {
	... MoreUserFields
	luckyNumber
}
fragment MoreUserFields on User {
	id
	hair {
		color
	}
}
`

func queryWithNamedFragments(
	ctx context.Context,
	client graphql.Client,
	ids []string,
) (*queryWithNamedFragmentsResponse, map[string]interface{}, error) {
	req := &graphql.Request{
		OpName: "queryWithNamedFragments",
		Query:  queryWithNamedFragments_Operation,
		Variables: &__queryWithNamedFragmentsInput{
			Ids: ids,
		},
	}
	var err error

	var data queryWithNamedFragmentsResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, resp.Extensions, err
}

// The query or mutation executed by queryWithOmitempty.
const queryWithOmitempty_Operation = `
query queryWithOmitempty ($id: ID) {
	user(id: $id) {
		id
		name
		luckyNumber
	}
}
`

func queryWithOmitempty(
	ctx context.Context,
	client graphql.Client,
	id string,
) (*queryWithOmitemptyResponse, map[string]interface{}, error) {
	req := &graphql.Request{
		OpName: "queryWithOmitempty",
		Query:  queryWithOmitempty_Operation,
		Variables: &__queryWithOmitemptyInput{
			Id: id,
		},
	}
	var err error

	var data queryWithOmitemptyResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, resp.Extensions, err
}

// The query or mutation executed by queryWithVariables.
const queryWithVariables_Operation = `
query queryWithVariables ($id: ID!) {
	user(id: $id) {
		id
		name
		luckyNumber
	}
}
`

func queryWithVariables(
	ctx context.Context,
	client graphql.Client,
	id string,
) (*queryWithVariablesResponse, map[string]interface{}, error) {
	req := &graphql.Request{
		OpName: "queryWithVariables",
		Query:  queryWithVariables_Operation,
		Variables: &__queryWithVariablesInput{
			Id: id,
		},
	}
	var err error

	var data queryWithVariablesResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, resp.Extensions, err
}

// The query or mutation executed by simpleQuery.
const simpleQuery_Operation = `
query simpleQuery {
	me {
		id
		name
		luckyNumber
	}
}
`

func simpleQuery(
	ctx context.Context,
	client graphql.Client,
) (*simpleQueryResponse, map[string]interface{}, error) {
	req := &graphql.Request{
		OpName: "simpleQuery",
		Query:  simpleQuery_Operation,
	}
	var err error

	var data simpleQueryResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, resp.Extensions, err
}

// The query or mutation executed by simpleQueryExt.
const simpleQueryExt_Operation = `
query simpleQueryExt {
	me {
		id
		name
		luckyNumber
	}
}
`

func simpleQueryExt(
	ctx context.Context,
	client graphql.Client,
) (*simpleQueryExtResponse, map[string]interface{}, error) {
	req := &graphql.Request{
		OpName: "simpleQueryExt",
		Query:  simpleQueryExt_Operation,
	}
	var err error

	var data simpleQueryExtResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, resp.Extensions, err
}
